/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir.filter;

public abstract class IIRFilterBase {
    protected int frequency;
    protected int sampleRate;
    protected static final int HISTORYSIZE = 3;
    protected float[][] inArray;
    protected float[][] outArray;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected float amplitudeAdj;

    public void initialize(int sampleRate, int channels, int frequency, float parameter) {
        this.frequency = frequency;
        this.sampleRate = sampleRate;
        this.inArray = new float[channels][3];
        this.outArray = new float[channels][3];
        this.clearHistory();
    }

    public void clearHistory() {
        int channels = this.inArray.length;
        for (int c = 0; c < channels; ++c) {
            for (int i = 0; i < 3; ++i) {
                this.outArray[c][i] = 0.0f;
                this.inArray[c][i] = 0.0f;
            }
        }
    }

    public static float getIIRDecimalValueFrom(float dbValue) {
        double decimalValue = Math.pow(10.0, (double)dbValue / 20.0);
        return (float)(decimalValue < 1.0 ? -decimalValue : decimalValue);
    }

    public static float getIIRDBValueFrom(float decimalValue) {
        return (float)Math.log10(decimalValue < 0.0f ? (double)(-decimalValue) : (double)decimalValue) * 20.0f;
    }

    protected float calcRadiansPerSample(float freq) {
        return (float)(Math.PI * 2 * (double)freq / (double)this.sampleRate);
    }

    protected float getThetaZero() {
        return this.calcRadiansPerSample(this.frequency);
    }

    public void setAmplitudeAdj(float newAmplitudeAdj) {
        this.amplitudeAdj = newAmplitudeAdj;
    }

    public float getAmplitudeAdj() {
        return this.amplitudeAdj;
    }

    public void setGain(float dbValue) {
        this.setAmplitudeAdj(IIRFilterBase.getIIRDecimalValueFrom(dbValue));
    }

    public float getGain() {
        return IIRFilterBase.getIIRDBValueFrom(this.getAmplitudeAdj());
    }

    protected abstract float performFilterCalculation(float var1, int var2, int var3, int var4, int var5);
}

