/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.pitchshift;

import de.quippy.javamod.mixer.dsp.DSPEffekt;
import de.quippy.javamod.mixer.dsp.FFT2;
import de.quippy.javamod.system.FastMath;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;

public class PitchShift
implements DSPEffekt {
    private static final int MAXFIFO = 2;
    private float[][] gInFIFO = null;
    private float[][] gOutFIFO = null;
    private float[][] stretchFIFO = null;
    private float[] gFFTworksp = null;
    private float[][] gLastPhase = null;
    private float[][] gSumPhase = null;
    private float[][] gOutputAccum = null;
    private float[] gAnaFreq = null;
    private float[] gAnaMagn = null;
    private float[] gSynFreq = null;
    private float[] gSynMagn = null;
    private float[] gWindow = null;
    private float[] gWindow2 = null;
    private float[] gWindow3 = null;
    private float[] outBuffer = null;
    private FFT2 fft = null;
    private int gRover;
    private float pitchScale;
    private float sampleScale;
    private int fftFrameSize;
    private int osamp;
    private float sampleRate;
    private int fftFrameSize2;
    private int stepSize;
    private float freqPerBin;
    private float expct;
    private float expct2;
    private float inFifoLatency;
    private boolean isActive;
    private int sampleBufferSize;
    private int channels;

    public PitchShift(float pitchScale, float sampleScale, int fftFrameSize, int osamp) {
        this.pitchScale = pitchScale;
        this.sampleScale = sampleScale;
        this.fftFrameSize = fftFrameSize;
        this.osamp = osamp;
        this.isActive = false;
    }

    public PitchShift() {
        this(1.0f, 1.0f, 4096, 32);
    }

    @Override
    public void initialize(AudioFormat audioFormat, int sampleBufferLength) {
        this.sampleBufferSize = sampleBufferLength;
        this.sampleRate = audioFormat.getSampleRate();
        this.channels = audioFormat.getChannels();
        this.outBuffer = new float[this.sampleBufferSize];
        this.changeFFTFrameSize(this.fftFrameSize);
    }

    @Override
    public void setIsActive(boolean active) {
        this.isActive = active;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public synchronized float getPitchScale() {
        return this.pitchScale;
    }

    public synchronized void setPitchScale(float pitchScale) {
        this.pitchScale = pitchScale;
    }

    public synchronized float getSampleScale() {
        return this.sampleScale;
    }

    public synchronized void setSampleScale(float sampleScale) {
        this.sampleScale = sampleScale;
    }

    public synchronized void setPitchAndSampleScale(float pitchScale, float sampleScale) {
        this.setPitchScale(pitchScale);
        this.setSampleScale(sampleScale);
    }

    public int getFftFrameSize() {
        return this.fftFrameSize;
    }

    public synchronized void setFFTFrameSize(int fftFrameSize) {
        this.changeFFTFrameSize(fftFrameSize);
    }

    public synchronized int getFFTOversampling() {
        return this.osamp;
    }

    public synchronized void setFFTOversampling(int osamp) {
        this.changeFFTOversampling(osamp);
    }

    private void changeFFTFrameSize(int newFFTFrameSize) {
        this.fftFrameSize = newFFTFrameSize;
        this.fftFrameSize2 = this.fftFrameSize >> 1;
        this.stepSize = this.fftFrameSize / this.osamp;
        this.freqPerBin = this.sampleRate / (float)this.fftFrameSize;
        this.expct = (float)Math.PI * 2 * (float)this.stepSize / (float)this.fftFrameSize;
        this.expct2 = (float)Math.PI * 2 / (float)this.osamp;
        this.inFifoLatency = this.fftFrameSize - this.stepSize;
        this.gRover = (int)this.inFifoLatency;
        this.fft = new FFT2(this.fftFrameSize);
        this.stretchFIFO = new float[this.channels][2];
        this.gInFIFO = new float[this.channels][this.fftFrameSize];
        this.gOutFIFO = new float[this.channels][this.fftFrameSize];
        this.gFFTworksp = new float[this.fftFrameSize << 1];
        this.gLastPhase = new float[this.channels][this.fftFrameSize >> 1];
        this.gSumPhase = new float[this.channels][this.fftFrameSize >> 1];
        this.gOutputAccum = new float[this.channels][this.fftFrameSize << 1];
        this.gAnaFreq = new float[this.fftFrameSize];
        this.gAnaMagn = new float[this.fftFrameSize];
        this.gSynFreq = new float[this.fftFrameSize];
        this.gSynMagn = new float[this.fftFrameSize];
        this.gWindow = new float[this.fftFrameSize];
        this.gWindow2 = new float[this.fftFrameSize];
        this.gWindow3 = new float[this.fftFrameSize2];
        Arrays.fill(this.gAnaFreq, 0.0f);
        Arrays.fill(this.gAnaMagn, 0.0f);
        Arrays.fill(this.gSynFreq, 0.0f);
        Arrays.fill(this.gSynMagn, 0.0f);
        Arrays.fill(this.gFFTworksp, 0.0f);
        for (int c = 0; c < this.channels; ++c) {
            Arrays.fill(this.gInFIFO[c], 0.0f);
            Arrays.fill(this.gOutFIFO[c], 0.0f);
            Arrays.fill(this.gOutputAccum[c], 0.0f);
            Arrays.fill(this.gLastPhase[c], 0.0f);
            Arrays.fill(this.gSumPhase[c], 0.0f);
        }
        this.computeWindow();
    }

    private void changeFFTOversampling(int newOverSampling) {
        this.osamp = newOverSampling;
        this.stepSize = this.fftFrameSize / this.osamp;
        this.expct = (float)Math.PI * 2 * (float)this.stepSize / (float)this.fftFrameSize;
        this.inFifoLatency = this.fftFrameSize - this.stepSize;
        this.gRover = (int)this.inFifoLatency;
    }

    private void processFrame(int c) {
        this.windowAndInterleave(c);
        this.analyze(c);
        this.process();
        this.synthesize(c);
        this.windowAndAccumulate(c);
        System.arraycopy(this.gOutputAccum[c], 0, this.gOutFIFO[c], 0, this.stepSize);
        System.arraycopy(this.gOutputAccum[c], this.stepSize, this.gOutputAccum[c], 0, this.fftFrameSize);
        System.arraycopy(this.gInFIFO[c], this.stepSize, this.gInFIFO[c], 0, (int)this.inFifoLatency);
    }

    private void computeWindow() {
        int k;
        for (k = 0; k < this.fftFrameSize; ++k) {
            this.gWindow[k] = -0.5f * (float)Math.cos(Math.PI * 2 * (double)k / (double)this.fftFrameSize) + 0.5f;
            this.gWindow2[k] = 2.0f * this.gWindow[k] / (float)(this.fftFrameSize2 * this.osamp);
        }
        for (k = 0; k < this.fftFrameSize2; ++k) {
            this.gWindow3[k] = (float)k * this.expct;
        }
    }

    private void windowAndInterleave(int c) {
        for (int k = 0; k < this.fftFrameSize; ++k) {
            this.gFFTworksp[k << 1] = this.gInFIFO[c][k] * this.gWindow[k];
            this.gFFTworksp[(k << 1) + 1] = 0.0f;
        }
    }

    private void analyze(int c) {
        this.fft.smsFft(this.gFFTworksp, -1);
        for (int k = 0; k < this.fftFrameSize2; ++k) {
            float real = this.gFFTworksp[k << 1];
            float imag = this.gFFTworksp[(k << 1) + 1];
            float magn = 2.0f * (float)FastMath.sqrt(real * real + imag * imag);
            float phase = (float)FastMath.atan2(imag, real);
            float tmp = phase - this.gLastPhase[c][k];
            this.gLastPhase[c][k] = phase;
            int qpd = (int)((double)(tmp -= (float)k * this.expct) / Math.PI);
            qpd = qpd >= 0 ? (qpd += qpd & 1) : (qpd -= qpd & 1);
            tmp -= (float)Math.PI * (float)qpd;
            tmp = (float)this.osamp * tmp / ((float)Math.PI * 2);
            tmp = (float)k * this.freqPerBin + tmp * this.freqPerBin;
            this.gAnaMagn[k] = magn;
            this.gAnaFreq[k] = tmp;
        }
    }

    private void process() {
        Arrays.fill(this.gSynMagn, 0, this.fftFrameSize, 0.0f);
        for (int k = 0; k <= this.fftFrameSize2; ++k) {
            int index = (int)((float)k / this.pitchScale);
            if (index > this.fftFrameSize2) continue;
            if (this.gAnaMagn[index] > this.gSynMagn[k]) {
                this.gSynMagn[k] = this.gAnaMagn[index];
                this.gSynFreq[k] = this.gAnaFreq[index] * this.pitchScale;
            }
            if (k <= 0 || this.gSynFreq[k] != 0.0f) continue;
            this.gSynFreq[k] = this.gSynFreq[k - 1];
            this.gSynMagn[k] = this.gSynMagn[k - 1];
        }
    }

    private void synthesize(int c) {
        for (int k = 0; k < this.fftFrameSize2; ++k) {
            float magn = this.gSynMagn[k];
            float tmp = this.gSynFreq[k];
            tmp = (tmp - (float)k * this.freqPerBin) / this.freqPerBin * this.expct2 + this.gWindow3[k];
            float[] fArray = this.gSumPhase[c];
            int n = k;
            float f = fArray[n] + tmp;
            fArray[n] = f;
            float phase = f;
            this.gFFTworksp[k << 1] = magn * (float)FastMath.fastCos(phase);
            this.gFFTworksp[(k << 1) + 1] = magn * (float)FastMath.fastSin(phase);
        }
        Arrays.fill(this.gFFTworksp, this.fftFrameSize + 2, this.fftFrameSize << 1, 0.0f);
        this.fft.smsFft(this.gFFTworksp, 1);
    }

    private void windowAndAccumulate(int c) {
        for (int k = 0; k < this.fftFrameSize; ++k) {
            float[] fArray = this.gOutputAccum[c];
            int n = k;
            fArray[n] = fArray[n] + this.gWindow2[k] * this.gFFTworksp[k << 1];
        }
    }

    private float getSampleFrom(int channel, float[] buffer, float index, float scale) {
        float[] b = this.stretchFIFO[channel];
        float s1 = b[0];
        float s2 = b[1];
        float sIndex = index + scale;
        float steigung = sIndex - FastMath.floor(index);
        int skipSamples = (int)sIndex - (int)index;
        if (skipSamples > 0) {
            b[0] = b[1];
            b[1] = buffer[((int)sIndex * this.channels + channel) % this.sampleBufferSize];
        }
        return s1 + (s2 - s1) * steigung;
    }

    @Override
    public synchronized int doEffekt(float[] ringBuffer, int start, int length) {
        if (!this.isActive) {
            return length;
        }
        if (this.gRover == 0) {
            this.gRover = (int)this.inFifoLatency;
        }
        float end = (float)(start + length) / (float)this.channels;
        float index = (float)start / (float)this.channels;
        int sampleIndex = 0;
        while (index < end) {
            int c;
            for (c = 0; c < this.channels; ++c) {
                this.gInFIFO[c][this.gRover] = this.getSampleFrom(c, ringBuffer, index, this.sampleScale);
                this.outBuffer[sampleIndex++] = this.gOutFIFO[c][this.gRover - (int)this.inFifoLatency];
            }
            index += this.sampleScale;
            ++this.gRover;
            if (this.gRover < this.fftFrameSize) continue;
            this.gRover = (int)this.inFifoLatency;
            for (c = 0; c < this.channels; ++c) {
                this.processFrame(c);
            }
        }
        int samples = sampleIndex;
        int targetBufferEnd = start + samples;
        if (targetBufferEnd >= this.sampleBufferSize) {
            System.arraycopy(this.outBuffer, samples -= (targetBufferEnd -= this.sampleBufferSize), ringBuffer, 0, targetBufferEnd);
        }
        System.arraycopy(this.outBuffer, 0, ringBuffer, start, samples);
        return sampleIndex;
    }
}

