/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.pitchshift;

import de.quippy.javamod.mixer.dsp.pitchshift.PitchShift;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PitchShiftGUI
extends JPanel {
    private static final long serialVersionUID = 4300230957744752568L;
    private static final int SHIFT = 100;
    private static final int SLIDER_MAX = 100;
    private static final int SLIDER_MIN = -100;
    private static final double factor = Math.log10(2.0);
    private PitchShift thePitcher;
    private JCheckBox pitchShiftActive = null;
    private JPanel pitchShiftPanel = null;
    private JPanel scaleShiftPanel = null;
    private JSlider pitchSlider = null;
    private JLabel pitchMinLable = null;
    private JLabel pitchCenterLable = null;
    private JLabel pitchMaxLable = null;
    private JSlider sampleScaleSlider = null;
    private JLabel scaleMinLable = null;
    private JLabel scaleCenterLable = null;
    private JLabel scaleMaxLable = null;
    private JLabel presetOversamplingLabel = null;
    private JComboBox presetOversampling = null;
    private JLabel presetFrameSizeLabel = null;
    private JComboBox presetFrameSize = null;
    private static final Integer[] OVERSAMPLINGS = new Integer[]{1, 5, 10, 15, 20};
    private static final Integer[] FRAMESIZE = new Integer[]{512, 1024, 2048, 4096, 8192};

    public PitchShiftGUI(PitchShift pitchShift) {
        this.thePitcher = pitchShift;
        this.initialize();
    }

    private void initialize() {
        this.setName("PitchShift");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPitchShiftActive(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 1.0, 0.0));
        this.add((Component)this.getPresetOversamplingLabel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPresetOversampling(), Helpers.getGridBagConstraint(2, 0, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getPresetFramesizeLabel(), Helpers.getGridBagConstraint(3, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPresetFramesize(), Helpers.getGridBagConstraint(4, 0, 1, 0, 2, 17, 1.0, 0.0));
        this.add((Component)this.getPitchShiftPanel(), Helpers.getGridBagConstraint(0, 1, 1, 0, 1, 17, 1.0, 1.0));
        this.add((Component)this.getScaleShiftPanel(), Helpers.getGridBagConstraint(0, 2, 1, 0, 1, 17, 1.0, 1.0));
    }

    private JLabel getPresetOversamplingLabel() {
        if (this.presetOversamplingLabel == null) {
            this.presetOversamplingLabel = new JLabel("Oversampling:");
            this.presetOversamplingLabel.setFont(Helpers.getDialogFont());
        }
        return this.presetOversamplingLabel;
    }

    private JComboBox getPresetOversampling() {
        if (this.presetOversampling == null) {
            this.presetOversampling = new JComboBox();
            this.presetOversampling.setName("presetOversampling");
            DefaultComboBoxModel<Integer> theModel = new DefaultComboBoxModel<Integer>(OVERSAMPLINGS);
            this.presetOversampling.setModel(theModel);
            this.presetOversampling.setFont(Helpers.getDialogFont());
            this.presetOversampling.setEditable(true);
            if (this.thePitcher != null) {
                this.presetOversampling.setSelectedItem(this.thePitcher.getFFTOversampling());
            }
            this.presetOversampling.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int oversampling = (Integer)PitchShiftGUI.this.getPresetOversampling().getSelectedItem();
                        if (PitchShiftGUI.this.thePitcher != null) {
                            PitchShiftGUI.this.thePitcher.setFFTOversampling(oversampling);
                        }
                    }
                }
            });
        }
        return this.presetOversampling;
    }

    private JLabel getPresetFramesizeLabel() {
        if (this.presetFrameSizeLabel == null) {
            this.presetFrameSizeLabel = new JLabel("Frame size:");
            this.presetFrameSizeLabel.setFont(Helpers.getDialogFont());
        }
        return this.presetFrameSizeLabel;
    }

    private JComboBox getPresetFramesize() {
        if (this.presetFrameSize == null) {
            this.presetFrameSize = new JComboBox();
            this.presetFrameSize.setName("presetFrameSize");
            DefaultComboBoxModel<Integer> theModel = new DefaultComboBoxModel<Integer>(FRAMESIZE);
            this.presetFrameSize.setModel(theModel);
            this.presetFrameSize.setFont(Helpers.getDialogFont());
            this.presetFrameSize.setEditable(true);
            if (this.thePitcher != null) {
                this.presetFrameSize.setSelectedItem(this.thePitcher.getFftFrameSize());
            }
            this.presetFrameSize.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int framesize = (Integer)PitchShiftGUI.this.getPresetFramesize().getSelectedItem();
                        if (PitchShiftGUI.this.thePitcher != null) {
                            PitchShiftGUI.this.thePitcher.setFFTFrameSize(framesize);
                        }
                    }
                }
            });
        }
        return this.presetFrameSize;
    }

    private JPanel getPitchShiftPanel() {
        if (this.pitchShiftPanel == null) {
            this.pitchShiftPanel = new JPanel();
            this.pitchShiftPanel.setName("pitchShiftPanel");
            this.pitchShiftPanel.setLayout(new GridBagLayout());
            this.pitchShiftPanel.setBorder(new TitledBorder(null, "Pitch", 4, 0, Helpers.getDialogFont(), null));
            this.pitchShiftPanel.add((Component)this.getPitchSlider(), Helpers.getGridBagConstraint(0, 0, 1, 3, 2, 11, 1.0, 0.0));
            this.pitchShiftPanel.add((Component)this.getPitchMinLabel(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 17, 1.0, 0.0));
            this.pitchShiftPanel.add((Component)this.getPitchCenterLabel(), Helpers.getGridBagConstraint(1, 1, 1, 1, 0, 10, 1.0, 0.0));
            this.pitchShiftPanel.add((Component)this.getPitchMaxLabel(), Helpers.getGridBagConstraint(2, 1, 1, 1, 0, 13, 1.0, 0.0));
        }
        return this.pitchShiftPanel;
    }

    private JPanel getScaleShiftPanel() {
        if (this.scaleShiftPanel == null) {
            this.scaleShiftPanel = new JPanel();
            this.scaleShiftPanel.setName("scaleShiftPanel");
            this.scaleShiftPanel.setLayout(new GridBagLayout());
            this.scaleShiftPanel.setBorder(new TitledBorder(null, "Tempo", 4, 0, Helpers.getDialogFont(), null));
            this.scaleShiftPanel.add((Component)this.getScaleSlider(), Helpers.getGridBagConstraint(0, 0, 1, 3, 2, 11, 1.0, 0.0));
            this.scaleShiftPanel.add((Component)this.getScaleMinLabel(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 17, 1.0, 0.0));
            this.scaleShiftPanel.add((Component)this.getScaleCenterLabel(), Helpers.getGridBagConstraint(1, 1, 1, 1, 0, 10, 1.0, 0.0));
            this.scaleShiftPanel.add((Component)this.getScaleMaxLabel(), Helpers.getGridBagConstraint(2, 1, 1, 1, 0, 13, 1.0, 0.0));
        }
        return this.scaleShiftPanel;
    }

    private JCheckBox getPitchShiftActive() {
        if (this.pitchShiftActive == null) {
            this.pitchShiftActive = new JCheckBox();
            this.pitchShiftActive.setName("pitchShiftActive");
            this.pitchShiftActive.setText("activate pitch shift");
            this.pitchShiftActive.setFont(Helpers.getDialogFont());
            if (this.thePitcher != null) {
                this.pitchShiftActive.setSelected(this.thePitcher.isActive());
            }
            this.pitchShiftActive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if ((e.getStateChange() == 1 || e.getStateChange() == 2) && PitchShiftGUI.this.thePitcher != null) {
                        PitchShiftGUI.this.thePitcher.setIsActive(PitchShiftGUI.this.getPitchShiftActive().isSelected());
                    }
                }
            });
        }
        return this.pitchShiftActive;
    }

    private JSlider getPitchSlider() {
        if (this.pitchSlider == null) {
            int value = (int)(Math.log10(this.thePitcher.getPitchScale()) / factor * 100.0);
            if (value > 100) {
                value = 100;
            } else if (value < -100) {
                value = -100;
            }
            this.pitchSlider = new JSlider(0, -100, 100, value);
            this.pitchSlider.setFont(Helpers.getDialogFont());
            this.pitchSlider.setMinorTickSpacing(10);
            this.pitchSlider.setMajorTickSpacing(50);
            this.pitchSlider.setPaintTicks(true);
            this.pitchSlider.setSnapToTicks(false);
            this.pitchSlider.setPaintLabels(false);
            this.pitchSlider.setPaintTrack(true);
            this.pitchSlider.setToolTipText(Float.toString((float)Math.round((float)value * 10.0f) / 1000.0f));
            this.pitchSlider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        PitchShiftGUI.this.getPitchSlider().setValue(0);
                        e.consume();
                    }
                }
            });
            this.pitchSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    double value = (double)PitchShiftGUI.this.getPitchSlider().getValue() / 100.0;
                    PitchShiftGUI.this.thePitcher.setPitchScale((float)Math.pow(10.0, value * factor));
                    PitchShiftGUI.this.pitchSlider.setToolTipText(Float.toString((float)Math.round(value * 10.0) / 10.0f));
                }
            });
        }
        return this.pitchSlider;
    }

    public JLabel getPitchMinLabel() {
        if (this.pitchMinLable == null) {
            this.pitchMinLable = new JLabel("one octave down");
            this.pitchMinLable.setFont(Helpers.getDialogFont());
        }
        return this.pitchMinLable;
    }

    public JLabel getPitchCenterLabel() {
        if (this.pitchCenterLable == null) {
            this.pitchCenterLable = new JLabel("center");
            this.pitchCenterLable.setFont(Helpers.getDialogFont());
        }
        return this.pitchCenterLable;
    }

    public JLabel getPitchMaxLabel() {
        if (this.pitchMaxLable == null) {
            this.pitchMaxLable = new JLabel("one octave up");
            this.pitchMaxLable.setFont(Helpers.getDialogFont());
        }
        return this.pitchMaxLable;
    }

    private JSlider getScaleSlider() {
        if (this.sampleScaleSlider == null) {
            int value = (int)(Math.log10(this.thePitcher.getSampleScale()) / factor * 100.0);
            if (value > 100) {
                value = 100;
            } else if (value < -100) {
                value = -100;
            }
            this.sampleScaleSlider = new JSlider(0, -100, 100, value);
            this.sampleScaleSlider.setFont(Helpers.getDialogFont());
            this.sampleScaleSlider.setMinorTickSpacing(10);
            this.sampleScaleSlider.setMajorTickSpacing(50);
            this.sampleScaleSlider.setPaintTicks(true);
            this.sampleScaleSlider.setSnapToTicks(false);
            this.sampleScaleSlider.setPaintLabels(false);
            this.sampleScaleSlider.setPaintTrack(true);
            this.sampleScaleSlider.setToolTipText(Float.toString((float)Math.round((float)value * 10.0f) / 1000.0f));
            this.sampleScaleSlider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        PitchShiftGUI.this.getScaleSlider().setValue(0);
                        e.consume();
                    }
                }
            });
            this.sampleScaleSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    double value = (double)PitchShiftGUI.this.getScaleSlider().getValue() / 100.0;
                    PitchShiftGUI.this.thePitcher.setPitchAndSampleScale((float)Math.pow(10.0, -value * factor), (float)Math.pow(10.0, value * factor));
                    PitchShiftGUI.this.sampleScaleSlider.setToolTipText(Float.toString((float)Math.round(value * 10.0) / 10.0f));
                    PitchShiftGUI.this.getPitchSlider().setValue((int)(-value * 100.0));
                }
            });
        }
        return this.sampleScaleSlider;
    }

    public JLabel getScaleMinLabel() {
        if (this.scaleMinLable == null) {
            this.scaleMinLable = new JLabel("half speed");
            this.scaleMinLable.setFont(Helpers.getDialogFont());
        }
        return this.scaleMinLable;
    }

    public JLabel getScaleCenterLabel() {
        if (this.scaleCenterLable == null) {
            this.scaleCenterLable = new JLabel("normal");
            this.scaleCenterLable.setFont(Helpers.getDialogFont());
        }
        return this.scaleCenterLable;
    }

    public JLabel getScaleMaxLabel() {
        if (this.scaleMaxLable == null) {
            this.scaleMaxLable = new JLabel("double speed");
            this.scaleMaxLable.setFont(Helpers.getDialogFont());
        }
        return this.scaleMaxLable;
    }
}

