/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class MultimediaContainer {
    private ArrayList<MultimediaContainerEventListener> listeners = new ArrayList();
    private URL fileURL;

    public MultimediaContainer getInstance(URL url) {
        this.fileURL = url;
        return this;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public String getPrintableFileUrl() {
        return this.getPrintableFileUrl(this.getFileURL());
    }

    public String getPrintableFileUrl(URL urlName) {
        if (urlName == null) {
            return "";
        }
        try {
            File f = new File(urlName.toURI());
            try {
                return f.getCanonicalPath();
            }
            catch (IOException ex) {
                return f.getAbsolutePath();
            }
        }
        catch (Throwable e) {
            return urlName.toExternalForm();
        }
    }

    public void updateLookAndFeel() {
        JPanel infoPanel = this.getInfoPanel();
        JPanel configPanel = this.getConfigPanel();
        if (infoPanel != null) {
            SwingUtilities.updateComponentTreeUI(infoPanel);
        }
        if (configPanel != null) {
            SwingUtilities.updateComponentTreeUI(configPanel);
        }
    }

    public void addListener(MultimediaContainerEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MultimediaContainerEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMultimediaContainerEvent(MultimediaContainerEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).multimediaContainerEventOccured(event);
        }
    }

    public String getSongName() {
        return MultimediaContainerManager.getSongNameFromURL(this.fileURL);
    }

    public abstract Object[] getSongInfosFor(URL var1);

    public abstract boolean canExport();

    public abstract JPanel getInfoPanel();

    public abstract JPanel getConfigPanel();

    public abstract String[] getFileExtensionList();

    public abstract String getName();

    public abstract void configurationChanged(Properties var1);

    public abstract void configurationSave(Properties var1);

    public abstract Mixer createNewMixer();
}

