/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia;

import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.sound.sampled.UnsupportedAudioFileException;

public class MultimediaContainerManager {
    private static HashMap<String, MultimediaContainer> fileExtensionMap;
    private static ArrayList<MultimediaContainer> containerArray;
    private static Properties containerConfigs;

    private MultimediaContainerManager() {
    }

    public static HashMap<String, MultimediaContainer> getFileExtensionMap() {
        if (fileExtensionMap == null) {
            fileExtensionMap = new HashMap();
        }
        return fileExtensionMap;
    }

    public static ArrayList<MultimediaContainer> getContainerArray() {
        if (containerArray == null) {
            containerArray = new ArrayList();
        }
        return containerArray;
    }

    public static Properties getContainerConfigs() {
        if (containerConfigs == null) {
            containerConfigs = new Properties();
        }
        return containerConfigs;
    }

    public static void getContainerConfigs(Properties intoProps) {
        MultimediaContainerManager.fireConfiggurationSave();
        Enumeration<Object> propertyEnum = MultimediaContainerManager.getContainerConfigs().keys();
        while (propertyEnum.hasMoreElements()) {
            Object key = propertyEnum.nextElement();
            Object value = MultimediaContainerManager.getContainerConfigs().get(key);
            intoProps.put(key, value);
        }
    }

    public static void configureContainer(Properties fromProps) {
        Enumeration<Object> propertyEnum = fromProps.keys();
        while (propertyEnum.hasMoreElements()) {
            Object key = propertyEnum.nextElement();
            Object value = fromProps.get(key);
            MultimediaContainerManager.getContainerConfigs().put(key, value);
        }
        MultimediaContainerManager.fireConfiggurationChanged();
    }

    private static void fireConfiggurationChanged() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        for (int i = 0; i < listeners.size(); ++i) {
            listeners.get(i).configurationChanged(MultimediaContainerManager.getContainerConfigs());
        }
    }

    private static void fireConfiggurationSave() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        for (int i = 0; i < listeners.size(); ++i) {
            listeners.get(i).configurationSave(MultimediaContainerManager.getContainerConfigs());
        }
    }

    public static void registerContainer(MultimediaContainer container) {
        MultimediaContainerManager.getContainerArray().add(container);
        String[] extensions = container.getFileExtensionList();
        for (int i = 0; i < extensions.length; ++i) {
            MultimediaContainerManager.getFileExtensionMap().put(extensions[i], container);
        }
    }

    public static void deregisterContainer(MultimediaContainer container) {
        MultimediaContainerManager.getContainerArray().remove(container);
        String[] extensions = container.getFileExtensionList();
        for (int i = 0; i < extensions.length; ++i) {
            MultimediaContainerManager.getFileExtensionMap().remove(extensions[i]);
        }
    }

    public static void updateLookAndFeel() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        for (int i = 0; i < listeners.size(); ++i) {
            listeners.get(i).updateLookAndFeel();
        }
    }

    public static String[] getSupportedFileExtensions() {
        Set<String> keys = MultimediaContainerManager.getFileExtensionMap().keySet();
        String[] result = new String[keys.size()];
        return keys.toArray(result);
    }

    public static HashMap<String, String[]> getSupportedFileExtensionsPerContainer() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        HashMap<String, String[]> result = new HashMap<String, String[]>(listeners.size());
        for (int i = 0; i < listeners.size(); ++i) {
            result.put(listeners.get(i).getName(), listeners.get(i).getFileExtensionList());
        }
        return result;
    }

    public static MultimediaContainer getMultimediaContainerForType(String type) throws UnsupportedAudioFileException {
        MultimediaContainer container = MultimediaContainerManager.getFileExtensionMap().get(type.toLowerCase());
        if (container == null) {
            throw new UnsupportedAudioFileException(type);
        }
        return container;
    }

    public static MultimediaContainer getMultimediaContainerSingleton(URL url) throws UnsupportedAudioFileException {
        String fileName = url.getPath();
        MultimediaContainer baseContainer = MultimediaContainerManager.getFileExtensionMap().get(Helpers.getExtensionFrom(fileName));
        if (baseContainer == null) {
            baseContainer = MultimediaContainerManager.getFileExtensionMap().get(Helpers.getPreceedingExtensionFrom(fileName));
        }
        if (baseContainer == null) {
            if (url.getProtocol().equalsIgnoreCase("file")) {
                throw new UnsupportedAudioFileException(fileName);
            }
            baseContainer = MultimediaContainerManager.getFileExtensionMap().get("mp3");
        }
        return baseContainer;
    }

    public static MultimediaContainer getMultimediaContainer(URL url) throws UnsupportedAudioFileException {
        MultimediaContainer baseContainer = MultimediaContainerManager.getMultimediaContainerSingleton(url);
        MultimediaContainer container = baseContainer.getInstance(url);
        if (container == null) {
            throw new UnsupportedAudioFileException(url.getPath());
        }
        return container;
    }

    public static MultimediaContainer getMultimediaContainer(URI uri) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(uri.toURL());
    }

    public static MultimediaContainer getMultimediaContainer(File file) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(file.toURI());
    }

    public static MultimediaContainer getMultimediaContainer(String fileName) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(new File(fileName));
    }

    public static void addMultimediaContainerEventListener(MultimediaContainerEventListener listener) {
        ArrayList<MultimediaContainer> containers = MultimediaContainerManager.getContainerArray();
        for (int i = 0; i < containers.size(); ++i) {
            containers.get(i).addListener(listener);
        }
    }

    public static void removeMultimediaContainerEventListener(MultimediaContainerEventListener listener) {
        ArrayList<MultimediaContainer> containers = MultimediaContainerManager.getContainerArray();
        for (int i = 0; i < containers.size(); ++i) {
            containers.get(i).removeListener(listener);
        }
    }

    public static String getSongNameFromURL(URL url) {
        if (url == null) {
            return "";
        }
        String result = Helpers.createStringFomURL(url);
        int lastSlash = result.lastIndexOf(47);
        int dot = result.lastIndexOf(46);
        if (dot == -1 || dot < lastSlash) {
            dot = result.length();
        }
        return result.substring(lastSlash + 1, dot);
    }

    public static String getSongNameFromFile(File fileName) {
        if (fileName == null) {
            return "";
        }
        String result = fileName.getAbsolutePath();
        int lastSlash = result.lastIndexOf(File.separatorChar);
        int dot = result.lastIndexOf(46);
        if (dot == -1 || dot < lastSlash) {
            dot = result.length();
        }
        return result.substring(lastSlash + 1, dot);
    }

    public static Object[] getSongInfosFor(URL url) {
        try {
            MultimediaContainer container = MultimediaContainerManager.getMultimediaContainerSingleton(url);
            if (container != null) {
                return container.getSongInfosFor(url);
            }
        }
        catch (UnsupportedAudioFileException ex) {
            Log.error("IGNORED", ex);
        }
        return new Object[]{MultimediaContainerManager.getSongNameFromURL(url) + " UNSUPPORTED FILE", -1L};
    }
}

