/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ape;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.ape.APEInfoPanel;
import de.quippy.javamod.multimedia.ape.APEMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.tools.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class APEContainer
extends MultimediaContainer {
    private static final String[] APEFILEEXTENSION = new String[]{"ape", "apl", "mac"};
    private JPanel apeInfoPanel;
    private APETag idTag;

    @Override
    public boolean canExport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultimediaContainer getInstance(URL url) {
        MultimediaContainer result = super.getInstance(url);
        File apeFile = null;
        try {
            apeFile = File.createFile(url, "r");
            IAPEDecompress spAPEDecompress = IAPEDecompress.CreateIAPEDecompress(apeFile);
            this.idTag = spAPEDecompress.getApeInfoTag();
            ((APEInfoPanel)this.getInfoPanel()).fillInfoPanelWith(spAPEDecompress, this.getPrintableFileUrl(), this.getSongName());
        }
        catch (IOException ex) {
        }
        finally {
            if (apeFile != null) {
                try {
                    apeFile.close();
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
        }
        return result;
    }

    @Override
    public Mixer createNewMixer() {
        return new APEMixer(this.getFileURL());
    }

    private String getSongName(APETag idTag, URL forURL) {
        if (idTag != null) {
            try {
                String artist = idTag.GetFieldString("Artist");
                String album = idTag.GetFieldString("Album");
                String title = idTag.GetFieldString("Title");
                if (title == null || title.length() == 0) {
                    title = MultimediaContainerManager.getSongNameFromURL(forURL);
                }
                StringBuilder str = new StringBuilder();
                if (artist != null && artist.length() != 0) {
                    str.append(artist).append(" - ");
                }
                if (album != null && album.length() != 0) {
                    str.append(album).append(" - ");
                }
                return str.append(title).toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return MultimediaContainerManager.getSongNameFromURL(forURL);
    }

    @Override
    public String getSongName() {
        if (this.idTag != null) {
            return this.getSongName(this.idTag, this.getFileURL());
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL url) {
        String songName = MultimediaContainerManager.getSongNameFromURL(url);
        Long duration = -1L;
        try {
            File apeFile = File.createFile(url, "r");
            IAPEDecompress spAPEDecompress = IAPEDecompress.CreateIAPEDecompress(apeFile);
            APETag idTag = spAPEDecompress.getApeInfoTag();
            songName = this.getSongName(idTag, url);
            duration = spAPEDecompress.getApeInfoDecompressLengthMS();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return new Object[]{songName, duration};
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.apeInfoPanel == null) {
            this.apeInfoPanel = new APEInfoPanel();
        }
        return this.apeInfoPanel;
    }

    @Override
    public void configurationChanged(Properties newProps) {
    }

    @Override
    public void configurationSave(Properties props) {
    }

    @Override
    public String[] getFileExtensionList() {
        return APEFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "APE-File";
    }

    static {
        MultimediaContainerManager.registerContainer(new APEContainer());
    }
}

