/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ape;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.tools.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;

public class APEMixer
extends BasicMixer {
    private URL apeFileURL;
    private File apeFile;
    private IAPEDecompress spAPEDecompress;
    private int blocksPerDecode;
    private int blockAlign;
    private int channels;
    private int bitsPerSample;
    private int sampleRate;
    private byte[] output;

    public APEMixer(URL apeFileURL) {
        this.apeFileURL = apeFileURL;
        this.initialize();
    }

    private void initialize() {
        try {
            this.apeFile = File.createFile(this.apeFileURL, "r");
            this.spAPEDecompress = IAPEDecompress.CreateIAPEDecompress(this.apeFile);
            this.blockAlign = this.spAPEDecompress.getApeInfoBlockAlign();
            this.channels = this.spAPEDecompress.getApeInfoChannels();
            this.bitsPerSample = this.spAPEDecompress.getApeInfoBitsPerSample();
            this.sampleRate = this.spAPEDecompress.getApeInfoSampleRate();
            this.blocksPerDecode = 250 * this.sampleRate / 1000;
            int bufferSize = this.blockAlign * this.blocksPerDecode;
            this.output = new byte[bufferSize];
            AudioFormat audioFormat = new AudioFormat(this.sampleRate, this.bitsPerSample, this.channels, true, false);
            this.setAudioFormat(audioFormat);
            this.openAudioDevice();
        }
        catch (Exception ex) {
            if (this.apeFile != null) {
                try {
                    this.apeFile.close();
                    this.apeFile = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            Log.error("[APEMixer]", ex);
        }
    }

    @Override
    public int getChannelCount() {
        if (this.spAPEDecompress == null) {
            return 0;
        }
        return this.spAPEDecompress.getApeInfoChannels();
    }

    @Override
    public int getCurrentKBperSecond() {
        if (this.spAPEDecompress == null) {
            return 0;
        }
        try {
            return this.spAPEDecompress.getApeInfoDecompressCurrentBitRate();
        }
        catch (IOException ex) {
            return this.spAPEDecompress.getApeInfoAverageBitrate();
        }
    }

    @Override
    public int getCurrentSampleFrequency() {
        if (this.spAPEDecompress == null) {
            return 0;
        }
        return this.spAPEDecompress.getApeInfoSampleRate() / 1000;
    }

    @Override
    public long getLengthInMilliseconds() {
        if (this.spAPEDecompress == null) {
            return 0L;
        }
        return this.spAPEDecompress.getApeInfoDecompressLengthMS();
    }

    @Override
    public long getMillisecondPosition() {
        if (this.spAPEDecompress == null) {
            return 0L;
        }
        return this.spAPEDecompress.getApeInfoDecompressCurrentMS();
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    protected void seek(long milliseconds) {
        try {
            this.spAPEDecompress.Seek((int)(milliseconds * (long)this.sampleRate / 1000L));
        }
        catch (Exception ex) {
            Log.error("[APEMixer]", ex);
        }
    }

    private void cleanUp() {
        if (this.spAPEDecompress != null) {
            this.spAPEDecompress = null;
        }
        if (this.apeFile != null) {
            try {
                this.apeFile.close();
                this.apeFile = null;
            }
            catch (IOException e) {
                Log.error("IGNORED", e);
            }
        }
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            int nBlocksDecoded = 0;
            do {
                if ((nBlocksDecoded = this.spAPEDecompress.GetData(this.output, this.blocksPerDecode)) <= 0 || !this.isInitialized()) continue;
                int byteCount = nBlocksDecoded * this.blockAlign;
                this.writeSampleDataToLine(this.output, 0, byteCount);
                if (this.isStopping()) {
                    this.setIsStopped();
                    break;
                }
                if (this.isPausing()) {
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (!this.isInSeeking()) continue;
                this.setIsSeeking();
                while (this.isInSeeking()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (nBlocksDecoded > 0);
            if (nBlocksDecoded <= 0) {
                this.setHasFinished();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            this.cleanUp();
        }
    }
}

