/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.flac;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.flac.FLACInfoPanel;
import de.quippy.javamod.multimedia.flac.FLACMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jflac.FLACDecoder;
import de.quippy.jflac.metadata.VorbisComment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;
import javax.swing.JPanel;

public class FLACContainer
extends MultimediaContainer {
    private static final String[] FLACFILEEXTENSION = new String[]{"flac"};
    private JPanel flacInfoPanel;
    private VorbisComment vorbisComment;

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public MultimediaContainer getInstance(URL url) {
        MultimediaContainer result = super.getInstance(url);
        FileOrPackedInputStream inputStream = null;
        try {
            inputStream = new FileOrPackedInputStream(url);
            FLACDecoder decoder = new FLACDecoder(inputStream);
            decoder.readMetadata();
            this.vorbisComment = decoder.getVorbisComment();
            AudioFormat audioFormat = decoder.getStreamInfo().getAudioFormat();
            long sampleRate = (long)audioFormat.getSampleRate();
            long duration = decoder.getStreamInfo().getTotalSamples() * 1000L / sampleRate;
            ((FLACInfoPanel)this.getInfoPanel()).fillInfoPanelWith(audioFormat, duration, this.getSongName(), decoder.getVorbisComment());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
        return result;
    }

    private String getSongName(VorbisComment vorbisComment, URL forURL) {
        if (vorbisComment != null) {
            try {
                String artist = vorbisComment.getArtist();
                String album = vorbisComment.getAlbum();
                String title = vorbisComment.getTitle();
                if (title == null || title.length() == 0) {
                    title = MultimediaContainerManager.getSongNameFromURL(forURL);
                }
                StringBuilder str = new StringBuilder();
                if (artist != null && artist.length() != 0) {
                    str.append(artist).append(" - ");
                }
                if (album != null && album.length() != 0) {
                    str.append(album).append(" - ");
                }
                return str.append(title).toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return MultimediaContainerManager.getSongNameFromURL(forURL);
    }

    @Override
    public String getSongName() {
        if (this.vorbisComment != null) {
            return this.getSongName(this.vorbisComment, this.getFileURL());
        }
        return super.getSongName();
    }

    @Override
    public Mixer createNewMixer() {
        return new FLACMixer(this.getFileURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getSongInfosFor(URL url) {
        String songName = MultimediaContainerManager.getSongNameFromURL(url);
        Long duration = -1L;
        FileOrPackedInputStream inputStream = null;
        try {
            inputStream = new FileOrPackedInputStream(url);
            FLACDecoder decoder = new FLACDecoder(inputStream);
            decoder.readMetadata();
            VorbisComment vorbisComment = decoder.getVorbisComment();
            songName = this.getSongName(vorbisComment, url);
            AudioFormat audioFormat = decoder.getStreamInfo().getAudioFormat();
            long sampleRate = (long)audioFormat.getSampleRate();
            duration = decoder.getStreamInfo().getTotalSamples() * 1000L / sampleRate;
        }
        catch (Throwable ex) {
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
        return new Object[]{songName, duration};
    }

    @Override
    public String getName() {
        return "FLAC-File";
    }

    @Override
    public String[] getFileExtensionList() {
        return FLACFILEEXTENSION;
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.flacInfoPanel == null) {
            this.flacInfoPanel = new FLACInfoPanel();
        }
        return this.flacInfoPanel;
    }

    @Override
    public void configurationChanged(Properties newProps) {
    }

    @Override
    public void configurationSave(Properties props) {
    }

    static {
        MultimediaContainerManager.registerContainer(new FLACContainer());
    }
}

