/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.flac;

import de.quippy.javamod.multimedia.mp3.id3.NullsoftID3GenreTable;
import de.quippy.javamod.system.Helpers;
import de.quippy.jflac.metadata.VorbisComment;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.sound.sampled.AudioFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FLACInfoPanel
extends JPanel {
    private static final long serialVersionUID = 8005898124149359343L;
    private JLabel flacNameLabel = null;
    private JTextField flacName = null;
    private JLabel flacDurationLabel = null;
    private JTextField flacDuration = null;
    private JLabel flacSampleSizeInBitsLabel = null;
    private JTextField flacSampleSizeInBits = null;
    private JLabel flacFrequencyLabel = null;
    private JTextField flacFrequency = null;
    private JLabel flacChannelsLabel = null;
    private JTextField flacChannels = null;
    private JLabel flacEncodingLabel = null;
    private JTextField flacEncoding = null;
    private JPanel flacIDPanel = null;
    private JLabel v1_L_Track = null;
    private JTextField v1_Track = null;
    private JLabel v1_L_Title = null;
    private JTextField v1_Title = null;
    private JLabel v1_L_Artist = null;
    private JTextField v1_Artist = null;
    private JLabel v1_L_Album = null;
    private JTextField v1_Album = null;
    private JLabel v1_L_Year = null;
    private JTextField v1_Year = null;
    private JLabel v1_L_Genre = null;
    private JComboBox v1_Genre = null;
    private JLabel v1_L_Comment = null;
    private JScrollPane scrollPane_comment = null;
    private JTextArea v1_Comment = null;

    public FLACInfoPanel() {
        this.initialize();
    }

    public FLACInfoPanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public FLACInfoPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public FLACInfoPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    private void initialize() {
        this.setName("FlacInfoPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getFlacNameLabel(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacName(), Helpers.getGridBagConstraint(1, 0, 1, 0, 2, 17, 1.0, 0.0));
        this.add((Component)this.getFlacFrequencyLabel(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacFrequency(), Helpers.getGridBagConstraint(1, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacSampleSizeInBitsLabel(), Helpers.getGridBagConstraint(2, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacSampleSizeInBits(), Helpers.getGridBagConstraint(3, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacChannelsLabel(), Helpers.getGridBagConstraint(4, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacChannels(), Helpers.getGridBagConstraint(5, 1, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacEncodingLabel(), Helpers.getGridBagConstraint(0, 2, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacEncoding(), Helpers.getGridBagConstraint(1, 2, 1, 3, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacDurationLabel(), Helpers.getGridBagConstraint(4, 2, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacDuration(), Helpers.getGridBagConstraint(5, 2, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getFlacIDPanel(), Helpers.getGridBagConstraint(0, 3, 1, 0, 1, 17, 1.0, 1.0));
    }

    public JLabel getFlacNameLabel() {
        if (this.flacNameLabel == null) {
            this.flacNameLabel = new JLabel("Flac file name:");
            this.flacNameLabel.setFont(Helpers.getDialogFont());
        }
        return this.flacNameLabel;
    }

    public JTextField getFlacName() {
        if (this.flacName == null) {
            this.flacName = new JTextField();
            this.flacName.setEditable(false);
            this.flacName.setFont(Helpers.getDialogFont());
        }
        return this.flacName;
    }

    public JLabel getFlacDurationLabel() {
        if (this.flacDurationLabel == null) {
            this.flacDurationLabel = new JLabel("Duration:");
            this.flacDurationLabel.setFont(Helpers.getDialogFont());
        }
        return this.flacDurationLabel;
    }

    public JTextField getFlacDuration() {
        if (this.flacDuration == null) {
            this.flacDuration = new JTextField();
            this.flacDuration.setEditable(false);
            this.flacDuration.setColumns(5);
            this.flacDuration.setFont(Helpers.getDialogFont());
        }
        return this.flacDuration;
    }

    public JLabel getFlacFrequencyLabel() {
        if (this.flacFrequencyLabel == null) {
            this.flacFrequencyLabel = new JLabel("Rate:");
            this.flacFrequencyLabel.setFont(Helpers.getDialogFont());
        }
        return this.flacFrequencyLabel;
    }

    public JTextField getFlacFrequency() {
        if (this.flacFrequency == null) {
            this.flacFrequency = new JTextField();
            this.flacFrequency.setEditable(false);
            this.flacFrequency.setColumns(5);
            this.flacFrequency.setFont(Helpers.getDialogFont());
        }
        return this.flacFrequency;
    }

    public JLabel getFlacSampleSizeInBitsLabel() {
        if (this.flacSampleSizeInBitsLabel == null) {
            this.flacSampleSizeInBitsLabel = new JLabel("Bits:");
            this.flacSampleSizeInBitsLabel.setFont(Helpers.getDialogFont());
        }
        return this.flacSampleSizeInBitsLabel;
    }

    public JTextField getFlacSampleSizeInBits() {
        if (this.flacSampleSizeInBits == null) {
            this.flacSampleSizeInBits = new JTextField();
            this.flacSampleSizeInBits.setEditable(false);
            this.flacSampleSizeInBits.setColumns(5);
            this.flacSampleSizeInBits.setFont(Helpers.getDialogFont());
        }
        return this.flacSampleSizeInBits;
    }

    public JLabel getFlacChannelsLabel() {
        if (this.flacChannelsLabel == null) {
            this.flacChannelsLabel = new JLabel("Channel:");
            this.flacChannelsLabel.setFont(Helpers.getDialogFont());
        }
        return this.flacChannelsLabel;
    }

    public JTextField getFlacChannels() {
        if (this.flacChannels == null) {
            this.flacChannels = new JTextField();
            this.flacChannels.setEditable(false);
            this.flacChannels.setColumns(5);
            this.flacChannels.setFont(Helpers.getDialogFont());
        }
        return this.flacChannels;
    }

    public JLabel getFlacEncodingLabel() {
        if (this.flacEncodingLabel == null) {
            this.flacEncodingLabel = new JLabel("Encoding:");
            this.flacEncodingLabel.setFont(Helpers.getDialogFont());
        }
        return this.flacEncodingLabel;
    }

    public JTextField getFlacEncoding() {
        if (this.flacEncoding == null) {
            this.flacEncoding = new JTextField();
            this.flacEncoding.setEditable(false);
            this.flacEncoding.setColumns(10);
            this.flacEncoding.setFont(Helpers.getDialogFont());
        }
        return this.flacEncoding;
    }

    private JPanel getFlacIDPanel() {
        if (this.flacIDPanel == null) {
            this.flacIDPanel = new JPanel();
            this.flacIDPanel.setLayout(new GridBagLayout());
            this.flacIDPanel.add((Component)this.getV1_L_Track(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 12, 0.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_Track(), Helpers.getGridBagConstraint(1, 0, 1, 0, 2, 18, 1.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_L_Title(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 12, 0.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_Title(), Helpers.getGridBagConstraint(1, 1, 1, 0, 2, 18, 1.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_L_Artist(), Helpers.getGridBagConstraint(0, 2, 1, 1, 0, 12, 0.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_Artist(), Helpers.getGridBagConstraint(1, 2, 1, 0, 2, 18, 1.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_L_Album(), Helpers.getGridBagConstraint(0, 3, 1, 1, 0, 12, 0.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_Album(), Helpers.getGridBagConstraint(1, 3, 1, 0, 2, 18, 1.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_L_Year(), Helpers.getGridBagConstraint(0, 4, 1, 1, 0, 12, 0.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_Year(), Helpers.getGridBagConstraint(1, 4, 1, 1, 2, 18, 1.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_L_Genre(), Helpers.getGridBagConstraint(2, 4, 1, 1, 0, 12, 0.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_Genre(), Helpers.getGridBagConstraint(3, 4, 1, 0, 2, 18, 1.0, 0.0));
            this.flacIDPanel.add((Component)this.getV1_L_Comment(), Helpers.getGridBagConstraint(0, 5, 1, 1, 0, 12, 0.0, 0.0));
            this.flacIDPanel.add((Component)this.getScrollPane_Comment(), Helpers.getGridBagConstraint(1, 5, 1, 0, 1, 18, 1.0, 1.0));
            this.flacIDPanel.add((Component)new JPanel(), Helpers.getGridBagConstraint(1, 5, 1, 0, 1, 12, 1.0, 1.0));
        }
        return this.flacIDPanel;
    }

    private JLabel getV1_L_Track() {
        if (this.v1_L_Track == null) {
            this.v1_L_Track = new JLabel();
            this.v1_L_Track.setName("v1_L_Track");
            this.v1_L_Track.setText("Track #");
            this.v1_L_Track.setFont(Helpers.getDialogFont());
        }
        return this.v1_L_Track;
    }

    private JTextField getV1_Track() {
        if (this.v1_Track == null) {
            this.v1_Track = new JTextField();
            this.v1_Track.setName("v1_Track");
            this.v1_Track.setFont(Helpers.getDialogFont());
            this.v1_Track.setEditable(true);
        }
        return this.v1_Track;
    }

    private JLabel getV1_L_Title() {
        if (this.v1_L_Title == null) {
            this.v1_L_Title = new JLabel();
            this.v1_L_Title.setName("v1_L_Title");
            this.v1_L_Title.setText("Title");
            this.v1_L_Title.setFont(Helpers.getDialogFont());
        }
        return this.v1_L_Title;
    }

    private JTextField getV1_Title() {
        if (this.v1_Title == null) {
            this.v1_Title = new JTextField();
            this.v1_Title.setName("v1_Title");
            this.v1_Title.setFont(Helpers.getDialogFont());
            this.v1_Title.setEditable(true);
        }
        return this.v1_Title;
    }

    private JLabel getV1_L_Artist() {
        if (this.v1_L_Artist == null) {
            this.v1_L_Artist = new JLabel();
            this.v1_L_Artist.setName("v1_L_Artist");
            this.v1_L_Artist.setText("Artist");
            this.v1_L_Artist.setFont(Helpers.getDialogFont());
        }
        return this.v1_L_Artist;
    }

    private JTextField getV1_Artist() {
        if (this.v1_Artist == null) {
            this.v1_Artist = new JTextField();
            this.v1_Artist.setName("v1_Artist");
            this.v1_Artist.setFont(Helpers.getDialogFont());
            this.v1_Artist.setEditable(true);
        }
        return this.v1_Artist;
    }

    private JLabel getV1_L_Album() {
        if (this.v1_L_Album == null) {
            this.v1_L_Album = new JLabel();
            this.v1_L_Album.setName("v1_L_Album");
            this.v1_L_Album.setText("Album");
            this.v1_L_Album.setFont(Helpers.getDialogFont());
        }
        return this.v1_L_Album;
    }

    private JTextField getV1_Album() {
        if (this.v1_Album == null) {
            this.v1_Album = new JTextField();
            this.v1_Album.setName("v1_Album");
            this.v1_Album.setFont(Helpers.getDialogFont());
            this.v1_Album.setEditable(true);
        }
        return this.v1_Album;
    }

    private JLabel getV1_L_Year() {
        if (this.v1_L_Year == null) {
            this.v1_L_Year = new JLabel();
            this.v1_L_Year.setName("v1_L_Year");
            this.v1_L_Year.setText("Year");
            this.v1_L_Year.setFont(Helpers.getDialogFont());
        }
        return this.v1_L_Year;
    }

    private JTextField getV1_Year() {
        if (this.v1_Year == null) {
            this.v1_Year = new JTextField();
            this.v1_Year.setName("v1_Year");
            this.v1_Year.setFont(Helpers.getDialogFont());
            this.v1_Year.setEditable(true);
        }
        return this.v1_Year;
    }

    private JLabel getV1_L_Genre() {
        if (this.v1_L_Genre == null) {
            this.v1_L_Genre = new JLabel();
            this.v1_L_Genre.setName("v1_L_Genre");
            this.v1_L_Genre.setText("Genre");
            this.v1_L_Genre.setFont(Helpers.getDialogFont());
        }
        return this.v1_L_Genre;
    }

    private JComboBox getV1_Genre() {
        if (this.v1_Genre == null) {
            this.v1_Genre = new JComboBox<String>(NullsoftID3GenreTable.getGenres());
            this.v1_Genre.setName("v1_Genre");
            this.v1_Genre.setFont(Helpers.getDialogFont());
            this.v1_Genre.setEditable(true);
        }
        return this.v1_Genre;
    }

    private JLabel getV1_L_Comment() {
        if (this.v1_L_Comment == null) {
            this.v1_L_Comment = new JLabel();
            this.v1_L_Comment.setName("v1_L_Comment");
            this.v1_L_Comment.setText("Comment");
            this.v1_L_Comment.setFont(Helpers.getDialogFont());
        }
        return this.v1_L_Comment;
    }

    private JScrollPane getScrollPane_Comment() {
        if (this.scrollPane_comment == null) {
            this.scrollPane_comment = new JScrollPane();
            this.scrollPane_comment.setName("scrollPane_comment");
            this.scrollPane_comment.setViewportView(this.getV1_Comment());
        }
        return this.scrollPane_comment;
    }

    private JTextArea getV1_Comment() {
        if (this.v1_Comment == null) {
            this.v1_Comment = new JTextArea();
            this.v1_Comment.setName("v1_Comment");
            this.v1_Comment.setFont(Helpers.getDialogFont());
            this.v1_Comment.setLineWrap(true);
            this.v1_Comment.setWrapStyleWord(true);
            this.v1_Comment.setEditable(true);
        }
        return this.v1_Comment;
    }

    public void fillInfoPanelWith(AudioFormat audioFormat, long lengthInMilliseconds, String songName, VorbisComment vorbisComment) {
        this.getFlacName().setText(songName);
        this.getFlacFrequency().setText(Integer.toString((int)audioFormat.getSampleRate()));
        this.getFlacSampleSizeInBits().setText(Integer.toString(audioFormat.getSampleSizeInBits()));
        this.getFlacChannels().setText(Integer.toString(audioFormat.getChannels()));
        this.getFlacEncoding().setText(audioFormat.getEncoding().toString());
        this.getFlacDuration().setText(Helpers.getTimeStringFromMilliseconds(lengthInMilliseconds));
        if (vorbisComment != null) {
            String totalDiscs;
            String disc;
            String totalTracks;
            StringBuilder sb = new StringBuilder();
            String track = vorbisComment.getTrackNumber();
            if (track.length() > 0) {
                sb.append("Track ").append(track);
            }
            if ((totalTracks = vorbisComment.getTotalTracks()).length() > 0) {
                sb.append(" of ").append(totalTracks);
            }
            if ((disc = vorbisComment.getDiscNumber()).length() > 0) {
                sb.append(" Disc ").append(disc);
            }
            if ((totalDiscs = vorbisComment.getTotalDiscs()).length() > 0) {
                sb.append(" of ").append(totalDiscs);
            }
            this.getV1_Track().setText(sb.toString());
            this.getV1_Title().setText(vorbisComment.getTitle());
            this.getV1_Artist().setText(vorbisComment.getArtist());
            this.getV1_Album().setText(vorbisComment.getAlbum());
            this.getV1_Year().setText(vorbisComment.getDate());
            this.getV1_Genre().setSelectedItem(vorbisComment.getGenre());
            this.getV1_Comment().setText(vorbisComment.getComment());
            this.getV1_Comment().select(0, 0);
        }
    }
}

