/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.flac;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jflac.FLACDecoder;
import de.quippy.jflac.FrameDecodeException;
import de.quippy.jflac.frame.Frame;
import de.quippy.jflac.frame.Header;
import de.quippy.jflac.util.ByteData;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;

public class FLACMixer
extends BasicMixer {
    private InputStream inputStream;
    private FLACDecoder decoder;
    private URL flacFileUrl;
    private int channels;
    private int sampleRate;
    private int lengthInMilliseconds;

    public FLACMixer(URL flacFileUrl) {
        this.flacFileUrl = flacFileUrl;
        this.initialize();
    }

    private void initialize() {
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            this.inputStream = new FileOrPackedInputStream(this.flacFileUrl);
            this.decoder = new FLACDecoder(this.inputStream);
            this.decoder.readMetadata();
            AudioFormat audioFormat = this.decoder.getStreamInfo().getAudioFormat();
            this.setAudioFormat(audioFormat);
            this.channels = audioFormat.getChannels();
            this.sampleRate = (int)audioFormat.getSampleRate();
            this.lengthInMilliseconds = (int)(this.decoder.getStreamInfo().getTotalSamples() * 1000L / (long)this.sampleRate);
        }
        catch (Exception ex) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            Log.error("[FLACMixer]", ex);
        }
    }

    @Override
    public int getChannelCount() {
        return this.channels;
    }

    @Override
    public int getCurrentKBperSecond() {
        Header h;
        Frame f;
        if (this.decoder != null && (f = this.decoder.getCurrentFrame()) != null && (h = f.getHeader()) != null) {
            return h.blockSize * h.bitsPerSample * h.channels * 1000 / h.sampleRate;
        }
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.decoder != null) {
            Header h;
            Frame f = this.decoder.getCurrentFrame();
            if (f != null && (h = f.getHeader()) != null) {
                return h.sampleNumber * 1000L / (long)this.sampleRate;
            }
            return this.decoder.getSamplesDecoded() * 1000L / (long)this.sampleRate;
        }
        return 0L;
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    protected void seek(long milliseconds) {
        try {
            long seekToSamples = milliseconds * (long)this.sampleRate / 1000L;
            long currentSamples = this.getMillisecondPosition() * (long)this.sampleRate / 1000L;
            if (currentSamples > seekToSamples || this.decoder.getSeekTable() != null) {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        Log.error("IGNORED", e);
                    }
                }
                this.inputStream = this.flacFileUrl.openStream();
                this.decoder = new FLACDecoder(this.inputStream);
                this.decoder.readMetadata();
            }
            this.decoder.seekTo(seekToSamples);
        }
        catch (Throwable ex) {
            Log.error("[FLACMixer::seek]", ex);
        }
    }

    private ByteData decode() throws IOException {
        try {
            this.decoder.findFrameSync();
            Frame currentFrame = this.decoder.readFrame();
            return this.decoder.decodeFrame(currentFrame, null);
        }
        catch (FrameDecodeException ex) {
            return null;
        }
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            boolean finished = false;
            do {
                try {
                    ByteData bd = this.decode();
                    if (bd != null) {
                        byte[] b = bd.getData();
                        int len = bd.getLen();
                        this.writeSampleDataToLine(b, 0, len);
                    }
                }
                catch (EOFException ex) {
                    finished = true;
                }
                if (this.isStopping()) {
                    this.setIsStopped();
                    break;
                }
                if (this.isPausing()) {
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (!this.isInSeeking()) continue;
                this.setIsSeeking();
                while (this.isInSeeking()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (!finished);
            if (finished) {
                this.setHasFinished();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
        }
    }
}

