/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.io.wav.RMIFile;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.midi.MidiConfigPanel;
import de.quippy.javamod.multimedia.midi.MidiInfoPanel;
import de.quippy.javamod.multimedia.midi.MidiMixer;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JPanel;

public class MidiContainer
extends MultimediaContainer {
    private static final String[] MIDIFILEEXTENSION = new String[]{"mid", "rmf", "rmi"};
    public static final String PROPERTY_MIDIPLAYER_OUTPUTDEVICE = "javamod.player.midi.outputdevice";
    public static final String PROPERTY_MIDIPLAYER_SOUNDBANK = "javamod.player.midi.soundbankurl";
    public static final String PROPERTY_MIDIPLAYER_CAPTURE = "javamod.player.midi.capture";
    public static final String PROPERTY_MIDIPLAYER_MIXERNAME = "javamod.player.midi.mixername";
    public static final String PROPERTY_MIDIPLAYER_PORTNAME = "javamod.player.midi.portname";
    public static final String DEFAULT_OUTPUTDEVICE = "Java Sound Synthesizer";
    public static final String DEFAULT_SOUNDBANKURL = "";
    public static final String DEFAULT_CAPUTRE = "0";
    public static final String DEFAULT_MIXERNAME = "";
    public static final String DEFAULT_PORTNAME = "";
    public static final MidiDevice.Info[] MIDIOUTDEVICEINFOS = MidiContainer.getMidiOutDevices();
    public static final Mixer.Info[] MIXERDEVICEINFOS = MidiContainer.getInputMixerNames();
    private MidiConfigPanel midiConfigPanel;
    private JPanel midiInfoPanel;
    private MidiMixer currentMixer;
    private Sequence currentSequence;

    @Override
    public MultimediaContainer getInstance(URL midiFileUrl) {
        MultimediaContainer result = super.getInstance(midiFileUrl);
        this.currentSequence = this.getSequenceFromURL(midiFileUrl);
        ((MidiInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.currentSequence, this.getSongName());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence getSequenceFromURL(URL midiFileUrl) {
        Sequence sequence;
        block11: {
            String fileName = midiFileUrl.getPath();
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
            if (extension.equals("rmi")) {
                return RMIFile.open(midiFileUrl);
            }
            FileOrPackedInputStream input = null;
            try {
                input = new FileOrPackedInputStream(midiFileUrl);
                sequence = MidiSystem.getSequence(input);
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException ex) {
                            Log.error("IGNORED", ex);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                input.close();
            }
            catch (IOException ex) {
                Log.error("IGNORED", ex);
            }
        }
        return sequence;
    }

    @Override
    public Object[] getSongInfosFor(URL url) {
        String songName = MultimediaContainerManager.getSongNameFromURL(url);
        Long duration = -1L;
        try {
            Sequence sequence = this.getSequenceFromURL(url);
            duration = sequence != null ? sequence.getMicrosecondLength() / 1000L : 0L;
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return new Object[]{songName, duration};
    }

    @Override
    public String getSongName() {
        return super.getSongName();
    }

    @Override
    public String[] getFileExtensionList() {
        return MIDIFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "Midi-File";
    }

    @Override
    public boolean canExport() {
        return ((MidiConfigPanel)this.getConfigPanel()).getCapture().isSelected();
    }

    @Override
    public JPanel getConfigPanel() {
        if (this.midiConfigPanel == null) {
            this.midiConfigPanel = new MidiConfigPanel();
            this.midiConfigPanel.setParentContainer(this);
        }
        return this.midiConfigPanel;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.midiInfoPanel == null) {
            this.midiInfoPanel = new MidiInfoPanel();
        }
        return this.midiInfoPanel;
    }

    private File getSoundBankFile() {
        String soundBankFile = ((MidiConfigPanel)this.getConfigPanel()).getMidiSoundBankURL().getText();
        return new File(soundBankFile);
    }

    @Override
    public de.quippy.javamod.mixer.Mixer createNewMixer() {
        Mixer.Info mixerInfo;
        MidiConfigPanel configPanel = (MidiConfigPanel)this.getConfigPanel();
        MidiDevice.Info info = MIDIOUTDEVICEINFOS[configPanel.getMidiOutputDevice().getSelectedIndex()];
        boolean capture = configPanel.getCapture().isSelected();
        int mixerIndex = configPanel.getMixerInputDevice().getSelectedIndex();
        Mixer.Info info2 = mixerInfo = mixerIndex != -1 ? MIXERDEVICEINFOS[mixerIndex] : null;
        if (capture && mixerInfo == null) {
            capture = false;
        }
        this.currentMixer = new MidiMixer(this.currentSequence, info, this.getSoundBankFile(), capture, mixerInfo);
        return this.currentMixer;
    }

    @Override
    public void configurationChanged(Properties newProps) {
        MidiConfigPanel configPanel = (MidiConfigPanel)this.getConfigPanel();
        configPanel.getMidiOutputDevice().setSelectedItem(MidiContainer.getMidiOutDevice(newProps.getProperty(PROPERTY_MIDIPLAYER_OUTPUTDEVICE, DEFAULT_OUTPUTDEVICE)));
        configPanel.getMidiSoundBankURL().setText(newProps.getProperty(PROPERTY_MIDIPLAYER_SOUNDBANK, ""));
        configPanel.getCapture().setSelected(Boolean.valueOf(newProps.getProperty(PROPERTY_MIDIPLAYER_CAPTURE, DEFAULT_CAPUTRE)));
        Mixer.Info mixerInfo = MidiContainer.getMixerInfo(newProps.getProperty(PROPERTY_MIDIPLAYER_MIXERNAME, ""));
        if (mixerInfo != null) {
            for (int i = 0; i < MIXERDEVICEINFOS.length; ++i) {
                if (!MIXERDEVICEINFOS[i].toString().equals(mixerInfo.toString())) continue;
                configPanel.getMixerInputDevice().setSelectedIndex(i);
            }
        }
    }

    @Override
    public void configurationSave(Properties props) {
        MidiConfigPanel configPanel = (MidiConfigPanel)this.getConfigPanel();
        MidiDevice.Info outputDevice = (MidiDevice.Info)configPanel.getMidiOutputDevice().getSelectedItem();
        if (outputDevice != null) {
            props.setProperty(PROPERTY_MIDIPLAYER_OUTPUTDEVICE, outputDevice.getName());
        }
        props.setProperty(PROPERTY_MIDIPLAYER_SOUNDBANK, configPanel.getMidiSoundBankURL().getText());
        props.setProperty(PROPERTY_MIDIPLAYER_CAPTURE, Boolean.toString(configPanel.getCapture().isSelected()));
        Mixer.Info mixerInfo = (Mixer.Info)configPanel.getMixerInputDevice().getSelectedItem();
        if (mixerInfo != null) {
            props.setProperty(PROPERTY_MIDIPLAYER_MIXERNAME, mixerInfo.getName());
        }
    }

    private static MidiDevice.Info[] getMidiOutDevices() {
        ArrayList<MidiDevice.Info> midiOuts = new ArrayList<MidiDevice.Info>();
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infos.length; ++i) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
                if (device.getMaxReceivers() == 0) continue;
                midiOuts.add(infos[i]);
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        MidiDevice.Info[] result = new MidiDevice.Info[midiOuts.size()];
        midiOuts.toArray(result);
        return result;
    }

    private static MidiDevice.Info getMidiOutDevice(String midiDeviceName) {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].getName().equalsIgnoreCase(midiDeviceName)) continue;
            return infos[i];
        }
        return null;
    }

    private static Mixer.Info[] getInputMixerNames() {
        ArrayList<Mixer.Info> mixers = new ArrayList<Mixer.Info>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        Line.Info lineInfo = new Line.Info(TargetDataLine.class);
        for (int i = 0; i < mixerInfos.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(mixerInfos[i]);
            if (!mixer.isLineSupported(lineInfo)) continue;
            mixers.add(mixerInfos[i]);
        }
        return mixers.toArray(new Mixer.Info[mixers.size()]);
    }

    private static Mixer.Info getMixerInfo(String fromName) {
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
            if (!mixerInfos[i].getName().equalsIgnoreCase(fromName)) continue;
            return mixerInfos[i];
        }
        return null;
    }

    public MidiMixer getCurrentMixer() {
        return this.currentMixer;
    }

    static {
        MultimediaContainerManager.registerContainer(new MidiContainer());
    }
}

