/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class MidiMixer
extends BasicMixer {
    private boolean capture;
    private Mixer.Info mixerInfo;
    private long seekPosition = 0L;
    private int bufferSize;
    private byte[] output;
    private int sampleSizeInBits;
    private int sampleSizeInBytes;
    private int channels;
    private int sampleRate;
    private int frameCalc;
    private TargetDataLine targetDataLine;
    private Sequence sequence;
    private Sequencer sequencer = null;
    private MidiDevice midiOutput = null;
    private MidiDevice.Info outputDeviceInfo;
    private File soundBankFile;

    public MidiMixer(Sequence sequence, MidiDevice.Info outputDeviceInfo, File soundBankFile, boolean capture, Mixer.Info mixerInfo) {
        this.outputDeviceInfo = outputDeviceInfo;
        this.soundBankFile = soundBankFile;
        this.sequence = sequence;
        this.capture = capture;
        this.mixerInfo = mixerInfo;
        this.targetDataLine = null;
        if (capture) {
            this.setAudioFormat(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false));
            this.channels = this.getAudioFormat().getChannels();
            this.sampleSizeInBits = this.getAudioFormat().getSampleSizeInBits();
            this.sampleSizeInBytes = this.sampleSizeInBits >> 3;
            this.sampleRate = (int)this.getAudioFormat().getSampleRate();
            this.frameCalc = this.channels * this.sampleSizeInBytes;
            this.bufferSize = 250 * this.channels * this.sampleSizeInBytes * this.sampleRate / 1000;
            this.bufferSize *= this.sampleSizeInBytes;
            this.output = new byte[this.bufferSize];
        }
    }

    private void initialize() {
        if (this.capture) {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.getAudioFormat());
            try {
                if (this.mixerInfo != null) {
                    Mixer mixer = AudioSystem.getMixer(this.mixerInfo);
                    this.targetDataLine = (TargetDataLine)mixer.getLine(info);
                } else {
                    this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                }
                this.targetDataLine.open();
                Control[] controles = this.targetDataLine.getControls();
                for (int i = 0; i < controles.length; ++i) {
                    if (!(controles[i] instanceof CompoundControl)) continue;
                    Control[] children = ((CompoundControl)controles[i]).getMemberControls();
                    for (int j = 0; j < children.length; ++j) {
                        if (!(children[i] instanceof BooleanControl) || !children[i].getType().getClass().getName().endsWith("BCT")) continue;
                        ((BooleanControl)children[i]).setValue(true);
                    }
                }
                this.targetDataLine.close();
            }
            catch (LineUnavailableException ex) {
                this.targetDataLine = null;
            }
        }
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.sequencer != null) {
            return this.sequencer.getMicrosecondPosition() / 1000L;
        }
        return 0L;
    }

    @Override
    protected void seek(long milliseconds) {
        if (this.sequencer != null) {
            this.sequencer.setMicrosecondPosition(milliseconds * 1000L);
        } else {
            this.seekPosition = milliseconds;
        }
    }

    @Override
    public void setMillisecondPosition(long milliseconds) {
        this.seek(milliseconds);
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.sequence != null ? this.sequence.getMicrosecondLength() / 1000L : 0L;
    }

    @Override
    public int getChannelCount() {
        Sequence sequence;
        if (this.sequencer != null && (sequence = this.sequencer.getSequence()) != null) {
            return sequence.getTracks().length;
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return 44;
    }

    public void setNewOutputDevice(MidiDevice.Info newDeviceInfo) {
        boolean isPlaying = this.isPlaying();
        if (isPlaying) {
            this.stopLine();
        }
        try {
            if (this.midiOutput != null) {
                this.midiOutput.close();
                this.midiOutput = null;
            }
            this.midiOutput = newDeviceInfo != null ? MidiSystem.getMidiDevice(newDeviceInfo) : MidiSystem.getMidiDevice(this.outputDeviceInfo);
            if (!this.midiOutput.isOpen()) {
                this.midiOutput.open();
            }
            if (this.midiOutput instanceof Synthesizer && this.soundBankFile != null && this.soundBankFile.length() != 0L) {
                try {
                    Soundbank bank = MidiSystem.getSoundbank(this.soundBankFile);
                    ((Synthesizer)this.midiOutput).loadAllInstruments(bank);
                }
                catch (Exception ex) {
                    Log.error("Error occured when opening soundfont bank", ex);
                }
            }
            Receiver synthReceiver = this.midiOutput.getReceiver();
            Transmitter seqTransmitter = this.sequencer.getTransmitter();
            seqTransmitter.setReceiver(synthReceiver);
            if (isPlaying) {
                this.startLine();
            }
        }
        catch (MidiUnavailableException ex) {
            this.closeAudioDevice();
            Log.error("Error occured when opening midi device", ex);
        }
    }

    @Override
    protected void openAudioDevice() {
        if (this.capture && this.targetDataLine != null) {
            try {
                this.setKeepSilent(true);
                super.openAudioDevice();
                this.targetDataLine.open();
            }
            catch (LineUnavailableException ex) {
                this.closeAudioDevice();
                Log.error("[MidiMixer]: TargetDataLine", ex);
            }
        } else {
            this.closeAudioDevice();
        }
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage event) {
                    if (event.getType() == 47) {
                        MidiMixer.this.setHasFinished();
                        MidiMixer.this.stopPlayback();
                    }
                }
            });
            this.sequencer.setSequence(this.sequence);
            this.sequencer.open();
            if (!(this.sequencer instanceof Synthesizer)) {
                this.setNewOutputDevice(this.outputDeviceInfo);
            }
        }
        catch (Exception ex) {
            Log.error("[MidiMixer]", ex);
        }
    }

    @Override
    protected void closeAudioDevice() {
        this.stopLine();
        if (this.midiOutput != null && this.midiOutput.isOpen()) {
            this.midiOutput.close();
        }
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.close();
        }
        this.midiOutput = null;
        this.sequencer = null;
        if (this.capture) {
            if (this.targetDataLine != null) {
                this.targetDataLine.close();
            }
            super.closeAudioDevice();
        }
        super.fullyCloseAudioDevice();
    }

    @Override
    protected void startLine() {
        if (this.targetDataLine != null) {
            this.targetDataLine.start();
        }
        if (this.sequencer != null) {
            this.sequencer.start();
        }
    }

    @Override
    protected void stopLine() {
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
        if (this.targetDataLine != null) {
            this.targetDataLine.stop();
        }
    }

    @Override
    protected boolean isInitialized() {
        if (this.capture && this.targetDataLine == null) {
            return false;
        }
        return this.sequencer != null;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        if (this.seekPosition > 0L) {
            this.seek(this.seekPosition);
        }
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            this.startLine();
            this.setIsPlaying();
            long framePosition = 0L;
            do {
                if (this.targetDataLine != null) {
                    int byteCount;
                    int amount = this.targetDataLine.available();
                    if (amount > this.bufferSize) {
                        amount = this.bufferSize;
                    }
                    if ((byteCount = this.targetDataLine.read(this.output, 0, amount)) > 0) {
                        this.writeSampleDataToLine(this.output, 0, byteCount);
                        this.setInternatFramePosition(framePosition);
                        framePosition += (long)(byteCount / this.frameCalc);
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this.isStopping()) {
                    this.setIsStopped();
                }
                if (!this.isPausing()) continue;
                this.setIsPaused();
                while (this.isPaused()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (this.isPlaying());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
        }
    }
}

