/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public abstract class Module {
    private String fileName;
    private String trackerName;
    private String modID;
    private int modType;
    private String songName;
    private int nChannels;
    private int nInstruments;
    private int nSamples;
    private int nPattern;
    private int BPMSpeed;
    private int tempo;
    private InstrumentsContainer instrumentContainer;
    private PatternContainer patternContainer;
    private int songLength;
    private int[] arrangement;
    private boolean[] arrangementPositionPlayed;
    private int baseVolume;
    protected int songFlags;

    public Module() {
    }

    protected Module(String fileName) {
        this();
        this.fileName = fileName;
    }

    public Module loadModFile(String fileName) throws IOException {
        return this.loadModFile(new File(fileName));
    }

    public Module loadModFile(File file) throws IOException {
        return this.loadModFile(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module loadModFile(URL url) throws IOException {
        ModfileInputStream inputStream = null;
        try {
            inputStream = new ModfileInputStream(url);
            Module module = this.loadModFile(inputStream);
            return module;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
    }

    public Module loadModFile(ModfileInputStream inputStream) throws IOException {
        Module mod = this.getNewInstance(inputStream.getFileName());
        mod.loadModFileInternal(inputStream);
        return mod;
    }

    public abstract boolean checkLoadingPossible(ModfileInputStream var1) throws IOException;

    protected abstract Module getNewInstance(String var1);

    protected abstract void loadModFileInternal(ModfileInputStream var1) throws IOException;

    public abstract BasicModMixer getModMixer(int var1, int var2, int var3);

    public abstract String[] getFileExtensionList();

    public abstract int getPanningValue(int var1);

    public abstract int getChannelVolume(int var1);

    public abstract int getFrequencyTable();

    public abstract boolean doFastSlides();

    public String toShortInfoString() {
        StringBuilder modInfo = new StringBuilder(this.getTrackerName());
        modInfo.append(" mod with ").append(this.getNSamples()).append(" samples and ").append(this.getNChannels()).append(" channels using ");
        switch (this.getFrequencyTable()) {
            case 2: {
                modInfo.append("Protracker");
                break;
            }
            case 0: {
                modInfo.append("Scream Tracker");
                break;
            }
            case 4: {
                modInfo.append("Fast Tracker log");
                break;
            }
            case 8: {
                modInfo.append("Fast Tracker linear");
                break;
            }
            case 1: {
                modInfo.append("Impuls Tracker linear");
                break;
            }
            case 16: {
                modInfo.append("Impuls Tracker log");
            }
        }
        modInfo.append(" frequency table");
        return modInfo.toString();
    }

    public String toString() {
        StringBuilder modInfo = new StringBuilder(this.toShortInfoString());
        modInfo.append("\n\nSong named: ");
        modInfo.append(this.getSongName()).append('\n');
        modInfo.append(this.getInstrumentContainer().toString());
        return modInfo.toString();
    }

    protected void allocArrangement(int length) {
        this.arrangement = new int[length];
        this.arrangementPositionPlayed = new boolean[length];
    }

    public int[] getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(int[] arrangement) {
        this.arrangement = arrangement;
    }

    public void cleanUpArrangement() {
        int illegalPatternNum = 0;
        for (int i = 0; i < this.songLength; ++i) {
            if (this.arrangement[i - illegalPatternNum] < this.nPattern) continue;
            ++illegalPatternNum;
            System.arraycopy(this.arrangement, i + 1, this.arrangement, i, this.arrangement.length - i - 1);
        }
        this.songLength -= illegalPatternNum;
    }

    public void resetLoopRecognition() {
        for (int i = 0; i < this.arrangementPositionPlayed.length; ++i) {
            this.arrangementPositionPlayed[i] = false;
        }
        this.getPatternContainer().resetRowsPlayed();
    }

    public boolean isArrangementPositionPlayed(int position) {
        return this.arrangementPositionPlayed[position];
    }

    public void setArrangementPositionPlayed(int position) {
        this.arrangementPositionPlayed[position] = true;
    }

    public int getBPMSpeed() {
        return this.BPMSpeed;
    }

    protected void setBPMSpeed(int speed) {
        this.BPMSpeed = speed;
    }

    public InstrumentsContainer getInstrumentContainer() {
        return this.instrumentContainer;
    }

    protected void setInstrumentContainer(InstrumentsContainer instrumentContainer) {
        this.instrumentContainer = instrumentContainer;
    }

    public int getNChannels() {
        return this.nChannels;
    }

    protected void setNChannels(int channels) {
        this.nChannels = channels;
    }

    public int getNPattern() {
        return this.nPattern;
    }

    protected void setNPattern(int pattern) {
        this.nPattern = pattern;
    }

    public int getNInstruments() {
        return this.nInstruments;
    }

    protected void setNInstruments(int instruments) {
        this.nInstruments = instruments;
    }

    public int getNSamples() {
        return this.nSamples;
    }

    protected void setNSamples(int samples) {
        this.nSamples = samples;
    }

    public int getSongLength() {
        return this.songLength;
    }

    protected void setSongLength(int songLength) {
        this.songLength = songLength;
    }

    public String getSongName() {
        return this.songName;
    }

    protected void setSongName(String songName) {
        this.songName = songName;
    }

    public int getTempo() {
        return this.tempo;
    }

    protected void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    protected void setTrackerName(String trackerName) {
        this.trackerName = trackerName;
    }

    public PatternContainer getPatternContainer() {
        return this.patternContainer;
    }

    protected void setPatternContainer(PatternContainer patternContainer) {
        this.patternContainer = patternContainer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getModID() {
        return this.modID;
    }

    protected void setModID(String modID) {
        this.modID = modID;
    }

    public int getBaseVolume() {
        return this.baseVolume;
    }

    protected void setBaseVolume(int baseVolume) {
        this.baseVolume = baseVolume;
    }

    public int getSongFlags() {
        return this.songFlags;
    }

    protected void setSongFlags(int songFlags) {
        this.songFlags = songFlags;
    }

    public int getModType() {
        return this.modType;
    }

    protected void setModType(int modType) {
        this.modType = modType;
    }

    protected void readSampleData(Sample current, int flags, ModfileInputStream inputStream) throws IOException {
        if (current.length > 0) {
            current.allocSampleData();
            if ((flags & 0x14) == 20 || (flags & 0x16) == 22) {
                ITDeCompressor reader = new ITDeCompressor(current, (flags & 0x16) == 22, inputStream);
                reader.decompress16();
            } else if ((flags & 0x10) == 16 || (flags & 0x12) == 18) {
                ITDeCompressor reader = new ITDeCompressor(current, (flags & 0x12) == 18, inputStream);
                reader.decompress8();
            } else {
                short old = 0;
                for (int s = 0; s < current.length; ++s) {
                    short sample;
                    if ((flags & 4) != 0) {
                        sample = (short)inputStream.readIntelWord();
                        if ((flags & 2) != 0) {
                            old = sample = (short)(sample + old);
                        }
                        if ((flags & 1) != 0) {
                            current.sample[s] = Helpers.promoteUnsigned16BitToSigned24Bit(sample);
                            continue;
                        }
                        current.sample[s] = Helpers.promoteSigned16BitToSigned24Bit(sample);
                        continue;
                    }
                    sample = inputStream.readByte();
                    if ((flags & 2) != 0) {
                        old = sample = (short)((byte)(sample + old));
                    }
                    current.sample[s] = (flags & 1) != 0 ? Helpers.promoteUnsigned8BitToSigned24Bit((byte)sample) : Helpers.promoteSigned8BitToSigned24Bit((byte)sample);
                }
            }
            current.fixSampleLoops(this.getModType());
        }
    }

    private static class ITDeCompressor {
        private ModfileInputStream input;
        private byte[] sourceBuffer;
        private int sourceIndex;
        private int[] destBuffer;
        private int destIndex;
        private int anzSamples;
        private int bitsRemain;
        private boolean isIT215;

        public ITDeCompressor(Sample sample, boolean isIT215, ModfileInputStream inputStream) {
            this.input = inputStream;
            this.sourceBuffer = null;
            this.sourceIndex = 0;
            this.bitsRemain = 0;
            this.destBuffer = sample.sample;
            this.destIndex = 0;
            this.anzSamples = sample.length;
            this.isIT215 = isIT215;
        }

        private int readbits(int b) {
            long value = 0L;
            if (b <= this.bitsRemain) {
                value = this.sourceBuffer[this.sourceIndex] & (1 << b) - 1;
                int n = this.sourceIndex;
                this.sourceBuffer[n] = (byte)(this.sourceBuffer[n] >> b);
                this.bitsRemain -= b;
            } else {
                int nbits = b - this.bitsRemain;
                value = (long)this.sourceBuffer[this.sourceIndex++] & (long)((1 << this.bitsRemain) - 1);
                while (nbits > 8) {
                    value |= (long)(this.sourceBuffer[this.sourceIndex++] & 0xFF) << this.bitsRemain;
                    nbits -= 8;
                    this.bitsRemain += 8;
                }
                value |= (long)(this.sourceBuffer[this.sourceIndex] & (1 << nbits) - 1) << this.bitsRemain;
                int n = this.sourceIndex;
                this.sourceBuffer[n] = (byte)(this.sourceBuffer[n] >> nbits);
                this.bitsRemain = 8 - nbits;
            }
            return (int)(value & 0xFFFFFFFFFFFFFFFFL);
        }

        private boolean readblock() throws IOException {
            if (this.input.available() == 0) {
                return false;
            }
            int size = this.input.readIntelWord();
            if (size == 0) {
                return false;
            }
            if (this.input.available() < size) {
                size = this.input.available();
            }
            this.sourceBuffer = new byte[size];
            this.input.read(this.sourceBuffer, 0, size);
            this.sourceIndex = 0;
            this.bitsRemain = 8;
            return true;
        }

        public boolean decompress8() throws IOException {
            while (this.anzSamples > 0) {
                if (!this.readblock()) {
                    return false;
                }
                int blklen = this.anzSamples < 32768 ? this.anzSamples : 32768;
                int blkpos = 0;
                int width = 9;
                byte d2 = 0;
                byte d1 = 0;
                while (blkpos < blklen) {
                    byte v;
                    int value = this.readbits(width);
                    if (width < 7) {
                        if (value == 1 << width - 1) {
                            value = this.readbits(3) + 1;
                            width = value < width ? value : value + 1;
                            continue;
                        }
                    } else if (width < 9) {
                        int border = (255 >> 9 - width) - 4;
                        if (value > border && value <= border + 8) {
                            width = (value -= border) < width ? value : value + 1;
                            continue;
                        }
                    } else if (width == 9) {
                        if ((value & 0x100) != 0) {
                            width = value + 1 & 0xFF;
                            continue;
                        }
                    } else {
                        return false;
                    }
                    if (width < 8) {
                        int shift = 8 - width;
                        v = (byte)(value << shift & 0xFF);
                        v = (byte)(v >> shift);
                    } else {
                        v = (byte)(value & 0xFF);
                    }
                    d1 = (byte)(d1 + v);
                    d2 = (byte)(d2 + d1);
                    this.destBuffer[this.destIndex++] = Helpers.promoteSigned8BitToSigned24Bit(this.isIT215 ? d2 : d1);
                    ++blkpos;
                }
                this.anzSamples -= blklen;
            }
            return true;
        }

        public boolean decompress16() throws IOException {
            while (this.anzSamples > 0) {
                if (!this.readblock()) {
                    return false;
                }
                int blklen = this.anzSamples < 16384 ? this.anzSamples : 16384;
                int blkpos = 0;
                int width = 17;
                short d2 = 0;
                short d1 = 0;
                while (blkpos < blklen) {
                    short v;
                    int value = this.readbits(width);
                    if (width < 7) {
                        if (value == 1 << width - 1) {
                            value = this.readbits(4) + 1;
                            width = value < width ? value : value + 1;
                            continue;
                        }
                    } else if (width < 17) {
                        int border = (65535 >> 17 - width) - 8;
                        if (value > border && value <= border + 16) {
                            width = (value -= border) < width ? value : value + 1;
                            continue;
                        }
                    } else if (width == 17) {
                        if ((value & 0x10000) != 0) {
                            width = value + 1 & 0xFF;
                            continue;
                        }
                    } else {
                        return false;
                    }
                    if (width < 16) {
                        int shift = 16 - width;
                        v = (short)(value << shift & 0xFFFF);
                        v = (short)(v >> shift);
                    } else {
                        v = (short)value;
                    }
                    d1 = (short)(d1 + v);
                    d2 = (short)(d2 + d1);
                    this.destBuffer[this.destIndex++] = Helpers.promoteSigned16BitToSigned24Bit(this.isIT215 ? d2 : d1);
                    ++blkpos;
                }
                this.anzSamples -= blklen;
            }
            return true;
        }
    }
}

