/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ModuleFactory {
    private static HashMap<String, Module> fileExtensionMap;
    private static ArrayList<Module> modulesArray;

    private ModuleFactory() {
    }

    private static HashMap<String, Module> getFileExtensionMap() {
        if (fileExtensionMap == null) {
            fileExtensionMap = new HashMap();
        }
        return fileExtensionMap;
    }

    private static ArrayList<Module> getModulesArray() {
        if (modulesArray == null) {
            modulesArray = new ArrayList();
        }
        return modulesArray;
    }

    public static void registerModule(Module mod) {
        ModuleFactory.getModulesArray().add(mod);
        String[] extensions = mod.getFileExtensionList();
        for (int i = 0; i < extensions.length; ++i) {
            ModuleFactory.getFileExtensionMap().put(extensions[i], mod);
        }
    }

    public static void deregisterModule(Module mod) {
        ModuleFactory.getModulesArray().remove(mod);
        String[] extensions = mod.getFileExtensionList();
        for (int i = 0; i < extensions.length; ++i) {
            ModuleFactory.getFileExtensionMap().remove(extensions[i]);
        }
    }

    public static String[] getSupportedFileExtensions() {
        Set<String> keys = ModuleFactory.getFileExtensionMap().keySet();
        String[] result = new String[keys.size()];
        return keys.toArray(result);
    }

    public static Module getModuleFromExtension(String extension) {
        return ModuleFactory.getFileExtensionMap().get(extension.toLowerCase());
    }

    private static Module getModuleFromStreamByID(ModfileInputStream input) {
        for (Module mod : ModuleFactory.getModulesArray()) {
            try {
                if (!mod.checkLoadingPossible(input)) continue;
                return mod;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private static Module getModuleFromStream(ModfileInputStream input) {
        for (Module mod : ModuleFactory.getModulesArray()) {
            try {
                Module result = mod.loadModFile(input);
                input.seek(0L);
                return result;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static Module getInstance(String fileName) throws IOException {
        return ModuleFactory.getInstance(new File(fileName));
    }

    public static Module getInstance(File file) throws IOException {
        return ModuleFactory.getInstance(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module getInstance(URL url) throws IOException {
        ModfileInputStream inputStream = null;
        try {
            inputStream = new ModfileInputStream(url);
            Module mod = ModuleFactory.getModuleFromStreamByID(inputStream);
            if (mod != null) {
                Module module = mod.loadModFile(inputStream);
                return module;
            }
            mod = ModuleFactory.getModuleFromStream(inputStream);
            if (mod != null) {
                Module module = mod;
                return module;
            }
            try {
                throw new IOException("Unsupported MOD-Type: " + inputStream.getFileName());
            }
            catch (Exception ex) {
                Log.error("[ModuleFactory] Failed with loading " + url.toString(), ex);
                Module module = null;
                return module;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
    }
}

