/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.instrument;

public class Envelope {
    private int[] position;
    private int[] value;
    private int nPoints;
    private int sustainStartPoint;
    private int sustainEndPoint;
    private int loopStartPoint;
    private int loopEndPoint;
    public boolean on = false;
    public boolean sustain = false;
    public boolean loop = false;
    public boolean carry = false;
    public boolean filter = false;
    private static final int SHIFT = 3;
    private static final int MAXVALUE = 512;

    public int updatePosition(int p, boolean keyOff) {
        if (this.loop && ++p >= this.position[this.loopEndPoint]) {
            p = this.position[this.loopStartPoint];
        }
        if (this.sustain && p >= this.position[this.sustainEndPoint] && !keyOff) {
            p = this.position[this.sustainStartPoint];
        }
        return p;
    }

    public int getValueForPosition(int p) {
        int x1;
        int v;
        int x2;
        int pt = this.nPoints - 1;
        for (int i = 0; i < pt; ++i) {
            if (p > this.position[i]) continue;
            pt = i;
            break;
        }
        if (p >= (x2 = this.position[pt])) {
            v = this.value[pt] << 3;
            x1 = x2;
        } else if (pt > 0) {
            v = this.value[pt - 1] << 3;
            x1 = this.position[pt - 1];
        } else {
            x1 = 0;
            v = 0;
        }
        if (p > x2) {
            p = x2;
        }
        if (x2 > x1 && p > x1) {
            v += (p - x1) * ((this.value[pt] << 3) - v) / (x2 - x1);
        }
        if (v < 0) {
            v = 0;
        } else if (v > 512) {
            v = 512;
        }
        return v;
    }

    public void setXMType(int flag) {
        this.on = (flag & 1) != 0;
        this.sustain = (flag & 2) != 0;
        this.loop = (flag & 4) != 0;
        this.filter = false;
        this.carry = false;
    }

    public void setITType(int flag) {
        this.on = (flag & 1) != 0;
        this.loop = (flag & 2) != 0;
        this.sustain = (flag & 4) != 0;
        this.carry = (flag & 8) != 0;
        this.filter = (flag & 0x80) != 0;
    }

    public void setLoopEndPoint(int loopEndPoint) {
        this.loopEndPoint = loopEndPoint;
    }

    public void setLoopStartPoint(int loopStartPoint) {
        this.loopStartPoint = loopStartPoint;
    }

    public void setNPoints(int points) {
        this.nPoints = points;
    }

    public void setPosition(int[] position) {
        this.position = position;
    }

    public void setValue(int[] value) {
        this.value = value;
    }

    public void setSustainPoint(int sustainPoint) {
        this.sustainStartPoint = this.sustainEndPoint = sustainPoint;
    }

    public void setSustainEndPoint(int sustainEndPoint) {
        this.sustainEndPoint = sustainEndPoint;
    }

    public void setSustainStartPoint(int sustainStartPoint) {
        this.sustainStartPoint = sustainStartPoint;
    }
}

