/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.instrument;

import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;

public class InstrumentsContainer {
    private Module parent;
    private Instrument[] instruments;
    private Sample[] samples;

    public InstrumentsContainer(Module module, int anzInstruments, int anzSamples) {
        this.parent = module;
        this.instruments = anzInstruments != 0 ? new Instrument[anzInstruments] : null;
        this.samples = anzSamples != 0 ? new Sample[anzSamples] : null;
    }

    public void reallocSampleSpace(int newAmount) {
        Sample[] newSamples = new Sample[newAmount];
        if (this.samples != null) {
            for (int i = 0; i < this.samples.length; ++i) {
                newSamples[i] = this.samples[i];
            }
        }
        this.samples = newSamples;
    }

    public void setInstrument(int index, Instrument instrument) {
        this.instruments[index] = instrument;
    }

    public void setSample(int index, Sample sample) {
        this.samples[index] = sample;
    }

    public Sample getSample(int sampleIndex) {
        if (this.samples == null || sampleIndex >= this.samples.length || sampleIndex < 0) {
            return null;
        }
        return this.samples[sampleIndex];
    }

    public int getFullSampleLength() {
        int fullSampleLength = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            fullSampleLength += this.samples[i].length;
        }
        return fullSampleLength;
    }

    public Instrument getInstrument(int index) {
        if (this.instruments == null) {
            return null;
        }
        if (index >= this.instruments.length) {
            return null;
        }
        return this.instruments[index];
    }

    public Instrument[] getInstruments() {
        return this.instruments;
    }

    public Sample[] getSamples() {
        return this.samples;
    }

    public Module getParentModule() {
        return this.parent;
    }

    public String toString() {
        int i;
        StringBuilder bf = new StringBuilder();
        if (this.instruments != null) {
            for (i = 0; i < this.instruments.length; ++i) {
                bf.append(this.instruments[i].toString());
                bf.append('\n');
            }
        }
        if (this.samples != null) {
            for (i = 0; i < this.samples.length; ++i) {
                bf.append(this.samples[i].toShortString());
                bf.append('\n');
            }
        }
        return bf.toString();
    }
}

