/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.instrument;

import de.quippy.javamod.multimedia.mod.mixer.interpolation.CubicSpline;
import de.quippy.javamod.multimedia.mod.mixer.interpolation.WindowedFIR;

public class Sample {
    public String name;
    public int length;
    public int fineTune;
    public int volume;
    public int repeatStart;
    public int repeatStop;
    public int repeatLength;
    public int loopType;
    public int transpose;
    public int baseFrequency;
    public int type;
    public String dosFileName;
    public int flags;
    public int panning;
    public int vibratoType;
    public int vibratoSweep;
    public int vibratoDepth;
    public int vibratoRate;
    public int sustainLoopStart;
    public int sustainLoopEnd;
    public int flag_CvT;
    public int globalVolume;
    public int[] sample;

    public void allocSampleData() {
        this.sample = new int[this.length + 5];
    }

    public void fixSampleLoops(int modType) {
        if (this.sample == null || this.length == 0) {
            return;
        }
        if (this.repeatStop > this.length) {
            this.repeatStop = this.length;
            this.repeatLength = this.repeatStop - this.repeatStart;
        }
        if (this.repeatStart + 2 > this.repeatStop) {
            this.repeatStart = 0;
            this.repeatStop = 0;
            this.repeatLength = this.repeatStop - this.repeatStart;
            this.loopType = 0;
        }
        this.sample[this.length + 1] = this.sample[this.length] = this.sample[this.length - 1];
        this.sample[this.length + 2] = this.sample[this.length];
        this.sample[this.length + 3] = this.sample[this.length];
        this.sample[this.length + 4] = this.sample[this.length];
        if (this.loopType == 1 && (this.repeatStop + 4 > this.repeatLength || modType == 1 || modType == 4)) {
            this.sample[this.repeatStop] = this.sample[this.repeatStart];
            this.sample[this.repeatStop + 1] = this.sample[this.repeatStart + 1];
            this.sample[this.repeatStop + 2] = this.sample[this.repeatStart + 2];
            this.sample[this.repeatStop + 3] = this.sample[this.repeatStart + 3];
            this.sample[this.repeatStop + 4] = this.sample[this.repeatStart + 4];
        }
    }

    public String toString() {
        StringBuilder bf = new StringBuilder(this.name);
        bf.append('(').append("length:").append(this.length).append(',').append("fineTune:").append(this.fineTune).append(',').append("transpose:").append(this.transpose).append(',').append("baseFrequency:").append(this.baseFrequency).append(',').append("volume:").append(this.volume).append(',').append("panning:").append(this.panning).append(',').append("repeatStart:").append(this.repeatStart).append(',').append("repeatLength:").append(this.repeatLength).append(',').append("repeatStop:").append(this.repeatStop).append(')');
        return bf.toString();
    }

    public String toShortString() {
        return this.name;
    }

    private int getLinearInterpolated(int currentSamplePos, int currentTuningPos) {
        long s1 = (long)this.sample[currentSamplePos] << 12;
        long s2 = (long)this.sample[currentSamplePos + 1] << 12;
        return (int)(s1 + ((s2 - s1) * (long)currentTuningPos >> 16) >> 12);
    }

    private int getCubicInterpolated(int currentSamplePos, int currentTuningPos) {
        int poslo = currentTuningPos >> 4 & 0xFFC;
        long v1 = (currentSamplePos - 1 < 0 ? 0L : (long)CubicSpline.lut[poslo] * (long)this.sample[currentSamplePos - 1]) + (long)CubicSpline.lut[poslo + 1] * (long)this.sample[currentSamplePos] + (long)CubicSpline.lut[poslo + 2] * (long)this.sample[currentSamplePos + 1] + (long)CubicSpline.lut[poslo + 3] * (long)this.sample[currentSamplePos + 2];
        return (int)(v1 >> 14);
    }

    private int getFIRInterpolated(int currentSamplePos, int currentTuningPos) {
        int poslo = currentTuningPos & 0xFFFF;
        int firidx = poslo + 16 >> 2 & 0x7FF8;
        long v1 = (currentSamplePos - 3 < 0 ? 0L : (long)WindowedFIR.lut[firidx] * (long)this.sample[currentSamplePos - 3]) + (currentSamplePos - 2 < 0 ? 0L : (long)WindowedFIR.lut[firidx + 1] * (long)this.sample[currentSamplePos - 2]) + (currentSamplePos - 1 < 0 ? 0L : (long)WindowedFIR.lut[firidx + 2] * (long)this.sample[currentSamplePos - 1]) + (long)WindowedFIR.lut[firidx + 3] * (long)this.sample[currentSamplePos];
        long v2 = (long)WindowedFIR.lut[firidx + 4] * (long)this.sample[currentSamplePos + 1] + (long)WindowedFIR.lut[firidx + 5] * (long)this.sample[currentSamplePos + 2] + (long)WindowedFIR.lut[firidx + 6] * (long)this.sample[currentSamplePos + 3] + (long)WindowedFIR.lut[firidx + 7] * (long)this.sample[currentSamplePos + 4];
        return (int)((v1 >> 1) + (v2 >> 1) >> 14);
    }

    public int getInterpolatedSample(int doISP, int currentSamplePos, int currentTuningPos) {
        if (this.sample == null) {
            return 0;
        }
        if (currentSamplePos > this.length) {
            return 0;
        }
        switch (doISP) {
            case 0: {
                return this.sample[currentSamplePos];
            }
            case 1: {
                return this.getLinearInterpolated(currentSamplePos, currentTuningPos);
            }
            case 2: {
                return this.getCubicInterpolated(currentSamplePos, currentTuningPos);
            }
            case 3: {
                return this.getFIRInterpolated(currentSamplePos, currentTuningPos);
            }
        }
        return 0;
    }

    public void setBaseFrequency(int baseFrequency) {
        this.baseFrequency = baseFrequency;
    }

    public void setDosFileName(String dosFileName) {
        this.dosFileName = dosFileName;
    }

    public void setFineTune(int fineTune) {
        this.fineTune = fineTune;
    }

    public void setFlags(int newFlags) {
        this.flags = newFlags;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLoopType(int loopType) {
        this.loopType = loopType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRepeatLength(int repeatLength) {
        this.repeatLength = repeatLength;
    }

    public void setRepeatStart(int repeatStart) {
        this.repeatStart = repeatStart;
    }

    public void setRepeatStop(int repeatStop) {
        this.repeatStop = repeatStop;
    }

    public void setSample(int[] sample) {
        this.sample = sample;
    }

    public void setTranspose(int transpose) {
        this.transpose = transpose;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setPanning(int panning) {
        this.panning = panning;
    }

    public void setCvT(int flag_CvT) {
        this.flag_CvT = flag_CvT;
    }

    public void setSustainLoopStart(int sustainLoopStart) {
        this.sustainLoopStart = sustainLoopStart;
    }

    public void setSustainLoopEnd(int sustainLoopEnd) {
        this.sustainLoopEnd = sustainLoopEnd;
    }

    public void setVibratoDepth(int vibratoDepth) {
        this.vibratoDepth = vibratoDepth;
    }

    public void setVibratoRate(int vibratoRate) {
        this.vibratoRate = vibratoRate;
    }

    public void setVibratoSweep(int vibratoSweep) {
        this.vibratoSweep = vibratoSweep;
    }

    public void setVibratoType(int vibratoType) {
        this.vibratoType = vibratoType;
    }

    public void setGlobalVolume(int globalVolume) {
        this.globalVolume = globalVolume;
    }
}

