/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.pattern;

import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.system.Helpers;

public class Pattern {
    private PatternRow[] patternRow;

    public Pattern(int rows) {
        this.patternRow = new PatternRow[rows];
    }

    public Pattern(int rows, int channels) {
        this(rows);
        for (int i = 0; i < rows; ++i) {
            this.patternRow[i] = new PatternRow(channels);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.patternRow.length; ++i) {
            sb.append(Helpers.getAsHex(i, 2)).append(": ").append(this.patternRow[i].toString()).append('\n');
        }
        return sb.toString();
    }

    public int getRowCount() {
        return this.patternRow.length;
    }

    public void resetRowsPlayed() {
        for (int i = 0; i < this.patternRow.length; ++i) {
            PatternRow row = this.patternRow[i];
            if (row == null) continue;
            row.resetRowPlayed();
        }
    }

    public PatternRow[] getPatternRow() {
        return this.patternRow;
    }

    public PatternRow getPatternRow(int row) {
        return this.patternRow[row];
    }

    public PatternElement getPatternElement(int row, int channel) {
        return this.patternRow[row].getPatternElement(channel);
    }

    public void setPatternRow(PatternRow[] patternRow) {
        this.patternRow = patternRow;
    }

    public void setPatternRow(int row, PatternRow patternRow) {
        this.patternRow[row] = patternRow;
    }

    public void setPatternElement(int row, int channel, PatternElement patternElement) {
        this.patternRow[row].setPatternElement(channel, patternElement);
    }
}

