/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.pattern;

import de.quippy.javamod.multimedia.mod.loader.pattern.Pattern;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;

public class PatternContainer {
    private Pattern[] pattern;

    public PatternContainer(int anzPattern) {
        this.pattern = new Pattern[anzPattern];
    }

    public PatternContainer(int anzPattern, int row) {
        this(anzPattern);
        for (int i = 0; i < anzPattern; ++i) {
            this.pattern[i] = new Pattern(row);
        }
    }

    public PatternContainer(int anzPattern, int row, int channels) {
        this(anzPattern);
        for (int i = 0; i < anzPattern; ++i) {
            this.pattern[i] = new Pattern(row, channels);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.pattern.length; ++i) {
            sb.append(i).append(". Pattern:\n").append(this.pattern[i].toString()).append('\n');
        }
        return sb.toString();
    }

    public void resetRowsPlayed() {
        for (int i = 0; i < this.pattern.length; ++i) {
            this.pattern[i].resetRowsPlayed();
        }
    }

    public Pattern[] getPattern() {
        return this.pattern;
    }

    public Pattern getPattern(int patternIndex) {
        return this.pattern[patternIndex];
    }

    public PatternRow getPatternRow(int patternIndex, int row) {
        return this.pattern[patternIndex].getPatternRow(row);
    }

    public PatternElement getPatternElement(int patternIndex, int row, int channel) {
        return this.pattern[patternIndex].getPatternElement(row, channel);
    }

    public void setPattern(Pattern[] pattern) {
        this.pattern = pattern;
    }

    public void setPattern(int patternIndex, Pattern pattern) {
        this.pattern[patternIndex] = pattern;
    }

    public void setPatternRow(int patternIndex, int row, PatternRow patternRow) {
        this.pattern[patternIndex].setPatternRow(row, patternRow);
    }

    public void setPatternElement(int patternIndex, int row, int channel, PatternElement patternElement) {
        this.pattern[patternIndex].setPatternElement(row, channel, patternElement);
    }

    public void setPatternElement(PatternElement patternElement) {
        this.pattern[patternElement.getPatternIndex()].setPatternElement(patternElement.getRow(), patternElement.getChannel(), patternElement);
    }
}

