/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.Envelope;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.Pattern;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.multimedia.mod.loader.tracker.ScreamTrackerMod;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ImpulseTrackerMod
extends ScreamTrackerMod {
    private static final int[] autovibit2xm = new int[]{0, 3, 1, 4, 2, 0, 0, 0};
    private static final String[] MODFILEEXTENSION = new String[]{"it"};
    private int special;
    private int[] channelVolume;

    public ImpulseTrackerMod() {
    }

    protected ImpulseTrackerMod(String fileName) {
        super(fileName);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public int getFrequencyTable() {
        return (this.songFlags & 0x10) != 0 ? 1 : 16;
    }

    @Override
    public int getChannelVolume(int channel) {
        return this.channelVolume[channel];
    }

    public int getSpecial() {
        return this.special;
    }

    private void readEnvelopeData(Envelope env, int add, ModfileInputStream inputStream) throws IOException {
        long pos = inputStream.getFilePointer();
        env.setITType(inputStream.readByteAsInt());
        int nPoints = inputStream.readByteAsInt();
        if (nPoints > 25) {
            nPoints = 25;
        }
        env.setNPoints(nPoints);
        env.setLoopStartPoint(inputStream.readByteAsInt());
        env.setLoopEndPoint(inputStream.readByteAsInt());
        env.setSustainStartPoint(inputStream.readByteAsInt());
        env.setSustainEndPoint(inputStream.readByteAsInt());
        int[] values = new int[nPoints];
        int[] points = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            values[i] = inputStream.readByteAsInt() + add & 0xFF;
            points[i] = inputStream.readIntelWord();
        }
        env.setPosition(points);
        env.setValue(values);
        inputStream.seek(pos + 82L);
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream inputStream) throws IOException {
        byte[] id = new byte[4];
        inputStream.read(id, 0, 4);
        inputStream.seek(0L);
        return Helpers.convertDWordToInt(id, 0) == 1229803597;
    }

    @Override
    protected Module getNewInstance(String fileName) {
        return new ImpulseTrackerMod(fileName);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream inputStream) throws IOException {
        int i;
        int i2;
        this.setModType(8);
        byte[] id = new byte[4];
        inputStream.read(id, 0, 4);
        this.setModID(Helpers.retrieveAsString(id, 0, 4));
        if (Helpers.convertDWordToInt(id, 0) != 1229803597) {
            throw new IOException("Unsupported IT Module!");
        }
        this.setSongName(inputStream.readString(26));
        inputStream.skip(2L);
        this.setSongLength(inputStream.readIntelWord());
        this.setNInstruments(inputStream.readIntelWord());
        this.setNSamples(inputStream.readIntelWord());
        this.setNPattern(inputStream.readIntelWord());
        this.version = inputStream.readIntelWord();
        this.setTrackerName("Impulse Tracker V" + Helpers.getAsHex(this.version >> 8 & 0xF, 1) + "." + Helpers.getAsHex(this.version & 0xFF, 2));
        int cmwt = inputStream.readIntelWord();
        this.setTrackerName(this.getTrackerName() + " (cmwt: " + Helpers.getAsHex(cmwt >> 8 & 0xF, 1) + "." + Helpers.getAsHex(cmwt & 0xFF, 2) + ")");
        this.flags = inputStream.readIntelWord();
        if ((this.flags & 8) != 0) {
            this.songFlags |= 0x10;
        }
        if ((this.flags & 0x10) != 0) {
            this.songFlags |= 4;
        }
        if ((this.flags & 0x20) != 0) {
            this.songFlags |= 8;
        }
        if ((this.flags & 0x80) != 0) {
            this.songFlags |= 1;
        }
        if ((this.flags & 0x1000) != 0) {
            this.songFlags |= 0x8000;
        }
        this.special = inputStream.readIntelWord();
        this.setBaseVolume(inputStream.readByteAsInt());
        inputStream.skip(1L);
        this.setTempo(inputStream.readByteAsInt());
        this.setBPMSpeed(inputStream.readByteAsInt());
        inputStream.skip(1L);
        inputStream.skip(1L);
        inputStream.skip(2L);
        inputStream.skip(4L);
        inputStream.skip(4L);
        this.isStereo = true;
        this.usePanningValues = true;
        this.panningValue = new int[64];
        for (i2 = 0; i2 < 64; ++i2) {
            int panValue = inputStream.readByteAsInt();
            this.panningValue[i2] = panValue == 100 || (panValue & 0x80) != 0 ? panValue << 2 : (panValue & 0x7F) << 2;
        }
        this.channelVolume = new int[64];
        for (i2 = 0; i2 < 64; ++i2) {
            this.channelVolume[i2] = inputStream.readByteAsInt();
            if (this.channelVolume[i2] <= 64) continue;
            this.channelVolume[i2] = 64;
        }
        this.allocArrangement(this.getSongLength());
        for (i2 = 0; i2 < this.getSongLength(); ++i2) {
            this.getArrangement()[i2] = inputStream.readByteAsInt();
        }
        InstrumentsContainer instrumentContainer = new InstrumentsContainer(this, this.getNInstruments(), this.getNSamples());
        this.setInstrumentContainer(instrumentContainer);
        for (i = 0; i < this.getNInstruments(); ++i) {
            inputStream.seek(192L + (long)this.getSongLength() + (long)(i << 2));
            inputStream.seek(inputStream.readIntelDWord());
            if (inputStream.readMotorolaDWord() != 1229803593) {
                throw new IOException("Unsupported IT Instrument Header!");
            }
            Instrument currentIns = new Instrument();
            currentIns.setDosFileName(inputStream.readString(13));
            Envelope volumeEnvelope = new Envelope();
            currentIns.setVolumeEnvelope(volumeEnvelope);
            Envelope panningEnvelope = new Envelope();
            currentIns.setPanningEnvelope(panningEnvelope);
            Envelope pitchEnvelope = new Envelope();
            currentIns.setPitchEnvelope(pitchEnvelope);
            if (cmwt < 512) {
                volumeEnvelope.setITType(inputStream.readByteAsInt());
                volumeEnvelope.setLoopStartPoint(inputStream.readByteAsInt());
                volumeEnvelope.setLoopEndPoint(inputStream.readByteAsInt());
                volumeEnvelope.setSustainStartPoint(inputStream.readByteAsInt());
                volumeEnvelope.setSustainEndPoint(inputStream.readByteAsInt());
                inputStream.skip(2L);
                currentIns.setVolumeFadeOut(inputStream.readIntelWord() << 6);
                currentIns.setGlobalVolume(64);
                currentIns.setNNA(inputStream.readByteAsInt());
                currentIns.setDublicateNoteCheck(inputStream.readByteAsInt());
                inputStream.skip(4L);
            } else {
                currentIns.setNNA(inputStream.readByteAsInt());
                currentIns.setDublicateNoteCheck(inputStream.readByteAsInt());
                currentIns.setDublicateNoteAction(inputStream.readByteAsInt());
                currentIns.setVolumeFadeOut(inputStream.readIntelWord() << 6);
                currentIns.setPitchPanSeparation(inputStream.readByteAsInt());
                currentIns.setPitchPanCenter(inputStream.readByteAsInt());
                currentIns.setGlobalVolume(inputStream.readByteAsInt() >> 1);
                currentIns.setDefaultPan(inputStream.readByteAsInt());
                currentIns.setRandomVolumeVariation(inputStream.readByteAsInt());
                currentIns.setRandomPanningVariation(inputStream.readByteAsInt());
                inputStream.skip(4L);
            }
            currentIns.setName(inputStream.readString(26));
            if (cmwt < 512) {
                inputStream.skip(6L);
            } else {
                currentIns.setInitialFilterCutoff(inputStream.readByteAsInt());
                currentIns.setInitialFilterResonance(inputStream.readByteAsInt());
                inputStream.skip(4L);
            }
            int[] sampleIndex = new int[120];
            int[] noteIndex = new int[120];
            for (int j = 0; j < 120; ++j) {
                noteIndex[j] = inputStream.readByteAsInt();
                sampleIndex[j] = inputStream.readByteAsInt();
            }
            currentIns.setIndexArray(sampleIndex);
            currentIns.setNoteArray(noteIndex);
            if (cmwt < 512) {
                int nPoints;
                int[] volumeEnvelopePosition = new int[25];
                int[] volumeEnvelopeValue = new int[25];
                for (nPoints = 0; nPoints < 25; ++nPoints) {
                    volumeEnvelopePosition[nPoints] = inputStream.readByteAsInt();
                    volumeEnvelopeValue[nPoints] = inputStream.readByteAsInt();
                }
                volumeEnvelope.setNPoints(nPoints);
                volumeEnvelope.setPosition(volumeEnvelopePosition);
                volumeEnvelope.setValue(volumeEnvelopeValue);
            } else {
                this.readEnvelopeData(volumeEnvelope, 0, inputStream);
                this.readEnvelopeData(panningEnvelope, 32, inputStream);
                this.readEnvelopeData(pitchEnvelope, 32, inputStream);
            }
            instrumentContainer.setInstrument(i, currentIns);
        }
        for (i = 0; i < this.getNSamples(); ++i) {
            inputStream.seek(192L + (long)this.getSongLength() + (long)(this.getNInstruments() << 2) + (long)(i << 2));
            inputStream.seek(inputStream.readIntelDWord());
            if (inputStream.readMotorolaDWord() != 1229803603) {
                throw new IOException("Unsupported IT Sample Header!");
            }
            Sample currentSample = new Sample();
            currentSample.setDosFileName(inputStream.readString(13));
            currentSample.setGlobalVolume(inputStream.readByteAsInt());
            int flags = inputStream.readByteAsInt();
            currentSample.setFlags(flags);
            int loopType = 0;
            if ((flags & 0x10) == 16) {
                loopType |= 1;
            }
            if ((flags & 0x20) == 32) {
                loopType |= 2;
            }
            if ((flags & 0x40) == 64) {
                loopType |= 4;
            }
            if ((flags & 0x80) == 128) {
                loopType |= 8;
            }
            currentSample.setLoopType(loopType);
            currentSample.setVolume(inputStream.readByteAsInt());
            currentSample.setName(inputStream.readString(26));
            int CvT = inputStream.readByteAsInt();
            currentSample.setCvT(CvT);
            int panning = inputStream.readByteAsInt();
            if ((panning & 0x80) == 0) {
                panning = -1;
            } else if ((panning = (panning & 0x7F) << 1) > 128) {
                panning = 128;
            }
            currentSample.setPanning(panning);
            currentSample.setLength(inputStream.readIntelDWord());
            int repeatStart = inputStream.readIntelDWord();
            int repeatStop = inputStream.readIntelDWord();
            currentSample.setRepeatStart(repeatStart);
            currentSample.setRepeatStop(repeatStop);
            currentSample.setRepeatLength(repeatStop - repeatStart);
            currentSample.setFineTune(0);
            currentSample.setTranspose(0);
            int c4Speed = inputStream.readIntelDWord();
            if (c4Speed == 0) {
                c4Speed = 8363;
            } else if (c4Speed < 256) {
                c4Speed = 256;
            }
            currentSample.setBaseFrequency(c4Speed);
            currentSample.setSustainLoopStart(inputStream.readIntelDWord());
            currentSample.setSustainLoopEnd(inputStream.readIntelDWord());
            int sampleOffset = inputStream.readIntelDWord();
            currentSample.setVibratoRate(inputStream.readByteAsInt());
            currentSample.setVibratoDepth(inputStream.readByteAsInt() & 0x7F);
            currentSample.setVibratoSweep(inputStream.readByteAsInt() + 3 >> 2);
            currentSample.setVibratoType(autovibit2xm[inputStream.readByteAsInt() & 7]);
            if (sampleOffset > 0 && currentSample.length > 0) {
                int loadFlag = 0;
                if (CvT == 255 && (flags & 2) != 2) {
                    loadFlag = 3;
                } else {
                    int n = loadFlag = (CvT & 1) == 1 ? 0 : 1;
                    if ((flags & 2) == 2) {
                        loadFlag |= 4;
                    }
                    if ((flags & 4) == 4) {
                        loadFlag |= 8;
                    }
                    if ((flags & 8) == 8) {
                        loadFlag |= this.version >= 533 && (CvT & 4) == 4 ? 18 : 16;
                    }
                }
                inputStream.seek(sampleOffset);
                this.readSampleData(currentSample, loadFlag, inputStream);
            }
            instrumentContainer.setSample(i, currentSample);
        }
        PatternContainer patternContainer = new PatternContainer(this.getNPattern());
        this.setPatternContainer(patternContainer);
        int maxChannels = 0;
        for (int pattNum = 0; pattNum < this.getNPattern(); ++pattNum) {
            int row;
            inputStream.seek(192 + this.getSongLength() + (this.getNInstruments() << 2) + (this.getNSamples() << 2) + (pattNum << 2));
            inputStream.seek(inputStream.readIntelDWord());
            int patternDataLength = inputStream.readIntelWord();
            int rows = inputStream.readIntelWord();
            inputStream.skip(4L);
            patternContainer.setPattern(pattNum, new Pattern(rows));
            for (row = 0; row < rows; ++row) {
                patternContainer.setPatternRow(pattNum, row, new PatternRow(64));
                for (int channel = 0; channel < 64; ++channel) {
                    PatternElement currentElement = new PatternElement(pattNum, row, channel);
                    patternContainer.setPatternElement(currentElement);
                }
            }
            row = 0;
            int[] lastMask = new int[64];
            int[] lastNote = new int[64];
            int[] lastIns = new int[64];
            int[] lastVolCmd = new int[64];
            int[] lastVolOp = new int[64];
            int[] lastCmd = new int[64];
            int[] lastData = new int[64];
            while (patternDataLength > 0) {
                int channelByte = inputStream.readByteAsInt();
                --patternDataLength;
                if (channelByte == 0) {
                    ++row;
                    continue;
                }
                int channel = channelByte - 1 & 0x3F;
                if (channel > maxChannels) {
                    maxChannels = channel;
                }
                PatternElement element = patternContainer.getPatternElement(pattNum, row, channel);
                if ((channelByte & 0x80) != 0) {
                    lastMask[channel] = inputStream.readByteAsInt();
                    --patternDataLength;
                }
                if ((lastMask[channel] & 1) != 0 || (lastMask[channel] & 0x10) != 0) {
                    int period;
                    int noteIndex;
                    if ((lastMask[channel] & 1) != 0) {
                        lastNote[channel] = inputStream.readByteAsInt();
                        --patternDataLength;
                    }
                    if ((noteIndex = lastNote[channel]) == 255) {
                        period = -1;
                        noteIndex = -1;
                    } else if (noteIndex == 254) {
                        period = -2;
                        noteIndex = -2;
                    } else {
                        period = noteIndex < Helpers.noteValues.length ? Helpers.noteValues[noteIndex] : 1;
                        ++noteIndex;
                    }
                    element.setNoteIndex(noteIndex);
                    element.setPeriod(period);
                }
                if ((lastMask[channel] & 2) != 0 || (lastMask[channel] & 0x20) != 0) {
                    if ((lastMask[channel] & 2) != 0) {
                        lastIns[channel] = inputStream.readByteAsInt();
                        --patternDataLength;
                    }
                    element.setInstrument(lastIns[channel]);
                }
                if ((lastMask[channel] & 4) != 0 || (lastMask[channel] & 0x40) != 0) {
                    if ((lastMask[channel] & 4) != 0) {
                        int vol = inputStream.readByteAsInt();
                        --patternDataLength;
                        int volCmd = 0;
                        int volOp = 0;
                        if (vol <= 64) {
                            volCmd = 1;
                            volOp = vol;
                        } else if (vol >= 128 && vol <= 192) {
                            volCmd = 8;
                            volOp = vol - 128;
                        } else if (vol < 75) {
                            volCmd = 5;
                            volOp = vol - 65;
                        } else if (vol < 85) {
                            volCmd = 4;
                            volOp = vol - 75;
                        } else if (vol < 95) {
                            volCmd = 3;
                            volOp = vol - 85;
                        } else if (vol < 105) {
                            volCmd = 2;
                            volOp = vol - 95;
                        } else if (vol < 115) {
                            volCmd = 13;
                            volOp = vol - 105;
                        } else if (vol < 125) {
                            volCmd = 12;
                            volOp = vol - 115;
                        } else if (vol >= 193 && vol <= 202) {
                            volCmd = 11;
                            volOp = vol - 193;
                        } else if (vol >= 203 && vol <= 212) {
                            volCmd = 6;
                            volOp = vol - 203;
                        }
                        lastVolCmd[channel] = volCmd;
                        lastVolOp[channel] = volOp;
                    }
                    element.setVolumeEffekt(lastVolCmd[channel]);
                    element.setVolumeEffektOp(lastVolOp[channel]);
                }
                if ((lastMask[channel] & 8) == 0 && (lastMask[channel] & 0x80) == 0) continue;
                if ((lastMask[channel] & 8) != 0) {
                    lastCmd[channel] = inputStream.readByteAsInt();
                    --patternDataLength;
                    lastData[channel] = inputStream.readByteAsInt();
                    --patternDataLength;
                }
                element.setEffekt(lastCmd[channel]);
                element.setEffektOp(lastData[channel]);
            }
        }
        if (maxChannels < 4) {
            maxChannels = 4;
        }
        this.setNChannels(maxChannels + 1);
        int realLen = 0;
        for (int i3 = 0; i3 < this.getSongLength() && this.getArrangement()[i3] != 255; ++i3) {
            if (this.getArrangement()[i3] >= 254 || this.getArrangement()[i3] >= this.getNPattern()) continue;
            this.getArrangement()[realLen++] = this.getArrangement()[i3];
        }
        this.setSongLength(realLen);
        this.cleanUpArrangement();
    }

    static {
        ModuleFactory.registerModule(new ImpulseTrackerMod());
    }
}

