/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.multimedia.mod.mixer.ScreamTrackerMixer;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ScreamTrackerMod
extends Module {
    private static final String[] MODFILEEXTENSION = new String[]{"s3m"};
    protected int version;
    protected int flags;
    protected int samplesType;
    protected boolean isStereo;
    protected boolean usePanningValues;
    protected int[] channelSettings;
    protected int[] panningValue;
    private int[] channelMap;

    public ScreamTrackerMod() {
    }

    protected ScreamTrackerMod(String fileName) {
        super(fileName);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public BasicModMixer getModMixer(int sampleRate, int doISP, int doNoLoops) {
        return new ScreamTrackerMixer(this, sampleRate, doISP, doNoLoops);
    }

    @Override
    public int getPanningValue(int channel) {
        return this.panningValue[channel];
    }

    @Override
    public int getChannelVolume(int channel) {
        return 64;
    }

    @Override
    public int getFrequencyTable() {
        return 0;
    }

    @Override
    public boolean doFastSlides() {
        return (this.flags & 0x40) != 0;
    }

    private void setPattern(int pattNum, ModfileInputStream inputStream) throws IOException {
        int row = 0;
        PatternRow currentRow = this.getPatternContainer().getPatternRow(pattNum, row);
        int count = inputStream.readIntelWord() - 2;
        while (count >= 0) {
            int packByte = inputStream.readByteAsInt();
            --count;
            if (packByte == 0) {
                if (++row >= 64) break;
                currentRow = this.getPatternContainer().getPatternRow(pattNum, row);
                continue;
            }
            int channel = packByte & 0x1F;
            channel = this.channelMap[channel];
            int period = 0;
            int noteIndex = 0;
            int instrument = 0;
            int volume = -1;
            int effekt = 0;
            int effektOp = 0;
            if ((packByte & 0x20) != 0) {
                int ton = inputStream.readByteAsInt();
                --count;
                if (ton == 254) {
                    period = -2;
                    noteIndex = -2;
                } else {
                    noteIndex = ((ton >> 4) + 1) * 12 + (ton & 0xF);
                    if (noteIndex >= Helpers.noteValues.length) {
                        period = 0;
                        noteIndex = 0;
                    } else {
                        period = Helpers.noteValues[noteIndex];
                        ++noteIndex;
                    }
                }
                instrument = inputStream.readByteAsInt();
                --count;
            }
            if ((packByte & 0x40) != 0) {
                volume = inputStream.readByteAsInt();
                --count;
            }
            if ((packByte & 0x80) != 0) {
                effekt = inputStream.readByteAsInt();
                --count;
                effektOp = inputStream.readByteAsInt();
                --count;
            }
            if (channel == -1) continue;
            PatternElement currentElement = currentRow.getPatternElement(channel);
            currentElement.setNoteIndex(noteIndex);
            currentElement.setPeriod(period);
            currentElement.setInstrument(instrument);
            if (volume != -1) {
                currentElement.setVolumeEffekt(1);
                currentElement.setVolumeEffektOp(volume);
            }
            currentElement.setEffekt(effekt);
            currentElement.setEffektOp(effektOp);
        }
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream inputStream) throws IOException {
        inputStream.seek(44L);
        String s3mID = inputStream.readString(4);
        inputStream.seek(0L);
        return s3mID.equals("SCRM");
    }

    @Override
    protected Module getNewInstance(String fileName) {
        return new ScreamTrackerMod(fileName);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream inputStream) throws IOException {
        int i;
        int i2;
        this.setModType(4);
        inputStream.seek(29L);
        int id = inputStream.readByteAsInt();
        if (id != 16) {
            throw new IOException("Unsupported S3M MOD (ID!=0x10)");
        }
        inputStream.seek(0L);
        this.setSongName(inputStream.readString(28));
        inputStream.seek(32L);
        this.setSongLength(inputStream.readIntelWord());
        this.setNSamples(inputStream.readIntelWord());
        this.setNInstruments(this.getNSamples());
        this.setNPattern(inputStream.readIntelWord());
        this.setNChannels(32);
        this.flags = inputStream.readIntelWord();
        this.version = inputStream.readIntelWord();
        this.samplesType = inputStream.readIntelWord();
        this.setModID(inputStream.readString(4));
        this.setTrackerName("ScreamTracker V" + (this.version >> 8 & 0xF) + '.' + (this.version & 0xFF));
        this.setBaseVolume(inputStream.readByteAsInt() << 1);
        this.setTempo(inputStream.readByteAsInt());
        this.setBPMSpeed(inputStream.readByteAsInt());
        this.isStereo = (inputStream.readByteAsInt() & 0x80) != 0;
        inputStream.readByteAsInt();
        this.usePanningValues = inputStream.readByteAsInt() == 252;
        inputStream.skip(10L);
        this.channelSettings = new int[32];
        this.channelMap = new int[32];
        int anzChannel = 0;
        for (i2 = 0; i2 < 32; ++i2) {
            int readByte = inputStream.readByteAsInt();
            if (readByte != 255) {
                this.channelMap[i2] = anzChannel;
                this.channelSettings[anzChannel++] = readByte;
                continue;
            }
            this.channelMap[i2] = -1;
        }
        this.setNChannels(anzChannel);
        this.allocArrangement(this.getSongLength());
        for (i2 = 0; i2 < this.getSongLength(); ++i2) {
            this.getArrangement()[i2] = inputStream.readByteAsInt();
        }
        InstrumentsContainer instrumentContainer = new InstrumentsContainer(this, 0, this.getNSamples());
        this.setInstrumentContainer(instrumentContainer);
        for (int i3 = 0; i3 < this.getNSamples(); ++i3) {
            int flags;
            inputStream.seek(96L + (long)this.getSongLength() + (long)(i3 << 1));
            long instrumentOffset = inputStream.readIntelWord();
            inputStream.seek(instrumentOffset << 4);
            Sample current = new Sample();
            current.setType(inputStream.readByteAsInt());
            current.setDosFileName(inputStream.readString(13));
            long sampleOffset = inputStream.readIntelWord();
            current.setLength(inputStream.readIntelDWord());
            int repeatStart = inputStream.readIntelDWord();
            int repeatStop = inputStream.readIntelDWord();
            current.setRepeatStart(repeatStart);
            current.setRepeatStop(repeatStop);
            current.setRepeatLength(repeatStop - repeatStart);
            current.setVolume(inputStream.readByteAsInt());
            inputStream.skip(2L);
            current.setFlags(inputStream.readByteAsInt());
            current.setLoopType((current.flags & 1) == 1 ? 1 : 0);
            current.setFineTune(0);
            current.setTranspose(0);
            current.setBaseFrequency(inputStream.readIntelDWord());
            inputStream.skip(12L);
            current.setName(inputStream.readString(28));
            inputStream.skip(4L);
            current.setPanning(-1);
            int n = flags = this.samplesType == 2 ? 1 : 0;
            if ((current.flags & 4) != 0) {
                flags |= 4;
            }
            inputStream.seek(sampleOffset << 4);
            this.readSampleData(current, flags, inputStream);
            instrumentContainer.setSample(i3, current);
        }
        PatternContainer patternContainer = new PatternContainer(this.getNPattern(), 64, this.getNChannels());
        this.setPatternContainer(patternContainer);
        for (int pattNum = 0; pattNum < this.getNPattern(); ++pattNum) {
            for (int row = 0; row < 64; ++row) {
                for (int channel = 0; channel < this.getNChannels(); ++channel) {
                    PatternElement currentElement = new PatternElement(pattNum, row, channel);
                    patternContainer.setPatternElement(currentElement);
                }
            }
            inputStream.seek(96L + (long)this.getSongLength() + (long)(this.getNSamples() << 1) + (long)(pattNum << 1));
            long patternPosition = inputStream.readIntelWord();
            inputStream.seek(patternPosition << 4);
            this.setPattern(pattNum, inputStream);
        }
        this.panningValue = new int[this.getNChannels()];
        if (this.usePanningValues) {
            inputStream.seek(96L + (long)this.getSongLength() + (long)(this.getNSamples() << 1) + (long)(this.getNPattern() << 1));
            for (i = 0; i < this.getNChannels(); ++i) {
                int readByte = inputStream.readByteAsInt() & 0xF;
                int ch = this.channelMap[i];
                if (ch == -1) continue;
                int val = readByte << 4;
                this.panningValue[ch] = this.channelSettings[ch] <= 7 || readByte != 0 ? val : 256 - val;
            }
        } else if (!this.isStereo) {
            for (i = 0; i < this.getNChannels(); ++i) {
                this.panningValue[i] = 128;
            }
        } else {
            for (i = 0; i < this.getNChannels(); ++i) {
                this.panningValue[i] = this.channelSettings[i] <= 7 ? 256 : 0;
            }
        }
        int realLen = 0;
        for (int i4 = 0; i4 < this.getSongLength(); ++i4) {
            if (this.getArrangement()[i4] >= 254 || this.getArrangement()[i4] >= this.getNPattern()) continue;
            this.getArrangement()[realLen++] = this.getArrangement()[i4];
        }
        this.setSongLength(realLen);
        this.cleanUpArrangement();
    }

    static {
        ModuleFactory.registerModule(new ScreamTrackerMod());
    }
}

