/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.multimedia.mod.mixer.ScreamTrackerMixer;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ScreamTrackerOldMod
extends Module {
    private static final String[] MODFILEEXTENSION = new String[]{"stm"};
    private int vHi;
    private int vLow;
    private int playBackTempo;
    private int STMType;

    public ScreamTrackerOldMod() {
    }

    protected ScreamTrackerOldMod(String fileName) {
        super(fileName);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public BasicModMixer getModMixer(int sampleRate, int doISP, int doNoLoops) {
        return new ScreamTrackerMixer(this, sampleRate, doISP, doNoLoops);
    }

    @Override
    public int getPanningValue(int channel) {
        if (channel % 3 != 0) {
            return 256;
        }
        return 0;
    }

    @Override
    public int getChannelVolume(int channel) {
        return 64;
    }

    @Override
    public int getFrequencyTable() {
        return 0;
    }

    public int getPlayBackTempo() {
        return this.playBackTempo;
    }

    @Override
    public boolean doFastSlides() {
        return false;
    }

    private String getModType(String kennung) throws IOException {
        if (!kennung.equals("!Scream!")) {
            throw new IOException("Mod id: " + kennung + ": this is not a screamtracker mod");
        }
        this.setNSamples(31);
        this.setNChannels(4);
        return "ScreamTracker";
    }

    private PatternElement createNewPatternElement(int pattNum, int row, int channel, int note) {
        int volume;
        PatternElement pe = new PatternElement(pattNum, row, channel);
        pe.setInstrument((note & 0xF80000) >> 19);
        int oktave = (note & 0xF0000000) >> 28;
        if (oktave != -1) {
            int ton = (note & 0xF000000) >> 24;
            int index = (oktave + 3) * 12 + ton;
            pe.setPeriod(index < Helpers.noteValues.length ? Helpers.noteValues[index] : 0);
            pe.setNoteIndex(index + 1);
        } else {
            pe.setPeriod(0);
            pe.setNoteIndex(0);
        }
        pe.setEffekt((note & 0xF00) >> 8);
        pe.setEffektOp(note & 0xFF);
        if (pe.getEffekt() == 1) {
            int effektOp = pe.getEffektOp();
            pe.setEffektOp((effektOp & 0xF) << 4 | (effektOp & 0xF0) >> 4);
        }
        if ((volume = (note & 0x70000) >> 16 | (note & 0xF000) >> 9) <= 64) {
            pe.setVolumeEffekt(1);
            pe.setVolumeEffektOp(volume);
        }
        return pe;
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream inputStream) throws IOException {
        inputStream.seek(20L);
        String stmID = inputStream.readString(8);
        inputStream.seek(0L);
        return stmID.equals("!SCREAM!") || stmID.equals("!Scream!");
    }

    @Override
    protected Module getNewInstance(String fileName) {
        return new ScreamTrackerOldMod(fileName);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream inputStream) throws IOException {
        inputStream.seek(20L);
        this.setTrackerName(this.getModType(inputStream.readString(8)));
        inputStream.seek(0L);
        this.setSongName(inputStream.readString(20));
        this.setModID(inputStream.readString(8));
        inputStream.skip(1L);
        this.STMType = inputStream.readByteAsInt();
        if (this.STMType != 2) {
            throw new IOException("Unsupported STM MOD (ID!=0x02)");
        }
        this.vHi = inputStream.readByteAsInt();
        this.vLow = inputStream.readByteAsInt();
        this.setTrackerName(this.getTrackerName() + " V" + this.vHi + '.' + this.vLow);
        this.playBackTempo = inputStream.readByteAsInt();
        this.setTempo(6);
        this.setBPMSpeed(125);
        int patternCount = inputStream.readByteAsInt();
        if (patternCount > 64) {
            patternCount = 64;
        }
        this.setNPattern(patternCount);
        this.setBaseVolume(inputStream.readByteAsInt() << 1);
        inputStream.skip(13L);
        this.setNInstruments(this.getNSamples());
        InstrumentsContainer instrumentContainer = new InstrumentsContainer(this, 0, this.getNSamples());
        this.setInstrumentContainer(instrumentContainer);
        for (int i = 0; i < this.getNSamples(); ++i) {
            Sample current = new Sample();
            current.setName(inputStream.readString(12));
            inputStream.skip(1L);
            int diskNumber = inputStream.readByteAsInt();
            if (this.STMType == 1) {
                current.setName(current.name + " #" + diskNumber);
            }
            inputStream.skip(2L);
            current.setLength(inputStream.readIntelWord());
            int repeatStart = inputStream.readIntelWord();
            int repeatStop = inputStream.readIntelWord();
            if (repeatStart < repeatStop && repeatStop != 65535) {
                current.setLoopType(1);
            } else {
                current.setLoopType(0);
            }
            current.setRepeatStart(repeatStart);
            current.setRepeatStop(repeatStop);
            current.setRepeatLength(repeatStop - repeatStart);
            int vol = inputStream.readByteAsInt() & 0x7F;
            current.setVolume(vol > 64 ? 64 : vol);
            inputStream.skip(1L);
            current.setPanning(-1);
            current.setFineTune(0);
            current.setTranspose(0);
            current.setBaseFrequency(inputStream.readIntelWord());
            inputStream.skip(4L);
            inputStream.skip(2L);
            instrumentContainer.setSample(i, current);
        }
        this.allocArrangement(128);
        int currentSongLenth = -1;
        for (int i = 0; i < 128; ++i) {
            int nextPatternIndex;
            this.getArrangement()[i] = nextPatternIndex = inputStream.readByteAsInt();
            if (currentSongLenth != -1 || nextPatternIndex != 99) continue;
            currentSongLenth = i;
        }
        while (this.getArrangement()[currentSongLenth - 1] >= this.getNPattern()) {
            --currentSongLenth;
        }
        this.setSongLength(currentSongLenth);
        PatternContainer patternContainer = new PatternContainer(this.getNPattern(), 64, this.getNChannels());
        this.setPatternContainer(patternContainer);
        for (int pattNum = 0; pattNum < this.getNPattern(); ++pattNum) {
            for (int row = 0; row < 64; ++row) {
                for (int channel = 0; channel < this.getNChannels(); ++channel) {
                    int value = inputStream.readMotorolaDWord();
                    patternContainer.setPatternElement(this.createNewPatternElement(pattNum, row, channel, value));
                }
            }
        }
        for (int i = 0; i < this.getNSamples(); ++i) {
            Sample current = this.getInstrumentContainer().getSample(i);
            this.readSampleData(current, 0, inputStream);
        }
        this.cleanUpArrangement();
    }

    static {
        ModuleFactory.registerModule(new ScreamTrackerOldMod());
    }
}

