/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer;

import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.system.Helpers;

public class ProTrackerMixer
extends BasicModMixer {
    public ProTrackerMixer(Module mod, int sampleRate, int doISP, int doNoLoops) {
        super(mod, sampleRate, doISP, doNoLoops);
    }

    protected void setPeriodBorders(BasicModMixer.ChannelMemory aktMemo) {
        if (this.frequencyTableType == 2) {
            aktMemo.portaStepUpEnd = this.getFineTunePeriod(aktMemo, Helpers.getNoteIndexForPeriod(113) + 1);
            aktMemo.portaStepDownEnd = this.getFineTunePeriod(aktMemo, Helpers.getNoteIndexForPeriod(856) + 1);
        } else {
            aktMemo.portaStepUpEnd = this.getFineTunePeriod(aktMemo, 119);
            aktMemo.portaStepDownEnd = this.getFineTunePeriod(aktMemo, 0);
        }
    }

    @Override
    protected void initializeMixer(int channel, BasicModMixer.ChannelMemory aktMemo) {
        this.setPeriodBorders(aktMemo);
    }

    @Override
    protected void resetAllEffects(BasicModMixer.ChannelMemory aktMemo, PatternElement nextElement, boolean forced) {
        if (aktMemo.arpegioIndex >= 0) {
            aktMemo.arpegioIndex = -1;
            int nextNotePeriod = aktMemo.arpegioNote[0];
            if (nextNotePeriod != 0) {
                aktMemo.currentNotePeriod = nextNotePeriod;
                this.setNewPlayerTuningFor(aktMemo, aktMemo.currentNotePeriod);
            }
        }
        if (aktMemo.vibratoOn && (forced || nextElement.getEffekt() != 4 && nextElement.getEffekt() != 6)) {
            aktMemo.vibratoOn = false;
            if (!aktMemo.vibratoNoRetrig) {
                aktMemo.vibratoTablePos = 0;
            }
            this.setNewPlayerTuningFor(aktMemo);
        }
        if (aktMemo.tremoloOn && (forced || nextElement.getEffekt() != 7)) {
            aktMemo.tremoloOn = false;
            if (!aktMemo.tremoloNoRetrig) {
                aktMemo.tremoloTablePos = 0;
            }
        }
        if (aktMemo.panbrelloOn && (forced || nextElement.getEffekt() != 34)) {
            aktMemo.panbrelloOn = false;
            if (!aktMemo.panbrelloNoRetrig) {
                aktMemo.panbrelloTablePos = 0;
            }
        }
    }

    @Override
    protected void doRowEffects(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.effekt == 0 && aktMemo.effektParam == 0) {
            return;
        }
        switch (aktMemo.effekt) {
            case 0: {
                if (aktMemo.assignedNotePeriod == 0) break;
                int currentIndex = aktMemo.assignedNoteIndex + aktMemo.currentTranspose;
                aktMemo.arpegioNote[0] = this.getFineTunePeriod(aktMemo, currentIndex);
                aktMemo.arpegioNote[1] = this.getFineTunePeriod(aktMemo, currentIndex + (aktMemo.effektParam >> 4));
                aktMemo.arpegioNote[2] = this.getFineTunePeriod(aktMemo, currentIndex + (aktMemo.effektParam & 0xF));
                aktMemo.arpegioIndex = 0;
                break;
            }
            case 1: {
                if (aktMemo.effektParam == 0) break;
                aktMemo.portaStepUp = aktMemo.effektParam << 4;
                this.setPeriodBorders(aktMemo);
                break;
            }
            case 2: {
                if (aktMemo.effektParam == 0) break;
                aktMemo.portaStepDown = aktMemo.effektParam << 4;
                this.setPeriodBorders(aktMemo);
                break;
            }
            case 3: {
                if (aktMemo.assignedNotePeriod != 0) {
                    aktMemo.portaTargetNotePeriod = this.getFineTunePeriod(aktMemo);
                }
                if (aktMemo.effektParam == 0) break;
                aktMemo.portaNoteStep = aktMemo.effektParam << 4;
                break;
            }
            case 4: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.vibratoStep = aktMemo.effektParam >> 4;
                }
                if ((aktMemo.effektParam & 0xF) != 0) {
                    aktMemo.vibratoAmplitude = aktMemo.effektParam & 0xF;
                }
                aktMemo.vibratoOn = true;
                break;
            }
            case 5: {
                if (aktMemo.assignedNotePeriod != 0) {
                    aktMemo.portaTargetNotePeriod = this.getFineTunePeriod(aktMemo);
                }
                if (this.mod.getModType() == 1 && aktMemo.effektParam == 0) {
                    aktMemo.volumSlideValue = 0;
                    break;
                }
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.volumSlideValue = aktMemo.effektParam >> 4;
                    break;
                }
                if ((aktMemo.effektParam & 0xF) == 0) break;
                aktMemo.volumSlideValue = -(aktMemo.effektParam & 0xF);
                break;
            }
            case 6: {
                aktMemo.vibratoOn = true;
                if (this.mod.getModType() == 1 && aktMemo.effektParam == 0) {
                    aktMemo.volumSlideValue = 0;
                    break;
                }
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.volumSlideValue = aktMemo.effektParam >> 4;
                    break;
                }
                if ((aktMemo.effektParam & 0xF) == 0) break;
                aktMemo.volumSlideValue = -(aktMemo.effektParam & 0xF);
                break;
            }
            case 7: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.tremoloStep = aktMemo.effektParam >> 4;
                }
                if ((aktMemo.effektParam & 0xF) != 0) {
                    aktMemo.tremoloAmplitude = aktMemo.effektParam & 0xF;
                }
                aktMemo.tremoloOn = true;
                break;
            }
            case 8: {
                if (aktMemo.effektParam == 164) {
                    aktMemo.doSurround = true;
                    aktMemo.panning = 128;
                    break;
                }
                aktMemo.doSurround = false;
                aktMemo.panning = aktMemo.effektParam;
                break;
            }
            case 9: {
                PatternElement element = aktMemo.currentElement;
                if (element.getPeriod() == 0 && element.getNoteIndex() == 0 || aktMemo.currentSample == null) break;
                if (aktMemo.effektParam != 0) {
                    aktMemo.sampleOffset = aktMemo.highSampleOffset << 16 | aktMemo.effektParam << 8;
                    aktMemo.highSampleOffset = 0;
                    if (aktMemo.sampleOffset >= aktMemo.currentSample.length) {
                        aktMemo.sampleOffset = aktMemo.currentSample.length - 1;
                    }
                }
                aktMemo.currentSamplePos = aktMemo.sampleOffset;
                aktMemo.currentTuningPos = 0;
                aktMemo.currentDirection = 0;
                break;
            }
            case 10: {
                if (this.mod.getModType() == 1 && aktMemo.effektParam == 0) {
                    aktMemo.volumSlideValue = 0;
                    break;
                }
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.volumSlideValue = aktMemo.effektParam >> 4;
                    break;
                }
                if ((aktMemo.effektParam & 0xF) == 0) break;
                aktMemo.volumSlideValue = -(aktMemo.effektParam & 0xF);
                break;
            }
            case 11: {
                this.patternBreakJumpPatternIndex = aktMemo.effektParam;
                break;
            }
            case 12: {
                aktMemo.currentSetVolume = aktMemo.currentVolume = aktMemo.effektParam;
                break;
            }
            case 13: {
                this.patternBreakRowIndex = (aktMemo.effektParam >> 4) * 10 + (aktMemo.effektParam & 0xF);
                break;
            }
            case 14: {
                int effektOp = aktMemo.effektParam & 0xF;
                switch (aktMemo.effektParam >> 4) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (effektOp != 0) {
                            aktMemo.finePortaUp = effektOp << 4;
                        }
                        aktMemo.currentNotePeriod -= aktMemo.finePortaUp;
                        this.setNewPlayerTuningFor(aktMemo);
                        break;
                    }
                    case 2: {
                        if (effektOp != 0) {
                            aktMemo.finePortaDown = effektOp << 4;
                        }
                        aktMemo.currentNotePeriod += aktMemo.finePortaDown;
                        this.setNewPlayerTuningFor(aktMemo);
                        break;
                    }
                    case 3: {
                        aktMemo.glissando = effektOp != 0;
                        break;
                    }
                    case 4: {
                        aktMemo.vibratoType = effektOp & 3;
                        aktMemo.vibratoNoRetrig = (effektOp & 4) != 0;
                        break;
                    }
                    case 5: {
                        aktMemo.currentFineTune = effektOp;
                        aktMemo.currentFinetuneFrequency = Helpers.it_fineTuneTable[effektOp];
                        this.setNewPlayerTuningFor(aktMemo);
                        break;
                    }
                    case 6: {
                        if (effektOp == 0) {
                            aktMemo.jumpLoopPatternRow = this.currentRow;
                            aktMemo.jumpLoopPositionSet = true;
                            break;
                        }
                        if (aktMemo.jumpLoopRepeatCount == -1) {
                            aktMemo.jumpLoopRepeatCount = effektOp;
                            if (!aktMemo.jumpLoopPositionSet) {
                                aktMemo.jumpLoopPatternRow = 0;
                                aktMemo.jumpLoopPositionSet = true;
                            }
                        }
                        if (aktMemo.jumpLoopRepeatCount > 0 && aktMemo.jumpLoopPositionSet) {
                            --aktMemo.jumpLoopRepeatCount;
                            this.patternJumpPatternIndex = aktMemo.jumpLoopPatternRow;
                            break;
                        }
                        aktMemo.jumpLoopPositionSet = false;
                        aktMemo.jumpLoopRepeatCount = -1;
                        break;
                    }
                    case 7: {
                        aktMemo.tremoloType = effektOp & 3;
                        aktMemo.tremoloNoRetrig = (effektOp & 4) == 4;
                        break;
                    }
                    case 8: {
                        aktMemo.doSurround = false;
                        aktMemo.panning = effektOp << 4;
                        break;
                    }
                    case 9: {
                        aktMemo.retrigCount = aktMemo.retrigMemo = effektOp;
                        break;
                    }
                    case 10: {
                        aktMemo.currentSetVolume = aktMemo.currentVolume += effektOp;
                        break;
                    }
                    case 11: {
                        aktMemo.currentSetVolume = aktMemo.currentVolume -= effektOp;
                        break;
                    }
                    case 12: {
                        aktMemo.noteCutCount = effektOp;
                        break;
                    }
                    case 13: {
                        aktMemo.noteDelayCount = effektOp;
                        break;
                    }
                    case 14: {
                        if (this.patternDelayCount > 0) break;
                        this.patternDelayCount = effektOp;
                        break;
                    }
                }
                break;
            }
            case 15: {
                if (aktMemo.effektParam > 31) {
                    this.currentBPM = aktMemo.effektParam;
                    this.samplePerTicks = this.calculateSamplesPerTick();
                    break;
                }
                this.currentTick = this.currentTempo = aktMemo.effektParam;
                break;
            }
            case 16: {
                this.globalVolume = aktMemo.effektParam << 1;
                if (this.globalVolume <= 128) break;
                this.globalVolume = 128;
                break;
            }
            case 17: {
                if (aktMemo.effektParam >> 4 != 0) {
                    this.globalVolumSlideValue = aktMemo.effektParam >> 4;
                } else if ((aktMemo.effektParam & 0xF) != 0) {
                    this.globalVolumSlideValue = -(aktMemo.effektParam & 0xF);
                }
                this.globalVolumSlideValue <<= 1;
                this.doGlobalVolumeSlideEffekt();
                break;
            }
            case 20: {
                aktMemo.keyOffCounter = aktMemo.effektParam;
                break;
            }
            case 21: {
                aktMemo.volEnvPos = aktMemo.effektParam;
                aktMemo.panEnvPos = aktMemo.effektParam;
                break;
            }
            case 25: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.panningSlideValue = aktMemo.effektParam >> 4 << 2;
                    break;
                }
                if ((aktMemo.effektParam & 0xF) == 0) break;
                aktMemo.panningSlideValue = -((aktMemo.effektParam & 0xF) << 2);
                break;
            }
            case 27: {
                aktMemo.retrigCount = aktMemo.retrigMemo = aktMemo.effektParam & 0xF;
                aktMemo.retrigVolSlide = aktMemo.effektParam >> 4;
                break;
            }
            case 29: {
                if (aktMemo.effektParam == 0) break;
                aktMemo.tremorCount = 0;
                aktMemo.tremorOntime = aktMemo.effektParam >> 4;
                aktMemo.tremorOfftime = aktMemo.effektParam & 0xF;
                break;
            }
            case 33: {
                int effektOpEx = aktMemo.effektParam & 0xF;
                block44 : switch (aktMemo.effektParam >> 4) {
                    case 1: {
                        if (effektOpEx != 0) {
                            aktMemo.finePortaUpEx = effektOpEx << 2;
                        }
                        aktMemo.currentNotePeriod -= aktMemo.finePortaUpEx;
                        this.setNewPlayerTuningFor(aktMemo);
                        break;
                    }
                    case 2: {
                        if (effektOpEx != 0) {
                            aktMemo.finePortaDownEx = effektOpEx << 2;
                        }
                        aktMemo.currentNotePeriod += aktMemo.finePortaDownEx;
                        this.setNewPlayerTuningFor(aktMemo);
                        break;
                    }
                    case 5: {
                        aktMemo.panbrelloType = effektOpEx & 3;
                        aktMemo.panbrelloNoRetrig = (effektOpEx & 4) != 0;
                        break;
                    }
                    case 6: {
                        if (this.patternTicksDelayCount > 0) break;
                        this.patternTicksDelayCount = effektOpEx;
                        break;
                    }
                    case 9: {
                        switch (effektOpEx) {
                            case 0: {
                                aktMemo.doSurround = false;
                                break block44;
                            }
                            case 1: {
                                aktMemo.doSurround = true;
                                break block44;
                            }
                            case 8: {
                                break block44;
                            }
                            case 9: {
                                break block44;
                            }
                            case 10: {
                                break block44;
                            }
                            case 11: {
                                break block44;
                            }
                            case 12: {
                                break block44;
                            }
                            case 13: {
                                break block44;
                            }
                            case 14: {
                                break block44;
                            }
                        }
                        break;
                    }
                    case 10: {
                        aktMemo.highSampleOffset = aktMemo.effektParam & 0xF;
                    }
                }
                break;
            }
            case 34: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.panbrelloStep = aktMemo.effektParam >> 4;
                }
                if ((aktMemo.effektParam & 0xF) != 0) {
                    aktMemo.panbrelloAmplitude = aktMemo.effektParam & 0xF;
                }
                aktMemo.panbrelloOn = true;
                break;
            }
        }
    }

    private void doPortaToNoteEffekt(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.portaTargetNotePeriod < aktMemo.currentNotePeriod) {
            aktMemo.currentNotePeriod -= aktMemo.portaNoteStep;
            if (aktMemo.currentNotePeriod < aktMemo.portaTargetNotePeriod) {
                aktMemo.currentNotePeriod = aktMemo.portaTargetNotePeriod;
            }
        } else {
            aktMemo.currentNotePeriod += aktMemo.portaNoteStep;
            if (aktMemo.currentNotePeriod > aktMemo.portaTargetNotePeriod) {
                aktMemo.currentNotePeriod = aktMemo.portaTargetNotePeriod;
            }
        }
        this.setNewPlayerTuningFor(aktMemo);
    }

    protected void doVibratoEffekt(BasicModMixer.ChannelMemory aktMemo) {
        int periodAdd;
        switch (aktMemo.vibratoType & 3) {
            case 1: {
                periodAdd = Helpers.ModRampDownTable[aktMemo.vibratoTablePos];
                break;
            }
            case 2: {
                periodAdd = Helpers.ModSquareTable[aktMemo.vibratoTablePos];
                break;
            }
            case 3: {
                periodAdd = Helpers.ModRandomTable[aktMemo.vibratoTablePos];
                break;
            }
            default: {
                periodAdd = Helpers.ModSinusTable[aktMemo.vibratoTablePos];
            }
        }
        periodAdd = (periodAdd << 4) * aktMemo.vibratoAmplitude >> 7;
        this.setNewPlayerTuningFor(aktMemo, aktMemo.currentNotePeriod + periodAdd);
        aktMemo.vibratoTablePos = aktMemo.vibratoTablePos + aktMemo.vibratoStep & 0x3F;
    }

    protected void doTremoloEffekt(BasicModMixer.ChannelMemory aktMemo) {
        int volumeAdd;
        switch (aktMemo.tremoloType & 3) {
            case 1: {
                volumeAdd = Helpers.ModRampDownTable[aktMemo.tremoloTablePos];
                break;
            }
            case 2: {
                volumeAdd = Helpers.ModSquareTable[aktMemo.tremoloTablePos];
                break;
            }
            case 3: {
                volumeAdd = Helpers.ModRandomTable[aktMemo.tremoloTablePos];
                break;
            }
            default: {
                volumeAdd = Helpers.ModSinusTable[aktMemo.tremoloTablePos];
            }
        }
        volumeAdd = volumeAdd * aktMemo.tremoloAmplitude >> 7;
        aktMemo.currentVolume = aktMemo.currentSetVolume + volumeAdd;
        aktMemo.tremoloTablePos = aktMemo.tremoloTablePos + aktMemo.tremoloStep & 0x3F;
    }

    protected void doTremorEffekt(BasicModMixer.ChannelMemory aktMemo) {
        aktMemo.currentVolume = aktMemo.tremorCount < aktMemo.tremorOntime ? aktMemo.currentSetVolume : 0;
        ++aktMemo.tremorCount;
        if (aktMemo.tremorCount > aktMemo.tremorOntime + aktMemo.tremorOfftime) {
            aktMemo.tremorCount = 0;
        }
    }

    protected void doVolumeSlideEffekt(BasicModMixer.ChannelMemory aktMemo) {
        aktMemo.currentSetVolume = aktMemo.currentVolume += aktMemo.volumSlideValue;
    }

    protected void doGlobalVolumeSlideEffekt() {
        this.globalVolume += this.globalVolumSlideValue;
        if (this.globalVolume > 128) {
            this.globalVolume = 128;
        } else if (this.globalVolume < 0) {
            this.globalVolume = 0;
        }
    }

    protected void doPanningSlideEffekt(BasicModMixer.ChannelMemory aktMemo) {
        aktMemo.doSurround = false;
        aktMemo.panning += aktMemo.panningSlideValue;
    }

    @Override
    protected void doTickEffekts(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.effekt == 0 && aktMemo.effektParam == 0) {
            return;
        }
        switch (aktMemo.effekt) {
            case 0: {
                aktMemo.arpegioIndex = (aktMemo.arpegioIndex + 1) % 3;
                int nextNotePeriod = aktMemo.arpegioNote[aktMemo.arpegioIndex];
                if (nextNotePeriod == 0) break;
                aktMemo.currentNotePeriod = nextNotePeriod;
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 1: {
                aktMemo.currentNotePeriod -= aktMemo.portaStepUp;
                if (aktMemo.glissando) {
                    aktMemo.currentNotePeriod = Helpers.getRoundedPeriod(aktMemo.currentNotePeriod >> 4) << 4;
                }
                if (aktMemo.currentNotePeriod < aktMemo.portaStepUpEnd) {
                    aktMemo.currentNotePeriod = aktMemo.portaStepUpEnd;
                }
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 2: {
                aktMemo.currentNotePeriod += aktMemo.portaStepDown;
                if (aktMemo.glissando) {
                    aktMemo.currentNotePeriod = Helpers.getRoundedPeriod(aktMemo.currentNotePeriod >> 4) << 4;
                }
                if (aktMemo.currentNotePeriod > aktMemo.portaStepDownEnd) {
                    aktMemo.currentNotePeriod = aktMemo.portaStepDownEnd;
                }
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 3: {
                this.doPortaToNoteEffekt(aktMemo);
                break;
            }
            case 4: {
                this.doVibratoEffekt(aktMemo);
                break;
            }
            case 5: {
                this.doPortaToNoteEffekt(aktMemo);
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 6: {
                this.doVibratoEffekt(aktMemo);
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 7: {
                this.doTremoloEffekt(aktMemo);
                break;
            }
            case 10: {
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 14: {
                switch (aktMemo.effektParam >> 4) {
                    case 9: {
                        --aktMemo.retrigCount;
                        if (aktMemo.retrigCount > 0) break;
                        aktMemo.retrigCount = aktMemo.retrigMemo;
                        this.resetInstrument(aktMemo);
                        break;
                    }
                    case 12: {
                        if (aktMemo.noteCutCount <= 0) break;
                        --aktMemo.noteCutCount;
                        if (aktMemo.noteCutCount > 0) break;
                        aktMemo.noteCutCount = -1;
                        aktMemo.currentVolume = 0;
                        break;
                    }
                    case 13: {
                        if (aktMemo.noteDelayCount <= 0) break;
                        --aktMemo.noteDelayCount;
                        if (aktMemo.noteDelayCount > 0) break;
                        aktMemo.noteDelayCount = -1;
                        this.setNewInstrumentAndPeriod(aktMemo);
                    }
                }
                break;
            }
            case 17: {
                this.doGlobalVolumeSlideEffekt();
                break;
            }
            case 20: {
                if (aktMemo.keyOffCounter <= 0) break;
                --aktMemo.keyOffCounter;
                if (aktMemo.keyOffCounter > 0) break;
                aktMemo.keyOffCounter = -1;
                aktMemo.keyOff = true;
                break;
            }
            case 25: {
                this.doPanningSlideEffekt(aktMemo);
                break;
            }
            case 27: {
                if (aktMemo.retrigVolSlide > 0) {
                    switch (aktMemo.retrigVolSlide) {
                        case 1: {
                            --aktMemo.currentVolume;
                            break;
                        }
                        case 2: {
                            aktMemo.currentVolume -= 2;
                            break;
                        }
                        case 3: {
                            aktMemo.currentVolume -= 4;
                            break;
                        }
                        case 4: {
                            aktMemo.currentVolume -= 8;
                            break;
                        }
                        case 5: {
                            aktMemo.currentVolume -= 16;
                            break;
                        }
                        case 6: {
                            aktMemo.currentVolume = (aktMemo.currentVolume << 1) / 3;
                            break;
                        }
                        case 7: {
                            aktMemo.currentVolume >>= 1;
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            ++aktMemo.currentVolume;
                            break;
                        }
                        case 10: {
                            aktMemo.currentVolume += 2;
                            break;
                        }
                        case 11: {
                            aktMemo.currentVolume += 4;
                            break;
                        }
                        case 12: {
                            aktMemo.currentVolume += 8;
                            break;
                        }
                        case 13: {
                            aktMemo.currentVolume += 16;
                            break;
                        }
                        case 14: {
                            aktMemo.currentVolume = aktMemo.currentVolume * 3 >> 1;
                            break;
                        }
                        case 15: {
                            aktMemo.currentVolume <<= 1;
                        }
                    }
                    aktMemo.currentSetVolume = aktMemo.currentVolume;
                }
                --aktMemo.retrigCount;
                if (aktMemo.retrigCount > 0) break;
                aktMemo.retrigCount = aktMemo.retrigMemo;
                this.resetInstrument(aktMemo);
                break;
            }
            case 29: {
                this.doTremorEffekt(aktMemo);
            }
        }
    }

    @Override
    protected void doVolumeColumnRowEffekt(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.volumeEffekt == 0) {
            return;
        }
        switch (aktMemo.volumeEffekt) {
            case 1: {
                aktMemo.currentSetVolume = aktMemo.currentVolume = aktMemo.volumeEffektOp;
                break;
            }
            case 2: {
                aktMemo.volumSlideValue = -aktMemo.volumeEffektOp;
                break;
            }
            case 3: {
                aktMemo.volumSlideValue = aktMemo.volumeEffektOp;
                break;
            }
            case 4: {
                aktMemo.currentSetVolume = aktMemo.currentVolume -= aktMemo.volumeEffektOp;
                break;
            }
            case 5: {
                aktMemo.currentSetVolume = aktMemo.currentVolume += aktMemo.volumeEffektOp;
                break;
            }
            case 6: {
                if (aktMemo.volumeEffektOp == 0) break;
                aktMemo.vibratoStep = aktMemo.volumeEffektOp;
                break;
            }
            case 7: {
                if (aktMemo.volumeEffektOp == 0) break;
                aktMemo.vibratoAmplitude = aktMemo.volumeEffektOp;
                break;
            }
            case 8: {
                aktMemo.doSurround = false;
                aktMemo.panning = aktMemo.volumeEffektOp << 4;
                break;
            }
            case 9: {
                aktMemo.panningSlideValue = -aktMemo.volumeEffektOp;
                break;
            }
            case 10: {
                aktMemo.panningSlideValue = aktMemo.volumeEffektOp;
                break;
            }
            case 11: {
                if (aktMemo.assignedNotePeriod != 0) {
                    aktMemo.portaTargetNotePeriod = this.getFineTunePeriod(aktMemo);
                }
                if (aktMemo.volumeEffektOp == 0) break;
                aktMemo.portaNoteStep = aktMemo.volumeEffektOp;
                break;
            }
            case 12: {
                aktMemo.portaStepDown = aktMemo.volumeEffektOp << 4;
                break;
            }
            case 13: {
                aktMemo.portaStepUp = aktMemo.volumeEffektOp << 4;
            }
        }
    }

    @Override
    protected void doVolumeColumnTickEffekt(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.volumeEffekt == 0) {
            return;
        }
        switch (aktMemo.volumeEffekt) {
            case 2: 
            case 3: {
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 6: 
            case 7: {
                this.doVibratoEffekt(aktMemo);
                break;
            }
            case 9: 
            case 10: {
                this.doPanningSlideEffekt(aktMemo);
                break;
            }
            case 11: {
                this.doPortaToNoteEffekt(aktMemo);
            }
        }
    }

    @Override
    protected boolean isNoteDelayEffekt(BasicModMixer.ChannelMemory aktMemo) {
        return aktMemo.effekt == 14 && aktMemo.effektParam >> 4 == 13;
    }

    @Override
    protected boolean isPortaToNoteEffekt(BasicModMixer.ChannelMemory aktMemo) {
        return (aktMemo.effekt == 3 || aktMemo.effekt == 5) && aktMemo.currentNotePeriod != 0;
    }

    @Override
    protected boolean isSampleOffsetEffekt(BasicModMixer.ChannelMemory aktMemo) {
        return aktMemo.effekt == 9;
    }
}

