/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer;

import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.system.Helpers;

public class ScreamTrackerMixer
extends BasicModMixer {
    public ScreamTrackerMixer(Module mod, int sampleRate, int doISP, int doNoLoops) {
        super(mod, sampleRate, doISP, doNoLoops);
    }

    @Override
    protected void initializeMixer(int channel, BasicModMixer.ChannelMemory aktMemo) {
        if (this.mod.getModType() == 8) {
            aktMemo.muted = (this.mod.getPanningValue(channel) & 0x200) != 0;
            aktMemo.doSurround = this.mod.getPanningValue(channel) == 400;
        }
    }

    @Override
    protected void resetAllEffects(BasicModMixer.ChannelMemory aktMemo, PatternElement nextElement, boolean forced) {
        if (aktMemo.arpegioIndex >= 0) {
            aktMemo.arpegioIndex = -1;
            int nextNotePeriod = aktMemo.arpegioNote[0];
            if (nextNotePeriod != 0) {
                aktMemo.currentNotePeriod = nextNotePeriod;
                this.setNewPlayerTuningFor(aktMemo, aktMemo.currentNotePeriod);
            }
        }
        if (aktMemo.vibratoOn && (forced || nextElement.getEffekt() != 8 && nextElement.getEffekt() != 11 && nextElement.getEffekt() != 21)) {
            aktMemo.vibratoOn = false;
            if (!aktMemo.vibratoNoRetrig) {
                aktMemo.vibratoTablePos = 0;
            }
            this.setNewPlayerTuningFor(aktMemo);
        }
        if (aktMemo.tremoloOn && (forced || nextElement.getEffekt() != 18)) {
            aktMemo.tremoloOn = false;
            if (!aktMemo.tremoloNoRetrig) {
                aktMemo.tremoloTablePos = 0;
            }
        }
        if (aktMemo.panbrelloOn && (forced || nextElement.getEffekt() != 25)) {
            aktMemo.panbrelloOn = false;
            if (!aktMemo.panbrelloNoRetrig) {
                aktMemo.panbrelloTablePos = 0;
            }
        }
    }

    @Override
    protected void doRowEffects(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.effekt == 0 && aktMemo.effektParam == 0) {
            return;
        }
        switch (aktMemo.effekt) {
            case 1: {
                this.currentTick = this.currentTempo = aktMemo.effektParam;
                break;
            }
            case 2: {
                this.patternBreakJumpPatternIndex = aktMemo.effektParam;
                break;
            }
            case 3: {
                this.patternBreakRowIndex = (aktMemo.effektParam >> 4) * 10 + (aktMemo.effektParam & 0xF);
                break;
            }
            case 4: {
                if (aktMemo.effektParam != 0) {
                    aktMemo.volumSlideValue = aktMemo.effektParam;
                }
                if (!(aktMemo.volumSlideValue >> 4 == 15 && (aktMemo.volumSlideValue & 0xF) != 0 || aktMemo.volumSlideValue >> 4 != 0 && (aktMemo.volumSlideValue & 0xF) == 15) && !this.useFastSlides) break;
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 5: {
                int indicatorPortaDown;
                if (aktMemo.effektParam != 0) {
                    aktMemo.portaStepDown = aktMemo.effektParam;
                }
                if ((indicatorPortaDown = aktMemo.portaStepDown & 0xF0) != 224 && indicatorPortaDown != 240) break;
                int effektOp = aktMemo.portaStepDown & 0xF;
                aktMemo.currentNotePeriod = aktMemo.currentNotePeriod + (indicatorPortaDown == 224 ? effektOp << 2 : effektOp << 4);
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 6: {
                int indicatorPortaUp;
                if (aktMemo.effektParam != 0) {
                    aktMemo.portaStepUp = aktMemo.effektParam;
                }
                if ((indicatorPortaUp = aktMemo.portaStepUp & 0xF0) != 224 && indicatorPortaUp != 240) break;
                int effektOp = aktMemo.portaStepUp & 0xF;
                aktMemo.currentNotePeriod = aktMemo.currentNotePeriod - (indicatorPortaUp == 224 ? effektOp << 2 : effektOp << 4);
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 7: {
                if (aktMemo.assignedNotePeriod != 0) {
                    aktMemo.portaTargetNotePeriod = this.getFineTunePeriod(aktMemo);
                }
                if (aktMemo.effektParam == 0) break;
                aktMemo.portaNoteStep = aktMemo.effektParam << 4;
                break;
            }
            case 8: 
            case 21: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.vibratoStep = aktMemo.effektParam >> 4;
                }
                if ((aktMemo.effektParam & 0xF) != 0) {
                    aktMemo.vibratoAmplitude = aktMemo.effektParam & 0xF;
                }
                aktMemo.vibratoOn = true;
                break;
            }
            case 9: {
                if (aktMemo.effektParam != 0) {
                    aktMemo.tremorCount = 0;
                    aktMemo.tremorOntime = (aktMemo.effektParam >> 4) + 1;
                    aktMemo.tremorOfftime = (aktMemo.effektParam & 0xF) + 1;
                }
                this.doTremorEffekt(aktMemo);
                break;
            }
            case 10: {
                if (aktMemo.assignedNotePeriod == 0) break;
                int currentIndex = aktMemo.assignedNoteIndex - 1;
                aktMemo.arpegioNote[0] = this.getFineTunePeriod(aktMemo);
                aktMemo.arpegioNote[1] = this.getFineTunePeriod(aktMemo, currentIndex + (aktMemo.effektParam >> 4));
                aktMemo.arpegioNote[2] = this.getFineTunePeriod(aktMemo, currentIndex + (aktMemo.effektParam & 0xF));
                aktMemo.arpegioIndex = 0;
                break;
            }
            case 11: {
                aktMemo.vibratoOn = true;
                if (aktMemo.effektParam != 0) {
                    aktMemo.volumSlideValue = aktMemo.effektParam;
                }
                if (!(aktMemo.effektParam >> 4 == 15 && (aktMemo.effektParam & 0xF) != 0 || aktMemo.effektParam >> 4 != 0 && (aktMemo.effektParam & 0xF) == 15) && !this.useFastSlides) break;
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 12: {
                if (aktMemo.assignedNotePeriod != 0) {
                    aktMemo.portaTargetNotePeriod = this.getFineTunePeriod(aktMemo);
                }
                if (aktMemo.effektParam != 0) {
                    aktMemo.volumSlideValue = aktMemo.effektParam;
                }
                if (!(aktMemo.effektParam >> 4 == 15 && (aktMemo.effektParam & 0xF) != 0 || aktMemo.effektParam >> 4 != 0 && (aktMemo.effektParam & 0xF) == 15) && !this.useFastSlides) break;
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 13: {
                aktMemo.channelVolume = aktMemo.effektParam;
                if (aktMemo.channelVolume <= 64) break;
                aktMemo.channelVolume = 64;
                break;
            }
            case 14: {
                if (aktMemo.effektParam != 0) {
                    aktMemo.channelVolumSlideValue = aktMemo.effektParam;
                }
                if (!(aktMemo.effektParam >> 4 == 15 && (aktMemo.effektParam & 0xF) != 0 || aktMemo.effektParam >> 4 != 0 && (aktMemo.effektParam & 0xF) == 15) && !this.useFastSlides) break;
                this.doChannelVolumeSlideEffekt(aktMemo);
                break;
            }
            case 15: {
                PatternElement element = aktMemo.currentElement;
                if (element.getPeriod() == 0 && element.getNoteIndex() == 0 || aktMemo.currentSample == null) break;
                if (aktMemo.effektParam != 0) {
                    aktMemo.sampleOffset = aktMemo.highSampleOffset << 16 | aktMemo.effektParam << 8;
                    aktMemo.highSampleOffset = 0;
                    if (aktMemo.sampleOffset >= aktMemo.currentSample.length) {
                        aktMemo.sampleOffset = aktMemo.currentSample.length - 1;
                    }
                }
                aktMemo.currentSamplePos = aktMemo.sampleOffset;
                aktMemo.currentTuningPos = 0;
                aktMemo.currentDirection = 0;
                break;
            }
            case 16: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.panningSlideValue = aktMemo.effektParam >> 4 << 2;
                    break;
                }
                aktMemo.panningSlideValue = -((aktMemo.effektParam & 0xF) << 2);
                break;
            }
            case 17: {
                aktMemo.retrigCount = aktMemo.retrigMemo = aktMemo.effektParam & 0xF;
                aktMemo.retrigVolSlide = aktMemo.effektParam >> 4;
                break;
            }
            case 18: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.tremoloStep = aktMemo.effektParam >> 4;
                }
                if ((aktMemo.effektParam & 0xF) != 0) {
                    aktMemo.tremoloAmplitude = aktMemo.effektParam & 0xF;
                }
                aktMemo.tremoloOn = true;
                break;
            }
            case 19: {
                int effektOpEx = aktMemo.effektParam & 0xF;
                block26 : switch (aktMemo.effektParam >> 4) {
                    case 1: {
                        aktMemo.glissando = effektOpEx != 0;
                        break;
                    }
                    case 2: {
                        aktMemo.currentFineTune = Helpers.it_fineTuneTable[effektOpEx];
                        aktMemo.currentFinetuneFrequency = Helpers.it_fineTuneTable[effektOpEx];
                        this.setNewPlayerTuningFor(aktMemo);
                        break;
                    }
                    case 3: {
                        aktMemo.vibratoType = effektOpEx & 3;
                        aktMemo.vibratoNoRetrig = (effektOpEx & 4) != 0;
                        break;
                    }
                    case 4: {
                        aktMemo.tremoloType = effektOpEx & 3;
                        aktMemo.tremoloNoRetrig = (effektOpEx & 4) != 0;
                        break;
                    }
                    case 5: {
                        aktMemo.panbrelloType = effektOpEx & 3;
                        aktMemo.panbrelloNoRetrig = (effektOpEx & 4) != 0;
                        break;
                    }
                    case 6: {
                        if (this.patternTicksDelayCount > 0) break;
                        this.patternTicksDelayCount = effektOpEx;
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        aktMemo.panning = effektOpEx << 4;
                        break;
                    }
                    case 9: {
                        switch (effektOpEx) {
                            case 0: {
                                aktMemo.doSurround = false;
                                break block26;
                            }
                            case 1: {
                                aktMemo.doSurround = true;
                                break block26;
                            }
                            case 8: {
                                break block26;
                            }
                            case 9: {
                                break block26;
                            }
                            case 10: {
                                break block26;
                            }
                            case 11: {
                                break block26;
                            }
                            case 12: {
                                break block26;
                            }
                            case 13: {
                                break block26;
                            }
                            case 14: {
                                break block26;
                            }
                        }
                        break;
                    }
                    case 10: {
                        aktMemo.highSampleOffset = aktMemo.effektParam & 0xF;
                        break;
                    }
                    case 11: {
                        if (effektOpEx == 0) {
                            aktMemo.jumpLoopPatternRow = this.currentRow;
                            aktMemo.jumpLoopPositionSet = true;
                            break;
                        }
                        if (aktMemo.jumpLoopRepeatCount == -1) {
                            aktMemo.jumpLoopRepeatCount = effektOpEx;
                            if (!aktMemo.jumpLoopPositionSet) {
                                aktMemo.jumpLoopPatternRow = 0;
                                aktMemo.jumpLoopPositionSet = true;
                            }
                        }
                        if (aktMemo.jumpLoopRepeatCount > 0 && aktMemo.jumpLoopPositionSet) {
                            --aktMemo.jumpLoopRepeatCount;
                            this.patternJumpPatternIndex = aktMemo.jumpLoopPatternRow;
                            break;
                        }
                        aktMemo.jumpLoopPositionSet = false;
                        aktMemo.jumpLoopRepeatCount = -1;
                        break;
                    }
                    case 12: {
                        aktMemo.noteCutCount = effektOpEx;
                        break;
                    }
                    case 13: {
                        aktMemo.noteDelayCount = effektOpEx;
                        break;
                    }
                    case 14: {
                        if (this.patternDelayCount > 0) break;
                        this.patternDelayCount = effektOpEx;
                        break;
                    }
                }
                break;
            }
            case 20: {
                this.currentBPM = aktMemo.effektParam >> 4 == 0 ? (this.currentBPM -= aktMemo.effektParam & 0xF) : (aktMemo.effektParam >> 4 == 1 ? (this.currentBPM += aktMemo.effektParam & 0xF) : aktMemo.effektParam);
                this.samplePerTicks = this.calculateSamplesPerTick();
                break;
            }
            case 22: {
                this.globalVolume = this.mod.getModType() == 8 ? aktMemo.effektParam : aktMemo.effektParam << 1;
                if (this.globalVolume <= 128) break;
                this.globalVolume = 128;
                break;
            }
            case 23: {
                this.globalVolumSlideValue = aktMemo.effektParam >> 4 != 0 ? aktMemo.effektParam >> 4 : -(aktMemo.effektParam & 0xF);
                if (this.mod.getModType() != 8) {
                    this.globalVolumSlideValue <<= 1;
                }
                this.doGlobalVolumeSlideEffekt();
                break;
            }
            case 24: {
                if (aktMemo.effektParam == 164) {
                    aktMemo.doSurround = true;
                    aktMemo.panning = 128;
                    break;
                }
                aktMemo.doSurround = false;
                aktMemo.panning = aktMemo.effektParam;
                break;
            }
            case 25: {
                if (aktMemo.effektParam >> 4 != 0) {
                    aktMemo.panbrelloStep = aktMemo.effektParam >> 4;
                }
                if ((aktMemo.effektParam & 0xF) != 0) {
                    aktMemo.panbrelloAmplitude = aktMemo.effektParam & 0xF;
                }
                aktMemo.panbrelloOn = true;
                break;
            }
        }
    }

    private void doPortaToNoteEffekt(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.portaTargetNotePeriod != aktMemo.currentNotePeriod) {
            if (aktMemo.portaTargetNotePeriod < aktMemo.currentNotePeriod) {
                aktMemo.currentNotePeriod -= aktMemo.portaNoteStep;
                if (aktMemo.currentNotePeriod < aktMemo.portaTargetNotePeriod) {
                    aktMemo.currentNotePeriod = aktMemo.portaTargetNotePeriod;
                }
            } else {
                aktMemo.currentNotePeriod += aktMemo.portaNoteStep;
                if (aktMemo.currentNotePeriod > aktMemo.portaTargetNotePeriod) {
                    aktMemo.currentNotePeriod = aktMemo.portaTargetNotePeriod;
                }
            }
            this.setNewPlayerTuningFor(aktMemo);
        }
    }

    protected void doVibratoEffekt(BasicModMixer.ChannelMemory aktMemo, boolean doFineVibrato) {
        int periodAdd;
        switch (aktMemo.vibratoType & 3) {
            case 1: {
                periodAdd = Helpers.ModRampDownTable[aktMemo.vibratoTablePos];
                break;
            }
            case 2: {
                periodAdd = Helpers.ModSquareTable[aktMemo.vibratoTablePos];
                break;
            }
            case 3: {
                periodAdd = Helpers.ModRandomTable[aktMemo.vibratoTablePos];
                break;
            }
            default: {
                periodAdd = Helpers.ModSinusTable[aktMemo.vibratoTablePos];
            }
        }
        periodAdd = (periodAdd << 4) * aktMemo.vibratoAmplitude >> (doFineVibrato ? 9 : 7);
        this.setNewPlayerTuningFor(aktMemo, aktMemo.currentNotePeriod + periodAdd);
        aktMemo.vibratoTablePos = aktMemo.vibratoTablePos + aktMemo.vibratoStep & 0x3F;
    }

    protected void doTremoloEffekt(BasicModMixer.ChannelMemory aktMemo) {
        int volumeAdd;
        switch (aktMemo.tremoloType & 3) {
            case 1: {
                volumeAdd = Helpers.ModRampDownTable[aktMemo.tremoloTablePos];
                break;
            }
            case 2: {
                volumeAdd = Helpers.ModSquareTable[aktMemo.tremoloTablePos];
                break;
            }
            case 3: {
                volumeAdd = Helpers.ModRandomTable[aktMemo.tremoloTablePos];
                break;
            }
            default: {
                volumeAdd = Helpers.ModSinusTable[aktMemo.tremoloTablePos];
            }
        }
        volumeAdd = volumeAdd * aktMemo.tremoloAmplitude >> 7;
        aktMemo.currentVolume = aktMemo.currentSetVolume + volumeAdd;
        aktMemo.tremoloTablePos = aktMemo.tremoloTablePos + aktMemo.tremoloStep & 0x3F;
    }

    protected void doTremorEffekt(BasicModMixer.ChannelMemory aktMemo) {
        aktMemo.currentVolume = aktMemo.tremorCount < aktMemo.tremorOntime ? aktMemo.currentSetVolume : 0;
        ++aktMemo.tremorCount;
        if (aktMemo.tremorCount > aktMemo.tremorOntime + aktMemo.tremorOfftime) {
            aktMemo.tremorCount = 0;
        }
    }

    protected void doVolumeSlideEffekt(BasicModMixer.ChannelMemory aktMemo) {
        int x = aktMemo.volumSlideValue >> 4;
        int y = aktMemo.volumSlideValue & 0xF;
        if (x != 0) {
            aktMemo.currentSetVolume = x == 15 && y != 0 ? (aktMemo.currentVolume -= y) : (aktMemo.currentVolume += x);
        } else if (y != 0) {
            aktMemo.currentSetVolume = x != 0 && y == 15 ? (aktMemo.currentVolume += x) : (aktMemo.currentVolume -= y);
        }
    }

    protected void doChannelVolumeSlideEffekt(BasicModMixer.ChannelMemory aktMemo) {
        int x = aktMemo.channelVolumSlideValue >> 4;
        int y = aktMemo.channelVolumSlideValue & 0xF;
        if (x != 0) {
            aktMemo.channelVolume = x == 15 && y != 0 ? (aktMemo.channelVolume -= y) : (aktMemo.channelVolume += x);
        } else if (y != 0) {
            aktMemo.channelVolume = x != 0 && y == 15 ? (aktMemo.channelVolume += x) : (aktMemo.channelVolume -= y);
        }
        if (aktMemo.channelVolume > 64) {
            aktMemo.channelVolume = 64;
        } else if (aktMemo.channelVolume < 0) {
            aktMemo.channelVolume = 0;
        }
    }

    protected void doGlobalVolumeSlideEffekt() {
        this.globalVolume += this.globalVolumSlideValue;
        if (this.globalVolume > 128) {
            this.globalVolume = 128;
        } else if (this.globalVolume < 0) {
            this.globalVolume = 0;
        }
    }

    protected void doPanningSlideEffekt(BasicModMixer.ChannelMemory aktMemo) {
        aktMemo.doSurround = false;
        aktMemo.panning += aktMemo.panningSlideValue;
    }

    @Override
    protected void doTickEffekts(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.effekt == 0 && aktMemo.effektParam == 0) {
            return;
        }
        switch (aktMemo.effekt) {
            case 4: {
                if (aktMemo.volumSlideValue >> 4 == 15 && (aktMemo.volumSlideValue & 0xF) != 0 && (aktMemo.volumSlideValue >> 4 == 0 || (aktMemo.volumSlideValue & 0xF) != 15)) break;
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 5: {
                int indicatorPortaDown = aktMemo.portaStepDown & 0xF0;
                if (indicatorPortaDown == 224 || indicatorPortaDown == 240) break;
                aktMemo.currentNotePeriod += aktMemo.portaStepDown << 4;
                if (aktMemo.glissando) {
                    aktMemo.currentNotePeriod = Helpers.getRoundedPeriod(aktMemo.currentNotePeriod >> 4) << 4;
                }
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 6: {
                int indicatorPortaUp = aktMemo.portaStepUp & 0xF0;
                if (indicatorPortaUp == 224 || indicatorPortaUp == 240) break;
                aktMemo.currentNotePeriod -= aktMemo.portaStepUp << 4;
                if (aktMemo.glissando) {
                    aktMemo.currentNotePeriod = Helpers.getRoundedPeriod(aktMemo.currentNotePeriod >> 4) << 4;
                }
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 7: {
                this.doPortaToNoteEffekt(aktMemo);
                break;
            }
            case 8: {
                this.doVibratoEffekt(aktMemo, false);
                break;
            }
            case 9: {
                this.doTremorEffekt(aktMemo);
                break;
            }
            case 10: {
                aktMemo.arpegioIndex = (aktMemo.arpegioIndex + 1) % 3;
                int nextNotePeriod = aktMemo.arpegioNote[aktMemo.arpegioIndex];
                if (nextNotePeriod == 0) break;
                aktMemo.currentNotePeriod = nextNotePeriod;
                this.setNewPlayerTuningFor(aktMemo);
                break;
            }
            case 11: {
                this.doVibratoEffekt(aktMemo, false);
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 12: {
                this.doPortaToNoteEffekt(aktMemo);
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 14: {
                if (aktMemo.effektParam >> 4 == 15 && (aktMemo.effektParam & 0xF) != 0 && (aktMemo.effektParam >> 4 == 0 || (aktMemo.effektParam & 0xF) != 15)) break;
                this.doChannelVolumeSlideEffekt(aktMemo);
                break;
            }
            case 16: {
                this.doPanningSlideEffekt(aktMemo);
                break;
            }
            case 17: {
                if (aktMemo.retrigVolSlide > 0) {
                    switch (aktMemo.retrigVolSlide) {
                        case 1: {
                            --aktMemo.currentVolume;
                            break;
                        }
                        case 2: {
                            aktMemo.currentVolume -= 2;
                            break;
                        }
                        case 3: {
                            aktMemo.currentVolume -= 4;
                            break;
                        }
                        case 4: {
                            aktMemo.currentVolume -= 8;
                            break;
                        }
                        case 5: {
                            aktMemo.currentVolume -= 16;
                            break;
                        }
                        case 6: {
                            aktMemo.currentVolume = (aktMemo.currentVolume << 1) / 3;
                            break;
                        }
                        case 7: {
                            aktMemo.currentVolume >>= 1;
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            ++aktMemo.currentVolume;
                            break;
                        }
                        case 10: {
                            aktMemo.currentVolume += 2;
                            break;
                        }
                        case 11: {
                            aktMemo.currentVolume += 4;
                            break;
                        }
                        case 12: {
                            aktMemo.currentVolume += 8;
                            break;
                        }
                        case 13: {
                            aktMemo.currentVolume += 16;
                            break;
                        }
                        case 14: {
                            aktMemo.currentVolume = aktMemo.currentVolume * 3 >> 1;
                            break;
                        }
                        case 15: {
                            aktMemo.currentVolume <<= 1;
                        }
                    }
                    aktMemo.currentSetVolume = aktMemo.currentVolume;
                }
                --aktMemo.retrigCount;
                if (aktMemo.retrigCount > 0) break;
                aktMemo.retrigCount = aktMemo.retrigMemo;
                this.resetInstrument(aktMemo);
                break;
            }
            case 18: {
                this.doTremoloEffekt(aktMemo);
                break;
            }
            case 19: {
                switch (aktMemo.effektParam >> 4) {
                    case 12: {
                        if (aktMemo.noteCutCount <= 0) break;
                        --aktMemo.noteCutCount;
                        if (aktMemo.noteCutCount > 0) break;
                        aktMemo.noteCutCount = -1;
                        aktMemo.currentVolume = 0;
                        break;
                    }
                    case 13: {
                        if (aktMemo.noteDelayCount <= 0) break;
                        --aktMemo.noteDelayCount;
                        if (aktMemo.noteDelayCount > 0) break;
                        aktMemo.noteDelayCount = -1;
                        this.setNewInstrumentAndPeriod(aktMemo);
                    }
                }
                break;
            }
            case 21: {
                this.doVibratoEffekt(aktMemo, true);
                break;
            }
            case 23: {
                this.doGlobalVolumeSlideEffekt();
            }
        }
    }

    @Override
    protected void doVolumeColumnRowEffekt(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.volumeEffekt == 0) {
            return;
        }
        switch (aktMemo.volumeEffekt) {
            case 1: {
                aktMemo.currentSetVolume = aktMemo.currentVolume = aktMemo.volumeEffektOp;
                break;
            }
            case 2: {
                aktMemo.volumSlideValue = -aktMemo.volumeEffektOp;
                break;
            }
            case 3: {
                aktMemo.volumSlideValue = aktMemo.volumeEffektOp;
                break;
            }
            case 4: {
                aktMemo.currentSetVolume = aktMemo.currentVolume -= aktMemo.volumeEffektOp;
                break;
            }
            case 5: {
                aktMemo.currentSetVolume = aktMemo.currentVolume += aktMemo.volumeEffektOp;
                break;
            }
            case 6: {
                if (aktMemo.volumeEffektOp == 0) break;
                aktMemo.vibratoStep = aktMemo.volumeEffektOp;
                break;
            }
            case 7: {
                if (aktMemo.volumeEffektOp == 0) break;
                aktMemo.vibratoAmplitude = aktMemo.volumeEffektOp;
                break;
            }
            case 8: {
                aktMemo.doSurround = false;
                aktMemo.panning = aktMemo.volumeEffektOp << 4;
                break;
            }
            case 9: {
                aktMemo.panningSlideValue = -aktMemo.volumeEffektOp;
                break;
            }
            case 10: {
                aktMemo.panningSlideValue = aktMemo.volumeEffektOp;
                break;
            }
            case 11: {
                if (aktMemo.assignedNotePeriod != 0) {
                    aktMemo.portaTargetNotePeriod = this.getFineTunePeriod(aktMemo);
                }
                if (aktMemo.volumeEffektOp == 0) break;
                aktMemo.portaNoteStep = aktMemo.volumeEffektOp;
                break;
            }
            case 12: {
                aktMemo.portaStepDown = aktMemo.volumeEffektOp << 4;
                break;
            }
            case 13: {
                aktMemo.portaStepUp = aktMemo.volumeEffektOp << 4;
            }
        }
    }

    @Override
    protected void doVolumeColumnTickEffekt(BasicModMixer.ChannelMemory aktMemo) {
        if (aktMemo.volumeEffekt == 0) {
            return;
        }
        switch (aktMemo.volumeEffekt) {
            case 2: 
            case 3: {
                this.doVolumeSlideEffekt(aktMemo);
                break;
            }
            case 6: 
            case 7: {
                this.doVibratoEffekt(aktMemo, false);
                break;
            }
            case 9: 
            case 10: {
                this.doPanningSlideEffekt(aktMemo);
                break;
            }
            case 11: {
                this.doPortaToNoteEffekt(aktMemo);
            }
        }
    }

    @Override
    protected boolean isNoteDelayEffekt(BasicModMixer.ChannelMemory aktMemo) {
        return aktMemo.effekt == 19 && aktMemo.effektParam >> 4 == 13;
    }

    @Override
    protected boolean isPortaToNoteEffekt(BasicModMixer.ChannelMemory aktMemo) {
        return (aktMemo.effekt == 7 || aktMemo.effekt == 12) && aktMemo.currentNotePeriod != 0;
    }

    @Override
    protected boolean isSampleOffsetEffekt(BasicModMixer.ChannelMemory aktMemo) {
        return aktMemo.effekt == 15;
    }
}

