/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer.interpolation;

public class WindowedFIR {
    private static final int WFIR_QUANTBITS = 15;
    private static final int WFIR_QUANTSCALE = 32768;
    public static final int WFIR_16BITSHIFT = 14;
    private static final int WFIR_FRACBITS = 10;
    private static final int WFIR_LUTLEN = 2049;
    private static final int WFIR_LOG2WIDTH = 3;
    private static final int WFIR_WIDTH = 8;
    private static final float WFIR_CUTOFF = 0.9f;
    private static final int WFIR_HANN = 0;
    private static final int WFIR_HAMMING = 1;
    private static final int WFIR_BLACKMANEXACT = 2;
    private static final int WFIR_BLACKMAN3T61 = 3;
    private static final int WFIR_BLACKMAN3T67 = 4;
    private static final int WFIR_BLACKMAN4T92 = 5;
    private static final int WFIR_BLACKMAN4T74 = 6;
    private static final int WFIR_KAISER4T = 7;
    private static final int WFIR_TYPE = 2;
    private static final double M_zEPS = 1.0E-8;
    public static final int WFIR_POSFRACMASK = 65535;
    public static final int WFIR_FRACSHIFT = 2;
    public static final int WFIR_FRACMASK = 32760;
    public static final int WFIR_FRACHALVE = 16;
    public static final int[] lut = new int[16392];

    private WindowedFIR() {
    }

    private static double coef(int _PCnr, double _POfs, double _PCut, int _PWidth, int _PType) {
        double _LSi;
        double _LWc;
        double _LWidthM1 = _PWidth - 1;
        double _LWidthM1Half = 0.5 * _LWidthM1;
        double _LPosU = (double)_PCnr - _POfs;
        double _LPos = _LPosU - _LWidthM1Half;
        double _LPIdl = Math.PI * 2 / _LWidthM1;
        if (Math.abs(_LPos) < 1.0E-8) {
            _LWc = 1.0;
            _LSi = _PCut;
        } else {
            switch (_PType) {
                case 0: {
                    _LWc = 0.5 - 0.5 * Math.cos(_LPIdl * _LPosU);
                    break;
                }
                case 1: {
                    _LWc = 0.54 - 0.46 * Math.cos(_LPIdl * _LPosU);
                    break;
                }
                case 2: {
                    _LWc = 0.42 - 0.5 * Math.cos(_LPIdl * _LPosU) + 0.08 * Math.cos(2.0 * _LPIdl * _LPosU);
                    break;
                }
                case 3: {
                    _LWc = 0.44959 - 0.49364 * Math.cos(_LPIdl * _LPosU) + 0.05677 * Math.cos(2.0 * _LPIdl * _LPosU);
                    break;
                }
                case 4: {
                    _LWc = 0.42323 - 0.49755 * Math.cos(_LPIdl * _LPosU) + 0.07922 * Math.cos(2.0 * _LPIdl * _LPosU);
                    break;
                }
                case 5: {
                    _LWc = 0.35875 - 0.48829 * Math.cos(_LPIdl * _LPosU) + 0.14128 * Math.cos(2.0 * _LPIdl * _LPosU) - 0.01168 * Math.cos(3.0 * _LPIdl * _LPosU);
                    break;
                }
                case 6: {
                    _LWc = 0.40217 - 0.49703 * Math.cos(_LPIdl * _LPosU) + 0.09392 * Math.cos(2.0 * _LPIdl * _LPosU) - 0.00183 * Math.cos(3.0 * _LPIdl * _LPosU);
                    break;
                }
                case 7: {
                    _LWc = 0.40243 - 0.49804 * Math.cos(_LPIdl * _LPosU) + 0.09831 * Math.cos(2.0 * _LPIdl * _LPosU) - 0.00122 * Math.cos(3.0 * _LPIdl * _LPosU);
                    break;
                }
                default: {
                    _LWc = 1.0;
                }
            }
            _LSi = Math.sin(_PCut * (_LPos *= Math.PI)) / _LPos;
        }
        return _LWc * _LSi;
    }

    private static void initialize() {
        double _LPcllen = 1024.0;
        double _LNorm = 1.0 / (2.0 * _LPcllen);
        double _LCut = 0.9f;
        double _LScale = 32768.0;
        for (int _LPcl = 0; _LPcl < 2049; ++_LPcl) {
            int _LCc;
            double[] _LCoefs = new double[8];
            double _LOfs = ((double)_LPcl - _LPcllen) * _LNorm;
            int _LIdx = _LPcl << 3;
            double _LGain = 0.0;
            for (_LCc = 0; _LCc < 8; ++_LCc) {
                _LCoefs[_LCc] = WindowedFIR.coef(_LCc, _LOfs, _LCut, 8, 2);
                _LGain += _LCoefs[_LCc];
            }
            _LGain = 1.0 / _LGain;
            for (_LCc = 0; _LCc < 8; ++_LCc) {
                double _LCoef = Math.floor(0.5 + _LScale * _LCoefs[_LCc] * _LGain);
                WindowedFIR.lut[_LIdx + _LCc] = (int)(_LCoef < -_LScale ? -_LScale : (_LCoef > _LScale ? _LScale : _LCoef));
            }
        }
    }

    static {
        WindowedFIR.initialize();
    }
}

