/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3;

import de.quippy.javamod.io.RandomAccessInputStreamImpl;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mp3.MP3InfoPanel;
import de.quippy.javamod.multimedia.mp3.MP3Mixer;
import de.quippy.javamod.multimedia.mp3.MP3StreamInfoPanel;
import de.quippy.javamod.multimedia.mp3.id3.MP3FileID3Controller;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseEvent;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import de.quippy.javamod.system.Log;
import de.quippy.mp3.decoder.Bitstream;
import de.quippy.mp3.decoder.BitstreamException;
import de.quippy.mp3.decoder.Header;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class MP3Container
extends MultimediaContainer
implements TagParseListener {
    private static final String[] MP3FILEEXTENSION = new String[]{"mp1", "mp2", "mp3"};
    private MP3Mixer currentMixer;
    private MP3InfoPanel mp3InfoPanel;
    private MP3StreamInfoPanel mp3StreamInfoPanel;
    private MP3FileID3Controller mp3FileIDTags = null;
    private boolean isStreaming;

    @Override
    public MultimediaContainer getInstance(URL mp3FileUrl) {
        MultimediaContainer result = super.getInstance(mp3FileUrl);
        boolean bl = this.isStreaming = !mp3FileUrl.getProtocol().equalsIgnoreCase("file");
        if (!this.isStreaming) {
            this.mp3FileIDTags = new MP3FileID3Controller(mp3FileUrl);
            ((MP3InfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.mp3FileIDTags);
        } else {
            this.mp3FileIDTags = null;
            ((MP3StreamInfoPanel)this.getInfoPanel()).clearFields();
        }
        return result;
    }

    @Override
    public String getSongName() {
        if (this.mp3FileIDTags != null) {
            return this.mp3FileIDTags.getShortDescription();
        }
        return super.getSongName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getSongInfosFor(URL url) {
        String songName = MultimediaContainerManager.getSongNameFromURL(url);
        Long duration = -1L;
        RandomAccessInputStreamImpl inputStream = null;
        Bitstream bitStream = null;
        try {
            if (url.getProtocol().equalsIgnoreCase("file")) {
                inputStream = new RandomAccessInputStreamImpl(url);
                bitStream = new Bitstream(inputStream);
                Header h = bitStream.readFrame();
                if (h != null) {
                    duration = (long)((double)h.total_ms(inputStream.available()) + 0.5);
                }
                this.mp3FileIDTags = new MP3FileID3Controller(inputStream);
                if (this.mp3FileIDTags != null) {
                    songName = this.mp3FileIDTags.getShortDescription();
                }
            }
        }
        catch (Throwable ex) {
        }
        finally {
            if (bitStream != null) {
                try {
                    bitStream.close();
                }
                catch (BitstreamException ex) {
                    Log.error("IGNORED", ex);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
        return new Object[]{songName, duration};
    }

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.isStreaming) {
            if (this.mp3StreamInfoPanel == null) {
                this.mp3StreamInfoPanel = new MP3StreamInfoPanel();
            }
            return this.mp3StreamInfoPanel;
        }
        if (this.mp3InfoPanel == null) {
            this.mp3InfoPanel = new MP3InfoPanel();
        }
        return this.mp3InfoPanel;
    }

    @Override
    public String[] getFileExtensionList() {
        return MP3FILEEXTENSION;
    }

    @Override
    public String getName() {
        return "MP3-File";
    }

    @Override
    public void configurationChanged(Properties newProps) {
    }

    @Override
    public void configurationSave(Properties props) {
    }

    @Override
    public Mixer createNewMixer() {
        this.currentMixer = new MP3Mixer(this.getFileURL());
        this.currentMixer.setTagParserListener(this);
        return this.currentMixer;
    }

    @Override
    public void tagParsed(TagParseEvent tpe) {
        JPanel panel = this.getInfoPanel();
        if (panel instanceof MP3StreamInfoPanel) {
            ((MP3StreamInfoPanel)panel).fillInfoPanelWith(tpe.getIcyTag());
            String currentSongName = ((MP3StreamInfoPanel)panel).getCurrentSongName();
            if (currentSongName != null && currentSongName.length() != 0) {
                this.fireMultimediaContainerEvent(new MultimediaContainerEvent(this, MultimediaContainerEvent.SONG_NAME_CHANGED, currentSongName));
            }
        }
    }

    static {
        MultimediaContainerManager.registerContainer(new MP3Container());
    }
}

