/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.mp3.streaming.IcyInputStream;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import de.quippy.javamod.system.Log;
import de.quippy.mp3.decoder.Bitstream;
import de.quippy.mp3.decoder.BitstreamException;
import de.quippy.mp3.decoder.Decoder;
import de.quippy.mp3.decoder.Header;
import de.quippy.mp3.decoder.SampleBuffer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;

public class MP3Mixer
extends BasicMixer {
    private static final String STREAM_HTTP = " HTTP/1.1\r\nuser-agent: JavaMod\r\nIcy-MetaData: 1\r\nConnection: keep-alive\r\n\r\n";
    private byte[] output;
    private Socket socket;
    private InputStream inputStream;
    private Bitstream bitStream;
    private Decoder decoder;
    private URL mp3FileUrl;
    private TagParseListener tagParseListener;
    private int played_ms;
    private Boolean isStreaming;

    public MP3Mixer(URL mp3FileUrl) {
        this.mp3FileUrl = mp3FileUrl;
    }

    public void setTagParserListener(TagParseListener tagParseListener) {
        this.tagParseListener = tagParseListener;
    }

    private void initialize() {
        try {
            if (this.bitStream != null) {
                try {
                    this.bitStream.close();
                    this.bitStream = null;
                }
                catch (BitstreamException e) {
                    Log.error("IGNORED", e);
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            if (!this.isStreaming()) {
                this.inputStream = new FileOrPackedInputStream(this.mp3FileUrl);
            } else {
                String path;
                int port = this.mp3FileUrl.getPort();
                if (port < 0) {
                    port = 80;
                }
                if ((path = this.mp3FileUrl.getPath()) == null || path.length() == 0) {
                    path = "/";
                }
                this.socket = new Socket(this.mp3FileUrl.getHost(), port);
                OutputStream os = this.socket.getOutputStream();
                String getString = "GET " + path + STREAM_HTTP;
                os.write(getString.getBytes());
                this.inputStream = new IcyInputStream((InputStream)new BufferedInputStream(this.socket.getInputStream()), this.tagParseListener);
            }
            this.bitStream = new Bitstream(this.inputStream);
            this.decoder = new Decoder();
            this.played_ms = 0;
        }
        catch (Exception ex) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            Log.error("[MP3Mixer]", ex);
        }
    }

    private boolean isStreaming() {
        if (this.isStreaming == null) {
            if (this.mp3FileUrl.getProtocol().equalsIgnoreCase("file")) {
                this.isStreaming = Boolean.FALSE;
            } else {
                try {
                    URLConnection con = this.mp3FileUrl.openConnection();
                    int length = con.getContentLength();
                    this.isStreaming = length == -1 ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable ex) {
                    Log.error("[MP3Mixer::isStreamaing]", ex);
                }
            }
        }
        return this.isStreaming;
    }

    @Override
    public boolean isSeekSupported() {
        return !this.isStreaming();
    }

    @Override
    public long getMillisecondPosition() {
        if (!this.isStreaming()) {
            return this.played_ms;
        }
        return 0L;
    }

    @Override
    public long getLengthInMilliseconds() {
        if (!this.isStreaming()) {
            try {
                this.initialize();
                Header h = this.bitStream.readFrame();
                if (h != null) {
                    return (long)((double)h.total_ms(this.inputStream.available()) + 0.5);
                }
            }
            catch (Throwable ex) {
                Log.error("IGNORED", ex);
            }
        }
        return 0L;
    }

    @Override
    protected void seek(long milliseconds) {
        block13: {
            try {
                float f_played_ms;
                Header h;
                if (this.isStreaming()) break block13;
                if ((long)this.played_ms > milliseconds) {
                    if (this.bitStream != null) {
                        try {
                            this.bitStream.close();
                            this.bitStream = null;
                        }
                        catch (BitstreamException e) {
                            Log.error("IGNORED", e);
                        }
                    }
                    if (this.inputStream != null) {
                        try {
                            this.inputStream.close();
                            this.inputStream = null;
                        }
                        catch (IOException e) {
                            Log.error("IGNORED", e);
                        }
                    }
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                            this.socket = null;
                        }
                        catch (IOException e) {
                            Log.error("IGNORED", e);
                        }
                    }
                    this.inputStream = this.mp3FileUrl.openStream();
                    this.bitStream = new Bitstream(this.inputStream);
                    this.decoder = new Decoder();
                    this.played_ms = 0;
                }
                for (f_played_ms = (float)this.played_ms; f_played_ms < (float)milliseconds && (h = this.bitStream.readFrame()) != null; f_played_ms += h.ms_per_frame()) {
                    this.bitStream.closeFrame();
                }
                this.played_ms = (int)((double)f_played_ms + 0.5);
            }
            catch (Throwable ex) {
                Log.error("[MP3Mixer]", ex);
            }
        }
    }

    @Override
    public int getChannelCount() {
        if (this.decoder != null) {
            return this.decoder.getOutputChannels();
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        Header h;
        if (this.bitStream != null && (h = this.bitStream.getHeader()) != null) {
            return h.bitrate_instant() / 1000;
        }
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        if (this.decoder != null) {
            return this.decoder.getOutputFrequency() / 1000;
        }
        return 0;
    }

    private byte[] getOutputBuffer(int length) {
        if (this.output == null || this.output.length < length) {
            this.output = new byte[length];
        }
        return this.output;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        if (this.bitStream == null) {
            return;
        }
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            boolean isFirstFrame = true;
            Header h = null;
            do {
                if ((h = this.bitStream.readFrame()) != null) {
                    SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitStream);
                    this.bitStream.closeFrame();
                    if (isFirstFrame) {
                        this.setAudioFormat(new AudioFormat(this.decoder.getOutputFrequency(), 16, this.decoder.getOutputChannels(), true, false));
                        this.openAudioDevice();
                        if (!this.isInitialized()) {
                            return;
                        }
                    }
                    short[] samples = output.getBuffer();
                    int origLen = output.getBufferLength();
                    this.played_ms += origLen / this.decoder.getOutputChannels() * 1000 / this.decoder.getOutputFrequency();
                    int len = origLen << 1;
                    byte[] b = this.getOutputBuffer(len);
                    int idx = 0;
                    int pos = 0;
                    boolean allZero = true;
                    while (origLen-- > 0) {
                        short s = samples[pos++];
                        if (allZero && s != 0) {
                            allZero = false;
                        }
                        b[idx++] = (byte)(s & 0xFF);
                        b[idx++] = (byte)(s >> 8 & 0xFF);
                    }
                    if (!isFirstFrame || !allZero) {
                        this.writeSampleDataToLine(b, 0, len);
                    }
                }
                isFirstFrame = false;
                if (this.isStopping()) {
                    this.setIsStopped();
                    break;
                }
                if (this.isPausing()) {
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (!this.isInSeeking()) continue;
                this.setIsSeeking();
                while (this.isInSeeking()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (h != null);
            if (h == null) {
                this.setHasFinished();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            if (this.bitStream != null) {
                try {
                    this.bitStream.close();
                    this.bitStream = null;
                }
                catch (BitstreamException e) {
                    Log.error("IGNORED", e);
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
        }
    }
}

