/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ID3v2Footer {
    private static final String ENC_TYPE = "ISO-8859-1";
    private static final String TAG_START = "3DI";
    private static final int FOOT_SIZE = 10;
    private static final int NEW_MAJOR_VERSION = 3;
    private static final int NEW_MINOR_VERSION = 0;
    private boolean footerExists = false;
    private int majorVersion = 3;
    private int minorVersion = 0;
    private boolean unsynchronisation = false;
    private boolean extended = false;
    private boolean experimental = false;
    private boolean footer = false;
    private int tagSize = 0;

    public ID3v2Footer(RandomAccessInputStream raf, int location) throws IOException {
        this.footerExists = this.checkFooter(raf, location);
        if (this.footerExists) {
            this.readFooter(raf, location);
        }
    }

    private boolean checkFooter(RandomAccessInputStream raf, int location) throws IOException {
        raf.seek(location);
        byte[] buf = new byte[10];
        if (raf.read(buf) != 10) {
            throw new IOException("Error encountered finding id3v2 footer");
        }
        String result = new String(buf, ENC_TYPE);
        return result.substring(0, TAG_START.length()).equals(TAG_START) && (buf[3] & 0xFF) != 255 && (buf[4] & 0xFF) != 255 && (buf[6] & 0x80) == 0 && (buf[7] & 0x80) == 0 && (buf[8] & 0x80) == 0 && (buf[9] & 0x80) == 0;
    }

    private void readFooter(RandomAccessInputStream raf, int location) throws IOException {
        raf.seek(location);
        byte[] foot = new byte[10];
        if (raf.read(foot) != 10) {
            throw new IOException("Error encountered reading id3v2 footer");
        }
        this.majorVersion = foot[3];
        if (this.majorVersion <= 3) {
            this.minorVersion = foot[4];
            this.unsynchronisation = (foot[5] & 0x80) != 0;
            this.extended = (foot[5] & 0x40) != 0;
            this.experimental = (foot[5] & 0x20) != 0;
            this.footer = (foot[5] & 0x10) != 0;
            this.tagSize = Helpers.convertDWordToInt(foot, 6);
        }
    }

    public byte[] getBytes() {
        byte[] b = new byte[10];
        int bytesCopied = 0;
        System.arraycopy(Helpers.getBytesFromString(TAG_START, TAG_START.length(), ENC_TYPE), 0, b, 0, TAG_START.length());
        bytesCopied += TAG_START.length();
        b[bytesCopied++] = (byte)this.majorVersion;
        b[bytesCopied++] = (byte)this.minorVersion;
        b[bytesCopied++] = this.getFlagByte();
        System.arraycopy(Helpers.convertIntToDWord(this.tagSize), 0, b, bytesCopied, 4);
        bytesCopied += 4;
        return b;
    }

    private byte getFlagByte() {
        byte ret = 0;
        if (this.unsynchronisation) {
            ret = (byte)(ret | 0x80);
        }
        if (this.extended) {
            ret = (byte)(ret | 0x40);
        }
        if (this.experimental) {
            ret = (byte)(ret | 0x20);
        }
        if (this.footer) {
            ret = (byte)(ret | 0x10);
        }
        return ret;
    }

    public boolean footerExists() {
        return this.footerExists;
    }

    public int getFooterSize() {
        if (this.footerExists) {
            return 10;
        }
        return 0;
    }

    public int getTagSize() {
        return this.tagSize;
    }

    public void setTagSize(int size) {
        if (size > 0) {
            this.tagSize = size;
            this.footerExists = true;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean getUnsynchronisation() {
        return this.unsynchronisation;
    }

    public void setUnsynchronisation(boolean unsynch) {
        this.unsynchronisation = unsynch;
    }

    public boolean getExtendedFooter() {
        return this.extended;
    }

    public void setExtendedFooter(boolean extend) {
        this.extended = extend;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(boolean experiment) {
        this.experimental = experiment;
    }

    public boolean getFooter() {
        return this.footer;
    }

    public void setFooter(boolean foot) {
        this.footer = foot;
    }

    public String toString() {
        return "ID3v2." + this.getMajorVersion() + "." + this.getMinorVersion() + "\n" + "TagSize:\t\t\t" + this.getTagSize() + " bytes\nUnsynchronisation:\t\t" + this.getUnsynchronisation() + "\nExtended Footer:\t\t" + this.getExtendedFooter() + "\nExperimental:\t\t\t" + this.getExperimental() + "\nFooter:\t\t\t\t" + this.getFooter();
    }
}

