/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.ID3v2Frame;
import java.util.HashMap;
import java.util.Iterator;

public class ID3v2Frames<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = -1434484594524119778L;
    public static final String ALBUM = "TALB";
    public static final String BPM = "TBPM";
    public static final String COMPOSER = "TCOM";
    public static final String CONTENT_TYPE = "TCON";
    public static final String COPYRIGHT_MESSAGE = "TCOP";
    public static final String ENCODING_TIME = "TDEN";
    public static final String PLAYLIST_DELAY = "TDLY";
    public static final String ORIGINAL_RELEASE_TIME = "TDOR";
    public static final String RECORDING_TIME = "TDRC";
    public static final String RELEASE_TIME = "TDRL";
    public static final String TAGGING_TIME = "TDTG";
    public static final String ENCODED_BY = "TENC";
    public static final String LYRICIST = "TEXT";
    public static final String FILE_TYPE = "TFLT";
    public static final String INVOLVED_PEOPLE = "TIPL";
    public static final String CONTENT_GROUP = "TIT1";
    public static final String TITLE = "TIT2";
    public static final String SUBTITLE = "TIT3";
    public static final String INITIAL_KEY = "TKEY";
    public static final String LANGUAGE = "TLAN";
    public static final String LENGTH = "TLEN";
    public static final String MUSICIAN_CREDITS = "TMCL";
    public static final String MEDIA_TYPE = "TMED";
    public static final String MOOD = "TMOO";
    public static final String ORIGINAL_ALBUM = "TOAL";
    public static final String ORIGINAL_FILENAME = "TOFN";
    public static final String ORIGINAL_LYRICIST = "TOLY";
    public static final String ORIGINAL_ARTIST = "TOPE";
    public static final String FILE_OWNER = "TOWN";
    public static final String LEAD_PERFORMERS = "TPE1";
    public static final String ACCOMPANIMENT = "TPE2";
    public static final String CONDUCTOR = "TPE3";
    public static final String REMIXED_BY = "TPE4";
    public static final String PART_OF_SET = "TPOS";
    public static final String PRODUCED_NOTICE = "TPRO";
    public static final String PUBLISHER = "TPUB";
    public static final String TRACK_NUMBER = "TRCK";
    public static final String INTERNET_RADIO_STATION_NAME = "TRSN";
    public static final String INTERNET_RADIO_STATION_OWNER = "TRSO";
    public static final String ALBUM_SORT_ORDER = "TSOA";
    public static final String PERFORMER_SORT_ORDER = "TSOP";
    public static final String TITLE_SORT_ORDER = "TSOT";
    public static final String ISRC = "TSRC";
    public static final String SOFTWARE_HARDWARE_SETTINGS = "TSSE";
    public static final String SET_SUBTITLE = "TSST";
    public static final String USER_DEFINED_TEXT_INFO = "TXXX";
    public static final String YEAR = "TYER";
    public static final String COMMERCIAL_INFO_URL = "WCOM";
    public static final String COPYRIGHT_INFO_URL = "WCOP";
    public static final String OFFICIAL_FILE_WEBPAGE_URL = "WOAF";
    public static final String OFFICIAL_ARTIST_WEBPAGE_URL = "WOAR";
    public static final String OFFICIAL_SOURCE_WEBPAGE_URL = "WOAS";
    public static final String OFFICIAL_INTERNET_RADIO_WEBPAGE_URL = "WOAS";
    public static final String PAYMENT_URL = "WPAY";
    public static final String OFFICIAL_PUBLISHER_WEBPAGE_URL = "WPUB";
    public static final String USER_DEFINED_URL = "WXXX";
    public static final String AUDIO_ENCRYPTION = "AENC";
    public static final String ATTACHED_PICTURE = "APIC";
    public static final String AUDIO_SEEK_POINT_INDEX = "ASPI";
    public static final String COMMENTS = "COMM";
    public static final String COMMERCIAL_FRAME = "COMR";
    public static final String ENCRYPTION_METHOD_REGISTRATION = "ENCR";
    public static final String EQUALISATION = "EQU2";
    public static final String EVENT_TIMING_CODES = "ETCO";
    public static final String GENERAL_ENCAPSULATED_OBJECT = "GEOB";
    public static final String GROUP_IDENTIFICATION_REGISTRATION = "GRID";
    public static final String LINKED_INFORMATION = "LINK";
    public static final String MUSIC_CD_IDENTIFIER = "MCDI";
    public static final String MPEG_LOCATION_LOOKUP_TABLE = "MLLT";
    public static final String OWNERSHIP_FRAME = "OWNE";
    public static final String PRIVATE_FRAME = "PRIV";
    public static final String PLAY_COUNTER = "PCNT";
    public static final String POPULARIMETER = "POPM";
    public static final String POSITION_SYNCHRONISATION_FRAME = "POSS";
    public static final String RECOMMENDED_BUFFER_SIZE = "RBUF";
    public static final String RELATIVE_VOLUME_ADJUSTMENT = "RVA2";
    public static final String REVERB = "RVRB";
    public static final String SEEK_FRAME = "SEEK";
    public static final String SIGNATURE_FRAME = "SIGN";
    public static final String SYNCHRONISED_LYRIC = "SYLT";
    public static final String SYNCHRONISED_TEMPO_CODES = "SYTC";
    public static final String UNIQUE_FILE_IDENTIFIER = "UFID";
    public static final String TERMS_OF_USE = "USER";
    public static final String UNSYNCHRONISED_LYRIC_TRANSCRIPTION = "USLT";

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            str.append(it.next().toString()).append('\n');
        }
        return str.toString();
    }

    public int getLength() {
        int length = 0;
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            length += ((ID3v2Frame)it.next()).getFrameLength();
        }
        return length;
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.getLength()];
        int bytesCopied = 0;
        for (ID3v2Frame frame : this.values()) {
            System.arraycopy(frame.getFrameBytes(), 0, b, bytesCopied, frame.getFrameLength());
            bytesCopied += frame.getFrameLength();
        }
        return b;
    }
}

