/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.streaming;

import de.quippy.javamod.multimedia.mp3.streaming.IcyTag;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseEvent;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class IcyInputStream
extends BufferedInputStream {
    private ArrayList<TagParseListener> tagParseListeners = new ArrayList();
    protected static final String INLINE_TAG_SEPARATORS = ";\u0000";
    private HashMap<String, IcyTag> tags;
    protected byte[] crlfBuffer = new byte[1024];
    protected CharsetDecoder charsetDecoder;
    protected int metaint = -1;
    protected int bytesUntilNextMetadata = -1;

    public IcyInputStream(InputStream in, String metaIntString, TagParseListener listener) throws IOException {
        super(in);
        this.tags = new HashMap();
        this.charsetDecoder = Charset.forName("ISO-8859-1").newDecoder();
        this.charsetDecoder.replaceWith("?");
        this.charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        if (listener != null) {
            this.addTagParseListener(listener);
        }
        if (metaIntString == null) {
            this.readInitialHeaders();
            IcyTag metaIntTag = this.getTag("icy-metaint");
            if (metaIntTag != null) {
                metaIntString = metaIntTag.getValue();
            }
        }
        try {
            if (metaIntString != null) {
                this.bytesUntilNextMetadata = this.metaint = Integer.parseInt(metaIntString.trim());
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    public IcyInputStream(InputStream in) throws IOException {
        this(in, null, null);
    }

    public IcyInputStream(InputStream in, TagParseListener listener) throws IOException {
        this(in, null, listener);
    }

    protected void readInitialHeaders() throws IOException {
        String line;
        while ((line = this.readCRLFLine()).length() != 0) {
            int colonIndex = line.indexOf(58);
            if (colonIndex == -1) continue;
            String tagName = line.substring(0, colonIndex);
            String value = line.substring(colonIndex + 1);
            if (value.toLowerCase().endsWith("<br>")) {
                value = value.substring(0, value.length() - 4);
            }
            IcyTag tag = new IcyTag(tagName, value);
            this.addTag(tag);
        }
    }

    protected String readCRLFLine() throws IOException {
        byte aByte;
        int i = 0;
        while (i < 1024 && (aByte = (byte)this.read()) != 10) {
            if (aByte == 13) continue;
            this.crlfBuffer[i++] = aByte;
        }
        return this.charsetDecoder.decode(ByteBuffer.wrap(this.crlfBuffer, 0, i)).toString();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.bytesUntilNextMetadata > 0) {
            --this.bytesUntilNextMetadata;
            return super.read();
        }
        if (this.bytesUntilNextMetadata == 0) {
            this.readMetadata();
            this.bytesUntilNextMetadata = this.metaint - 1;
            return super.read();
        }
        return super.read();
    }

    @Override
    public synchronized int read(byte[] buf, int offset, int length) throws IOException {
        if (this.bytesUntilNextMetadata > 0) {
            int adjLength = Math.min(length, this.bytesUntilNextMetadata);
            int got = super.read(buf, offset, adjLength);
            this.bytesUntilNextMetadata -= got;
            return got;
        }
        if (this.bytesUntilNextMetadata == 0) {
            this.readMetadata();
            this.bytesUntilNextMetadata = this.metaint;
            int adjLength = Math.min(length, this.bytesUntilNextMetadata);
            int got = super.read(buf, offset, adjLength);
            this.bytesUntilNextMetadata -= got;
            return got;
        }
        return super.read(buf, offset, length);
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    protected void readMetadata() throws IOException {
        int blockCount = super.read();
        int byteCount = blockCount * 16;
        if (byteCount <= 0) {
            return;
        }
        byte[] metadataBlock = new byte[byteCount];
        int index = 0;
        while (byteCount > 0) {
            int bytesRead = super.read(metadataBlock, index, byteCount);
            index += bytesRead;
            byteCount -= bytesRead;
        }
        this.parseInlineIcyTags(metadataBlock);
    }

    protected void parseInlineIcyTags(byte[] tagBlock) {
        String blockString = null;
        try {
            blockString = new String(tagBlock, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            blockString = new String(tagBlock);
        }
        StringTokenizer izer = new StringTokenizer(blockString, INLINE_TAG_SEPARATORS);
        while (izer.hasMoreTokens()) {
            String tagString = izer.nextToken();
            int separatorIdx = tagString.indexOf(61);
            if (separatorIdx == -1) continue;
            int valueStartIdx = tagString.charAt(separatorIdx + 1) == '\'' ? separatorIdx + 2 : separatorIdx + 1;
            int valueEndIdx = tagString.charAt(tagString.length() - 1) == '\'' ? tagString.length() - 1 : tagString.length();
            String name = tagString.substring(0, separatorIdx);
            String value = tagString.substring(valueStartIdx, valueEndIdx);
            this.addTag(new IcyTag(name, value));
        }
    }

    protected void addTag(IcyTag tag) {
        this.tags.put(tag.getName(), tag);
        this.fireTagParsed(this, tag);
    }

    public IcyTag getTag(String tagName) {
        return this.tags.get(tagName);
    }

    public IcyTag[] getTags() {
        return this.tags.values().toArray(new IcyTag[this.tags.values().size()]);
    }

    public HashMap<String, IcyTag> getTagHash() {
        return this.tags;
    }

    public void addTagParseListener(TagParseListener tpl) {
        this.tagParseListeners.add(tpl);
    }

    public void removeTagParseListener(TagParseListener tpl) {
        this.tagParseListeners.remove(tpl);
    }

    public void fireTagParseEvent(TagParseEvent tpe) {
        for (int i = 0; i < this.tagParseListeners.size(); ++i) {
            TagParseListener l = this.tagParseListeners.get(i);
            l.tagParsed(tpe);
        }
    }

    public void fireTagParsed(Object source, IcyTag tag) {
        this.fireTagParseEvent(new TagParseEvent(source, tag));
    }
}

