/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.ogg.OGGInfoPanel;
import de.quippy.javamod.multimedia.ogg.OGGMixer;
import de.quippy.javamod.multimedia.ogg.metadata.OggMetaData;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class OGGContainer
extends MultimediaContainer {
    private static final String[] OGGFILEEXTENSION = new String[]{"ogg", "oga"};
    private JPanel oggInfoPanel;
    private OggMetaData oggMetaData = null;

    @Override
    public MultimediaContainer getInstance(URL url) {
        MultimediaContainer result = super.getInstance(url);
        this.oggMetaData = new OggMetaData(url);
        ((OGGInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.oggMetaData, this.getPrintableFileUrl());
        return result;
    }

    @Override
    public String getSongName() {
        if (this.oggMetaData != null) {
            return this.oggMetaData.getShortDescription();
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL url) {
        String songName = MultimediaContainerManager.getSongNameFromURL(url);
        Long duration = -1L;
        try {
            OggMetaData metaData = new OggMetaData(url);
            songName = metaData.getShortDescription();
            duration = metaData.getLengthInMilliseconds();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return new Object[]{songName, duration};
    }

    @Override
    public Mixer createNewMixer() {
        return new OGGMixer(this.getFileURL(), this.oggMetaData.getLengthInMilliseconds());
    }

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public String[] getFileExtensionList() {
        return OGGFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "ogg/vorbis-File";
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.oggInfoPanel == null) {
            this.oggInfoPanel = new OGGInfoPanel();
        }
        return this.oggInfoPanel;
    }

    @Override
    public void configurationChanged(Properties newProps) {
    }

    @Override
    public void configurationSave(Properties props) {
    }

    static {
        MultimediaContainerManager.registerContainer(new OGGContainer());
    }
}

