/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import de.quippy.ogg.jogg.Packet;
import de.quippy.ogg.jogg.Page;
import de.quippy.ogg.jogg.StreamState;
import de.quippy.ogg.jogg.SyncState;
import de.quippy.ogg.jorbis.Block;
import de.quippy.ogg.jorbis.Comment;
import de.quippy.ogg.jorbis.DspState;
import de.quippy.ogg.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;

public class OGGMixer
extends BasicMixer {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_READHEADER = 1;
    private static final int STATE_PREPARE = 2;
    private static final int STATE_READFIRSTFRAME = 3;
    private static final int STATE_PROCESSPACKET = 4;
    private static final int STATE_NEEDMOREDATA = 5;
    private static final int STATE_CONVERTPCM = 6;
    private static final int STATE_EOS = 7;
    private static final int CHUNKSIZE = 4096;
    private boolean oggEOS;
    private int decoderState;
    private SyncState oggSyncState;
    private StreamState oggStreamState;
    private Page oggPage;
    private Packet oggPacket;
    private Info vorbisInfo;
    private Comment vorbisComment;
    private DspState vorbisDSPState;
    private Block vorbisBlock;
    private final float[][][] pcmFloatBuffer = new float[1][][];
    private int[] pcmGeneratorIndex;
    private int bufferSize;
    private byte[] output;
    private int samplesProcessed;
    private long currentSamplesWritten;
    private int lengthInMilliseconds;
    private InputStream inputStream;
    private URL oggFileUrl;

    public OGGMixer(URL oggFileUrl, int lengthInMilliseconds) {
        this.oggFileUrl = oggFileUrl;
        this.lengthInMilliseconds = lengthInMilliseconds;
    }

    private void initialize() {
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            this.inputStream = new FileOrPackedInputStream(this.oggFileUrl);
            this.oggEOS = false;
            this.decoderState = 0;
            this.bufferSize = 0;
            this.output = null;
        }
        catch (Exception ex) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException e) {
                    Log.error("IGNORED", e);
                }
            }
            Log.error("[OGGMixer]", ex);
        }
    }

    @Override
    public int getChannelCount() {
        if (this.vorbisInfo != null) {
            return this.vorbisInfo.channels;
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        if (this.vorbisInfo != null) {
            int bitRate = this.vorbisInfo.bitrate();
            if (bitRate == -1) {
                return 16 * this.vorbisInfo.rate * this.vorbisInfo.channels / 1000;
            }
            return bitRate / 1000;
        }
        return 0;
    }

    @Override
    public int getCurrentSampleFrequency() {
        if (this.vorbisInfo != null) {
            return this.vorbisInfo.rate / 1000;
        }
        return 0;
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.vorbisInfo != null && this.vorbisInfo.rate != 0) {
            return this.currentSamplesWritten * 1000L / (long)this.vorbisInfo.rate;
        }
        return 0L;
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    protected void seek(long milliseconds) {
        try {
            if (milliseconds < this.getMillisecondPosition()) {
                this.cleanUp();
                this.initialize();
            }
            int byteCount = 1;
            while (this.getMillisecondPosition() < milliseconds && byteCount > 0) {
                byteCount = this.decodeFrame();
            }
        }
        catch (Exception ex) {
            Log.error("[OGGMixer]", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decodeFrame() throws Exception {
        block10: while (true) {
            switch (this.decoderState) {
                case 7: {
                    return -1;
                }
                case 0: {
                    this.decoderState = this.doStateInitial();
                    continue block10;
                }
                case 1: {
                    this.decoderState = this.doStateReadHeader();
                    continue block10;
                }
                case 2: {
                    this.decoderState = this.doStatePrepare();
                    continue block10;
                }
                case 3: {
                    this.decoderState = 5;
                    continue block10;
                }
                case 5: {
                    this.decoderState = this.doStateNeedMoreData();
                    continue block10;
                }
                case 4: {
                    this.decoderState = this.doStateProcessPacket();
                    continue block10;
                }
                case 6: {
                    this.decoderState = this.doStateConvertPCM();
                    if (this.decoderState == 6) return this.samplesProcessed * 2 * this.vorbisInfo.channels;
                    continue block10;
                }
            }
            break;
        }
        throw new IOException("invalid decoder state " + this.decoderState);
    }

    private void fetchMoreData() throws IOException {
        if (!this.oggEOS) {
            int oggIndex = this.oggSyncState.buffer(4096);
            int bytesRead = this.inputStream.read(this.oggSyncState.data, oggIndex, 4096);
            if (bytesRead <= 0) {
                this.oggEOS = true;
            } else {
                this.oggSyncState.wrote(bytesRead);
            }
        }
    }

    private int doStateConvertPCM() throws Exception {
        int nextState = 4;
        int samplesGenerated = this.vorbisDSPState.synthesis_pcmout(this.pcmFloatBuffer, this.pcmGeneratorIndex);
        if (samplesGenerated > 0) {
            this.samplesProcessed = samplesGenerated > this.bufferSize ? this.bufferSize : samplesGenerated;
            for (int i = 0; i < this.vorbisInfo.channels; ++i) {
                int sampleIndex = i << 1;
                for (int j = 0; j < this.samplesProcessed; ++j) {
                    int value = (int)(this.pcmFloatBuffer[0][i][this.pcmGeneratorIndex[i] + j] * 32767.0f);
                    if (value > Short.MAX_VALUE) {
                        value = Short.MAX_VALUE;
                    } else if (value < Short.MIN_VALUE) {
                        value = Short.MIN_VALUE;
                    }
                    if (value < 0) {
                        value |= 0x8000;
                    }
                    this.output[sampleIndex] = (byte)(value & 0xFF);
                    this.output[sampleIndex + 1] = (byte)(value >> 8 & 0xFF);
                    sampleIndex += this.vorbisInfo.channels << 1;
                }
            }
            this.currentSamplesWritten += (long)this.samplesProcessed;
            this.vorbisDSPState.synthesis_read(this.samplesProcessed);
            nextState = 6;
        }
        return nextState;
    }

    private int doStateNeedMoreData() throws Exception {
        if (this.oggEOS) {
            return 7;
        }
        while (!this.oggEOS) {
            int result;
            do {
                if ((result = this.oggSyncState.pageout(this.oggPage)) != 0) continue;
                this.fetchMoreData();
            } while (!this.oggEOS && result == 0);
            if (result == -1) continue;
            this.oggStreamState.pagein(this.oggPage);
            if (this.oggPage.granulepos() != 0L) break;
            this.oggEOS = true;
            return 7;
        }
        return 4;
    }

    private int doStateProcessPacket() throws Exception {
        int nextState = 4;
        int result = this.oggStreamState.packetout(this.oggPacket);
        if (result == 0) {
            if (!this.oggEOS) {
                this.oggEOS = this.oggPage.eos() != 0;
            }
            nextState = 5;
        } else if (result != -1) {
            if (this.vorbisBlock.synthesis(this.oggPacket) == 0) {
                this.vorbisDSPState.synthesis_blockin(this.vorbisBlock);
            }
            nextState = 6;
        }
        return nextState;
    }

    private int doStateInitial() throws Exception {
        this.oggSyncState = new SyncState();
        this.oggStreamState = new StreamState();
        this.oggPage = new Page();
        this.oggPacket = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.vorbisDSPState = new DspState();
        this.vorbisBlock = new Block(this.vorbisDSPState);
        this.oggSyncState.init();
        this.oggEOS = false;
        return 1;
    }

    private int doStateReadHeader() throws Exception {
        this.fetchMoreData();
        if (this.oggSyncState.pageout(this.oggPage) != 1) {
            throw new IOException("Input does not appear to be an Ogg bitstream");
        }
        this.oggStreamState.init(this.oggPage.serialno());
        this.oggStreamState.reset();
        if (this.oggStreamState.pagein(this.oggPage) < 0) {
            throw new IOException("Error reading first page of Ogg bitstream data");
        }
        if (this.oggStreamState.packetout(this.oggPacket) != 1) {
            throw new IOException("Error reading initial header packet");
        }
        this.vorbisInfo.init();
        this.vorbisComment.init();
        if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket) < 0) {
            throw new IOException("This Ogg bitstream does not contain Vorbis audio data");
        }
        int i = 0;
        while (i < 2) {
            int result;
            while (i < 2 && (result = this.oggSyncState.pageout(this.oggPage)) != 0) {
                if (result == 1) {
                    this.oggStreamState.pagein(this.oggPage);
                    while (i < 2 && (result = this.oggStreamState.packetout(this.oggPacket)) != 0) {
                        if (result == -1) {
                            throw new IOException("Corrupt secondary header");
                        }
                        this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket);
                        ++i;
                    }
                    continue;
                }
                throw new IOException("Unhandled pageout() return code " + result);
            }
            this.fetchMoreData();
            if (!this.oggEOS) continue;
            throw new IOException("End of file before finding all Vorbis headers");
        }
        return 2;
    }

    private final int doStatePrepare() throws Exception {
        this.vorbisDSPState.synthesis_init(this.vorbisInfo);
        this.vorbisBlock.init(this.vorbisDSPState);
        this.pcmGeneratorIndex = new int[this.vorbisInfo.channels];
        this.currentSamplesWritten = 0L;
        this.bufferSize = 250 * this.vorbisInfo.channels * this.vorbisInfo.rate / 1000;
        this.bufferSize <<= 1;
        this.output = new byte[this.bufferSize];
        AudioFormat audioFormat = new AudioFormat(this.vorbisInfo.rate, 16, this.vorbisInfo.channels, true, false);
        this.setAudioFormat(audioFormat);
        this.openAudioDevice();
        return 3;
    }

    private void cleanUp() {
        if (this.oggStreamState != null) {
            this.oggStreamState.clear();
            this.oggStreamState = null;
        }
        if (this.vorbisBlock != null) {
            this.vorbisBlock.clear();
            this.vorbisBlock = null;
        }
        if (this.vorbisDSPState != null) {
            this.vorbisDSPState.clear();
            this.vorbisDSPState = null;
        }
        if (this.vorbisInfo != null) {
            this.vorbisInfo.clear();
            this.vorbisInfo = null;
        }
        if (this.oggSyncState != null) {
            this.oggSyncState.clear();
            this.oggSyncState = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (IOException e) {
                Log.error("IGNORED", e);
            }
        }
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            int byteCount = 0;
            do {
                if ((byteCount = this.decodeFrame()) <= 0 || !this.isInitialized()) continue;
                this.writeSampleDataToLine(this.output, 0, byteCount);
                if (this.isStopping()) {
                    this.setIsStopped();
                    break;
                }
                if (this.isPausing()) {
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (!this.isInSeeking()) continue;
                this.setIsSeeking();
                while (this.isInSeeking()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (byteCount != -1);
            if (byteCount <= 0) {
                this.setHasFinished();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            this.cleanUp();
        }
    }
}

