/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.sid;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.sid.SIDMixer;
import de.quippy.javamod.multimedia.sid.SidConfigPanel;
import de.quippy.javamod.system.Log;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class SIDContainer
extends MultimediaContainer {
    private static final String[] SIDFILEEXTENSION = new String[]{"sid", "dat", "inf"};
    public static final String PROPERTY_SID_FREQUENCY = "javamod.player.sid.frequency";
    public static final String PROPERTY_SID_MODEL = "javamod.player.sid.sidmodel";
    public static final String PROPERTY_SID_OPTIMIZATION = "javamod.player.sid.optimization";
    public static final String PROPERTY_SID_USEFILTER = "javamod.player.sid.usesidfilter";
    public static final String PROPERTY_SID_VIRTUALSTEREO = "javamod.player.sid.virtualstrereo";
    public static final String DEFAULT_SAMPLERATE = "44100";
    public static final String DEFAULT_SIDMODEL = "0";
    public static final String DEFAULT_OPTIMIZATION = "1";
    public static final String DEFAULT_USEFILTER = "true";
    public static final String DEFAULT_VIRTUALSTEREO = "false";
    public static final String[] SAMPLERATE = new String[]{"8000", "11025", "16000", "22050", "33075", "44100", "48000", "96000"};
    public static final String[] SIDMODELS = new String[]{"best", "SID 6581 (old model)", "SID 8580 (new model)"};
    private SidTune sidTune;
    private SIDMixer currentMixer;
    private SidConfigPanel sidConfigPanel;
    private JPanel sidInfoPanel;

    @Override
    public MultimediaContainer getInstance(URL sidFileUrl) {
        MultimediaContainer result = super.getInstance(sidFileUrl);
        this.sidTune = this.loadSidTune(sidFileUrl);
        return result;
    }

    @Override
    public String getSongName() {
        if (this.sidTune != null) {
            return this.getShortDescriptionFrom(this.sidTune);
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL url) {
        String songName = MultimediaContainerManager.getSongNameFromURL(url);
        Long duration = -1L;
        try {
            SidTune sidTune = this.loadSidTune(url);
            if (sidTune != null) {
                songName = this.getShortDescriptionFrom(sidTune);
                duration = sidTune.getInfo().songs * 1000;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return new Object[]{songName, duration};
    }

    public void nameChanged() {
        this.fireMultimediaContainerEvent(new MultimediaContainerEvent(this, MultimediaContainerEvent.SONG_NAME_CHANGED_OLD_INVALID, this.getSongName()));
    }

    @Override
    public boolean canExport() {
        return true;
    }

    private SidTune loadSidTune(URL sidFileURL) {
        FileOrPackedInputStream in = null;
        try {
            int b;
            in = new FileOrPackedInputStream(sidFileURL);
            int size = ((InputStream)in).available();
            if (size < 1024) {
                size = 1024;
            }
            short[] sidTuneData = new short[size];
            int index = 0;
            while ((b = ((InputStream)in).read()) != -1) {
                sidTuneData[index++] = (short)(b & 0xFF);
                if (index < sidTuneData.length) continue;
                short[] newBuffer = new short[sidTuneData.length + size];
                System.arraycopy(sidTuneData, 0, newBuffer, 0, sidTuneData.length);
                sidTuneData = newBuffer;
            }
            SidTune sidTune = new SidTune(sidTuneData, index);
            return sidTune;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
    }

    private String getShortDescriptionFrom(SidTune sidTune) {
        SidTuneInfo info = sidTune.getInfo();
        String[] infoString = info.infoString;
        return infoString[0] + " [" + infoString[1] + "] " + Integer.toString(info.currentSong) + '/' + Integer.toString(info.songs) + " (" + infoString[2] + ')';
    }

    @Override
    public Mixer createNewMixer() {
        Properties props = new Properties();
        this.configurationSave(props);
        int frequency = Integer.parseInt(props.getProperty(PROPERTY_SID_FREQUENCY, DEFAULT_SAMPLERATE));
        int sidModel = Integer.parseInt(props.getProperty(PROPERTY_SID_MODEL, DEFAULT_SIDMODEL));
        int optimization = Integer.parseInt(props.getProperty(PROPERTY_SID_OPTIMIZATION, DEFAULT_OPTIMIZATION));
        boolean useSIDFilter = Boolean.parseBoolean(props.getProperty(PROPERTY_SID_USEFILTER, DEFAULT_USEFILTER));
        boolean isStereo = Boolean.parseBoolean(props.getProperty(PROPERTY_SID_VIRTUALSTEREO, DEFAULT_VIRTUALSTEREO));
        this.currentMixer = new SIDMixer(this.sidTune, this, frequency, sidModel, optimization, useSIDFilter, isStereo);
        return this.currentMixer;
    }

    public SIDMixer getCurrentMixer() {
        return this.currentMixer;
    }

    @Override
    public void configurationChanged(Properties newProps) {
        SidConfigPanel configPanel = (SidConfigPanel)this.getConfigPanel();
        configPanel.getPlayerSetUp_SampleRate().setSelectedItem(newProps.getProperty(PROPERTY_SID_FREQUENCY, DEFAULT_SAMPLERATE));
        configPanel.getPlayerSetUp_SIDModel().setSelectedIndex(Integer.parseInt(newProps.getProperty(PROPERTY_SID_MODEL, DEFAULT_SIDMODEL)));
        configPanel.getPlayerSetUp_UseSIDFilter().setSelected(Boolean.parseBoolean(newProps.getProperty(PROPERTY_SID_USEFILTER, DEFAULT_USEFILTER)));
        configPanel.getPlayerSetUp_VirtualStereo().setSelected(Boolean.parseBoolean(newProps.getProperty(PROPERTY_SID_VIRTUALSTEREO, DEFAULT_VIRTUALSTEREO)));
        int optimization = Integer.parseInt(newProps.getProperty(PROPERTY_SID_OPTIMIZATION, DEFAULT_OPTIMIZATION));
        if (optimization <= 1) {
            configPanel.getPlayerSetUp_Optimization_Level1().setSelected(true);
        } else {
            configPanel.getPlayerSetUp_Optimization_Level2().setSelected(true);
        }
    }

    @Override
    public void configurationSave(Properties props) {
        SidConfigPanel configPanel = (SidConfigPanel)this.getConfigPanel();
        props.setProperty(PROPERTY_SID_FREQUENCY, configPanel.getPlayerSetUp_SampleRate().getSelectedItem().toString());
        props.setProperty(PROPERTY_SID_MODEL, Integer.toString(configPanel.getPlayerSetUp_SIDModel().getSelectedIndex()));
        props.setProperty(PROPERTY_SID_USEFILTER, Boolean.toString(configPanel.getPlayerSetUp_UseSIDFilter().isSelected()));
        props.setProperty(PROPERTY_SID_VIRTUALSTEREO, Boolean.toString(configPanel.getPlayerSetUp_VirtualStereo().isSelected()));
        props.setProperty(PROPERTY_SID_OPTIMIZATION, configPanel.getPlayerSetUp_Optimization_Level1().isSelected() ? DEFAULT_OPTIMIZATION : "2");
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.sidInfoPanel == null) {
            this.sidInfoPanel = new JPanel();
        }
        return this.sidInfoPanel;
    }

    @Override
    public JPanel getConfigPanel() {
        if (this.sidConfigPanel == null) {
            this.sidConfigPanel = new SidConfigPanel();
            this.sidConfigPanel.setParentContainer(this);
        }
        return this.sidConfigPanel;
    }

    @Override
    public String[] getFileExtensionList() {
        return SIDFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "SID-File";
    }

    static {
        MultimediaContainerManager.registerContainer(new SIDContainer());
    }
}

