/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.sid;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.sid.SIDContainer;
import de.quippy.javamod.system.Log;
import de.quippy.sidplay.libsidplay.SIDPlay2;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.resid_builder.ReSIDBuilder;
import javax.sound.sampled.AudioFormat;

public class SIDMixer
extends BasicMixer {
    private SIDPlay2 sidPlayer;
    private SidTune sidTune;
    private byte[] output;
    private int sampleRate;
    private int sidModel;
    private int optimization;
    private boolean sidFilter;
    private boolean isStereo;
    private static final int MULTIPLIER_SHIFT = 4;
    private static final int MULTIPLIER_VALUE = 16;
    private int multiplier;
    private int songNumber;
    private SIDContainer parentSIDContainer;

    public SIDMixer(SidTune sidTune, SIDContainer parent, int sampleRate, int sidModel, int optimization, boolean sidFilter, boolean isStereo) {
        this.sidTune = sidTune;
        if (sidTune != null) {
            this.songNumber = sidTune.getInfo().currentSong;
            if (this.songNumber == 0) {
                this.songNumber = 1;
            }
        } else {
            this.songNumber = 1;
        }
        this.parentSIDContainer = parent;
        this.optimization = optimization;
        this.sampleRate = sampleRate;
        this.sidModel = sidModel;
        this.sidFilter = sidFilter;
        this.isStereo = isStereo;
    }

    private void initialize() {
        try {
            this.sidPlayer = new SIDPlay2();
            ISID2Types.sid2_config_t sidConfig = this.sidPlayer.config();
            sidConfig.frequency = this.sampleRate;
            sidConfig.emulateStereo = this.isStereo;
            sidConfig.playback = this.isStereo ? ISID2Types.sid2_playback_t.sid2_stereo : ISID2Types.sid2_playback_t.sid2_mono;
            sidConfig.optimisation = (byte)this.optimization;
            sidConfig.sidModel = this.sidModel == 0 ? ISID2Types.sid2_model_t.SID2_MODEL_CORRECT : (this.sidModel == 1 ? ISID2Types.sid2_model_t.SID2_MOS6581 : ISID2Types.sid2_model_t.SID2_MOS8580);
            sidConfig.clockDefault = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
            sidConfig.clockSpeed = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
            sidConfig.clockForced = false;
            sidConfig.environment = ISID2Types.sid2_env_t.sid2_envR;
            sidConfig.forceDualSids = false;
            sidConfig.leftVolume = 255L;
            sidConfig.rightVolume = 255L;
            sidConfig.sampleFormat = ISID2Types.sid2_sample_t.SID2_LITTLE_SIGNED;
            sidConfig.sidDefault = ISID2Types.sid2_model_t.SID2_MOS6581;
            sidConfig.sidSamples = true;
            sidConfig.precision = 16;
            this.sidPlayer.config(sidConfig);
            ReSIDBuilder rs = new ReSIDBuilder("ReSID");
            if (rs.bool()) {
                sidConfig.sidEmulation = rs;
                rs.create(this.sidPlayer.info().maxsids);
                rs.filter(this.sidFilter);
                rs.sampling(this.sampleRate);
            }
            this.sidTune.selectSong(this.songNumber);
            this.sidPlayer.load(this.sidTune);
            this.multiplier = 16;
        }
        catch (Exception ex) {
            Log.error("[SIDMixer]", ex);
        }
    }

    public void setSampleRate(int newSampleRate) {
        boolean wasPlaying;
        int oldSampleRate = this.sampleRate;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.sampleRate = newSampleRate;
        if (wasPlaying) {
            this.setAudioFormat(new AudioFormat(this.sampleRate, 16, 2, true, false));
            this.openAudioDevice();
            if (!this.isInitialized()) {
                this.sampleRate = oldSampleRate;
                this.setAudioFormat(new AudioFormat(this.sampleRate, 16, 2, true, false));
                this.openAudioDevice();
            } else {
                ISID2Types.sid2_config_t sidConfig = this.sidPlayer.config();
                sidConfig.frequency = this.sampleRate;
                SIDBuilder rs = sidConfig.sidEmulation;
                if (rs != null && rs.bool() && rs instanceof ReSIDBuilder) {
                    ((ReSIDBuilder)rs).sampling(this.sampleRate);
                }
                this.sidPlayer.config(sidConfig);
            }
            this.pausePlayback();
        }
    }

    public void setSIDModel(int newSidModel) {
        boolean wasPlaying;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.sidModel = newSidModel;
        ISID2Types.sid2_config_t sidConfig = this.sidPlayer.config();
        sidConfig.sidModel = this.sidModel == 0 ? ISID2Types.sid2_model_t.SID2_MODEL_CORRECT : (this.sidModel == 1 ? ISID2Types.sid2_model_t.SID2_MOS6581 : ISID2Types.sid2_model_t.SID2_MOS8580);
        this.sidPlayer.config(sidConfig);
        ReSIDBuilder rs = new ReSIDBuilder("ReSID");
        if (rs.bool()) {
            sidConfig.sidEmulation = rs;
            rs.create(this.sidPlayer.info().maxsids);
            rs.filter(this.sidFilter);
            rs.sampling(this.sampleRate);
        }
        this.sidPlayer.config(sidConfig);
        if (wasPlaying) {
            this.pausePlayback();
        }
    }

    public void setOptimization(int newOptimization) {
        boolean wasPlaying;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.optimization = newOptimization;
        ISID2Types.sid2_config_t sidConfig = this.sidPlayer.config();
        sidConfig.optimisation = (byte)this.optimization;
        this.sidPlayer.config(sidConfig);
        ReSIDBuilder rs = new ReSIDBuilder("ReSID");
        if (rs.bool()) {
            sidConfig.sidEmulation = rs;
            rs.create(this.sidPlayer.info().maxsids);
            rs.filter(this.sidFilter);
            rs.sampling(this.sampleRate);
        }
        this.sidPlayer.config(sidConfig);
        if (wasPlaying) {
            this.pausePlayback();
        }
    }

    public void setUseSIDFilter(boolean useSIDFilter) {
        boolean wasPlaying;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.sidFilter = useSIDFilter;
        ISID2Types.sid2_config_t sidConfig = this.sidPlayer.config();
        SIDBuilder rs = sidConfig.sidEmulation;
        if (rs != null && rs.bool() && rs instanceof ReSIDBuilder) {
            ((ReSIDBuilder)rs).filter(this.sidFilter);
        }
        this.sidPlayer.config(sidConfig);
        if (wasPlaying) {
            this.pausePlayback();
        }
    }

    public void setVirtualStereo(boolean newIsStereo) {
        boolean wasPlaying;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.isStereo = newIsStereo;
        ISID2Types.sid2_config_t sidConfig = this.sidPlayer.config();
        sidConfig.emulateStereo = this.isStereo;
        sidConfig.playback = this.isStereo ? ISID2Types.sid2_playback_t.sid2_stereo : ISID2Types.sid2_playback_t.sid2_mono;
        this.sidPlayer.config(sidConfig);
        ReSIDBuilder rs = new ReSIDBuilder("ReSID");
        if (rs.bool()) {
            sidConfig.sidEmulation = rs;
            rs.create(this.sidPlayer.info().maxsids);
            rs.filter(this.sidFilter);
            rs.sampling(this.sampleRate);
        }
        this.sidPlayer.config(sidConfig);
        if (wasPlaying) {
            this.pausePlayback();
        }
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.sidTune != null ? (long)(this.sidTune.getInfo().songs * 1000) : 0L;
    }

    @Override
    public long getMillisecondPosition() {
        return (long)this.songNumber * 1000L;
    }

    @Override
    public int getChannelCount() {
        if (this.sidPlayer != null) {
            return this.sidPlayer.info().channels;
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        return 16 * this.sampleRate / 1000;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    @Override
    protected void seek(long milliseconds) {
        if (this.sidTune != null) {
            this.pausePlayback();
            this.songNumber = (int)(milliseconds / 1000L) + 1;
            this.sidTune.selectSong(this.songNumber);
            this.sidPlayer.load(this.sidTune);
            this.parentSIDContainer.nameChanged();
            this.pausePlayback();
        }
    }

    @Override
    public void setMillisecondPosition(long milliseconds) {
        this.seek(milliseconds);
    }

    private byte[] getOutputBuffer(int length) {
        if (this.output == null || this.output.length < length) {
            this.output = new byte[length];
        }
        return this.output;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.parentSIDContainer.nameChanged();
        this.setIsPlaying();
        try {
            this.setAudioFormat(new AudioFormat(this.sampleRate, 16, 2, true, false));
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            boolean finished = false;
            int bufferSize = this.sampleRate >> 1;
            if (bufferSize % 2 != 0) {
                ++bufferSize;
            }
            short[] shortBuffer = new short[bufferSize];
            do {
                this.sidPlayer.play(shortBuffer, bufferSize);
                int byteBufferSize = this.isStereo ? bufferSize : bufferSize << 1;
                byte[] b = this.getOutputBuffer(byteBufferSize);
                int idx = byteBufferSize;
                int pos = bufferSize;
                while (pos > 0) {
                    byte rh;
                    byte rl;
                    byte lh;
                    byte ll;
                    if (this.isStereo) {
                        int sl = shortBuffer[--pos] << 8 | shortBuffer[--pos];
                        int sr = shortBuffer[--pos] << 8 | shortBuffer[--pos];
                        sl = sl * this.multiplier >> 4;
                        sr = sr * this.multiplier >> 4;
                        ll = (byte)(sl & 0xFF);
                        lh = (byte)(sl >> 8);
                        rl = (byte)(sr & 0xFF);
                        rh = (byte)(sr >> 8);
                    } else {
                        int s = shortBuffer[--pos] << 8 | shortBuffer[--pos];
                        s = s * this.multiplier >> 4;
                        ll = rl = (byte)(s & 0xFF);
                        lh = rh = (byte)(s >> 8);
                    }
                    b[--idx] = lh;
                    b[--idx] = ll;
                    b[--idx] = rh;
                    b[--idx] = rl;
                }
                this.writeSampleDataToLine(b, 0, byteBufferSize);
                if (this.isStopping()) {
                    this.setIsStopped();
                    break;
                }
                if (!this.isPausing()) continue;
                this.setIsPaused();
                while (this.isPaused()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ex) {}
                }
            } while (!finished);
            if (finished) {
                this.setHasFinished();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.sidPlayer.stop();
            this.setIsStopped();
            this.closeAudioDevice();
        }
    }
}

