/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.sid;

import de.quippy.javamod.multimedia.sid.SIDContainer;
import de.quippy.javamod.multimedia.sid.SIDMixer;
import de.quippy.javamod.system.Helpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SidConfigPanel
extends JPanel {
    private static final long serialVersionUID = -3720765201747394016L;
    private SIDContainer parentContainer;
    private JLabel playerSetUp_L_SampleRate = null;
    private JComboBox playerSetUp_SampleRate = null;
    private JLabel playerSetUp_L_SIDModel = null;
    private JComboBox playerSetUp_SIDModel = null;
    private JLabel playerSetUp_L_Optimization = null;
    private JPanel playerSetUpOptimizationPanel = null;
    private JRadioButton playerSetUp_Optimization_Level1 = null;
    private JRadioButton playerSetUp_Optimization_Level2 = null;
    private ButtonGroup playerSetUp_Optimization_Group = null;
    private JCheckBox playerSetUp_UseFilter = null;
    private JCheckBox playerSetUp_VirtualStereo = null;

    public SidConfigPanel() {
        this.initialize();
    }

    public SidConfigPanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public SidConfigPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public SidConfigPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    public SIDContainer getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(SIDContainer parent) {
        this.parentContainer = parent;
    }

    private void initialize() {
        this.setName("SidConfigPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPlayerSetUp_L_SampleRate(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_L_SIDModel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_L_Optimization(), Helpers.getGridBagConstraint(2, 0, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_SampleRate(), Helpers.getGridBagConstraint(0, 1, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getPlayerSetUp_SIDModel(), Helpers.getGridBagConstraint(1, 1, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getPlayerSetUp_Optimization_Panel(), Helpers.getGridBagConstraint(2, 1, 1, 0, 0, 17, 1.0, 0.0));
        this.add((Component)this.getPlayerSetUp_UseSIDFilter(), Helpers.getGridBagConstraint(0, 2, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getPlayerSetUp_VirtualStereo(), Helpers.getGridBagConstraint(1, 2, 1, 0, 0, 17, 0.0, 0.0));
    }

    public JLabel getPlayerSetUp_L_SampleRate() {
        if (this.playerSetUp_L_SampleRate == null) {
            this.playerSetUp_L_SampleRate = new JLabel();
            this.playerSetUp_L_SampleRate.setName("playerSetUp_L_SampleRate");
            this.playerSetUp_L_SampleRate.setText("Frequency");
            this.playerSetUp_L_SampleRate.setFont(Helpers.getDialogFont());
        }
        return this.playerSetUp_L_SampleRate;
    }

    public JComboBox getPlayerSetUp_SampleRate() {
        if (this.playerSetUp_SampleRate == null) {
            this.playerSetUp_SampleRate = new JComboBox();
            this.playerSetUp_SampleRate.setName("playerSetUp_SampleRate");
            DefaultComboBoxModel<String> theModel = new DefaultComboBoxModel<String>(SIDContainer.SAMPLERATE);
            this.playerSetUp_SampleRate.setModel(theModel);
            this.playerSetUp_SampleRate.setFont(Helpers.getDialogFont());
            this.playerSetUp_SampleRate.setEnabled(true);
            this.playerSetUp_SampleRate.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SIDMixer currentMixer;
                    SIDContainer parent;
                    if (e.getStateChange() == 1 && (parent = SidConfigPanel.this.getParentContainer()) != null && (currentMixer = parent.getCurrentMixer()) != null) {
                        currentMixer.setSampleRate(Integer.parseInt(SidConfigPanel.this.getPlayerSetUp_SampleRate().getSelectedItem().toString()));
                    }
                }
            });
        }
        return this.playerSetUp_SampleRate;
    }

    public JLabel getPlayerSetUp_L_SIDModel() {
        if (this.playerSetUp_L_SIDModel == null) {
            this.playerSetUp_L_SIDModel = new JLabel();
            this.playerSetUp_L_SIDModel.setName("playerSetUp_L_SIDModel");
            this.playerSetUp_L_SIDModel.setText("SID Model");
            this.playerSetUp_L_SIDModel.setFont(Helpers.getDialogFont());
        }
        return this.playerSetUp_L_SIDModel;
    }

    public JComboBox getPlayerSetUp_SIDModel() {
        if (this.playerSetUp_SIDModel == null) {
            this.playerSetUp_SIDModel = new JComboBox();
            this.playerSetUp_SIDModel.setName("playerSetUp_SIDModel");
            DefaultComboBoxModel<String> theModel = new DefaultComboBoxModel<String>(SIDContainer.SIDMODELS);
            this.playerSetUp_SIDModel.setModel(theModel);
            this.playerSetUp_SIDModel.setFont(Helpers.getDialogFont());
            this.playerSetUp_SIDModel.setEnabled(true);
            this.playerSetUp_SIDModel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SIDMixer currentMixer;
                    SIDContainer parent;
                    if (e.getStateChange() == 1 && (parent = SidConfigPanel.this.getParentContainer()) != null && (currentMixer = parent.getCurrentMixer()) != null) {
                        currentMixer.setSIDModel(SidConfigPanel.this.getPlayerSetUp_SIDModel().getSelectedIndex());
                    }
                }
            });
        }
        return this.playerSetUp_SIDModel;
    }

    public JLabel getPlayerSetUp_L_Optimization() {
        if (this.playerSetUp_L_Optimization == null) {
            this.playerSetUp_L_Optimization = new JLabel();
            this.playerSetUp_L_Optimization.setName("playerSetUp_L_Optimization");
            this.playerSetUp_L_Optimization.setText("Optimization");
            this.playerSetUp_L_Optimization.setFont(Helpers.getDialogFont());
        }
        return this.playerSetUp_L_Optimization;
    }

    public ButtonGroup getPlayerSetUp_Optimization() {
        if (this.playerSetUp_Optimization_Group == null) {
            this.playerSetUp_Optimization_Group = new ButtonGroup();
            this.playerSetUp_Optimization_Group.add(this.getPlayerSetUp_Optimization_Level1());
            this.playerSetUp_Optimization_Group.add(this.getPlayerSetUp_Optimization_Level2());
        }
        return this.playerSetUp_Optimization_Group;
    }

    public JPanel getPlayerSetUp_Optimization_Panel() {
        if (this.playerSetUpOptimizationPanel == null) {
            this.playerSetUpOptimizationPanel = new JPanel();
            this.playerSetUpOptimizationPanel.setName("playerSetUpOptimizationPanel");
            this.playerSetUpOptimizationPanel.setLayout(new BorderLayout());
            this.playerSetUpOptimizationPanel.add((Component)this.getPlayerSetUp_Optimization_Level1(), "North");
            this.playerSetUpOptimizationPanel.add((Component)this.getPlayerSetUp_Optimization_Level2(), "South");
            this.getPlayerSetUp_Optimization();
        }
        return this.playerSetUpOptimizationPanel;
    }

    public JRadioButton getPlayerSetUp_Optimization_Level1() {
        if (this.playerSetUp_Optimization_Level1 == null) {
            this.playerSetUp_Optimization_Level1 = new JRadioButton("Level 1");
            this.playerSetUp_Optimization_Level1.setFont(Helpers.getDialogFont());
            this.playerSetUp_Optimization_Level1.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SIDMixer currentMixer;
                    SIDContainer parent;
                    if (e.getStateChange() == 1 && SidConfigPanel.this.getPlayerSetUp_Optimization_Level1().isSelected() && (parent = SidConfigPanel.this.getParentContainer()) != null && (currentMixer = parent.getCurrentMixer()) != null) {
                        currentMixer.setOptimization(1);
                    }
                }
            });
        }
        return this.playerSetUp_Optimization_Level1;
    }

    public JRadioButton getPlayerSetUp_Optimization_Level2() {
        if (this.playerSetUp_Optimization_Level2 == null) {
            this.playerSetUp_Optimization_Level2 = new JRadioButton("Level 2");
            this.playerSetUp_Optimization_Level2.setFont(Helpers.getDialogFont());
            this.playerSetUp_Optimization_Level2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SIDMixer currentMixer;
                    SIDContainer parent;
                    if (e.getStateChange() == 1 && SidConfigPanel.this.getPlayerSetUp_Optimization_Level2().isSelected() && (parent = SidConfigPanel.this.getParentContainer()) != null && (currentMixer = parent.getCurrentMixer()) != null) {
                        currentMixer.setOptimization(2);
                    }
                }
            });
        }
        return this.playerSetUp_Optimization_Level2;
    }

    public JCheckBox getPlayerSetUp_UseSIDFilter() {
        if (this.playerSetUp_UseFilter == null) {
            this.playerSetUp_UseFilter = new JCheckBox();
            this.playerSetUp_UseFilter.setName("playerSetUp_UseFilter");
            this.playerSetUp_UseFilter.setText("use SID Filter");
            this.playerSetUp_UseFilter.setFont(Helpers.getDialogFont());
            this.playerSetUp_UseFilter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SIDMixer currentMixer;
                    SIDContainer parent;
                    if ((e.getStateChange() == 1 || e.getStateChange() == 2) && (parent = SidConfigPanel.this.getParentContainer()) != null && (currentMixer = parent.getCurrentMixer()) != null) {
                        currentMixer.setUseSIDFilter(SidConfigPanel.this.getPlayerSetUp_UseSIDFilter().isSelected());
                    }
                }
            });
        }
        return this.playerSetUp_UseFilter;
    }

    public JCheckBox getPlayerSetUp_VirtualStereo() {
        if (this.playerSetUp_VirtualStereo == null) {
            this.playerSetUp_VirtualStereo = new JCheckBox();
            this.playerSetUp_VirtualStereo.setName("playerSetUp_VirtualStereo");
            this.playerSetUp_VirtualStereo.setText("virtual Stereo");
            this.playerSetUp_VirtualStereo.setFont(Helpers.getDialogFont());
            this.playerSetUp_VirtualStereo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SIDMixer currentMixer;
                    SIDContainer parent;
                    if ((e.getStateChange() == 1 || e.getStateChange() == 2) && (parent = SidConfigPanel.this.getParentContainer()) != null && (currentMixer = parent.getCurrentMixer()) != null) {
                        currentMixer.setVirtualStereo(SidConfigPanel.this.getPlayerSetUp_VirtualStereo().isSelected());
                    }
                }
            });
        }
        return this.playerSetUp_VirtualStereo;
    }
}

