/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.wav;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.wav.WavInfoPanel;
import de.quippy.javamod.multimedia.wav.WavMixer;
import de.quippy.javamod.system.Log;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JPanel;

public class WavContainer
extends MultimediaContainer {
    private static final String[] wavefile_Extensions;
    private JPanel wavInfoPanel;
    private WavMixer currentMixer;

    @Override
    public MultimediaContainer getInstance(URL waveFileUrl) {
        MultimediaContainer result = super.getInstance(waveFileUrl);
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(new FileOrPackedInputStream(waveFileUrl));
            ((WavInfoPanel)this.getInfoPanel()).fillInfoPanelWith(audioInputStream, this.getSongName());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (audioInputStream != null) {
                try {
                    audioInputStream.close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
        return result;
    }

    @Override
    public Object[] getSongInfosFor(URL url) {
        String songName = MultimediaContainerManager.getSongNameFromURL(url);
        Long duration = -1L;
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new FileOrPackedInputStream(url));
            AudioFormat audioFormat = audioInputStream.getFormat();
            float frameRate = audioFormat.getFrameRate();
            if (frameRate != -1.0f) {
                duration = (long)((double)((float)audioInputStream.getFrameLength() * 1000.0f / frameRate) + 0.5);
            } else {
                int channels = audioFormat.getChannels();
                int sampleSizeInBits = audioFormat.getSampleSizeInBits();
                int sampleSizeInBytes = sampleSizeInBits >> 3;
                int sampleRate = (int)audioFormat.getSampleRate();
                duration = (long)audioInputStream.available() / (long)sampleSizeInBytes / (long)channels * 1000L / (long)sampleRate;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return new Object[]{songName, duration};
    }

    @Override
    public boolean canExport() {
        return false;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.wavInfoPanel == null) {
            this.wavInfoPanel = new WavInfoPanel();
        }
        return this.wavInfoPanel;
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public String[] getFileExtensionList() {
        return wavefile_Extensions;
    }

    @Override
    public String getName() {
        return "Wave-File";
    }

    @Override
    public void configurationChanged(Properties newProps) {
    }

    @Override
    public void configurationSave(Properties props) {
    }

    @Override
    public Mixer createNewMixer() {
        this.currentMixer = new WavMixer(this.getFileURL());
        return this.currentMixer;
    }

    static {
        AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes();
        wavefile_Extensions = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            WavContainer.wavefile_Extensions[i] = types[i].getExtension();
        }
        MultimediaContainerManager.registerContainer(new WavContainer());
    }
}

