/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.wav;

import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WavInfoPanel
extends JPanel {
    private static final long serialVersionUID = -2853660365143541701L;
    private JLabel wavNameLabel = null;
    private JTextField wavName = null;
    private JLabel wavDurationLabel = null;
    private JTextField wavDuration = null;
    private JLabel wavSampleSizeInBitsLabel = null;
    private JTextField wavSampleSizeInBits = null;
    private JLabel wavFrequencyLabel = null;
    private JTextField wavFrequency = null;
    private JLabel wavChannelsLabel = null;
    private JTextField wavChannels = null;
    private JLabel wavEncodingLabel = null;
    private JTextField wavEncoding = null;

    public WavInfoPanel() {
        this.initialize();
    }

    public WavInfoPanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public WavInfoPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public WavInfoPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    private void initialize() {
        this.setName("WavInfoPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getWavNameLabel(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavName(), Helpers.getGridBagConstraint(1, 0, 1, 0, 2, 17, 1.0, 0.0));
        this.add((Component)this.getWavFrequencyLabel(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavFrequency(), Helpers.getGridBagConstraint(1, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavSampleSizeInBitsLabel(), Helpers.getGridBagConstraint(2, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavSampleSizeInBits(), Helpers.getGridBagConstraint(3, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavChannelsLabel(), Helpers.getGridBagConstraint(4, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavChannels(), Helpers.getGridBagConstraint(5, 1, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavEncodingLabel(), Helpers.getGridBagConstraint(0, 2, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavEncoding(), Helpers.getGridBagConstraint(1, 2, 1, 3, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavDurationLabel(), Helpers.getGridBagConstraint(4, 2, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getWavDuration(), Helpers.getGridBagConstraint(5, 2, 1, 0, 0, 17, 0.0, 0.0));
    }

    public JLabel getWavNameLabel() {
        if (this.wavNameLabel == null) {
            this.wavNameLabel = new JLabel("Wav file name:");
            this.wavNameLabel.setFont(Helpers.getDialogFont());
        }
        return this.wavNameLabel;
    }

    public JTextField getWavName() {
        if (this.wavName == null) {
            this.wavName = new JTextField();
            this.wavName.setEditable(false);
            this.wavName.setFont(Helpers.getDialogFont());
        }
        return this.wavName;
    }

    public JLabel getWavDurationLabel() {
        if (this.wavDurationLabel == null) {
            this.wavDurationLabel = new JLabel("Duration:");
            this.wavDurationLabel.setFont(Helpers.getDialogFont());
        }
        return this.wavDurationLabel;
    }

    public JTextField getWavDuration() {
        if (this.wavDuration == null) {
            this.wavDuration = new JTextField();
            this.wavDuration.setEditable(false);
            this.wavDuration.setColumns(5);
            this.wavDuration.setFont(Helpers.getDialogFont());
        }
        return this.wavDuration;
    }

    public JLabel getWavFrequencyLabel() {
        if (this.wavFrequencyLabel == null) {
            this.wavFrequencyLabel = new JLabel("Rate:");
            this.wavFrequencyLabel.setFont(Helpers.getDialogFont());
        }
        return this.wavFrequencyLabel;
    }

    public JTextField getWavFrequency() {
        if (this.wavFrequency == null) {
            this.wavFrequency = new JTextField();
            this.wavFrequency.setEditable(false);
            this.wavFrequency.setColumns(5);
            this.wavFrequency.setFont(Helpers.getDialogFont());
        }
        return this.wavFrequency;
    }

    public JLabel getWavSampleSizeInBitsLabel() {
        if (this.wavSampleSizeInBitsLabel == null) {
            this.wavSampleSizeInBitsLabel = new JLabel("Bits:");
            this.wavSampleSizeInBitsLabel.setFont(Helpers.getDialogFont());
        }
        return this.wavSampleSizeInBitsLabel;
    }

    public JTextField getWavSampleSizeInBits() {
        if (this.wavSampleSizeInBits == null) {
            this.wavSampleSizeInBits = new JTextField();
            this.wavSampleSizeInBits.setEditable(false);
            this.wavSampleSizeInBits.setColumns(5);
            this.wavSampleSizeInBits.setFont(Helpers.getDialogFont());
        }
        return this.wavSampleSizeInBits;
    }

    public JLabel getWavChannelsLabel() {
        if (this.wavChannelsLabel == null) {
            this.wavChannelsLabel = new JLabel("Channel:");
            this.wavChannelsLabel.setFont(Helpers.getDialogFont());
        }
        return this.wavChannelsLabel;
    }

    public JTextField getWavChannels() {
        if (this.wavChannels == null) {
            this.wavChannels = new JTextField();
            this.wavChannels.setEditable(false);
            this.wavChannels.setColumns(5);
            this.wavChannels.setFont(Helpers.getDialogFont());
        }
        return this.wavChannels;
    }

    public JLabel getWavEncodingLabel() {
        if (this.wavEncodingLabel == null) {
            this.wavEncodingLabel = new JLabel("Encoding:");
            this.wavEncodingLabel.setFont(Helpers.getDialogFont());
        }
        return this.wavEncodingLabel;
    }

    public JTextField getWavEncoding() {
        if (this.wavEncoding == null) {
            this.wavEncoding = new JTextField();
            this.wavEncoding.setEditable(false);
            this.wavEncoding.setColumns(10);
            this.wavEncoding.setFont(Helpers.getDialogFont());
        }
        return this.wavEncoding;
    }

    public void fillInfoPanelWith(AudioInputStream audioInputStream, String songName) {
        this.getWavName().setText(songName);
        AudioFormat audioFormat = audioInputStream.getFormat();
        this.getWavFrequency().setText(Integer.toString((int)audioFormat.getSampleRate()));
        this.getWavSampleSizeInBits().setText(Integer.toString(audioFormat.getSampleSizeInBits()));
        this.getWavChannels().setText(Integer.toString(audioFormat.getChannels()));
        this.getWavEncoding().setText(audioFormat.getEncoding().toString());
        int lengthInMilliseconds = 0;
        try {
            lengthInMilliseconds = (int)((long)audioInputStream.available() / ((long)audioFormat.getSampleSizeInBits() >> 3) / (long)audioFormat.getChannels() * 1000L / (long)audioFormat.getSampleRate());
        }
        catch (IOException ex) {
            Log.error("IGNORED", ex);
        }
        this.getWavDuration().setText(Helpers.getTimeStringFromMilliseconds(lengthInMilliseconds));
    }
}

