/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.wav;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class WavMixer
extends BasicMixer {
    private int bufferSize;
    private byte[] output;
    private int sampleSizeInBits;
    private int sampleSizeInBytes;
    private int channels;
    private int sampleRate;
    private int lengthInMilliseconds;
    private URL waveFileUrl;
    private AudioInputStream audioInputStream;
    private long currentSamplesWritten;

    public WavMixer(URL waveFileUrl) {
        this.waveFileUrl = waveFileUrl;
        this.initialize();
    }

    private void initialize() {
        try {
            AudioFormat[] possibleFormats;
            if (this.audioInputStream != null) {
                try {
                    this.audioInputStream.close();
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
            this.audioInputStream = AudioSystem.getAudioInputStream(new FileOrPackedInputStream(this.waveFileUrl));
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            this.lengthInMilliseconds = 0;
            float frameRate = audioFormat.getFrameRate();
            if (frameRate != -1.0f) {
                this.lengthInMilliseconds = (int)((double)((float)this.audioInputStream.getFrameLength() * 1000.0f / frameRate) + 0.5);
            } else {
                try {
                    this.lengthInMilliseconds = (int)((long)this.audioInputStream.available() / (long)(audioFormat.getSampleSizeInBits() >> 3) / (long)audioFormat.getChannels() * 1000L / (long)audioFormat.getSampleRate());
                }
                catch (IOException ex) {
                    Log.error("[WavMixer] No data available!", ex);
                }
            }
            DataLine.Info sourceLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
            if (!AudioSystem.isLineSupported(sourceLineInfo) && (possibleFormats = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, audioFormat)) != null && possibleFormats.length != 0) {
                this.audioInputStream = AudioSystem.getAudioInputStream(possibleFormats[0], this.audioInputStream);
                audioFormat = this.audioInputStream.getFormat();
                Log.info("Converting input data to " + audioFormat.toString());
            }
            this.setAudioFormat(audioFormat);
            this.channels = audioFormat.getChannels();
            this.sampleSizeInBits = audioFormat.getSampleSizeInBits();
            this.sampleSizeInBytes = this.sampleSizeInBits >> 3;
            this.sampleRate = (int)audioFormat.getSampleRate();
            this.bufferSize = 250 * this.channels * this.sampleRate / 1000;
            this.bufferSize *= this.sampleSizeInBytes;
            this.output = new byte[this.bufferSize];
        }
        catch (Throwable ex) {
            Log.error("[WavMixer]", ex);
        }
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.sampleRate != 0) {
            return this.currentSamplesWritten * 1000L / (long)this.sampleRate;
        }
        return 0L;
    }

    @Override
    protected void seek(long milliseconds) {
        try {
            if (this.getMillisecondPosition() > milliseconds) {
                if (this.audioInputStream != null) {
                    try {
                        this.audioInputStream.close();
                    }
                    catch (IOException ex) {
                        Log.error("IGNORED", ex);
                    }
                }
                this.audioInputStream = AudioSystem.getAudioInputStream(this.waveFileUrl);
                this.currentSamplesWritten = 0L;
            }
            long skipSamples = milliseconds * (long)this.sampleRate / 1000L - this.currentSamplesWritten;
            for (long skipBytes = skipSamples * (long)this.sampleSizeInBytes * (long)this.channels; skipBytes > 0L; skipBytes -= this.audioInputStream.skip(skipBytes)) {
            }
            this.currentSamplesWritten += skipSamples;
        }
        catch (Exception ex) {
            Log.error("[WavMixer]: error while seeking", ex);
        }
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    @Override
    public int getChannelCount() {
        return this.channels;
    }

    @Override
    public int getCurrentKBperSecond() {
        return this.sampleSizeInBits * this.channels * this.sampleRate / 1000;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.currentSamplesWritten = 0L;
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            int byteCount = 0;
            do {
                if ((byteCount = this.audioInputStream.read(this.output, 0, this.bufferSize)) <= 0) continue;
                this.writeSampleDataToLine(this.output, 0, byteCount);
                this.currentSamplesWritten += (long)(byteCount / this.sampleSizeInBytes / this.channels);
                if (this.isStopping()) {
                    this.setIsStopped();
                    break;
                }
                if (this.isPausing()) {
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (!this.isInSeeking()) continue;
                this.setIsSeeking();
                while (this.isInSeeking()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (byteCount != -1);
            if (byteCount <= 0) {
                this.setHasFinished();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            if (this.audioInputStream != null) {
                try {
                    this.audioInputStream.close();
                    this.audioInputStream = null;
                }
                catch (IOException ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
    }
}

