/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.system;

public class FastMath {
    private static final double B = 1.2732395447351628;
    private static final double C = -0.4052847345693511;
    private static final double P = 0.218;
    private static final double hPI = 1.5707963267948966;
    private static final double PI2 = Math.PI * 2;
    private static final double sPI = 4.71238898038469;
    private static final double atan2_coeff_1 = 0.7853981633974483;
    private static final double atan2_coeff_2 = 2.356194490192345;

    public static double wrap(double angle) {
        if ((angle %= Math.PI * 2) > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        if (angle < -Math.PI || angle > Math.PI) {
            throw new IllegalArgumentException("Wrong angel : " + angle);
        }
        return angle;
    }

    public static double fastSin(double theta) {
        return FastMath.fastSin0(FastMath.wrap(theta));
    }

    public static double fastCos(double theta) {
        return FastMath.fastSin0(FastMath.wrap(theta + 1.5707963267948966));
    }

    public static double fastSin0(double theta) {
        double y = 1.2732395447351628 * theta + -0.4052847345693511 * theta * Math.abs(theta);
        y = 0.218 * (y * Math.abs(y) - y) + y;
        return y;
    }

    public static double fastCos0(double theta) {
        theta = theta > 1.5707963267948966 ? (theta -= 4.71238898038469) : (theta += 1.5707963267948966);
        return FastMath.fastSin0(theta);
    }

    public static double exp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static double log(double x) {
        return 6.0 * (x - 1.0) / (x + 1.0 + 4.0 * Math.sqrt(x));
    }

    public static double pow(double a, double b) {
        int x = (int)(Double.doubleToLongBits(a) >> 32);
        int y = (int)(b * (double)(x - 1072632447) + 1.072632447E9);
        return Double.longBitsToDouble((long)y << 32);
    }

    public static float floor(float value) {
        if (value < 0.0f) {
            throw new IllegalArgumentException("Wrong value : " + value);
        }
        return (int)value;
    }

    public static double floor(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Wrong value : " + value);
        }
        return (long)value;
    }

    public static double atan2(double y, double x) {
        double angle;
        if (y == 0.0) {
            return 0.0;
        }
        if (x == 0.0) {
            return y > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double abs_y = Math.abs(y);
        if (x > 0.0) {
            double r = (x - abs_y) / (x + abs_y);
            angle = 0.7853981633974483 - 0.7853981633974483 * r;
        } else {
            double r = (x + abs_y) / (abs_y - x);
            angle = 2.356194490192345 - 0.7853981633974483 * r;
        }
        return y >= 0.0 ? angle : -angle;
    }

    public static double fastSqrt(double a) {
        long x = Double.doubleToLongBits(a) >> 32;
        double y = Double.longBitsToDouble(x + 1072632448L << 31);
        return y;
    }

    public static double sqrt(double a) {
        long x = Double.doubleToLongBits(a) >> 32;
        double y = Double.longBitsToDouble(x + 1072632448L << 31);
        y = (y + a / y) * 0.5;
        return y;
    }
}

