/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.system;

import de.quippy.javamod.main.gui.components.SimpleProgessDialog;
import de.quippy.javamod.main.gui.tools.FileChooserResult;
import de.quippy.javamod.main.gui.tools.PlaylistDropListener;
import de.quippy.javamod.system.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class Helpers {
    public static final String VERSION = "V2.3";
    public static final String PROGRAM = "Java Mod Player";
    public static final String FULLVERSION = "Java Mod Player V2.3";
    public static final String COPYRIGHT = "\u00c2\u00a9 by Daniel Becker since 2006";
    public static final String VERSION_URL = "http://www.quippy.de/download.php?file=./modplayer/javamod_version.txt";
    public static final String JAVAMOD_URL = "http://www.quippy.de/download.php?file=./modplayer/javamod.jar";
    public static final String CODING_GUI = "cp850";
    public static final String CODING_COMMANLINE = "cp1252";
    public static final String CODING_M3U = "ISO-8859-1";
    public static String currentCoding = "cp850";
    public static final String DEFAULTFONTPATH = "/de/quippy/javamod/main/gui/ressources/lucon.ttf";
    private static Font DIALOG_FONT = null;
    private static Font TEXTAREA_FONT = null;
    public static String HOMEDIR;
    private static final String[] noteStrings;
    public static final int[] noteValues;
    public static final int[][] protracker_fineTunedPeriods;
    public static final int[] FreqS3MTable;
    public static final int[] it_fineTuneTable;
    public static final int[] FineLinearSlideUpTable;
    public static final int[] FineLinearSlideDownTable;
    public static final int[] LinearSlideUpTable;
    public static final int[] LinearSlideDownTable;
    protected static final int LOGFAC = 128;
    public static final int[] logtab;
    public static final int[] lintab;
    public static final int[] ModSinusTable;
    public static final int[] ModRampDownTable;
    public static final int[] ModSquareTable;
    public static final int[] ModRandomTable;
    public static final int[] ft2VibratoTable;
    public static final int BASEFREQUENCY = 8363;
    public static final int BASEPERIOD = 428;
    public static final String SCROLLY_BLANKS = "     ";
    public static final int STM_S3M_TABLE = 0;
    public static final int IT_LINEAR_TABLE = 1;
    public static final int AMIGA_TABLE = 2;
    public static final int XM_AMIGA_TABLE = 4;
    public static final int XM_LINEAR_TABLE = 8;
    public static final int IT_AMIGA_TABLE = 16;
    public static final int VOLUMESHIFT = 8;
    public static final int VOLUMESHIFT_FULL = 8;
    public static final int MAXVOLUME = 16384;
    public static final int MAXVOLUMESHIFT = 32;
    public static final int SHIFT = 16;
    public static final int SHIFT_ONE = 65536;
    public static final int SHIFT_MASK = 65535;
    public static final int PERIOD_SHIFT = 4;
    public static final int SAMPLE_SHIFT = 12;
    public static final int VOL_RAMP_FRAC = 4;
    public static final int VOL_RAMP_LEN = 16;
    public static final int VOLRAMPLEN_MS = 146;
    public static final int XBASS_DELAY = 14;
    public static final int XBASS_BUFFER = 64;
    public static final int MODTYPE_MOD = 1;
    public static final int MODTYPE_XM = 2;
    public static final int MODTYPE_S3M = 4;
    public static final int MODTYPE_IT = 8;
    public static final int SM_PCMS = 0;
    public static final int SM_PCMU = 1;
    public static final int SM_PCMD = 2;
    public static final int SM_ADPCM4 = 3;
    public static final int SM_16BIT = 4;
    public static final int SM_STEREO = 8;
    public static final int SM_PCM16S = 4;
    public static final int SM_PCM16U = 5;
    public static final int SM_PCM16D = 6;
    public static final int SM_PCM16M = 7;
    public static final int SM_STPCM8S = 8;
    public static final int SM_STPCM8U = 9;
    public static final int SM_STPCM8D = 10;
    public static final int SM_STPCM16S = 12;
    public static final int SM_STPCM16U = 13;
    public static final int SM_STPCM16D = 14;
    public static final int SM_STPCM16M = 15;
    public static final int SM_IT2148 = 16;
    public static final int SM_IT21416 = 20;
    public static final int SM_IT2158 = 18;
    public static final int SM_IT21516 = 22;
    public static final int LOOP_ON = 1;
    public static final int LOOP_SUSTAIN_ON = 2;
    public static final int LOOP_IS_PINGPONG = 4;
    public static final int LOOP_SUSTAIN_IS_PINGPONG = 8;
    public static final int NNA_CUT = 0;
    public static final int NNA_CONTINUE = 1;
    public static final int NNA_OFF = 2;
    public static final int NNA_FADE = 3;
    public static final int KEY_OFF = -1;
    public static final int NOTE_CUT = -2;
    public static final int FLTMODE_LOWPASS = 0;
    public static final int FLTMODE_HIGHPASS = 1;
    public static final int FLTMODE_BANDPASS = 2;
    public static final int FILTER_SHIFT_BITS = 32;
    public static final double FILTER_PRECISION = 4.294967296E9;
    public static final int SONG_EMBEDMIDICFG = 1;
    public static final int SONG_FASTVOLSLIDES = 2;
    public static final int SONG_ITOLDEFFECTS = 4;
    public static final int SONG_ITCOMPATMODE = 8;
    public static final int SONG_LINEARSLIDES = 16;
    public static final int SONG_PATTERNLOOP = 32;
    public static final int SONG_STEP = 64;
    public static final int SONG_PAUSED = 128;
    public static final int SONG_FADINGSONG = 256;
    public static final int SONG_ENDREACHED = 512;
    public static final int SONG_GLOBALFADE = 1024;
    public static final int SONG_CPUVERYHIGH = 2048;
    public static final int SONG_FIRSTTICK = 4096;
    public static final int SONG_MPTFILTERMODE = 8192;
    public static final int SONG_SURROUNDPAN = 16384;
    public static final int SONG_EXFILTERRANGE = 32768;
    public static final int SONG_AMIGALIMITS = 65536;
    public static final int PLAYER_LOOP_DEACTIVATED = 0;
    public static final int PLAYER_LOOP_FADEOUT = 1;
    public static final int PLAYER_LOOP_IGNORE = 2;

    private Helpers() {
    }

    public static Font getTextAreaFont() {
        if (TEXTAREA_FONT == null) {
            try {
                InputStream is = Helpers.class.getResourceAsStream(DEFAULTFONTPATH);
                Font font = Font.createFont(0, is);
                TEXTAREA_FONT = font.deriveFont(10.0f);
            }
            catch (Exception ex) {
                Log.error("Could not load font!", ex);
                TEXTAREA_FONT = new Font("Monospaced", 0, 10);
            }
        }
        return TEXTAREA_FONT;
    }

    public static Font getDialogFont() {
        if (DIALOG_FONT == null) {
            DIALOG_FONT = new Font("Dialog", 0, 10);
        }
        return DIALOG_FONT;
    }

    public static void setCoding(boolean gui) {
        currentCoding = gui ? CODING_GUI : CODING_COMMANLINE;
    }

    public static String getNoteNameToIndex(int index) {
        if (index == 0) {
            return "...";
        }
        if (index == -1) {
            return "===";
        }
        if (index == -2) {
            return "^^^";
        }
        return noteStrings[index % 12] + index / 12;
    }

    public static String getNoteNameToPeriod(int noteIndex) {
        return Helpers.getNoteNameToIndex(noteIndex > 0 ? noteIndex - 1 : noteIndex);
    }

    public static int getNoteIndexForPeriod(int period) {
        int i;
        if (period == 0) {
            return 0;
        }
        if (period == -1) {
            return -1;
        }
        if (period == -2) {
            return -2;
        }
        for (i = 0; i < noteValues.length && period < noteValues[i]; ++i) {
        }
        if (i >= noteValues.length) {
            return 0;
        }
        return i;
    }

    public static int getRoundedPeriod(int period) {
        int diff2;
        int diff1;
        int i = Helpers.getNoteIndexForPeriod(period);
        if (i > 0 && (diff1 = noteValues[i - 1] - period) < (diff2 = period - noteValues[i])) {
            return noteValues[i - 1];
        }
        return noteValues[i];
    }

    public static String retrieveAsString(byte[] input, int start, int length) {
        return Helpers.retrieveAsString(input, start, length, currentCoding);
    }

    public static String retrieveAsString(byte[] input, int start, int length, String coding) {
        int index;
        String str = null;
        if (coding != null) {
            try {
                str = new String(input, start, length, coding);
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (str == null) {
            str = new String(input, start, length);
        }
        StringBuilder b = new StringBuilder(str);
        for (index = 0; index < b.length() && b.charAt(index) != '\u0000'; ++index) {
            if (b.charAt(index) >= ' ') continue;
            b.setCharAt(index, ' ');
        }
        b.delete(index, b.length());
        return b.toString();
    }

    public static byte[] getBytesFromString(String str, int length, String coding) {
        byte[] result = new byte[length];
        int len = str.length();
        if (len > length) {
            len = length;
        }
        try {
            System.arraycopy(str.getBytes(coding), 0, result, 0, len);
        }
        catch (UnsupportedEncodingException ex) {
            System.arraycopy(str.getBytes(), 0, result, 0, len);
        }
        return result;
    }

    public static String getAsHex(int value, int digits) {
        StringBuilder result = new StringBuilder();
        String hex = Integer.toString(value, 16).toUpperCase();
        for (int i = 0; i < digits - hex.length(); ++i) {
            result.append('0');
        }
        return result.append(hex).toString();
    }

    public static int convertIntelWordToInt(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    public static int convertIntel3ByteToInt(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16;
    }

    public static int convertIntelDWordToInt(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | (buf[offset + 3] & 0xFF) << 24;
    }

    public static int convertWordToInt(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 8 | buf[offset + 1] & 0xFF;
    }

    public static int convert3ByteToInt(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 16 | (buf[offset + 1] & 0xFF) << 8 | buf[offset + 2] & 0xFF;
    }

    public static int convertDWordToInt(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    public static byte[] convertIntToDWord(int value) {
        byte[] buf = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return buf;
    }

    public static int promoteSigned8BitToSigned16Bit(byte sample) {
        return sample << 8;
    }

    public static int promoteSigned8BitToSigned24Bit(byte sample) {
        return sample << 16;
    }

    public static int promoteSigned16BitToSigned24Bit(int sample) {
        return sample << 8;
    }

    public static int promoteUnsigned8BitToSigned16Bit(byte sample) {
        return (sample & 0xFF) - 128 << 8;
    }

    public static int promoteUnsigned16BitToSigned16Bit(int sample) {
        return (sample & 0xFFFF) - 32768;
    }

    public static int promoteUnsigned8BitToSigned24Bit(byte sample) {
        return (sample & 0xFF) - 128 << 16;
    }

    public static int promoteUnsigned16BitToSigned24Bit(int sample) {
        return (sample & 0xFFFF) - 32768 << 8;
    }

    public static int promoteUnsigned24BitToSigned24Bit(int sample) {
        return (sample & 0xFFFFFF) - 0x800000;
    }

    public static int promoteSigned16BitToUnsigned8Bit(int sample) {
        return (sample >> 8) + 128 & 0xFF;
    }

    public static int promoteSigned24BitToUnsigned24Bit(int sample) {
        return sample + 0x800000 & 0xFFFFFF;
    }

    public static GridBagConstraints getGridBagConstraint(int gridx, int gridy, int gridheight, int gridwidth, int fill, int anchor, double weightx, double weighty) {
        return Helpers.getGridBagConstraint(gridx, gridy, gridheight, gridwidth, fill, anchor, weightx, weighty, new Insets(4, 4, 4, 4));
    }

    public static GridBagConstraints getGridBagConstraint(int gridx, int gridy, int gridheight, int gridwidth, int fill, int anchor, double weightx, double weighty, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridheight = gridheight;
        constraints.gridwidth = gridwidth;
        constraints.fill = fill;
        constraints.anchor = anchor;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.insets = insets;
        return constraints;
    }

    public static Point getFrameCenteredLocation(Component centerThis, Component parent) {
        Dimension screenSize = parent == null ? Toolkit.getDefaultToolkit().getScreenSize() : parent.getSize();
        int x = screenSize.width - centerThis.getWidth() >> 1;
        int y = screenSize.height - centerThis.getHeight() >> 1;
        if (parent != null) {
            x += parent.getX();
            y += parent.getY();
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        return new Point(x, y);
    }

    public static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, PlaylistDropListener myListener) {
        list.add(new DropTarget(basePanel, 3, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                Helpers.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, 3, myListener));
        }
    }

    public static boolean isEqualURL(URL url1, URL url2) {
        if (url1 != null && url2 != null) {
            try {
                URI uri1 = url1.toURI();
                URI uri2 = url2.toURI();
                return uri1.equals(uri2);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    public static URL createURLfromFile(File file) {
        if (!file.exists()) {
            try {
                String path = file.getPath();
                StringBuilder b = new StringBuilder(File.separatorChar != '/' ? path.replace(File.separatorChar, '/') : path);
                if (file.isDirectory() && b.charAt(b.length() - 1) != '/') {
                    b.append('/');
                }
                if (b.length() > 2 && b.charAt(0) == '/' && b.charAt(1) == '/') {
                    b.insert(0, "//");
                }
                URI uri = new URI("file", null, b.toString(), null);
                return uri.toURL();
            }
            catch (URISyntaxException e) {
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL createURLfromString(String urlLine) {
        try {
            try {
                URL url = new URL(urlLine);
                try {
                    URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                    return uri.toURL();
                }
                catch (URISyntaxException e) {
                    return url;
                }
            }
            catch (MalformedURLException ex) {
                return Helpers.createURLfromFile(new File(urlLine));
            }
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static String createStringFomURL(URL url) {
        if (url == null) {
            return "";
        }
        return Helpers.createStringFromURLString(url.toExternalForm());
    }

    public static String createStringFromURLString(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Log.error("Helpers::createStringRomURLString", ex);
            return url;
        }
    }

    public static String getFileNameFrom(String fileName) {
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    public static String getFileNameFromURL(URL url) {
        return Helpers.getFileNameFrom(Helpers.createStringFomURL(url));
    }

    public static String getExtensionFrom(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
    }

    public static String getExtensionFromURL(URL url) {
        return Helpers.getExtensionFrom(Helpers.createStringFomURL(url));
    }

    public static String getPreceedingExtensionFrom(String fileName) {
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        int dot = (fileName = fileName.substring(fileName.lastIndexOf(47) + 1)).indexOf(46);
        if (dot > 0) {
            return fileName.substring(0, dot).toLowerCase();
        }
        return "";
    }

    public static String getPreceedingExtensionFromURL(URL url) {
        return Helpers.getPreceedingExtensionFrom(url.getPath());
    }

    public static String createLocalFileStringFromURL(URL url, boolean stayLocal) {
        String suggestedPath = Helpers.createStringFomURL(url);
        if (url != null) {
            String proto = url.getProtocol().toLowerCase();
            if (proto.equals("file")) {
                try {
                    suggestedPath = new File(url.toURI()).toString();
                }
                catch (URISyntaxException ex) {
                    Log.error("Helpers::createLocalFileStringFromURL", ex);
                }
            } else if (!proto.equals("http") && stayLocal) {
                try {
                    suggestedPath = HOMEDIR + Helpers.getFileNameFromURL(url);
                }
                catch (SecurityException ex) {
                    Log.error("Helpers::createLocalFileStringFromURL", ex);
                }
            }
        }
        return suggestedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean urlExists(URL url) {
        if (url == null) {
            return false;
        }
        if (url.getProtocol().equalsIgnoreCase("file")) {
            try {
                File f = new File(url.toURI());
                return f.exists();
            }
            catch (Throwable ex) {
                return false;
            }
        }
        try {
            InputStream in = null;
            try {
                in = url.openStream();
                if (in == null) return true;
            }
            catch (Throwable ex) {
                try {
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
            try {
                in.close();
                return true;
            }
            catch (Throwable e) {
                return true;
            }
        }
        catch (Throwable throwable2) {
            return false;
        }
    }

    public static boolean urlExists(String url) {
        return Helpers.urlExists(Helpers.createURLfromString(url));
    }

    public static URL createAbsolutePathForFile(URL baseURL, String inputFileName) {
        String fileName = inputFileName;
        try {
            if (!Helpers.urlExists(fileName)) {
                int iterations;
                fileName = fileName.replace('\\', '/');
                String path = Helpers.createStringFomURL(baseURL);
                int lastSlash = path.lastIndexOf(47);
                StringBuilder relPath = new StringBuilder(path.substring(0, lastSlash + 1));
                if (fileName.startsWith("/")) {
                    fileName = fileName.substring(1);
                }
                URL fullURL = Helpers.createURLfromString(new StringBuilder(relPath).append(fileName).toString());
                for (iterations = 0; fullURL != null && !Helpers.urlExists(fullURL) && iterations < 256; ++iterations) {
                    relPath.append("../");
                    fullURL = Helpers.createURLfromString(new StringBuilder(relPath).append(fileName).toString());
                }
                if (iterations < 256 && fullURL != null) {
                    try {
                        return fullURL.toURI().normalize().toURL();
                    }
                    catch (URISyntaxException x) {
                        Log.error("[createAbsolutePathForFile]", x);
                        return fullURL;
                    }
                }
                Log.info("File not found: " + inputFileName + " in relation to " + baseURL);
                return Helpers.createURLfromString(inputFileName);
            }
            return Helpers.createURLfromString(fileName);
        }
        catch (Throwable ex) {
            Log.error("createAbsolutePathForFile", ex);
            Log.info("Illegal filename specification: " + inputFileName + " in playlist " + baseURL);
            return null;
        }
    }

    public static FileChooserResult selectFileNameFor(Component parent, String showDir, String action, FileFilter[] filter, int type, boolean multiFileSelection, boolean directoryOnly) {
        int result;
        File theDirectory;
        String dir = showDir == null ? HOMEDIR : showDir;
        try {
            File f = new File(dir);
            dir = f.getCanonicalPath();
        }
        catch (Exception ex) {
            Log.error("Helpers::selectFileNameFor", ex);
        }
        File theFile = new File(dir);
        for (theDirectory = new File(dir); !(theDirectory == null || theDirectory.isDirectory() && theDirectory.exists()); theDirectory = theDirectory.getParentFile()) {
        }
        JFileChooser chooser = new JFileChooser(theDirectory);
        if (filter != null) {
            chooser.setAcceptAllFileFilterUsed(false);
            for (int i = filter.length - 1; i >= 0; --i) {
                chooser.addChoosableFileFilter(filter[i]);
            }
        } else {
            chooser.setAcceptAllFileFilterUsed(true);
        }
        if (!theFile.isDirectory()) {
            chooser.setSelectedFile(theFile);
        }
        chooser.setApproveButtonText(action);
        chooser.setMultiSelectionEnabled(multiFileSelection);
        chooser.setFileSelectionMode(directoryOnly ? 1 : 0);
        int n = result = type == 0 ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
        if (result == 0) {
            File[] fileArray;
            if (multiFileSelection) {
                fileArray = chooser.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = chooser.getSelectedFile();
            }
            File[] selectedFiles = fileArray;
            return new FileChooserResult(chooser.getFileFilter(), selectedFiles);
        }
        return null;
    }

    public static String getStringFromPoint(Point location) {
        return "" + (int)location.getX() + 'x' + (int)location.getY();
    }

    public static Point getPointFromString(String point) {
        int xIndex = point.indexOf(120);
        String x = point.substring(0, xIndex);
        String y = point.substring(xIndex + 1);
        return new Point(Integer.parseInt(x), Integer.parseInt(y));
    }

    public static String getStringFromDimension(Dimension dimension) {
        return "" + (int)dimension.getWidth() + 'x' + (int)dimension.getHeight();
    }

    public static Dimension getDimensionFromString(String dimension) {
        int xIndex = dimension.indexOf(120);
        String width = dimension.substring(0, xIndex);
        String height = dimension.substring(xIndex + 1);
        return new Dimension(Integer.parseInt(width), Integer.parseInt(height));
    }

    public static Insets getInsetsFromString(String insets) {
        StringTokenizer tok = new StringTokenizer(insets, ",");
        int left = Integer.parseInt(tok.nextToken().trim());
        int top = Integer.parseInt(tok.nextToken().trim());
        int right = Integer.parseInt(tok.nextToken().trim());
        int bottom = Integer.parseInt(tok.nextToken().trim());
        return new Insets(top, left, bottom, right);
    }

    public static Color getColorFromString(String color) {
        StringTokenizer tok = new StringTokenizer(color, ",");
        int r = Integer.parseInt(tok.nextToken().trim());
        int g = Integer.parseInt(tok.nextToken().trim());
        int b = Integer.parseInt(tok.nextToken().trim());
        return new Color(r, g, b);
    }

    public static String getTimeStringFromMilliseconds(long millis) {
        int sec = (int)(millis / 1000L % 60L);
        int min = (int)(millis / 60000L);
        return (min < 10 ? "  " : "") + Integer.toString(min) + ':' + (sec < 10 ? "0" : "") + Integer.toString(sec);
    }

    public static double getDecimalValueFrom(float dbValue) {
        return Math.pow(10.0, (double)dbValue / 20.0);
    }

    public static double getDBValueFrom(float decimalValue) {
        return Math.log10(decimalValue) * 20.0;
    }

    public static long getMillisecondsFromTimeString(String timeString) {
        int minIndex = timeString.indexOf(58);
        int min = Integer.parseInt(timeString.substring(0, minIndex).trim());
        String secString = timeString.substring(minIndex + 1);
        int secIndex = secString.indexOf(58);
        if (secIndex == -1) {
            secIndex = secString.length();
        }
        int sec = Integer.parseInt(secString.substring(0, secIndex).trim());
        return (long)(min * 60 + sec) * 1000L;
    }

    public static String getAudioInfos() {
        StringBuilder result = new StringBuilder("Running on ").append(System.getProperty("os.arch"));
        result.append("\nMixerInfo:\n");
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfo.length; ++i) {
            result.append(mixerInfo[i]).append('\n');
            Mixer mixer = AudioSystem.getMixer(mixerInfo[i]);
            Line.Info[] targetLineInfos = mixer.getTargetLineInfo();
            for (int j = 0; j < targetLineInfos.length; ++j) {
                result.append("Targetline(").append(j).append("): ").append(targetLineInfos[j]).append('\n');
                if (!(targetLineInfos[j] instanceof DataLine.Info)) continue;
                AudioFormat[] audioFormats = ((DataLine.Info)targetLineInfos[j]).getFormats();
                for (int u = 0; u < audioFormats.length; ++u) {
                    result.append("Audioformat(").append(u).append("): ").append(audioFormats[u]).append('\n');
                }
            }
            result.append("---------------------------------------------------------------------\n");
        }
        return result.toString();
    }

    public static void registerAllClasses() throws ClassNotFoundException {
        Class.forName("de.quippy.javamod.system.Log");
        Class.forName("de.quippy.javamod.system.Helpers");
        Class.forName("de.quippy.javamod.multimedia.mod.mixer.interpolation.CubicSpline");
        Class.forName("de.quippy.javamod.multimedia.mod.mixer.interpolation.WindowedFIR");
        Class.forName("de.quippy.javamod.multimedia.mod.loader.tracker.ProTrackerMod");
        Class.forName("de.quippy.javamod.multimedia.mod.loader.tracker.XMMod");
        Class.forName("de.quippy.javamod.multimedia.mod.loader.tracker.ScreamTrackerOldMod");
        Class.forName("de.quippy.javamod.multimedia.mod.loader.tracker.ScreamTrackerMod");
        Class.forName("de.quippy.javamod.multimedia.mod.loader.tracker.ImpulseTrackerMod");
        Class.forName("de.quippy.javamod.multimedia.mod.ModContainer");
        Class.forName("de.quippy.javamod.multimedia.wav.WavContainer");
        Class.forName("de.quippy.javamod.multimedia.mp3.MP3Container");
        Class.forName("de.quippy.javamod.multimedia.ogg.OGGContainer");
        Class.forName("de.quippy.javamod.multimedia.ape.APEContainer");
        Class.forName("de.quippy.javamod.multimedia.flac.FLACContainer");
        Class.forName("de.quippy.javamod.multimedia.midi.MidiContainer");
        Class.forName("de.quippy.javamod.multimedia.sid.SIDContainer");
        Class.forName("de.quippy.sidplay.resid_builder.resid.Wave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentServerVersion() {
        BufferedReader reader = null;
        try {
            URL version_url = Helpers.createURLfromString(VERSION_URL);
            reader = new BufferedReader(new InputStreamReader(version_url.openStream(), CODING_M3U));
            String version = reader.readLine();
            reader.close();
            reader = null;
            String string = version;
            return string;
        }
        catch (Throwable ex) {
            Log.error("getCurrentServerVersion", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    Log.error("IGNORED", ex);
                }
            }
        }
        return null;
    }

    public static int compareVersions(String v1, String v2) {
        if (v1.startsWith("V")) {
            v1 = v1.substring(1);
        }
        StringTokenizer t1 = new StringTokenizer(v1, ".");
        if (v2.startsWith("V")) {
            v2 = v2.substring(1);
        }
        StringTokenizer t2 = new StringTokenizer(v2, ".");
        while (t1.hasMoreTokens() && t2.hasMoreTokens()) {
            int subV2;
            int subV1 = Integer.parseInt(t1.nextToken());
            if (subV1 < (subV2 = Integer.parseInt(t2.nextToken()))) {
                return -1;
            }
            if (subV1 <= subV2) continue;
            return 1;
        }
        if (t1.hasMoreTokens() && !t2.hasMoreTokens()) {
            return 1;
        }
        if (!t1.hasMoreTokens() && t2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public static int downloadJavaMod(File destination, SimpleProgessDialog bar) {
        try {
            URL javamod_url = new URL(JAVAMOD_URL);
            return Helpers.copyFromURL(javamod_url, destination, bar);
        }
        catch (Throwable ex) {
            Log.error("CheckForUpdate failed", ex);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFromURL(URL fromURL, File destination, SimpleProgessDialog bar) {
        int copied = 0;
        InputStream in = null;
        OutputStream out = null;
        try {
            if (destination.createNewFile()) {
                int len;
                URLConnection conn = fromURL.openConnection();
                if (bar != null) {
                    bar.setMinimum(0);
                    bar.setMaximum(conn.getContentLength());
                }
                in = new BufferedInputStream(conn.getInputStream());
                out = new BufferedOutputStream(new FileOutputStream(destination));
                byte[] input = new byte[8192];
                while ((len = in.read(input, 0, 8192)) != -1) {
                    out.write(input, 0, len);
                    copied += len;
                    if (bar == null) continue;
                    bar.setValue(copied);
                }
                out.flush();
            }
        }
        catch (Throwable ex) {
            Log.error("CopyFromURL failed", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        return copied;
    }

    /*
     * Opcode count of 13067 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        try {
            HOMEDIR = System.getProperty("user.home");
        }
        catch (Throwable throwable) {
            try {
                HOMEDIR = System.getProperty("java.io.tmpdir");
            }
            catch (Throwable ex2) {
                Log.error("Could not set home dir", ex2);
                HOMEDIR = "";
            }
        }
        noteStrings = new String[]{"C-", "C#", "D-", "D#", "E-", "F-", "F#", "G-", "G#", "A-", "A#", "H-"};
        noteValues = new int[]{6848, 6464, 6096, 5760, 5424, 5120, 4832, 4560, 4304, 4064, 3840, 3624, 3424, 3232, 3048, 2880, 2712, 2560, 2416, 2280, 2152, 2032, 1920, 1812, 1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016, 960, 907, 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113, 107, 101, 95, 90, 85, 80, 75, 71, 67, 63, 60, 56, 53, 50, 47, 45, 42, 40, 37, 35, 33, 31, 30, 28, 26, 25, 23, 22, 21, 20, 18, 17, 16, 15, 15, 14};
        protracker_fineTunedPeriods = new int[][]{{29024, 27392, 25840, 24416, 22992, 21696, 20480, 19328, 18240, 17216, 16272, 15376, 14512, 13696, 12928, 12192, 11520, 10848, 10240, 9664, 9120, 8608, 8128, 7680, 7248, 6848, 6464, 6096, 5760, 5424, 5120, 4832, 4560, 4304, 4064, 3840, 3616, 3424, 3232, 3040, 2880, 2720, 2560, 2416, 2288, 2160, 2032, 1920, 1808, 1712, 1616, 1520, 1440, 1360, 1264, 1200, 1136, 1072, 1024, 944, 896, 848, 800, 768, 704, 672, 624, 592, 560, 528, 512, 480}, {28816, 27200, 25648, 24240, 22816, 21536, 20336, 19184, 18112, 17104, 16160, 15264, 14400, 13600, 12832, 12112, 11440, 10800, 10176, 9616, 9072, 8560, 8080, 7632, 7200, 6800, 6416, 6064, 5712, 5392, 5088, 4800, 4544, 4288, 4048, 3808, 3600, 3392, 3200, 3024, 2864, 2704, 2544, 2400, 2272, 2144, 2016, 1904, 1808, 1696, 1600, 1520, 1424, 1344, 1264, 1200, 1120, 1056, 1008, 944, 896, 848, 784, 752, 704, 672, 624, 592, 560, 528, 512, 464}, {28608, 27008, 25456, 24064, 22656, 21392, 20176, 19040, 17984, 16976, 16048, 15152, 14304, 13504, 12736, 12032, 11344, 10720, 10112, 9552, 9008, 8512, 8032, 7584, 7152, 6752, 6368, 6016, 5680, 5360, 5056, 4768, 4512, 4256, 4016, 3792, 3568, 3376, 3184, 3008, 2832, 2672, 2528, 2384, 2256, 2128, 2000, 1888, 1792, 1680, 1584, 1504, 1424, 1344, 1248, 1184, 1120, 1056, 1008, 928, 880, 832, 784, 752, 704, 672, 624, 592, 544, 512, 496, 464}, {28400, 26800, 25280, 23888, 22496, 21232, 20032, 18912, 17856, 16848, 15920, 15040, 14192, 13408, 12656, 11936, 11264, 10640, 10048, 9472, 8944, 8448, 7968, 7520, 7104, 6704, 6320, 5968, 5632, 5312, 5024, 4736, 4480, 4224, 3984, 3760, 3552, 3344, 3168, 2992, 2816, 2656, 2512, 2368, 2240, 2112, 2000, 1888, 1776, 1680, 1568, 1488, 1408, 1328, 1248, 1184, 1104, 1040, 992, 928, 880, 832, 784, 752, 704, 656, 608, 576, 544, 512, 496, 464}, {28192, 26608, 25104, 23712, 22336, 21088, 19888, 18768, 17728, 16736, 15808, 14944, 14096, 13312, 12560, 11856, 11184, 10560, 9968, 9408, 8880, 8384, 7904, 7472, 7056, 6656, 6272, 5920, 5600, 5280, 4992, 4704, 4448, 4192, 3952, 3728, 3520, 3328, 3136, 2960, 2800, 2640, 2496, 2352, 2224, 2096, 1968, 1872, 1760, 1664, 1568, 1488, 1392, 1312, 1232, 1168, 1104, 1040, 992, 928, 880, 816, 768, 736, 688, 656, 608, 576, 544, 512, 496, 464}, {27984, 26416, 24912, 23552, 22176, 20928, 19744, 18640, 17600, 16608, 15696, 14832, 14000, 13216, 12464, 11776, 11104, 10480, 9904, 9344, 8816, 8320, 7856, 7408, 6992, 6608, 6240, 5888, 5552, 5248, 4944, 4672, 4416, 4160, 3920, 3712, 3504, 3296, 3120, 2944, 2784, 2624, 2480, 2336, 2208, 2080, 1968, 1856, 1744, 1648, 1552, 1472, 1392, 1312, 1232, 1168, 1088, 1024, 976, 912, 864, 816, 768, 736, 688, 656, 608, 576, 544, 512, 496, 464}, {27792, 26240, 24736, 23376, 22016, 20784, 19616, 18512, 17472, 16496, 15584, 14720, 13888, 13120, 12384, 11680, 11024, 10416, 9824, 9280, 8752, 8256, 7792, 7360, 6944, 6560, 6192, 5840, 5520, 5200, 4912, 4640, 4384, 4128, 3904, 3680, 3472, 3280, 3088, 2928, 2752, 2608, 2464, 2320, 2192, 2064, 1952, 1840, 1744, 1632, 1536, 1456, 1376, 1296, 1216, 1152, 1088, 1024, 976, 912, 864, 816, 768, 736, 688, 656, 608, 576, 528, 496, 480, 448}, {27584, 26048, 24560, 23200, 21856, 20624, 19472, 18368, 17344, 16368, 15472, 14624, 13792, 13024, 12288, 11600, 10944, 10336, 9760, 9200, 8688, 8208, 7744, 7312, 6896, 6512, 6144, 5808, 5472, 5168, 4880, 4608, 4352, 4096, 3872, 3648, 3456, 3248, 3072, 2896, 2736, 2576, 2432, 2304, 2176, 2048, 1936, 1824, 1728, 1632, 1536, 1456, 1376, 1296, 1216, 1152, 1072, 1008, 960, 896, 848, 800, 752, 720, 672, 640, 592, 560, 528, 496, 480, 448}, {27392, 25856, 24384, 23040, 21696, 20480, 19328, 18240, 17216, 16256, 15360, 14512, 13696, 12928, 12192, 11520, 10848, 10240, 9664, 9120, 8608, 8128, 7680, 7248, 6848, 6464, 6096, 5760, 5424, 5120, 4832, 4560, 4304, 4064, 3840, 3616, 3424, 3232, 3040, 2880, 2720, 2560, 2416, 2288, 2160, 2032, 1920, 1808, 1712, 1616, 1520, 1440, 1360, 1280, 1200, 1136, 1072, 1008, 960, 896, 848, 800, 752, 720, 672, 640, 592, 560, 528, 496, 480, 448}, {27200, 25664, 24208, 22880, 21536, 20336, 19184, 18112, 17088, 16144, 15248, 14400, 13600, 12832, 12112, 11440, 10784, 10192, 9616, 9072, 8560, 8080, 7632, 7200, 6800, 6416, 6064, 5712, 5392, 5088, 4800, 4544, 4288, 4048, 3824, 3600, 3408, 3216, 3024, 2864, 2704, 2544, 2400, 2272, 2144, 2016, 1904, 1808, 1696, 1600, 1504, 1424, 1344, 1264, 1184, 1120, 1072, 1008, 960, 896, 848, 800, 752, 720, 672, 640, 592, 560, 528, 496, 480, 448}, {26992, 25488, 24032, 22704, 21392, 20192, 19056, 17984, 16976, 16016, 15136, 14304, 13504, 12736, 12032, 11344, 10720, 10112, 9552, 9008, 8512, 8032, 7584, 7152, 6752, 6368, 6016, 5680, 5360, 5056, 4768, 4512, 4256, 4016, 3792, 3584, 3376, 3184, 3008, 2832, 2672, 2528, 2384, 2256, 2128, 2000, 1888, 1792, 1680, 1600, 1504, 1424, 1344, 1264, 1184, 1120, 1056, 992, 944, 880, 832, 784, 736, 704, 656, 624, 576, 544, 528, 496, 480, 448}, {26800, 25296, 23856, 22544, 21232, 20048, 18912, 17856, 16848, 15904, 15024, 14208, 13408, 12656, 11936, 11264, 10640, 10048, 9472, 8944, 8448, 7968, 7520, 7104, 6704, 6320, 5968, 5632, 5312, 5024, 4736, 4480, 4224, 3984, 3760, 3552, 3344, 3168, 2992, 2816, 2656, 2512, 2368, 2240, 2112, 2000, 1888, 1776, 1680, 1584, 1488, 1408, 1328, 1248, 1168, 1104, 1056, 992, 944, 880, 832, 784, 736, 704, 656, 624, 576, 544, 512, 480, 464, 432}, {26608, 25120, 23696, 22384, 21072, 19904, 18784, 17728, 16720, 15792, 14928, 14096, 13312, 12560, 11856, 11184, 10560, 9968, 9408, 8880, 8384, 7920, 7472, 7056, 6656, 6272, 5920, 5600, 5280, 4992, 4704, 4448, 4192, 3952, 3728, 3520, 3328, 3136, 2960, 2800, 2640, 2496, 2352, 2224, 2096, 1984, 1872, 1760, 1664, 1568, 1472, 1392, 1328, 1248, 1168, 1104, 1040, 976, 928, 864, 816, 784, 736, 704, 656, 624, 576, 544, 512, 480, 464, 432}, {26416, 24944, 23520, 22224, 20928, 19760, 18640, 17600, 16608, 15680, 14816, 14000, 13216, 12464, 11776, 11104, 10480, 9904, 9344, 8816, 8320, 7856, 7408, 6992, 6608, 6240, 5888, 5552, 5248, 4944, 4672, 4416, 4160, 3920, 3712, 3504, 3296, 3120, 2944, 2784, 2624, 2480, 2336, 2208, 2080, 1968, 1856, 1744, 1648, 1552, 1472, 1392, 1312, 1232, 1152, 1088, 1040, 976, 928, 864, 816, 768, 720, 688, 656, 624, 576, 544, 512, 480, 464, 432}, {26224, 24752, 23344, 22064, 20784, 19616, 18512, 17472, 16480, 15568, 14704, 13904, 13120, 12384, 11680, 11024, 10416, 9824, 9280, 8752, 8256, 7792, 7360, 6944, 6560, 6192, 5840, 5520, 5200, 4912, 4640, 4384, 4128, 3904, 3680, 3472, 3280, 3088, 2928, 2752, 2608, 2464, 2320, 2192, 2064, 1952, 1840, 1744, 1632, 1552, 1456, 1376, 1296, 1232, 1152, 1088, 1024, 960, 912, 864, 816, 768, 720, 688, 640, 608, 560, 544, 512, 480, 464, 432}, {26048, 24576, 23184, 21904, 20624, 19472, 18368, 17344, 16368, 15456, 14608, 13792, 13024, 12288, 11600, 10944, 10336, 9760, 9200, 8688, 8208, 7744, 7312, 6896, 6512, 6144, 5808, 5472, 5168, 4880, 4608, 4352, 4096, 3872, 3648, 3456, 3264, 3072, 2896, 2736, 2576, 2432, 2304, 2176, 2048, 1936, 1824, 1728, 1632, 1536, 1440, 1376, 1296, 1216, 1136, 1088, 1024, 960, 912, 848, 800, 768, 720, 688, 640, 608, 560, 528, 496, 464, 464, 432}};
        FreqS3MTable = new int[]{1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016, 960, 907};
        it_fineTuneTable = new int[]{7895, 7941, 7985, 8046, 8107, 8169, 8232, 8280, 8363, 8413, 8463, 8529, 8581, 8651, 8723, 8757};
        FineLinearSlideUpTable = new int[]{65536, 65595, 65654, 65714, 65773, 65832, 65892, 65951, 66011, 66071, 66130, 66190, 66250, 66309, 66369, 66429};
        FineLinearSlideDownTable = new int[]{65535, 65477, 65418, 65359, 65300, 65241, 65182, 65123, 65065, 65006, 64947, 64888, 64830, 64772, 64713, 64645};
        LinearSlideUpTable = new int[]{65536, 65773, 66010, 66249, 66489, 66729, 66971, 67213, 67456, 67700, 67945, 68190, 68437, 68685, 68933, 69182, 69432, 69684, 69936, 70189, 70442, 70697, 70953, 71209, 71467, 71725, 71985, 72245, 72507, 72769, 73032, 73296, 73561, 73827, 74094, 74362, 74631, 74901, 75172, 75444, 75717, 75991, 76265, 76541, 76818, 77096, 77375, 77655, 77935, 78217, 78500, 78784, 79069, 79355, 79642, 79930, 80219, 80509, 80800, 81093, 81386, 81680, 81976, 82272, 82570, 82868, 83168, 83469, 83771, 84074, 84378, 84683, 84989, 85297, 85605, 85915, 86225, 86537, 86850, 87164, 87480, 87796, 88113, 88432, 88752, 89073, 89395, 89718, 90043, 90369, 90695, 91023, 91353, 91683, 92015, 92347, 92681, 93017, 93353, 93691, 94029, 94370, 94711, 95053, 95397, 95742, 96088, 96436, 96785, 97135, 97486, 97839, 98193, 98548, 98904, 99262, 99621, 99981, 100343, 100706, 101070, 101435, 101802, 102170, 102540, 102911, 103283, 103657, 104031, 104408, 104785, 105164, 105545, 105926, 106309, 106694, 107080, 107467, 107856, 108246, 108637, 109030, 109425, 109820, 110217, 110616, 111016, 111418, 111821, 112225, 112631, 113038, 113447, 113857, 114269, 114682, 115097, 115514, 115931, 116351, 116771, 117194, 117618, 118043, 118470, 118898, 119328, 119760, 120193, 120628, 121064, 121502, 121941, 122382, 122825, 123269, 123715, 124162, 124611, 125062, 125514, 125968, 126424, 126881, 127340, 127801, 128263, 128727, 129192, 129660, 130129, 130599, 131072, 131546, 132021, 132499, 132978, 133459, 133942, 134426, 134912, 135400, 135890, 136381, 136875, 137370, 137866, 138365, 138865, 139368, 139872, 140378, 140885, 141395, 141906, 142419, 142935, 143451, 143970, 144491, 145014, 145538, 146064, 146593, 147123, 147655, 148189, 148725, 149263, 149803, 150344, 150888, 151434, 151982, 152531, 153083, 153637, 154192, 154750, 155310, 155871, 156435, 157001, 157569, 158138, 158710, 159284, 159860, 160439, 161019, 161601, 162186, 162772, 163361, 163952, 164545};
        LinearSlideDownTable = new int[]{65536, 65299, 65064, 64830, 64596, 64363, 64131, 63900, 63670, 63440, 63212, 62984, 62757, 62531, 62305, 62081, 61857, 61634, 61412, 61191, 60970, 60751, 60532, 60314, 60096, 59880, 59664, 59449, 59235, 59021, 58809, 58597, 58385, 58175, 57965, 57757, 57548, 57341, 57134, 56928, 56723, 56519, 56315, 56112, 55910, 55709, 55508, 55308, 55108, 54910, 54712, 54515, 54318, 54123, 53928, 53733, 53540, 53347, 53154, 52963, 52772, 52582, 52392, 52204, 52015, 51828, 51641, 51455, 51270, 51085, 50901, 50717, 50535, 50353, 50171, 49990, 49810, 49631, 49452, 49274, 49096, 48919, 48743, 48567, 48392, 48218, 48044, 47871, 47698, 47526, 47355, 47185, 47014, 46845, 46676, 46508, 46340, 46173, 46007, 45841, 45676, 45511, 45347, 45184, 45021, 44859, 44697, 44536, 44376, 44216, 44056, 43898, 43740, 43582, 43425, 43268, 43112, 42957, 42802, 42648, 42494, 42341, 42189, 42037, 41885, 41734, 41584, 41434, 41285, 41136, 40988, 40840, 40693, 40546, 40400, 40254, 40109, 39965, 39821, 39677, 39534, 39392, 39250, 39108, 38967, 38827, 38687, 38548, 38409, 38270, 38132, 37995, 37858, 37722, 37586, 37450, 37315, 37181, 37047, 36913, 36780, 36648, 36516, 36384, 36253, 36122, 35992, 35862, 35733, 35604, 35476, 35348, 35221, 35094, 34968, 34842, 34716, 34591, 34466, 34342, 34218, 34095, 33972, 33850, 33728, 33606, 33485, 33364, 33244, 33124, 33005, 32886, 32768, 32649, 32532, 32415, 32298, 32181, 32065, 31950, 31835, 31720, 31606, 31492, 31378, 31265, 31152, 31040, 30928, 30817, 30706, 30595, 30485, 30375, 30266, 30157, 30048, 29940, 29832, 29724, 29617, 29510, 29404, 29298, 29192, 29087, 28982, 28878, 28774, 28670, 28567, 28464, 28361, 28259, 28157, 28056, 27955, 27854, 27754, 27654, 27554, 27455, 27356, 27257, 27159, 27061, 26964, 26866, 26770, 26673, 26577, 26481, 26386, 26291, 26196, 26102};
        logtab = new int[]{116096, 115200, 114432, 113536, 112768, 112000, 111104, 110336, 109568, 108800, 108032, 107264, 106496, 105728, 104960, 104192, 103424, 102656, 101888, 101248, 100480, 99712, 99072, 98304, 97536, 96896, 96256, 95488, 94848, 94208, 93440, 92800, 92160, 91520, 90752, 90112, 89472, 88832, 88192, 87552, 86784, 86400, 85760, 85120, 84480, 83840, 83328, 82688, 81920, 81408, 80896, 80384, 79744, 79232, 78592, 78080, 77312, 76928, 76416, 75776, 75264, 74752, 74240, 73600, 72960, 72576, 72064, 71552, 71040, 70528, 70016, 69504, 68864, 68480, 68096, 67584, 67072, 66560, 66048, 65664, 65024, 64640, 64256, 63744, 63232, 62848, 62336, 61952, 61440, 61056, 60672, 60160, 59776, 59264, 58880, 58496, 57984, 57600, 57216, 56704, 56320, 55936, 55552, 55168, 54784};
        lintab = new int[]{535232, 534749, 534266, 533784, 533303, 532822, 532341, 531861, 531381, 530902, 530423, 529944, 529466, 528988, 528511, 528034, 527558, 527082, 526607, 526131, 525657, 525183, 524709, 524236, 523763, 523290, 522818, 522346, 521875, 521404, 520934, 520464, 519994, 519525, 519057, 518588, 518121, 517653, 517186, 516720, 516253, 515788, 515322, 514858, 514393, 513929, 513465, 513002, 512539, 512077, 511615, 511154, 510692, 510232, 509771, 509312, 508852, 508393, 507934, 507476, 507018, 506561, 506104, 505647, 505191, 504735, 504280, 503825, 503371, 502917, 502463, 502010, 501557, 501104, 500652, 500201, 499749, 499298, 498848, 498398, 497948, 497499, 497050, 496602, 496154, 495706, 495259, 494812, 494366, 493920, 493474, 493029, 492585, 492140, 491696, 491253, 490809, 490367, 489924, 489482, 489041, 488600, 488159, 487718, 487278, 486839, 486400, 485961, 485522, 485084, 484647, 484210, 483773, 483336, 482900, 482465, 482029, 481595, 481160, 480726, 480292, 479859, 479426, 478994, 478562, 478130, 477699, 477268, 476837, 476407, 475977, 475548, 475119, 474690, 474262, 473834, 473407, 472979, 472553, 472126, 471701, 471275, 470850, 470425, 470001, 469577, 469153, 468730, 468307, 467884, 467462, 467041, 466619, 466198, 465778, 465358, 464938, 464518, 464099, 463681, 463262, 462844, 462427, 462010, 461593, 461177, 460760, 460345, 459930, 459515, 459100, 458686, 458272, 457859, 457446, 457033, 456621, 456209, 455797, 455386, 454975, 454565, 454155, 453745, 453336, 452927, 452518, 452110, 451702, 451294, 450887, 450481, 450074, 449668, 449262, 448857, 448452, 448048, 447644, 447240, 446836, 446433, 446030, 445628, 445226, 444824, 444423, 444022, 443622, 443221, 442821, 442422, 442023, 441624, 441226, 440828, 440430, 440033, 439636, 439239, 438843, 438447, 438051, 437656, 437261, 436867, 436473, 436079, 435686, 435293, 434900, 434508, 434116, 433724, 433333, 432942, 432551, 432161, 431771, 431382, 430992, 430604, 430215, 429827, 429439, 429052, 428665, 428278, 427892, 427506, 427120, 426735, 426350, 425965, 425581, 425197, 424813, 424430, 424047, 423665, 423283, 422901, 422519, 422138, 421757, 421377, 420997, 420617, 420237, 419858, 419479, 419101, 418723, 418345, 417968, 417591, 417214, 416838, 416462, 416086, 415711, 415336, 414961, 414586, 414212, 413839, 413465, 413092, 412720, 412347, 411975, 411604, 411232, 410862, 410491, 410121, 409751, 409381, 409012, 408643, 408274, 407906, 407538, 407170, 406803, 406436, 406069, 405703, 405337, 404971, 404606, 404241, 403876, 403512, 403148, 402784, 402421, 402058, 401695, 401333, 400970, 400609, 400247, 399886, 399525, 399165, 398805, 398445, 398086, 397727, 397368, 397009, 396651, 396293, 395936, 395579, 395222, 394865, 394509, 394153, 393798, 393442, 393087, 392733, 392378, 392024, 391671, 391317, 390964, 390612, 390259, 389907, 389556, 389204, 388853, 388502, 388152, 387802, 387452, 387102, 386753, 386404, 386056, 385707, 385359, 385012, 384664, 384317, 383971, 383624, 383278, 382932, 382587, 382242, 381897, 381552, 381208, 380864, 380521, 380177, 379834, 379492, 379149, 378807, 378466, 378124, 377783, 377442, 377102, 376762, 376422, 376082, 375743, 375404, 375065, 374727, 374389, 374051, 373714, 373377, 373040, 372703, 372367, 372031, 371695, 371360, 371025, 370690, 370356, 370022, 369688, 369355, 369021, 368688, 368356, 368023, 367691, 367360, 367028, 366697, 366366, 366036, 365706, 365376, 365046, 364717, 364388, 364059, 363731, 363403, 363075, 362747, 362420, 362093, 361766, 361440, 361114, 360788, 360463, 360137, 359813, 359488, 359164, 358840, 358516, 358193, 357869, 357547, 357224, 356902, 356580, 356258, 355937, 355616, 355295, 354974, 354654, 354334, 354014, 353695, 353376, 353057, 352739, 352420, 352103, 351785, 351468, 351150, 350834, 350517, 350201, 349885, 349569, 349254, 348939, 348624, 348310, 347995, 347682, 347368, 347055, 346741, 346429, 346116, 345804, 345492, 345180, 344869, 344558, 344247, 343936, 343626, 343316, 343006, 342697, 342388, 342079, 341770, 341462, 341154, 340846, 340539, 340231, 339924, 339618, 339311, 339005, 338700, 338394, 338089, 337784, 337479, 337175, 336870, 336566, 336263, 335959, 335656, 335354, 335051, 334749, 334447, 334145, 333844, 333542, 333242, 332941, 332641, 332341, 332041, 331741, 331442, 331143, 330844, 330546, 330247, 329950, 329652, 329355, 329057, 328761, 328464, 328168, 327872, 327576, 327280, 326985, 326690, 326395, 326101, 325807, 325513, 325219, 324926, 324633, 324340, 324047, 323755, 323463, 323171, 322879, 322588, 322297, 322006, 321716, 321426, 321136, 320846, 320557, 320267, 319978, 319690, 319401, 319113, 318825, 318538, 318250, 317963, 317676, 317390, 317103, 316817, 316532, 316246, 315961, 315676, 315391, 315106, 314822, 314538, 314254, 313971, 313688, 313405, 313122, 312839, 312557, 312275, 311994, 311712, 311431, 311150, 310869, 310589, 310309, 310029, 309749, 309470, 309190, 308911, 308633, 308354, 308076, 307798, 307521, 307243, 306966, 306689, 306412, 306136, 305860, 305584, 305308, 305033, 304758, 304483, 304208, 303934, 303659, 303385, 303112, 302838, 302565, 302292, 302019, 301747, 301475, 301203, 300931, 300660, 300388, 300117, 299847, 299576, 299306, 299036, 298766, 298497, 298227, 297958, 297689, 297421, 297153, 296884, 296617, 296349, 296082, 295815, 295548, 295281, 295015, 294749, 294483, 294217, 293952, 293686, 293421, 293157, 292892, 292628, 292364, 292100, 291837, 291574, 291311, 291048, 290785, 290523, 290261, 289999, 289737, 289476, 289215, 288954, 288693, 288433, 288173, 287913, 287653, 287393, 287134, 286875, 286616, 286358, 286099, 285841, 285583, 285326, 285068, 284811, 284554, 284298, 284041, 283785, 283529, 283273, 283017, 282762, 282507, 282252, 281998, 281743, 281489, 281235, 280981, 280728, 280475, 280222, 279969, 279716, 279464, 279212, 278960, 278708, 278457, 278206, 277955, 277704, 277453, 277203, 276953, 276703, 276453, 276204, 275955, 275706, 275457, 275209, 274960, 274712, 274465, 274217, 273970, 273722, 273476, 273229, 272982, 272736, 272490, 272244, 271999, 271753, 271508, 271263, 271018, 270774, 270530, 270286, 270042, 269798, 269555, 269312, 269069, 268826, 268583, 268341, 268099, 267857};
        ModSinusTable = new int[]{0, 24, 49, 74, 97, 120, 141, 161, 180, 197, 212, 224, 235, 244, 250, 253, 255, 253, 250, 244, 235, 224, 212, 197, 180, 161, 141, 120, 97, 74, 49, 24, 0, -24, -49, -74, -97, -120, -141, -161, -180, -197, -212, -224, -235, -244, -250, -253, -255, -253, -250, -244, -235, -224, -212, -197, -180, -161, -141, -120, -97, -74, -49, -24};
        ModRampDownTable = new int[]{0, -8, -16, -24, -32, -40, -48, -56, -64, -72, -80, -88, -96, -104, -112, -120, -128, -136, -144, -152, -160, -168, -176, -184, -192, -200, -208, -216, -224, -232, -240, -248, 255, 247, 239, 231, 223, 215, 207, 199, 191, 183, 175, 167, 159, 151, 143, 135, 127, 119, 113, 103, 95, 87, 79, 71, 63, 55, 47, 39, 31, 23, 15, 7};
        ModSquareTable = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255, -255};
        ModRandomTable = new int[]{196, -254, -86, 176, 204, 82, -130, -188, 250, 40, -142, -172, -140, -64, -32, -192, 34, 144, 214, -10, 232, -138, -124, -80, 20, -122, 130, 218, -36, -76, -26, -152, -46, 176, 42, -188, 16, 212, 42, -224, 12, 218, 40, -176, -60, 18, -254, 236, 84, -68, 178, -8, -102, -144, 42, -58, 224, 246, 168, -202, -184, 196, -108, -190};
        ft2VibratoTable = new int[]{0, -2, -3, -5, -6, -8, -9, -11, -12, -14, -16, -17, -19, -20, -22, -23, -24, -26, -27, -29, -30, -32, -33, -34, -36, -37, -38, -39, -41, -42, -43, -44, -45, -46, -47, -48, -49, -50, -51, -52, -53, -54, -55, -56, -56, -57, -58, -59, -59, -60, -60, -61, -61, -62, -62, -62, -63, -63, -63, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64, -63, -63, -63, -62, -62, -62, -61, -61, -60, -60, -59, -59, -58, -57, -56, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -39, -38, -37, -36, -34, -33, -32, -30, -29, -27, -26, -24, -23, -22, -20, -19, -17, -16, -14, -12, -11, -9, -8, -6, -5, -3, -2, 0, 2, 3, 5, 6, 8, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23, 24, 26, 27, 29, 30, 32, 33, 34, 36, 37, 38, 39, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 56, 57, 58, 59, 59, 60, 60, 61, 61, 62, 62, 62, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 63, 63, 63, 62, 62, 62, 61, 61, 60, 60, 59, 59, 58, 57, 56, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 39, 38, 37, 36, 34, 33, 32, 30, 29, 27, 26, 24, 23, 22, 20, 19, 17, 16, 14, 12, 11, 9, 8, 6, 5, 3, 2};
    }
}

