/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.system;

import de.quippy.javamod.system.LogMessageCallBack;
import java.util.ArrayList;

public class Log {
    public static final int LOGLEVEL_NONE = 0;
    public static final int LOGLEVEL_INFO = 1;
    public static final int LOGLEVEL_ERROR = 2;
    public static final int LOGLEVEL_DEBUG = 4;
    public static final int LOGLEVEL_ALL = 7;
    private static ArrayList<LogMessageCallBack> logReceiver = new ArrayList();
    private static int currentLogLevel = 7;

    private Log() {
    }

    public static void setLogLevel(int newLogLevel) {
        currentLogLevel = newLogLevel;
    }

    public static boolean isLogLevel(int whatLogLevel) {
        return (currentLogLevel & whatLogLevel) != 0;
    }

    public static synchronized void addLogListener(LogMessageCallBack receiver) {
        if (!logReceiver.contains(receiver)) {
            logReceiver.add(receiver);
        }
    }

    public static synchronized void removeLogListener(LogMessageCallBack receiver) {
        logReceiver.remove(receiver);
    }

    public static synchronized void error(String message) {
        Log.error(message, null);
    }

    public static synchronized void error(String message, Throwable ex) {
        if (Log.isLogLevel(2)) {
            int size = logReceiver.size();
            for (int i = 0; i < size; ++i) {
                logReceiver.get(i).error(message, ex);
            }
            System.err.println(message);
            if (ex != null) {
                ex.printStackTrace(System.err);
                System.err.print('\n');
            }
        }
    }

    public static synchronized void info(String message) {
        if (Log.isLogLevel(1)) {
            int size = logReceiver.size();
            for (int i = 0; i < size; ++i) {
                logReceiver.get(i).info(message);
            }
            System.out.println(message);
        }
    }

    public static synchronized void debug(String message) {
        if (Log.isLogLevel(4)) {
            int size = logReceiver.size();
            for (int i = 0; i < size; ++i) {
                logReceiver.get(i).debug(message);
            }
            System.out.println(message);
        }
    }
}

