/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac;

import de.quippy.jflac.ChannelData;
import de.quippy.jflac.Constants;
import de.quippy.jflac.FrameDecodeException;
import de.quippy.jflac.FrameListener;
import de.quippy.jflac.FrameListeners;
import de.quippy.jflac.PCMProcessor;
import de.quippy.jflac.PCMProcessors;
import de.quippy.jflac.frame.BadHeaderException;
import de.quippy.jflac.frame.ChannelConstant;
import de.quippy.jflac.frame.ChannelFixed;
import de.quippy.jflac.frame.ChannelLPC;
import de.quippy.jflac.frame.ChannelVerbatim;
import de.quippy.jflac.frame.Frame;
import de.quippy.jflac.frame.Header;
import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.io.RandomFileInputStream;
import de.quippy.jflac.metadata.Application;
import de.quippy.jflac.metadata.CueSheet;
import de.quippy.jflac.metadata.Metadata;
import de.quippy.jflac.metadata.Padding;
import de.quippy.jflac.metadata.Picture;
import de.quippy.jflac.metadata.SeekPoint;
import de.quippy.jflac.metadata.SeekTable;
import de.quippy.jflac.metadata.StreamInfo;
import de.quippy.jflac.metadata.Unknown;
import de.quippy.jflac.metadata.VorbisComment;
import de.quippy.jflac.util.ByteData;
import de.quippy.jflac.util.CRC16;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class FLACDecoder {
    private static final int FRAME_FOOTER_CRC_LEN = 16;
    private static final byte[] ID3V2_TAG = new byte[]{73, 68, 51};
    private BitInputStream bitStream;
    private ChannelData[] channelData = new ChannelData[8];
    private int outputCapacity = 0;
    private int outputChannels = 0;
    private int lastFrameNumber;
    private long samplesDecoded = 0L;
    private StreamInfo streamInfo;
    private SeekTable seekTable;
    private VorbisComment vorbisComment;
    private Frame frame = new Frame();
    private byte[] headerWarmup = new byte[2];
    private int channels;
    private int channelAssignment;
    private int bitsPerSample;
    private int sampleRate;
    private int blockSize;
    private InputStream inputStream = null;
    private int badFrames;
    private boolean eof = false;
    private FrameListeners frameListeners = new FrameListeners();
    private PCMProcessors pcmProcessors = new PCMProcessors();

    public FLACDecoder(InputStream inputStream) {
        this.inputStream = inputStream;
        this.bitStream = new BitInputStream(inputStream);
        this.lastFrameNumber = 0;
        this.samplesDecoded = 0L;
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public SeekTable getSeekTable() {
        return this.seekTable;
    }

    public VorbisComment getVorbisComment() {
        return this.vorbisComment;
    }

    public ChannelData[] getChannelData() {
        return this.channelData;
    }

    public BitInputStream getBitInputStream() {
        return this.bitStream;
    }

    public Frame getCurrentFrame() {
        return this.frame;
    }

    public int getChannelAssignment() {
        return this.channelAssignment;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getLastFrameNumber() {
        return this.lastFrameNumber;
    }

    public long getSamplesDecoded() {
        return this.samplesDecoded;
    }

    public int getBadFrames() {
        return this.badFrames;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void addFrameListener(FrameListener listener) {
        this.frameListeners.addFrameListener(listener);
    }

    public void removeFrameListener(FrameListener listener) {
        this.frameListeners.removeFrameListener(listener);
    }

    public void addPCMProcessor(PCMProcessor processor) {
        this.pcmProcessors.addPCMProcessor(processor);
    }

    public void removePCMProcessor(PCMProcessor processor) {
        this.pcmProcessors.removePCMProcessor(processor);
    }

    private void callPCMProcessors(Frame frame) {
        ByteData bd = this.decodeFrame(frame, null);
        this.pcmProcessors.processPCM(bd);
    }

    public ByteData decodeFrame(Frame frame, ByteData pcmData) {
        block9: {
            block10: {
                block8: {
                    int byteSize = frame.header.blockSize * this.channels * ((this.streamInfo.getBitsPerSample() + 7) / 2);
                    if (pcmData == null || pcmData.getData().length < byteSize) {
                        pcmData = new ByteData(byteSize);
                    } else {
                        pcmData.setLen(0);
                    }
                    if (this.streamInfo.getBitsPerSample() != 8) break block8;
                    for (int i = 0; i < frame.header.blockSize; ++i) {
                        for (int channel = 0; channel < this.channels; ++channel) {
                            pcmData.append((byte)(this.channelData[channel].getOutput()[i] + 128));
                        }
                    }
                    break block9;
                }
                if (this.streamInfo.getBitsPerSample() != 16) break block10;
                for (int i = 0; i < frame.header.blockSize; ++i) {
                    for (int channel = 0; channel < this.channels; ++channel) {
                        short val = (short)this.channelData[channel].getOutput()[i];
                        pcmData.append((byte)(val & 0xFF));
                        pcmData.append((byte)(val >> 8 & 0xFF));
                    }
                }
                break block9;
            }
            if (this.streamInfo.getBitsPerSample() != 24) break block9;
            for (int i = 0; i < frame.header.blockSize; ++i) {
                for (int channel = 0; channel < this.channels; ++channel) {
                    int val = this.channelData[channel].getOutput()[i];
                    pcmData.append((byte)(val & 0xFF));
                    pcmData.append((byte)(val >> 8 & 0xFF));
                    pcmData.append((byte)(val >> 16 & 0xFF));
                }
            }
        }
        return pcmData;
    }

    public StreamInfo readStreamInfo() throws IOException {
        this.readStreamSync();
        Metadata metadata = this.readNextMetadata();
        if (!(metadata instanceof StreamInfo)) {
            throw new IOException("StreamInfo metadata block missing");
        }
        return (StreamInfo)metadata;
    }

    public Metadata[] readMetadata() throws IOException {
        Metadata metadata;
        this.readStreamSync();
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        do {
            metadata = this.readNextMetadata();
            metadataList.add(metadata);
        } while (!metadata.isLast());
        return metadataList.toArray(new Metadata[0]);
    }

    public Metadata[] readMetadata(StreamInfo streamInfo) throws IOException {
        Metadata metadata;
        if (streamInfo.isLast()) {
            return new Metadata[0];
        }
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        do {
            metadata = this.readNextMetadata();
            metadataList.add(metadata);
        } while (!metadata.isLast());
        return metadataList.toArray(new Metadata[0]);
    }

    public void decode() throws IOException {
        this.readMetadata();
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                }
            }
        }
        catch (EOFException e) {
            this.eof = true;
            return;
        }
    }

    public void decodeFrames() throws IOException {
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                }
            }
        }
        catch (EOFException e) {
            this.eof = true;
            return;
        }
    }

    public void decode(SeekPoint from, SeekPoint to) throws IOException {
        if (!(this.inputStream instanceof RandomFileInputStream)) {
            throw new IOException("Not a RandomFileInputStream: " + this.inputStream.getClass().getName());
        }
        ((RandomFileInputStream)this.inputStream).seek(from.getStreamOffset());
        this.bitStream.reset();
        this.samplesDecoded = from.getSampleNumber();
        try {
            do {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                }
            } while (to == null || this.samplesDecoded < to.getSampleNumber());
            return;
        }
        catch (EOFException e) {
            this.eof = true;
            return;
        }
    }

    public Frame readNextFrame() throws IOException {
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    return this.frame;
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                    continue;
                }
                break;
            }
        }
        catch (EOFException e) {
            this.eof = true;
            return null;
        }
    }

    public long getTotalBytesRead() {
        return this.bitStream.getTotalBytesRead();
    }

    private void allocateOutput(int size, int channels) {
        int i;
        if (size <= this.outputCapacity && channels <= this.outputChannels) {
            return;
        }
        for (i = 0; i < 8; ++i) {
            this.channelData[i] = null;
        }
        for (i = 0; i < channels; ++i) {
            this.channelData[i] = new ChannelData(size);
        }
        this.outputCapacity = size;
        this.outputChannels = channels;
    }

    private void readStreamSync() throws IOException {
        int id = 0;
        int i = 0;
        while (i < 4) {
            int x = this.bitStream.readRawUInt(8);
            if (x == Constants.STREAM_SYNC_STRING[i]) {
                ++i;
                id = 0;
                continue;
            }
            if (x == ID3V2_TAG[id]) {
                i = 0;
                if (++id != 3) continue;
                this.skipID3v2Tag();
                id = 0;
                continue;
            }
            throw new IOException("Could not find Stream Sync");
        }
    }

    public Metadata readNextMetadata() throws IOException {
        Metadata metadata = null;
        boolean isLast = this.bitStream.readRawUInt(1) != 0;
        int type = this.bitStream.readRawUInt(7);
        int length = this.bitStream.readRawUInt(24);
        if (type == 0) {
            metadata = this.streamInfo = new StreamInfo(this.bitStream, length, isLast);
            this.pcmProcessors.processStreamInfo((StreamInfo)metadata);
        } else if (type == 3) {
            this.seekTable = new SeekTable(this.bitStream, length, isLast);
            metadata = this.seekTable;
        } else if (type == 2) {
            metadata = new Application(this.bitStream, length, isLast);
        } else if (type == 1) {
            metadata = new Padding(this.bitStream, length, isLast);
        } else if (type == 4) {
            this.vorbisComment = new VorbisComment(this.bitStream, length, isLast);
            metadata = this.vorbisComment;
        } else {
            metadata = type == 5 ? new CueSheet(this.bitStream, length, isLast) : (type == 6 ? new Picture(this.bitStream, length, isLast) : new Unknown(this.bitStream, length, isLast));
        }
        this.frameListeners.processMetadata(metadata);
        return metadata;
    }

    private void skipID3v2Tag() throws IOException {
        this.bitStream.readRawInt(8);
        this.bitStream.readRawInt(8);
        this.bitStream.readRawInt(8);
        int skip = 0;
        for (int i = 0; i < 4; ++i) {
            int x = this.bitStream.readRawUInt(8);
            skip <<= 7;
            skip |= x & 0x7F;
        }
        this.bitStream.readByteBlockAlignedNoCRC(null, skip);
    }

    public void findFrameSync() throws IOException {
        boolean first = true;
        if (this.streamInfo != null && this.streamInfo.getTotalSamples() != 0L && this.samplesDecoded >= this.streamInfo.getTotalSamples()) {
            return;
        }
        if (!this.bitStream.isConsumedByteAligned()) {
            this.bitStream.readRawUInt(this.bitStream.bitsLeftForByteAlignment());
        }
        try {
            while (true) {
                int x;
                if ((x = this.bitStream.readRawUInt(8)) == 255) {
                    this.headerWarmup[0] = (byte)x;
                    x = this.bitStream.peekRawUInt(8);
                    if (x >> 2 == 62) {
                        this.headerWarmup[1] = (byte)this.bitStream.readRawUInt(8);
                        return;
                    }
                }
                if (!first) continue;
                this.frameListeners.processError("FindSync LOST_SYNC: " + Integer.toHexString(x & 0xFF));
                first = false;
            }
        }
        catch (EOFException e) {
            if (!first) {
                this.frameListeners.processError("FindSync LOST_SYNC: Left over data in file");
            }
            return;
        }
    }

    public Frame readFrame() throws IOException, FrameDecodeException {
        block24: {
            int channel;
            short frameCRC;
            block23: {
                frameCRC = 0;
                frameCRC = CRC16.update(this.headerWarmup[0], frameCRC);
                frameCRC = CRC16.update(this.headerWarmup[1], frameCRC);
                this.bitStream.resetReadCRC16(frameCRC);
                try {
                    this.frame.header = new Header(this.bitStream, this.headerWarmup, this.streamInfo);
                }
                catch (BadHeaderException e) {
                    this.frameListeners.processError("Found bad header: " + e);
                    throw new FrameDecodeException("Bad Frame Header: " + e);
                }
                this.allocateOutput(this.frame.header.blockSize, this.frame.header.channels);
                for (channel = 0; channel < this.frame.header.channels; ++channel) {
                    int bps = this.frame.header.bitsPerSample;
                    switch (this.frame.header.channelAssignment) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (channel != 1) break;
                            ++bps;
                            break;
                        }
                        case 2: {
                            if (channel != 0) break;
                            ++bps;
                            break;
                        }
                        case 3: {
                            if (channel != 1) break;
                            ++bps;
                            break;
                        }
                    }
                    try {
                        this.readSubframe(channel, bps);
                        continue;
                    }
                    catch (IOException e) {
                        this.frameListeners.processError("ReadSubframe: " + e);
                        throw e;
                    }
                }
                this.readZeroPadding();
                frameCRC = this.bitStream.getReadCRC16();
                this.frame.setCRC((short)this.bitStream.readRawUInt(16));
                if (frameCRC != this.frame.getCRC()) break block23;
                switch (this.frame.header.channelAssignment) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this.frame.header.blockSize; ++i) {
                            this.channelData[1].getOutput()[i] = this.channelData[0].getOutput()[i] - this.channelData[1].getOutput()[i];
                        }
                        break block24;
                    }
                    case 2: {
                        for (int i = 0; i < this.frame.header.blockSize; ++i) {
                            int[] nArray = this.channelData[0].getOutput();
                            int n = i;
                            nArray[n] = nArray[n] + this.channelData[1].getOutput()[i];
                        }
                        break block24;
                    }
                    case 3: {
                        for (int i = 0; i < this.frame.header.blockSize; ++i) {
                            int mid = this.channelData[0].getOutput()[i];
                            int side = this.channelData[1].getOutput()[i];
                            mid <<= 1;
                            if ((side & 1) != 0) {
                                ++mid;
                            }
                            int left = mid + side;
                            int right = mid - side;
                            this.channelData[0].getOutput()[i] = left >>> 1;
                            this.channelData[1].getOutput()[i] = right >>> 1;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            this.frameListeners.processError("CRC Error: " + Integer.toHexString(frameCRC & 0xFFFF) + " vs " + Integer.toHexString(this.frame.getCRC() & 0xFFFF));
            for (channel = 0; channel < this.frame.header.channels; ++channel) {
                for (int j = 0; j < this.frame.header.blockSize; ++j) {
                    this.channelData[channel].getOutput()[j] = 0;
                }
            }
        }
        this.channels = this.frame.header.channels;
        this.channelAssignment = this.frame.header.channelAssignment;
        this.bitsPerSample = this.frame.header.bitsPerSample;
        this.sampleRate = this.frame.header.sampleRate;
        this.blockSize = this.frame.header.blockSize;
        this.samplesDecoded += (long)this.frame.header.blockSize;
        return this.frame;
    }

    private void readSubframe(int channel, int bps) throws IOException, FrameDecodeException {
        int x = this.bitStream.readRawUInt(8);
        boolean haveWastedBits = (x & 1) != 0;
        x &= 0xFE;
        int wastedBits = 0;
        if (haveWastedBits) {
            wastedBits = this.bitStream.readUnaryUnsigned() + 1;
            bps -= wastedBits;
        }
        if ((x & 0x80) != 0) {
            this.frameListeners.processError("ReadSubframe LOST_SYNC: " + Integer.toHexString(x & 0xFF));
            throw new FrameDecodeException("ReadSubframe LOST_SYNC: " + Integer.toHexString(x & 0xFF));
        }
        if (x == 0) {
            this.frame.subframes[channel] = new ChannelConstant(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits);
        } else if (x == 2) {
            this.frame.subframes[channel] = new ChannelVerbatim(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits);
        } else {
            if (x < 16) {
                throw new FrameDecodeException("ReadSubframe Bad Subframe Type: " + Integer.toHexString(x & 0xFF));
            }
            if (x <= 24) {
                this.frame.subframes[channel] = new ChannelFixed(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits, x >> 1 & 7);
            } else {
                if (x < 64) {
                    throw new FrameDecodeException("ReadSubframe Bad Subframe Type: " + Integer.toHexString(x & 0xFF));
                }
                this.frame.subframes[channel] = new ChannelLPC(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits, (x >> 1 & 0x1F) + 1);
            }
        }
        if (haveWastedBits) {
            x = this.frame.subframes[channel].getWastedBits();
            int i = 0;
            while (i < this.frame.header.blockSize) {
                int[] nArray = this.channelData[channel].getOutput();
                int n = i++;
                nArray[n] = nArray[n] << x;
            }
        }
    }

    private void readZeroPadding() throws IOException, FrameDecodeException {
        int zero;
        if (!this.bitStream.isConsumedByteAligned() && (zero = this.bitStream.readRawUInt(this.bitStream.bitsLeftForByteAlignment())) != 0) {
            this.frameListeners.processError("ZeroPaddingError: " + Integer.toHexString(zero));
            throw new FrameDecodeException("ZeroPaddingError: " + Integer.toHexString(zero));
        }
    }

    public void seekTo(long seekToSamples) throws IOException {
        if (this.seekTable != null) {
            for (int s = 0; s < this.seekTable.numberOfPoints(); ++s) {
                SeekPoint p = this.seekTable.getSeekPoint(s);
                this.samplesDecoded = p.getSampleNumber();
                if (this.samplesDecoded < seekToSamples) continue;
                if (s > 0) {
                    p = this.seekTable.getSeekPoint(s - 1);
                }
                this.samplesDecoded = p.getSampleNumber();
                this.bitStream.skip(p.getStreamOffset());
                break;
            }
        }
        while (this.samplesDecoded < seekToSamples) {
            try {
                this.findFrameSync();
                this.readFrame();
                if (this.frame == null || this.frame.header == null) continue;
                this.samplesDecoded = this.frame.header.sampleNumber;
                if (this.samplesDecoded + (long)this.frame.header.blockSize < seekToSamples) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }
}

