/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.metadata.Metadata;
import de.quippy.jflac.metadata.VorbisString;
import java.io.IOException;
import java.util.ArrayList;

public class VorbisComment
extends Metadata {
    private static final String EMPTY_STRING = "";
    protected byte[] vendorString = new byte[0];
    protected int numComments = 0;
    protected VorbisString[] comments;

    public VorbisComment(BitInputStream is, int length, boolean isLast) throws IOException {
        super(isLast);
        int len = is.readRawIntLittleEndian();
        this.vendorString = new byte[len];
        is.readByteBlockAlignedNoCRC(this.vendorString, this.vendorString.length);
        this.numComments = is.readRawIntLittleEndian();
        if (this.numComments > 0) {
            this.comments = new VorbisString[this.numComments];
        }
        for (int i = 0; i < this.numComments; ++i) {
            this.comments[i] = new VorbisString(is);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VendorString '").append(new String(this.vendorString)).append("'\n");
        sb.append("VorbisComment (count=" + this.numComments + ")");
        for (int i = 0; i < this.numComments; ++i) {
            sb.append("\n\t" + this.comments[i].toString());
        }
        return sb.toString();
    }

    public String[] getCommentByName(String key) {
        if (key == null) {
            return null;
        }
        ArrayList<String> sbuff = new ArrayList<String>();
        for (int i = 0; i < this.comments.length; ++i) {
            String comment = this.comments[i].toString();
            int eqpos = comment.indexOf(61);
            if (eqpos == -1 || !comment.substring(0, eqpos).equalsIgnoreCase(key)) continue;
            sbuff.add(comment.substring(eqpos + 1, comment.length()));
        }
        return sbuff.toArray(new String[0]);
    }

    public String getComment() {
        String[] v = this.getCommentByName("COMMENT");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getGenre() {
        String[] v = this.getCommentByName("GENRE");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getDate() {
        String[] v = this.getCommentByName("DATE");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getAlbum() {
        String[] v = this.getCommentByName("ALBUM");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getTotalDiscs() {
        String[] v = this.getCommentByName("TOTALDISCS");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getDiscNumber() {
        String[] v = this.getCommentByName("DISCNUMBER");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getTotalTracks() {
        String[] v = this.getCommentByName("TOTALTRACKS");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getTrackNumber() {
        String[] v = this.getCommentByName("TRACKNUMBER");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getTitle() {
        String[] v = this.getCommentByName("TITLE");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }

    public String getArtist() {
        String[] v = this.getCommentByName("ARTIST");
        if (v != null && v.length > 0 && v[0] != null) {
            return v[0];
        }
        return EMPTY_STRING;
    }
}

