/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.decoder.UnMAC;
import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEInfo;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.info.WaveHeader;
import de.quippy.jmac.tools.ByteBuffer;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.IOException;
import java.util.Arrays;

public class APEDecompressOld
extends IAPEDecompress {
    protected byte[] m_spBuffer;
    protected int m_nBufferTail;
    protected ByteBuffer output = new ByteBuffer();
    protected int m_nBlockAlign;
    protected int m_nCurrentFrame;
    protected int m_nStartBlock;
    protected int m_nFinishBlock;
    protected int m_nCurrentBlock;
    protected boolean m_bIsRanged;
    protected UnMAC m_UnMAC = new UnMAC();
    protected APEInfo m_spAPEInfo;
    protected boolean m_bDecompressorInitialized;

    public APEDecompressOld(APEInfo pAPEInfo) {
        this(pAPEInfo, -1, -1);
    }

    public APEDecompressOld(APEInfo pAPEInfo, int nStartBlock) {
        this(pAPEInfo, nStartBlock, -1);
    }

    public APEDecompressOld(APEInfo pAPEInfo, int nStartBlock, int nFinishBlock) {
        this.m_spAPEInfo = pAPEInfo;
        if (this.getApeInfoFileVersion() > 3920) {
            throw new JMACException("Wrong Version");
        }
        this.m_nBlockAlign = this.getApeInfoBlockAlign();
        this.m_nBufferTail = 0;
        this.m_bDecompressorInitialized = false;
        this.m_nCurrentFrame = 0;
        this.m_nCurrentBlock = 0;
        this.m_nStartBlock = nStartBlock < 0 ? 0 : Math.min(nStartBlock, this.getApeInfoTotalBlocks());
        this.m_nFinishBlock = nFinishBlock < 0 ? this.getApeInfoTotalBlocks() : Math.min(nFinishBlock, this.getApeInfoTotalBlocks());
        this.m_bIsRanged = this.m_nStartBlock != 0 || this.m_nFinishBlock != this.getApeInfoTotalBlocks();
    }

    @Override
    public int GetData(byte[] pBuffer, int nBlocks) throws IOException {
        int nTotalBytesNeeded;
        this.InitializeDecompressor();
        int nBlocksUntilFinish = this.m_nFinishBlock - this.m_nCurrentBlock;
        nBlocks = Math.min(nBlocks, nBlocksUntilFinish);
        int nBlocksRetrieved = 0;
        int nBytesLeft = nTotalBytesNeeded = nBlocks * this.m_nBlockAlign;
        int nBlocksDecoded = 1;
        while (nBytesLeft > 0 && nBlocksDecoded > 0) {
            int nBytesAvailable = this.m_nBufferTail;
            int nIntialBytes = Math.min(nBytesLeft, nBytesAvailable);
            if (nIntialBytes > 0) {
                System.arraycopy(this.m_spBuffer, 0, pBuffer, nTotalBytesNeeded - nBytesLeft, nIntialBytes);
                if (this.m_nBufferTail - nIntialBytes > 0) {
                    System.arraycopy(this.m_spBuffer, nIntialBytes, this.m_spBuffer, 0, this.m_nBufferTail - nIntialBytes);
                }
                nBytesLeft -= nIntialBytes;
                this.m_nBufferTail -= nIntialBytes;
            }
            if (nBytesLeft <= 0) continue;
            this.output.reset(this.m_spBuffer, this.m_nBufferTail);
            nBlocksDecoded = this.m_UnMAC.DecompressFrame(this.output, this.m_nCurrentFrame++);
            this.m_nBufferTail += nBlocksDecoded * this.m_nBlockAlign;
        }
        nBlocksRetrieved = (nTotalBytesNeeded - nBytesLeft) / this.m_nBlockAlign;
        this.m_nCurrentBlock += nBlocksRetrieved;
        return nBlocksRetrieved;
    }

    @Override
    public void Seek(int nBlockOffset) throws IOException {
        this.InitializeDecompressor();
        if ((nBlockOffset += this.m_nStartBlock) >= this.m_nFinishBlock) {
            nBlockOffset = this.m_nFinishBlock - 1;
        }
        if (nBlockOffset < this.m_nStartBlock) {
            nBlockOffset = this.m_nStartBlock;
        }
        this.m_nBufferTail = 0;
        int nBaseFrame = nBlockOffset / this.getApeInfoBlocksPerFrame();
        int nBlocksToSkip = nBlockOffset % this.getApeInfoBlocksPerFrame();
        int nBytesToSkip = nBlocksToSkip * this.m_nBlockAlign;
        int nMaximumDecompressedFrameBytes = this.m_nBlockAlign * this.getApeInfoBlocksPerFrame();
        byte[] pTempBuffer = new byte[nMaximumDecompressedFrameBytes + 16];
        Arrays.fill(pTempBuffer, (byte)0);
        this.m_nCurrentFrame = nBaseFrame;
        this.output.reset(pTempBuffer);
        int nBlocksDecoded = this.m_UnMAC.DecompressFrame(this.output, this.m_nCurrentFrame++);
        if (nBlocksDecoded == -1) {
            throw new JMACException("Error While Decoding");
        }
        int nBytesToKeep = nBlocksDecoded * this.m_nBlockAlign - nBytesToSkip;
        System.arraycopy(pTempBuffer, nBytesToSkip, this.m_spBuffer, this.m_nBufferTail, nBytesToKeep);
        this.m_nBufferTail += nBytesToKeep;
        this.m_nCurrentBlock = nBlockOffset;
    }

    protected void InitializeDecompressor() throws IOException {
        if (this.m_bDecompressorInitialized) {
            return;
        }
        this.m_UnMAC.Initialize(this);
        int nMaximumDecompressedFrameBytes = this.m_nBlockAlign * this.getApeInfoBlocksPerFrame();
        int nTotalBufferBytes = Math.max(65536, (nMaximumDecompressedFrameBytes + 16) * 2);
        this.m_spBuffer = new byte[nTotalBufferBytes];
        this.m_bDecompressorInitialized = true;
        this.Seek(0);
    }

    @Override
    public int getApeInfoDecompressCurrentBlock() {
        return this.m_nCurrentBlock - this.m_nStartBlock;
    }

    @Override
    public int getApeInfoDecompressCurrentMS() {
        int nSampleRate = this.m_spAPEInfo.getApeInfoSampleRate();
        if (nSampleRate > 0) {
            return (int)((long)this.m_nCurrentBlock * 1000L / (long)nSampleRate);
        }
        return 0;
    }

    @Override
    public int getApeInfoDecompressTotalBlocks() {
        return this.m_nFinishBlock - this.m_nStartBlock;
    }

    @Override
    public int getApeInfoDecompressLengthMS() {
        int nSampleRate = this.m_spAPEInfo.getApeInfoSampleRate();
        if (nSampleRate > 0) {
            return (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)nSampleRate);
        }
        return 0;
    }

    @Override
    public int getApeInfoDecompressCurrentBitRate() throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(this.m_nCurrentFrame);
    }

    @Override
    public int getApeInfoDecompressAverageBitrate() throws IOException {
        if (this.m_bIsRanged) {
            int nBlocksPerFrame = this.m_spAPEInfo.getApeInfoBlocksPerFrame();
            int nStartFrame = this.m_nStartBlock / nBlocksPerFrame;
            int nFinishFrame = (this.m_nFinishBlock + nBlocksPerFrame - 1) / nBlocksPerFrame;
            int nTotalBytes = this.m_spAPEInfo.getApeInfoFrameBytes(nStartFrame) * (this.m_nStartBlock % nBlocksPerFrame) / nBlocksPerFrame;
            if (nFinishFrame != nStartFrame) {
                nTotalBytes += this.m_spAPEInfo.getApeInfoFrameBytes(nFinishFrame) * (this.m_nFinishBlock % nBlocksPerFrame) / nBlocksPerFrame;
            }
            int nTotalFrames = this.m_spAPEInfo.getApeInfoTotalFrames();
            for (int nFrame = nStartFrame + 1; nFrame < nFinishFrame && nFrame < nTotalFrames; ++nFrame) {
                nTotalBytes += this.m_spAPEInfo.getApeInfoFrameBytes(nFrame);
            }
            int nTotalMS = (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)this.m_spAPEInfo.getApeInfoSampleRate());
            if (nTotalMS != 0) {
                return nTotalBytes * 8 / nTotalMS;
            }
        } else {
            return this.m_spAPEInfo.getApeInfoAverageBitrate();
        }
        return 0;
    }

    @Override
    public int getApeInfoWavHeaderBytes() {
        if (this.m_bIsRanged) {
            return 44;
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderBytes();
    }

    @Override
    public byte[] getApeInfoWavHeaderData(int nMaxBytes) {
        if (this.m_bIsRanged) {
            if (44 > nMaxBytes) {
                return null;
            }
            WaveFormat wfeFormat = this.m_spAPEInfo.getApeInfoWaveFormatEx();
            WaveHeader WAVHeader = new WaveHeader();
            WaveHeader.FillWaveHeader(WAVHeader, (this.m_nFinishBlock - this.m_nStartBlock) * this.m_spAPEInfo.getApeInfoBlockAlign(), wfeFormat, 0);
            return WAVHeader.write();
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderData(nMaxBytes);
    }

    @Override
    public int getApeInfoWavTerminatingBytes() {
        if (this.m_bIsRanged) {
            return 0;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingBytes();
    }

    @Override
    public byte[] getApeInfoWavTerminatingData(int nMaxBytes) throws IOException {
        if (this.m_bIsRanged) {
            return null;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingData(nMaxBytes);
    }

    @Override
    public WaveFormat getApeInfoWaveFormatEx() {
        return this.m_spAPEInfo.getApeInfoWaveFormatEx();
    }

    @Override
    public File getApeInfoIoSource() {
        return this.m_spAPEInfo.getApeInfoIoSource();
    }

    @Override
    public int getApeInfoBlocksPerFrame() {
        return this.m_spAPEInfo.getApeInfoBlocksPerFrame();
    }

    @Override
    public int getApeInfoFileVersion() {
        return this.m_spAPEInfo.getApeInfoFileVersion();
    }

    @Override
    public int getApeInfoCompressionLevel() {
        return this.m_spAPEInfo.getApeInfoCompressionLevel();
    }

    @Override
    public int getApeInfoFormatFlags() {
        return this.m_spAPEInfo.getApeInfoFormatFlags();
    }

    @Override
    public int getApeInfoSampleRate() {
        return this.m_spAPEInfo.getApeInfoSampleRate();
    }

    @Override
    public int getApeInfoBitsPerSample() {
        return this.m_spAPEInfo.getApeInfoBitsPerSample();
    }

    @Override
    public int getApeInfoBytesPerSample() {
        return this.m_spAPEInfo.getApeInfoBytesPerSample();
    }

    @Override
    public int getApeInfoChannels() {
        return this.m_spAPEInfo.getApeInfoChannels();
    }

    @Override
    public int getApeInfoBlockAlign() {
        return this.m_spAPEInfo.getApeInfoBlockAlign();
    }

    @Override
    public int getApeInfoFinalFrameBlocks() {
        return this.m_spAPEInfo.getApeInfoFinalFrameBlocks();
    }

    @Override
    public int getApeInfoTotalFrames() {
        return this.m_spAPEInfo.getApeInfoTotalFrames();
    }

    @Override
    public int getApeInfoWavDataBytes() {
        return this.m_spAPEInfo.getApeInfoWavDataBytes();
    }

    @Override
    public int getApeInfoWavTotalBytes() {
        return this.m_spAPEInfo.getApeInfoWavTotalBytes();
    }

    @Override
    public int getApeInfoApeTotalBytes() {
        return this.m_spAPEInfo.getApeInfoApeTotalBytes();
    }

    @Override
    public int getApeInfoTotalBlocks() {
        return this.m_spAPEInfo.getApeInfoTotalBlocks();
    }

    @Override
    public int getApeInfoLengthMs() {
        return this.m_spAPEInfo.getApeInfoLengthMs();
    }

    @Override
    public int getApeInfoAverageBitrate() {
        return this.m_spAPEInfo.getApeInfoAverageBitrate();
    }

    @Override
    public int getApeInfoSeekByte(int nFrame) {
        return this.m_spAPEInfo.getApeInfoSeekByte(nFrame);
    }

    @Override
    public int getApeInfoFrameBytes(int nFrame) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBytes(nFrame);
    }

    @Override
    public int getApeInfoFrameBlocks(int nFrame) {
        return this.m_spAPEInfo.getApeInfoFrameBlocks(nFrame);
    }

    @Override
    public int getApeInfoFrameBitrate(int nFrame) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(nFrame);
    }

    @Override
    public int getApeInfoDecompressedBitrate() {
        return this.m_spAPEInfo.getApeInfoDecompressedBitrate();
    }

    @Override
    public int getApeInfoPeakLevel() {
        return this.m_spAPEInfo.getApeInfoPeakLevel();
    }

    @Override
    public int getApeInfoSeekBit(int nFrame) {
        return this.m_spAPEInfo.getApeInfoSeekBit(nFrame);
    }

    @Override
    public APETag getApeInfoTag() {
        return this.m_spAPEInfo.getApeInfoTag();
    }

    @Override
    public APEFileInfo getApeInfoInternalInfo() {
        return this.m_spAPEInfo.getApeInfoInternalInfo();
    }
}

