/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.APEDecompress;
import de.quippy.jmac.decoder.APEDecompressOld;
import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEInfo;
import de.quippy.jmac.info.APELink;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class IAPEDecompress {
    public abstract int GetData(byte[] var1, int var2) throws IOException;

    public abstract void Seek(int var1) throws IOException;

    public abstract int getApeInfoDecompressCurrentBlock();

    public abstract int getApeInfoDecompressCurrentMS();

    public abstract int getApeInfoDecompressTotalBlocks();

    public abstract int getApeInfoDecompressLengthMS();

    public abstract int getApeInfoDecompressCurrentBitRate() throws IOException;

    public abstract int getApeInfoDecompressAverageBitrate() throws IOException;

    public abstract File getApeInfoIoSource();

    public abstract int getApeInfoBlocksPerFrame();

    public abstract int getApeInfoFileVersion();

    public abstract int getApeInfoCompressionLevel();

    public abstract int getApeInfoFormatFlags();

    public abstract int getApeInfoSampleRate();

    public abstract int getApeInfoBitsPerSample();

    public abstract int getApeInfoBytesPerSample();

    public abstract int getApeInfoChannels();

    public abstract int getApeInfoBlockAlign();

    public abstract int getApeInfoFinalFrameBlocks();

    public abstract int getApeInfoTotalFrames();

    public abstract int getApeInfoWavHeaderBytes();

    public abstract int getApeInfoWavTerminatingBytes();

    public abstract int getApeInfoWavDataBytes();

    public abstract int getApeInfoWavTotalBytes();

    public abstract int getApeInfoApeTotalBytes();

    public abstract int getApeInfoTotalBlocks();

    public abstract int getApeInfoLengthMs();

    public abstract int getApeInfoAverageBitrate();

    public abstract int getApeInfoSeekByte(int var1);

    public abstract int getApeInfoFrameBytes(int var1) throws IOException;

    public abstract int getApeInfoFrameBlocks(int var1);

    public abstract int getApeInfoFrameBitrate(int var1) throws IOException;

    public abstract int getApeInfoDecompressedBitrate();

    public abstract int getApeInfoPeakLevel();

    public abstract int getApeInfoSeekBit(int var1);

    public abstract WaveFormat getApeInfoWaveFormatEx();

    public abstract byte[] getApeInfoWavHeaderData(int var1);

    public abstract APETag getApeInfoTag();

    public abstract byte[] getApeInfoWavTerminatingData(int var1) throws IOException;

    public abstract APEFileInfo getApeInfoInternalInfo();

    public static IAPEDecompress CreateIAPEDecompressCore(APEInfo pAPEInfo, int nStartBlock, int nFinishBlock) {
        IAPEDecompress pAPEDecompress = null;
        if (pAPEInfo != null) {
            pAPEDecompress = pAPEInfo.getApeInfoFileVersion() >= 3930 ? new APEDecompress(pAPEInfo, nStartBlock, nFinishBlock) : new APEDecompressOld(pAPEInfo, nStartBlock, nFinishBlock);
        }
        return pAPEDecompress;
    }

    public static APEInfo CreateAPEInfo(File in) throws IOException {
        APEInfo pAPEInfo = null;
        if (in.isLocal()) {
            String pExtension = in.getExtension();
            if (pExtension.toLowerCase().equals(".mac") || pExtension.toLowerCase().equals(".ape")) {
                pAPEInfo = new APEInfo(in);
            }
        } else {
            pAPEInfo = new APEInfo(in);
        }
        if (pAPEInfo == null) {
            throw new JMACException("Invalid Input File");
        }
        return pAPEInfo;
    }

    public static IAPEDecompress CreateIAPEDecompress(File in) throws IOException {
        APEInfo pAPEInfo = null;
        int nStartBlock = -1;
        int nFinishBlock = -1;
        if (in.isLocal()) {
            String pFilename = in.getFilename();
            String pExtension = in.getExtension();
            if (pExtension.toLowerCase().equals(".apl")) {
                APELink APELink2 = new APELink(pFilename);
                if (APELink2.GetIsLinkFile()) {
                    URL url = null;
                    try {
                        url = new URL(APELink2.GetImageFilename());
                        pAPEInfo = new APEInfo(url);
                    }
                    catch (MalformedURLException e) {
                        pAPEInfo = new APEInfo(new java.io.File(APELink2.GetImageFilename()));
                    }
                    nStartBlock = APELink2.GetStartBlock();
                    nFinishBlock = APELink2.GetFinishBlock();
                }
            } else if (pExtension.toLowerCase().equals(".mac") || pExtension.toLowerCase().equals(".ape")) {
                pAPEInfo = new APEInfo(in);
            }
        } else {
            pAPEInfo = new APEInfo(in);
        }
        if (pAPEInfo == null) {
            throw new JMACException("Invalid Input File");
        }
        IAPEDecompress pAPEDecompress = IAPEDecompress.CreateIAPEDecompressCore(pAPEInfo, nStartBlock, nFinishBlock);
        return pAPEDecompress;
    }

    public static IAPEDecompress CreateIAPEDecompressEx(APEInfo pAPEInfo, int nStartBlock, int nFinishBlock) {
        return IAPEDecompress.CreateIAPEDecompressCore(pAPEInfo, nStartBlock, nFinishBlock);
    }
}

