/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.RangeCoderStructDecompress;
import de.quippy.jmac.decoder.UnBitArrayBase;
import de.quippy.jmac.decoder.UnBitArrayState;
import de.quippy.jmac.tools.File;
import java.io.IOException;

public class UnBitArray
extends UnBitArrayBase {
    private static final long[] RANGE_TOTAL_1 = new long[]{0L, 14824L, 28224L, 39348L, 47855L, 53994L, 58171L, 60926L, 62682L, 63786L, 64463L, 64878L, 65126L, 65276L, 65365L, 65419L, 65450L, 65469L, 65480L, 65487L, 65491L, 65493L, 65494L, 65495L, 65496L, 65497L, 65498L, 65499L, 65500L, 65501L, 65502L, 65503L, 65504L, 65505L, 65506L, 65507L, 65508L, 65509L, 65510L, 65511L, 65512L, 65513L, 65514L, 65515L, 65516L, 65517L, 65518L, 65519L, 65520L, 65521L, 65522L, 65523L, 65524L, 65525L, 65526L, 65527L, 65528L, 65529L, 65530L, 65531L, 65532L, 65533L, 65534L, 65535L, 65536L};
    private static final long[] RANGE_WIDTH_1 = new long[]{14824L, 13400L, 11124L, 8507L, 6139L, 4177L, 2755L, 1756L, 1104L, 677L, 415L, 248L, 150L, 89L, 54L, 31L, 19L, 11L, 7L, 4L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L};
    private static final long[] RANGE_TOTAL_2 = new long[]{0L, 19578L, 36160L, 48417L, 56323L, 60899L, 63265L, 64435L, 64971L, 65232L, 65351L, 65416L, 65447L, 65466L, 65476L, 65482L, 65485L, 65488L, 65490L, 65491L, 65492L, 65493L, 65494L, 65495L, 65496L, 65497L, 65498L, 65499L, 65500L, 65501L, 65502L, 65503L, 65504L, 65505L, 65506L, 65507L, 65508L, 65509L, 65510L, 65511L, 65512L, 65513L, 65514L, 65515L, 65516L, 65517L, 65518L, 65519L, 65520L, 65521L, 65522L, 65523L, 65524L, 65525L, 65526L, 65527L, 65528L, 65529L, 65530L, 65531L, 65532L, 65533L, 65534L, 65535L, 65536L};
    private static final long[] RANGE_WIDTH_2 = new long[]{19578L, 16582L, 12257L, 7906L, 4576L, 2366L, 1170L, 536L, 261L, 119L, 65L, 31L, 19L, 10L, 6L, 3L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L};
    private static final long[] K_SUM_MIN_BOUNDARY = new long[]{0L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0L, 0L, 0L, 0L};
    private static final long CODE_BITS = 32L;
    private static final long TOP_VALUE = 0x80000000L;
    private static final long EXTRA_BITS = 7L;
    private static final long BOTTOM_VALUE = 0x800000L;
    private static final int RANGE_OVERFLOW_SHIFT = 16;
    private static final int MODEL_ELEMENTS = 64;
    private UnBitArrayState GenerateArrayRangeBitArrayState = new UnBitArrayState();
    private RangeCoderStructDecompress m_RangeCoderInfo = new RangeCoderStructDecompress();
    private long m_nRefillBitThreshold;

    public UnBitArray(File pIO, int nVersion) {
        this.CreateHelper(pIO, 16384, nVersion);
    }

    @Override
    public long DecodeValue(int DecodeMethod, int nParam1, int nParam2) throws IOException {
        if (DecodeMethod == 0) {
            return this.DecodeValueXBits(32L);
        }
        return 0L;
    }

    @Override
    public void GenerateArray(int[] pOutputArray, int nElements) throws IOException {
        this.GenerateArray(pOutputArray, nElements, -1);
    }

    @Override
    public void GenerateArray(int[] pOutputArray, int nElements, int nBytesRequired) throws IOException {
        this.GenerateArrayRange(pOutputArray, nElements);
    }

    @Override
    public int DecodeValueRange(UnBitArrayState BitArrayState) throws IOException {
        if (this.m_nCurrentBitIndex > this.m_nRefillBitThreshold) {
            this.FillBitArray();
        }
        int nValue = 0;
        if (this.m_nVersion >= 3990) {
            int nPivotValue = Math.max(BitArrayState.nKSum / 32, 1);
            int nOverflow = 0;
            int nRangeTotal = this.RangeDecodeFast(16);
            long[] al1 = RANGE_TOTAL_2;
            if (nRangeTotal > 65416) {
                int low = 12;
                nOverflow = 64;
                int mid = 38;
                long midVal = al1[38];
                do {
                    if (midVal < (long)nRangeTotal) {
                        low = mid + 1;
                    } else {
                        if (midVal <= (long)nRangeTotal) {
                            nOverflow = mid;
                            break;
                        }
                        nOverflow = mid - 1;
                    }
                    mid = low + nOverflow >>> 1;
                    midVal = al1[mid];
                } while (low <= nOverflow);
            } else {
                nOverflow = 1;
                while ((long)nRangeTotal >= al1[nOverflow]) {
                    ++nOverflow;
                }
                --nOverflow;
            }
            RangeCoderStructDecompress range = this.m_RangeCoderInfo;
            range.low -= range.range * al1[nOverflow];
            range.range *= RANGE_WIDTH_2[nOverflow];
            if (nOverflow == 63) {
                nOverflow = this.RangeDecodeFastWithUpdate(16);
                nOverflow <<= 16;
                nOverflow |= this.RangeDecodeFastWithUpdate(16);
            }
            int nBase = 0;
            if (nPivotValue >= 65536) {
                int nPivotValueBits = 0;
                while (nPivotValue >> nPivotValueBits > 0) {
                    ++nPivotValueBits;
                }
                int nSplitFactor = 1 << nPivotValueBits - 16;
                int nPivotValueA = nPivotValue / nSplitFactor + 1;
                int nPivotValueB = nSplitFactor;
                RangeCoderStructDecompress range2 = this.m_RangeCoderInfo;
                while (range2.range <= 0x800000L) {
                    range2.buffer = range2.buffer << 8 | this.m_pBitArray[(int)(this.m_nCurrentBitIndex >> 5)] >> (int)(24L - (this.m_nCurrentBitIndex & 0x1FL)) & 0xFFL;
                    this.m_nCurrentBitIndex += 8L;
                    range2.low = range2.low << 8 | range2.buffer >> 1 & 0xFFL;
                    range2.range <<= 8;
                }
                range2.range /= (long)nPivotValueA;
                int nBaseA = (int)(range2.low / range2.range);
                range2.low -= range2.range * (long)nBaseA;
                while (range2.range <= 0x800000L) {
                    range2.buffer = range2.buffer << 8 | this.m_pBitArray[(int)(this.m_nCurrentBitIndex >> 5)] >> (int)(24L - (this.m_nCurrentBitIndex & 0x1FL)) & 0xFFL;
                    this.m_nCurrentBitIndex += 8L;
                    range2.low = range2.low << 8 | range2.buffer >> 1 & 0xFFL;
                    range2.range <<= 8;
                }
                range2.range /= (long)nPivotValueB;
                int nBaseB = (int)(range2.low / range2.range);
                range2.low -= range2.range * (long)nBaseB;
                nBase = nBaseA * nSplitFactor + nBaseB;
            } else {
                RangeCoderStructDecompress range3 = this.m_RangeCoderInfo;
                while (range3.range <= 0x800000L) {
                    range3.buffer = range3.buffer << 8 | this.m_pBitArray[(int)(this.m_nCurrentBitIndex >> 5)] >> (int)(24L - (this.m_nCurrentBitIndex & 0x1FL)) & 0xFFL;
                    this.m_nCurrentBitIndex += 8L;
                    range3.low = range3.low << 8 | range3.buffer >> 1 & 0xFFL;
                    range3.range <<= 8;
                }
                range3.range /= (long)nPivotValue;
                int nBaseLower = (int)(range3.low / range3.range);
                range3.low -= range3.range * (long)nBaseLower;
                nBase = nBaseLower;
            }
            nValue = nBase + nOverflow * nPivotValue;
        } else {
            int nTempK;
            int nOverflow;
            int nRangeTotal = this.RangeDecodeFast(16);
            long[] al1 = RANGE_TOTAL_1;
            if (nRangeTotal > 64878) {
                int low = 12;
                nOverflow = 64;
                int mid = 38;
                long midVal = al1[38];
                do {
                    if (midVal < (long)nRangeTotal) {
                        low = mid + 1;
                    } else {
                        if (midVal <= (long)nRangeTotal) {
                            nOverflow = mid;
                            break;
                        }
                        nOverflow = mid - 1;
                    }
                    mid = low + nOverflow >>> 1;
                    midVal = al1[mid];
                } while (low <= nOverflow);
            } else {
                nOverflow = 1;
                while ((long)nRangeTotal >= al1[nOverflow]) {
                    ++nOverflow;
                }
                --nOverflow;
            }
            RangeCoderStructDecompress range = this.m_RangeCoderInfo;
            range.low -= range.range * al1[nOverflow];
            range.range *= RANGE_WIDTH_1[nOverflow];
            if (nOverflow == 63) {
                nTempK = this.RangeDecodeFastWithUpdate(5);
                nOverflow = 0;
            } else {
                int n = nTempK = BitArrayState.k < 1 ? 0 : BitArrayState.k - 1;
            }
            if (nTempK <= 16 || this.m_nVersion < 3910) {
                nValue = this.RangeDecodeFastWithUpdate(nTempK);
            } else {
                int nX1 = this.RangeDecodeFastWithUpdate(16);
                int nX2 = this.RangeDecodeFastWithUpdate(nTempK - 16);
                nValue = nX1 | nX2 << 16;
            }
            nValue += nOverflow << nTempK;
        }
        BitArrayState.nKSum += (nValue + 1) / 2 - (BitArrayState.nKSum + 16 >> 5);
        if ((long)BitArrayState.nKSum < K_SUM_MIN_BOUNDARY[BitArrayState.k]) {
            --BitArrayState.k;
        } else if ((long)BitArrayState.nKSum >= K_SUM_MIN_BOUNDARY[BitArrayState.k + 1]) {
            ++BitArrayState.k;
        }
        return (nValue & 1) > 0 ? (nValue >> 1) + 1 : -(nValue >> 1);
    }

    @Override
    public void FlushState(UnBitArrayState BitArrayState) {
        BitArrayState.k = 10;
        BitArrayState.nKSum = (1 << BitArrayState.k) * 16;
    }

    @Override
    public void FlushBitArray() {
        this.AdvanceToByteBoundary();
        RangeCoderStructDecompress struct = this.m_RangeCoderInfo;
        this.m_nCurrentBitIndex += 8L;
        struct.buffer = this.GetC();
        struct.low = struct.buffer >> 1;
        struct.range = 128L;
        this.m_nRefillBitThreshold = this.m_nBits - 512L;
    }

    @Override
    public void finalize_internally() {
        long range;
        RangeCoderStructDecompress struct = this.m_RangeCoderInfo;
        long i = this.m_nCurrentBitIndex;
        for (range = struct.range; range <= 0x800000L; range <<= 8) {
            i += 8L;
        }
        if (this.m_nVersion <= 3950) {
            i -= 16L;
        }
        this.m_nCurrentBitIndex = i;
        struct.range = range;
    }

    private void GenerateArrayRange(int[] pOutputArray, int nElements) throws IOException {
        this.FlushState(this.GenerateArrayRangeBitArrayState);
        this.FlushBitArray();
        for (int z = 0; z < nElements; ++z) {
            pOutputArray[z] = this.DecodeValueRange(this.GenerateArrayRangeBitArrayState);
        }
        this.finalize_internally();
    }

    private final int RangeDecodeFast(int nShift) {
        long range;
        RangeCoderStructDecompress struct = this.m_RangeCoderInfo;
        long[] a1 = this.m_pBitArray;
        long i = this.m_nCurrentBitIndex;
        long buffer = struct.buffer;
        long low = struct.low;
        for (range = struct.range; range <= 0x800000L; range <<= 8) {
            buffer = buffer << 8 | a1[(int)(i >> 5)] >> (int)(24L - (i & 0x1FL)) & 0xFFL;
            i += 8L;
            low = low << 8 | buffer >> 1 & 0xFFL;
        }
        this.m_nCurrentBitIndex = i;
        struct.low = low;
        struct.buffer = buffer;
        struct.range = range >>= nShift;
        return (int)(low / range);
    }

    private final int RangeDecodeFastWithUpdate(int nShift) {
        long range;
        RangeCoderStructDecompress struct = this.m_RangeCoderInfo;
        long[] a1 = this.m_pBitArray;
        long i = this.m_nCurrentBitIndex;
        long buffer = struct.buffer;
        long low = struct.low;
        for (range = struct.range; range <= 0x800000L; range <<= 8) {
            buffer = buffer << 8 | a1[(int)(i >> 5)] >> (int)(24L - (i & 0x1FL)) & 0xFFL;
            i += 8L;
            low = low << 8 | buffer >> 1 & 0xFFL;
        }
        this.m_nCurrentBitIndex = i;
        int nRetVal = (int)(low / (range >>= nShift));
        struct.range = range;
        struct.low = low -= range * (long)nRetVal;
        struct.buffer = buffer;
        return nRetVal;
    }

    private final short GetC() {
        long l = this.m_nCurrentBitIndex;
        short nValue = (short)(this.m_pBitArray[(int)(l >> 5)] >> (int)(24L - (l & 0x1FL)));
        this.m_nCurrentBitIndex = l + 8L;
        return nValue;
    }
}

