/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.decoder.UnBitArray;
import de.quippy.jmac.decoder.UnBitArrayOld;
import de.quippy.jmac.decoder.UnBitArrayState;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.IOException;

public class UnBitArrayBase {
    private static final long[] POWERS_OF_TWO_MINUS_ONE = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL};
    protected long m_nElements;
    protected long m_nBytes;
    protected long m_nBits;
    protected int m_nVersion;
    protected File m_pIO;
    protected long m_nCurrentBitIndex;
    protected long[] m_pBitArray;
    protected ByteArrayReader m_pReader;

    public void FillBitArray() throws IOException {
        long nBitArrayIndex = this.m_nCurrentBitIndex >> 5;
        long[] al = this.m_pBitArray;
        int j = (int)nBitArrayIndex;
        System.arraycopy(this.m_pBitArray, j, al, 0, (int)((long)al.length - nBitArrayIndex));
        ByteArrayReader reader = this.m_pReader;
        reader.reset(this.m_pIO, j << 2);
        long l1 = this.m_nElements;
        int i = (int)(l1 - nBitArrayIndex);
        if ((long)i < l1) {
            do {
                al[i] = reader.readUnsignedInt();
            } while ((long)(++i) < l1);
        }
        this.m_nCurrentBitIndex &= 0x1FL;
    }

    public void FillAndResetBitArray() throws IOException {
        this.FillAndResetBitArray(-1, 0);
    }

    public void FillAndResetBitArray(int nFileLocation) throws IOException {
        this.FillAndResetBitArray(nFileLocation, 0);
    }

    public void FillAndResetBitArray(int nFileLocation, int nNewBitIndex) throws IOException {
        this.m_nCurrentBitIndex = nNewBitIndex;
        if (nFileLocation != -1) {
            this.m_pIO.seek(nFileLocation);
        }
        ByteArrayReader reader = this.m_pReader;
        reader.reset(this.m_pIO, (int)this.m_nBytes);
        long[] al = this.m_pBitArray;
        long l = this.m_nElements;
        int i = 0;
        while ((long)i < l) {
            al[i] = reader.readUnsignedInt();
            ++i;
        }
    }

    public void GenerateArray(int[] pOutputArray, int nElements) throws IOException {
        this.GenerateArray(pOutputArray, nElements, -1);
    }

    public void GenerateArray(int[] pOutputArray, int nElements, int nBytesRequired) throws IOException {
    }

    public long DecodeValue(int DecodeMethod) throws IOException {
        return this.DecodeValue(DecodeMethod, 0, 0);
    }

    public long DecodeValue(int DecodeMethod, int nParam1) throws IOException {
        return this.DecodeValue(DecodeMethod, nParam1, 0);
    }

    public long DecodeValue(int DecodeMethod, int nParam1, int nParam2) throws IOException {
        return 0L;
    }

    public void AdvanceToByteBoundary() {
        long nMod = this.m_nCurrentBitIndex % 8L;
        if (nMod != 0L) {
            this.m_nCurrentBitIndex += 8L - nMod;
        }
    }

    public int DecodeValueRange(UnBitArrayState BitArrayState) throws IOException {
        return 0;
    }

    public void FlushState(UnBitArrayState BitArrayState) {
    }

    public void FlushBitArray() {
    }

    public void finalize_internally() {
    }

    protected void CreateHelper(File pIO, int nBytes, int nVersion) {
        if (pIO == null || nBytes <= 0) {
            throw new JMACException("Bad Parameter");
        }
        this.m_nElements = nBytes / 4;
        this.m_nBytes = this.m_nElements * 4L;
        this.m_nBits = this.m_nBytes * 8L;
        this.m_pIO = pIO;
        this.m_nVersion = nVersion;
        this.m_nCurrentBitIndex = 0L;
        this.m_pBitArray = new long[(int)this.m_nElements];
        this.m_pReader = new ByteArrayReader((int)this.m_nBytes);
    }

    protected long DecodeValueXBits(long nBits) throws IOException {
        long nBitArrayIndex = this.m_nCurrentBitIndex;
        if (nBitArrayIndex + nBits >= this.m_nBits) {
            this.FillBitArray();
        }
        long nLeftBits = 32L - (nBitArrayIndex & 0x1FL);
        nBitArrayIndex >>= 5;
        this.m_nCurrentBitIndex += nBits;
        if (nLeftBits >= nBits) {
            return (this.m_pBitArray[(int)nBitArrayIndex] & POWERS_OF_TWO_MINUS_ONE[(int)nLeftBits]) >> (int)(nLeftBits - nBits);
        }
        long nRightBits = nBits - nLeftBits;
        long nLeftValue = (this.m_pBitArray[(int)nBitArrayIndex] & POWERS_OF_TWO_MINUS_ONE[(int)nLeftBits]) << (int)nRightBits;
        long nRightValue = this.m_pBitArray[(int)nBitArrayIndex + 1] >> (int)(32L - nRightBits);
        return nLeftValue | nRightValue;
    }

    public static UnBitArrayBase CreateUnBitArray(IAPEDecompress pAPEDecompress, int nVersion) {
        if (nVersion >= 3900) {
            return new UnBitArray(pAPEDecompress.getApeInfoIoSource(), nVersion);
        }
        return new UnBitArrayOld(pAPEDecompress, nVersion);
    }
}

