/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.decoder.UnBitArrayBase;
import java.io.IOException;

public class UnBitArrayOld
extends UnBitArrayBase {
    public static final long[] K_SUM_MIN_BOUNDARY_OLD = new long[]{0L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final long[] K_SUM_MAX_BOUNDARY_OLD = new long[]{128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final long[] Powers_of_Two = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L};
    public static final long[] Powers_of_Two_Reversed = new long[]{0x80000000L, 0x40000000L, 0x20000000L, 0x10000000L, 0x8000000L, 0x4000000L, 0x2000000L, 0x1000000L, 0x800000L, 0x400000L, 0x200000L, 0x100000L, 524288L, 262144L, 131072L, 65536L, 32768L, 16384L, 8192L, 4096L, 2048L, 1024L, 512L, 256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L};
    public static final long[] Powers_of_Two_Minus_One = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL};
    public static final long[] Powers_of_Two_Minus_One_Reversed = new long[]{0xFFFFFFFFL, Integer.MAX_VALUE, 0x3FFFFFFFL, 0x1FFFFFFFL, 0xFFFFFFFL, 0x7FFFFFFL, 0x3FFFFFFL, 0x1FFFFFFL, 0xFFFFFFL, 0x7FFFFFL, 0x3FFFFFL, 0x1FFFFFL, 1048575L, 524287L, 262143L, 131071L, 65535L, 32767L, 16383L, 8191L, 4095L, 2047L, 1023L, 511L, 255L, 127L, 63L, 31L, 15L, 7L, 3L, 1L, 0L};
    public static final long[] K_SUM_MIN_BOUNDARY = new long[]{0L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0L, 0L, 0L, 0L};
    public static final long[] K_SUM_MAX_BOUNDARY = new long[]{32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0L, 0L, 0L, 0L, 0L};
    private long k;
    private long K_Sum;
    private long m_nRefillBitThreshold;

    public UnBitArrayOld(IAPEDecompress pAPEDecompress, int nVersion) {
        int nBitArrayBytes = 262144;
        if (nVersion <= 3880) {
            int nMaxFrameBytes = pAPEDecompress.getApeInfoBlocksPerFrame() * 50 / 8;
            for (nBitArrayBytes = 65536; nBitArrayBytes < nMaxFrameBytes; nBitArrayBytes <<= 1) {
            }
            nBitArrayBytes = Math.max(nBitArrayBytes, 262144);
        } else if (nVersion <= 3890) {
            nBitArrayBytes = 65536;
        }
        this.CreateHelper(pAPEDecompress.getApeInfoIoSource(), nBitArrayBytes, nVersion);
        this.m_nRefillBitThreshold = this.m_nVersion <= 3880 ? this.m_nBits - 131072L : this.m_nBits - 512L;
    }

    @Override
    public void GenerateArray(int[] pOutputArray, int nElements, int nBytesRequired) throws IOException {
        if (this.m_nVersion < 3860) {
            this.GenerateArrayOld(pOutputArray, nElements, nBytesRequired);
        } else if (this.m_nVersion <= 3890) {
            this.GenerateArrayRice(pOutputArray, nElements, nBytesRequired);
        }
    }

    @Override
    public long DecodeValue(int DecodeMethod, int nParam1, int nParam2) throws IOException {
        switch (DecodeMethod) {
            case 0: {
                return this.DecodeValueXBits(32L);
            }
            case 1: {
                return this.DecodeValueRiceUnsigned(nParam1);
            }
            case 2: {
                return this.DecodeValueXBits(nParam1);
            }
        }
        return 0L;
    }

    private void GenerateArrayOld(int[] Output_Array, long Number_of_Elements, int Minimum_nCurrentBitIndex_Array_Bytes) throws IOException {
        long q;
        long Max_Bits_Needed = Number_of_Elements * 50L;
        if (Minimum_nCurrentBitIndex_Array_Bytes > 0) {
            Max_Bits_Needed = (Minimum_nCurrentBitIndex_Array_Bytes + 4) * 8;
        }
        if (Max_Bits_Needed > this.GetBitsRemaining()) {
            this.FillBitArray();
        }
        long Max = Number_of_Elements < 5L ? Number_of_Elements : 5L;
        for (q = 0L; q < Max; ++q) {
            Output_Array[(int)q] = (int)this.DecodeValueRiceUnsigned(10L);
        }
        if (Number_of_Elements <= 5L) {
            int i = 0;
            while ((long)i < Number_of_Elements) {
                int tvi = Output_Array[i];
                Output_Array[i] = (tvi & 1) > 0 ? (tvi >> 1) + 1 : -(tvi >> 1);
                ++i;
            }
            return;
        }
        long K_Sum = Output_Array[0] + Output_Array[1] + Output_Array[2] + Output_Array[3] + Output_Array[4];
        long k = this.Get_K(K_Sum / 10L);
        Max = Number_of_Elements < 64L ? Number_of_Elements : 64L;
        for (q = 5L; q < Max; ++q) {
            Output_Array[(int)q] = (int)this.DecodeValueRiceUnsigned(k);
            k = this.Get_K((K_Sum += (long)Output_Array[(int)q]) / (q + 1L) / 2L);
        }
        if (Number_of_Elements <= 64L) {
            int i = 0;
            while ((long)i < Number_of_Elements) {
                int tvi = Output_Array[i];
                Output_Array[i] = (tvi & 1) > 0 ? (tvi >> 1) + 1 : -(tvi >> 1);
                ++i;
            }
            return;
        }
        k = this.Get_K(K_Sum >> 7);
        long kmin = K_SUM_MIN_BOUNDARY_OLD[(int)k];
        long kmax = K_SUM_MAX_BOUNDARY_OLD[(int)k];
        int p1 = 64;
        int p2 = 0;
        while ((long)p1 < Number_of_Elements) {
            long v;
            long Bit_Initial = this.m_nCurrentBitIndex;
            while ((this.m_pBitArray[(int)(this.m_nCurrentBitIndex >> 5)] & Powers_of_Two_Reversed[(int)(this.m_nCurrentBitIndex++ & 0x1FL)]) == 0L) {
            }
            if (k == 0L) {
                v = this.m_nCurrentBitIndex - Bit_Initial - 1L;
            } else {
                v = this.m_nCurrentBitIndex - Bit_Initial - 1L << (int)k;
                long Bit_Array_Index = this.m_nCurrentBitIndex >> 5;
                long Bit_Index = this.m_nCurrentBitIndex & 0x1FL;
                this.m_nCurrentBitIndex += k;
                int Left_Extra_Bits = (int)(32L - k - Bit_Index);
                long Left_Value = this.m_pBitArray[(int)Bit_Array_Index] & Powers_of_Two_Minus_One_Reversed[(int)Bit_Index];
                v = Left_Extra_Bits >= 0 ? (v |= Left_Value >> Left_Extra_Bits) : (v |= Left_Value << -Left_Extra_Bits | this.m_pBitArray[(int)(Bit_Array_Index + 1L)] >> 32 + Left_Extra_Bits);
            }
            Output_Array[p1] = (int)v;
            int n = Output_Array[p2] = Output_Array[p2] % 2 > 0 ? (Output_Array[p2] >> 1) + 1 : -(Output_Array[p2] >> 1);
            if ((K_Sum += (long)(Output_Array[p1] - Output_Array[p2])) < kmin || K_Sum >= kmax) {
                if (K_Sum < kmin) {
                    while (K_Sum < K_SUM_MIN_BOUNDARY_OLD[(int)(--k)]) {
                    }
                } else {
                    while (K_Sum >= K_SUM_MAX_BOUNDARY_OLD[(int)(++k)]) {
                    }
                }
                kmax = K_SUM_MAX_BOUNDARY_OLD[(int)k];
                kmin = K_SUM_MIN_BOUNDARY_OLD[(int)k];
            }
            ++p1;
            ++p2;
        }
        while ((long)p2 < Number_of_Elements) {
            Output_Array[p2] = (Output_Array[p2] & 1) > 0 ? (Output_Array[p2] >> 1) + 1 : -(Output_Array[p2] >> 1);
            ++p2;
        }
    }

    private void GenerateArrayRice(int[] pOutputArray, long NumberOfElements, int MinimumBitArrayBytes) throws IOException {
        this.k = 10L;
        this.K_Sum = 16384L;
        if (this.m_nVersion <= 3880) {
            int i = 0;
            while ((long)i < NumberOfElements) {
                pOutputArray[i] = this.DecodeValueNew(false);
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < NumberOfElements) {
                pOutputArray[i] = this.DecodeValueNew(true);
                ++i;
            }
        }
    }

    private long DecodeValueRiceUnsigned(long k) throws IOException {
        long BitInitial = this.m_nCurrentBitIndex;
        while ((this.m_pBitArray[(int)(this.m_nCurrentBitIndex >> 5)] & Powers_of_Two_Reversed[(int)(this.m_nCurrentBitIndex++ & 0x1FL)]) == 0L) {
        }
        if (k == 0L) {
            return this.m_nCurrentBitIndex - BitInitial - 1L;
        }
        long v = this.m_nCurrentBitIndex - BitInitial - 1L << (int)k;
        return v | this.DecodeValueXBits(k);
    }

    private int DecodeValueNew(boolean bCapOverflow) throws IOException {
        long v;
        int nOverflow;
        if (this.m_nCurrentBitIndex > this.m_nRefillBitThreshold) {
            this.FillBitArray();
        }
        long Bit_Initial = this.m_nCurrentBitIndex;
        while ((this.m_pBitArray[(int)(this.m_nCurrentBitIndex >> 5)] & Powers_of_Two_Reversed[(int)(this.m_nCurrentBitIndex++ & 0x1FL)]) == 0L) {
        }
        if (bCapOverflow) {
            for (nOverflow = (int)(this.m_nCurrentBitIndex - Bit_Initial - 1L); nOverflow >= 16; nOverflow -= 16) {
                this.k += 4L;
            }
        }
        if (this.k != 0L) {
            v = nOverflow << (int)this.k;
            long Bit_Array_Index = this.m_nCurrentBitIndex >> 5;
            long Bit_Index = this.m_nCurrentBitIndex & 0x1FL;
            this.m_nCurrentBitIndex += this.k;
            int Left_Extra_Bits = (int)(32L - this.k - Bit_Index);
            long Left_Value = this.m_pBitArray[(int)Bit_Array_Index] & Powers_of_Two_Minus_One_Reversed[(int)Bit_Index];
            v = Left_Extra_Bits >= 0 ? (v |= Left_Value >> Left_Extra_Bits) : (v |= Left_Value << -Left_Extra_Bits | this.m_pBitArray[(int)(Bit_Array_Index + 1L)] >> 32 + Left_Extra_Bits);
        } else {
            v = nOverflow;
        }
        this.K_Sum += v - (this.K_Sum + 8L >> 4);
        if (this.K_Sum < K_SUM_MIN_BOUNDARY[(int)this.k]) {
            --this.k;
        } else if (this.K_Sum >= K_SUM_MAX_BOUNDARY[(int)this.k]) {
            ++this.k;
        }
        return (v & 1L) != 0L ? (int)((v >> 1) + 1L) : -((int)(v >> 1));
    }

    private long GetBitsRemaining() {
        return this.m_nElements * 32L - this.m_nCurrentBitIndex;
    }

    private long Get_K(long x) {
        if (x == 0L) {
            return 0L;
        }
        long k = 0L;
        while (x >= Powers_of_Two[(int)(++k)]) {
        }
        return k;
    }
}

