/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.info.APEDescriptor;
import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEHeaderNew;
import de.quippy.jmac.info.APEHeaderOld;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APEHeader {
    public static final int MAC_FORMAT_FLAG_8_BIT = 1;
    public static final int MAC_FORMAT_FLAG_CRC = 2;
    public static final int MAC_FORMAT_FLAG_HAS_PEAK_LEVEL = 4;
    public static final int MAC_FORMAT_FLAG_24_BIT = 8;
    public static final int MAC_FORMAT_FLAG_HAS_SEEK_ELEMENTS = 16;
    public static final int MAC_FORMAT_FLAG_CREATE_WAV_HEADER = 32;
    protected File m_pIO;

    public APEHeader(File file) {
        this.m_pIO = file;
    }

    public void Analyze(APEFileInfo pInfo) throws IOException {
        pInfo.nJunkHeaderBytes = this.FindDescriptor(true);
        if (pInfo.nJunkHeaderBytes < 0) {
            throw new JMACException("Unsupported Format");
        }
        this.m_pIO.mark(10);
        ByteArrayReader reader = new ByteArrayReader(this.m_pIO, 8);
        if (!reader.readString(4, "US-ASCII").equals("MAC ")) {
            throw new JMACException("Unsupported Format");
        }
        int version = reader.readUnsignedShort();
        this.m_pIO.reset();
        if (version >= 3980) {
            this.AnalyzeCurrent(pInfo);
        } else {
            this.AnalyzeOld(pInfo);
        }
    }

    protected void AnalyzeCurrent(APEFileInfo m_APEFileInfo) throws IOException {
        m_APEFileInfo.spAPEDescriptor = APEDescriptor.read(this.m_pIO);
        if (m_APEFileInfo.spAPEDescriptor.nDescriptorBytes - 52L > 0L) {
            this.m_pIO.skipBytes((int)(m_APEFileInfo.spAPEDescriptor.nDescriptorBytes - 52L));
        }
        APEHeaderNew APEHeader2 = APEHeaderNew.read(this.m_pIO);
        if (m_APEFileInfo.spAPEDescriptor.nHeaderBytes - 24L > 0L) {
            this.m_pIO.skipBytes((int)(m_APEFileInfo.spAPEDescriptor.nHeaderBytes - 24L));
        }
        m_APEFileInfo.nVersion = m_APEFileInfo.spAPEDescriptor.nVersion;
        m_APEFileInfo.nCompressionLevel = APEHeader2.nCompressionLevel;
        m_APEFileInfo.nFormatFlags = APEHeader2.nFormatFlags;
        m_APEFileInfo.nTotalFrames = (int)APEHeader2.nTotalFrames;
        m_APEFileInfo.nFinalFrameBlocks = (int)APEHeader2.nFinalFrameBlocks;
        m_APEFileInfo.nBlocksPerFrame = (int)APEHeader2.nBlocksPerFrame;
        m_APEFileInfo.nChannels = APEHeader2.nChannels;
        m_APEFileInfo.nSampleRate = (int)APEHeader2.nSampleRate;
        m_APEFileInfo.nBitsPerSample = APEHeader2.nBitsPerSample;
        m_APEFileInfo.nBytesPerSample = m_APEFileInfo.nBitsPerSample / 8;
        m_APEFileInfo.nBlockAlign = m_APEFileInfo.nBytesPerSample * m_APEFileInfo.nChannels;
        m_APEFileInfo.nTotalBlocks = (int)(APEHeader2.nTotalFrames == 0L ? 0L : (APEHeader2.nTotalFrames - 1L) * (long)m_APEFileInfo.nBlocksPerFrame + APEHeader2.nFinalFrameBlocks);
        m_APEFileInfo.nWAVHeaderBytes = (int)((APEHeader2.nFormatFlags & 0x20) > 0 ? 44L : m_APEFileInfo.spAPEDescriptor.nHeaderDataBytes);
        m_APEFileInfo.nWAVTerminatingBytes = (int)m_APEFileInfo.spAPEDescriptor.nTerminatingDataBytes;
        m_APEFileInfo.nWAVDataBytes = m_APEFileInfo.nTotalBlocks * m_APEFileInfo.nBlockAlign;
        m_APEFileInfo.nWAVTotalBytes = m_APEFileInfo.nWAVDataBytes + m_APEFileInfo.nWAVHeaderBytes + m_APEFileInfo.nWAVTerminatingBytes;
        m_APEFileInfo.nAPETotalBytes = this.m_pIO.isLocal() ? (int)this.m_pIO.length() : -1;
        m_APEFileInfo.nLengthMS = (int)((long)m_APEFileInfo.nTotalBlocks * 1000L / (long)m_APEFileInfo.nSampleRate);
        m_APEFileInfo.nAverageBitrate = m_APEFileInfo.nLengthMS <= 0 ? 0 : (int)((long)m_APEFileInfo.nAPETotalBytes * 8L / (long)m_APEFileInfo.nLengthMS);
        m_APEFileInfo.nDecompressedBitrate = m_APEFileInfo.nBlockAlign * m_APEFileInfo.nSampleRate * 8 / 1000;
        m_APEFileInfo.nSeekTableElements = (int)(m_APEFileInfo.spAPEDescriptor.nSeekTableBytes / 4L);
        m_APEFileInfo.nPeakLevel = -1;
        m_APEFileInfo.spSeekByteTable = new int[m_APEFileInfo.nSeekTableElements];
        for (int i = 0; i < m_APEFileInfo.nSeekTableElements; ++i) {
            m_APEFileInfo.spSeekByteTable[i] = this.m_pIO.readIntBack();
        }
        if ((APEHeader2.nFormatFlags & 0x20) <= 0) {
            m_APEFileInfo.spWaveHeaderData = new byte[m_APEFileInfo.nWAVHeaderBytes];
            try {
                this.m_pIO.readFully(m_APEFileInfo.spWaveHeaderData);
            }
            catch (EOFException e) {
                throw new JMACException("Can't Read Wave Header Data");
            }
        }
    }

    protected void AnalyzeOld(APEFileInfo m_APEFileInfo) throws IOException {
        APEHeaderOld header = APEHeaderOld.read(this.m_pIO);
        if (header.nTotalFrames == 0L) {
            throw new JMACException("Unsupported Format");
        }
        int nPeakLevel = -1;
        if ((header.nFormatFlags & 4) > 0) {
            nPeakLevel = this.m_pIO.readIntBack();
        }
        m_APEFileInfo.nSeekTableElements = (header.nFormatFlags & 0x10) > 0 ? this.m_pIO.readIntBack() : (int)header.nTotalFrames;
        m_APEFileInfo.nVersion = header.nVersion;
        m_APEFileInfo.nCompressionLevel = header.nCompressionLevel;
        m_APEFileInfo.nFormatFlags = header.nFormatFlags;
        m_APEFileInfo.nTotalFrames = (int)header.nTotalFrames;
        m_APEFileInfo.nFinalFrameBlocks = (int)header.nFinalFrameBlocks;
        int n = m_APEFileInfo.nBlocksPerFrame = header.nVersion >= 3900 || header.nVersion >= 3800 && header.nCompressionLevel == 4000 ? 73728 : 9216;
        if (header.nVersion >= 3950) {
            m_APEFileInfo.nBlocksPerFrame = 294912;
        }
        m_APEFileInfo.nChannels = header.nChannels;
        m_APEFileInfo.nSampleRate = (int)header.nSampleRate;
        m_APEFileInfo.nBitsPerSample = (m_APEFileInfo.nFormatFlags & 1) > 0 ? 8 : ((m_APEFileInfo.nFormatFlags & 8) > 0 ? 24 : 16);
        m_APEFileInfo.nBytesPerSample = m_APEFileInfo.nBitsPerSample / 8;
        m_APEFileInfo.nBlockAlign = m_APEFileInfo.nBytesPerSample * m_APEFileInfo.nChannels;
        m_APEFileInfo.nTotalBlocks = (int)(header.nTotalFrames == 0L ? 0L : (header.nTotalFrames - 1L) * (long)m_APEFileInfo.nBlocksPerFrame + header.nFinalFrameBlocks);
        m_APEFileInfo.nWAVHeaderBytes = (int)((header.nFormatFlags & 0x20) > 0 ? 44L : header.nHeaderBytes);
        m_APEFileInfo.nWAVTerminatingBytes = (int)header.nTerminatingBytes;
        m_APEFileInfo.nWAVDataBytes = m_APEFileInfo.nTotalBlocks * m_APEFileInfo.nBlockAlign;
        m_APEFileInfo.nWAVTotalBytes = m_APEFileInfo.nWAVDataBytes + m_APEFileInfo.nWAVHeaderBytes + m_APEFileInfo.nWAVTerminatingBytes;
        m_APEFileInfo.nAPETotalBytes = this.m_pIO.isLocal() ? (int)this.m_pIO.length() : -1;
        m_APEFileInfo.nLengthMS = (int)((long)m_APEFileInfo.nTotalBlocks * 1000L / (long)m_APEFileInfo.nSampleRate);
        m_APEFileInfo.nAverageBitrate = (int)(m_APEFileInfo.nLengthMS <= 0 ? 0L : (long)m_APEFileInfo.nAPETotalBytes * 8L / (long)m_APEFileInfo.nLengthMS);
        m_APEFileInfo.nDecompressedBitrate = m_APEFileInfo.nBlockAlign * m_APEFileInfo.nSampleRate * 8 / 1000;
        m_APEFileInfo.nPeakLevel = nPeakLevel;
        if ((header.nFormatFlags & 0x20) <= 0) {
            if (header.nHeaderBytes > Integer.MAX_VALUE) {
                throw new JMACException("The HeaderBytes Parameter Is Too Big");
            }
            m_APEFileInfo.spWaveHeaderData = new byte[(int)header.nHeaderBytes];
            try {
                this.m_pIO.readFully(m_APEFileInfo.spWaveHeaderData);
            }
            catch (EOFException e) {
                throw new JMACException("Can't Read Wave Header Data");
            }
        }
        m_APEFileInfo.spSeekByteTable = new int[m_APEFileInfo.nSeekTableElements];
        for (int i = 0; i < m_APEFileInfo.nSeekTableElements; ++i) {
            m_APEFileInfo.spSeekByteTable[i] = this.m_pIO.readIntBack();
        }
        if (header.nVersion <= 3800) {
            m_APEFileInfo.spSeekBitTable = new byte[m_APEFileInfo.nSeekTableElements];
            try {
                this.m_pIO.readFully(m_APEFileInfo.spSeekBitTable);
            }
            catch (EOFException e) {
                throw new JMACException("Can't Read Seek Bit Table");
            }
        }
    }

    protected int FindDescriptor(boolean bSeek) throws IOException {
        int nJunkBytes = 0;
        if (this.m_pIO.isLocal()) {
            this.m_pIO.mark(1000);
            ByteArrayReader reader = new ByteArrayReader(10);
            reader.reset(this.m_pIO, 10);
            String tag = reader.readString(3, "US-ASCII");
            if (tag.equals("ID3")) {
                reader.readByte();
                reader.readByte();
                short byte5 = reader.readUnsignedByte();
                int nSyncSafeLength = (reader.readUnsignedByte() & 0x7F) << 21;
                nSyncSafeLength += (reader.readUnsignedByte() & 0x7F) << 14;
                nSyncSafeLength += (reader.readUnsignedByte() & 0x7F) << 7;
                nSyncSafeLength += reader.readUnsignedByte() & 0x7F;
                boolean bHasTagFooter = false;
                if ((byte5 & 0x10) > 0) {
                    bHasTagFooter = true;
                    nJunkBytes = nSyncSafeLength + 20;
                } else {
                    nJunkBytes = nSyncSafeLength + 10;
                }
                if ((byte5 & 0x40) > 0) {
                    // empty if block
                }
                this.m_pIO.skipBytes(nJunkBytes - 10);
                if (!bHasTagFooter) {
                    while (this.m_pIO.read() == 0) {
                        ++nJunkBytes;
                    }
                }
            }
            this.m_pIO.reset();
            this.m_pIO.skipBytes(nJunkBytes);
        }
        this.m_pIO.mark(1000);
        int nGoalID = 1296122656;
        int nReadID = this.m_pIO.readInt();
        if (this.m_pIO.isLocal()) {
            for (int nScanBytes = 0; nGoalID != nReadID && nScanBytes < 0x100000; ++nScanBytes) {
                nReadID = nReadID << 8 | this.m_pIO.readByte() & 0xFF;
                ++nJunkBytes;
            }
        }
        if (nGoalID != nReadID) {
            nJunkBytes = -1;
        }
        if (bSeek && nJunkBytes != -1) {
            this.m_pIO.reset();
            this.m_pIO.skipBytes(nJunkBytes);
            this.m_pIO.mark(1000);
        } else {
            this.m_pIO.reset();
        }
        return nJunkBytes;
    }
}

