/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APEHeaderOld {
    public String cID;
    public int nVersion;
    public int nCompressionLevel;
    public int nFormatFlags;
    public int nChannels;
    public long nSampleRate;
    public long nHeaderBytes;
    public long nTerminatingBytes;
    public long nTotalFrames;
    public long nFinalFrameBlocks;
    public static final int APE_HEADER_OLD_BYTES = 32;

    public static APEHeaderOld read(File file) throws IOException {
        try {
            APEHeaderOld header = new APEHeaderOld();
            ByteArrayReader reader = new ByteArrayReader(file, 32);
            header.cID = reader.readString(4, "US-ASCII");
            header.nVersion = reader.readUnsignedShort();
            header.nCompressionLevel = reader.readUnsignedShort();
            header.nFormatFlags = reader.readUnsignedShort();
            header.nChannels = reader.readUnsignedShort();
            header.nSampleRate = reader.readUnsignedInt();
            header.nHeaderBytes = reader.readUnsignedInt();
            header.nTerminatingBytes = reader.readUnsignedInt();
            header.nTotalFrames = reader.readUnsignedInt();
            header.nFinalFrameBlocks = reader.readUnsignedInt();
            return header;
        }
        catch (EOFException e) {
            throw new JMACException("Unsupported Format");
        }
    }
}

